// Generated by gtkmmproc -- DO NOT MODIFY!

#include <gconfmm/value.h>
#include <gconfmm/private/value_p.h>

// -*- Mode: C++; c-basic-offset: 4  -*-
/* $Id: value.ccg,v 1.2 2005/01/11 12:08:16 murrayc Exp $ */

/* value.hg
 * 
 * Copyright (C) 2000-2002 GConfmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gconf/gconf.h>
#include "gconfmm/schema.h"

namespace Gnome
{

namespace Conf
{

void ValueTraits::release_c_type(GConfValue* ptr)
{
  gconf_value_free(ptr);
}
  

GConfValue* ValueSchemaTraits::to_c_type(const Schema& ptr)
{
  GConfValue* v = gconf_value_new(GCONF_VALUE_SCHEMA);
  gconf_value_set_schema(v, ptr.gobj());
  return v;
}

Schema ValueSchemaTraits::to_cpp_type(GConfValue* ptr)
{
  return Schema(gconf_value_get_schema(ptr), true);
}

GConfValue* ValueStringTraits::to_c_type(const Glib::ustring& ptr)
{
  GConfValue* v = gconf_value_new(GCONF_VALUE_STRING);
  gconf_value_set_string(v,ptr.c_str());
  return v;
}

Glib::ustring ValueStringTraits::to_cpp_type(GConfValue* ptr)
{
  return Glib::ustring(gconf_value_get_string(ptr));
}

GConfValue* ValueIntTraits::to_c_type(const int& ptr)
{
  GConfValue* v = gconf_value_new(GCONF_VALUE_INT);
  gconf_value_set_int(v,ptr);
  return v;
}

int ValueIntTraits::to_cpp_type(GConfValue* ptr)
{
  return gconf_value_get_int(ptr);
}

GConfValue* ValueBoolTraits::to_c_type(const bool& ptr)
{
  GConfValue* v = gconf_value_new(GCONF_VALUE_BOOL);
  gconf_value_set_bool(v, ptr);
  return v;
}

bool ValueBoolTraits::to_cpp_type(GConfValue* ptr)
{
  return (bool)gconf_value_get_bool(ptr);
}

GConfValue* ValueFloatTraits::to_c_type(const double& ptr)
{
  GConfValue* v = gconf_value_new(GCONF_VALUE_FLOAT);
  gconf_value_set_float(v,ptr);
  return v;
}

double ValueFloatTraits::to_cpp_type(GConfValue* ptr)
{
  return gconf_value_get_float(ptr);
}


Value::Value(ValueType type)
  : gobject_(0)
{
  if(type != VALUE_INVALID)
    gobject_ = gconf_value_new((GConfValueType)type);
}

ValueType Value::get_type() const 
{
  if(gobject_ == 0)
    return VALUE_INVALID;

  return (ValueType)gobj()->type;
}

Value Value::get_car() const
{
  return Value(gconf_value_get_car(gobj()), true);
}

Value Value::get_cdr() const
{
  return Value(gconf_value_get_cdr(gobj()), true);
}

Schema Value::get_schema() const
{
  return Schema(gconf_value_get_schema(gobj()), true);
}

} /* namespace Conf */
} /* namespace Gnome */


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gnome::Conf::ValueType>::value_type()
{
  return gconf_value_type_get_type();
}


namespace Glib
{

Gnome::Conf::Value wrap(GConfValue* object, bool take_copy /* = false */)
{
  return Gnome::Conf::Value(object, take_copy);
}

} // namespace Glib


namespace Gnome
{

namespace Conf
{


Value::Value(const Value& src)
:
  gobject_ ((src.gobject_) ? gconf_value_copy(src.gobject_) : 0)
{}

Value::Value(GConfValue* castitem, bool make_a_copy /* = false */)
{
  if(!make_a_copy)
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
  else
  {
    // We are probably getting it via direct access to a struct,
    // so we can not just take it - we have to take a copy of it.
    if(castitem)
      gobject_ = gconf_value_copy(castitem);
    else
      gobject_ = 0;
  }
}

Value& Value::operator=(const Value& src)
{
  GConfValue *const new_gobject = (src.gobject_) ? gconf_value_copy(src.gobject_) : 0;

  if(gobject_)
    gconf_value_free(gobject_);

  gobject_ = new_gobject;

  return *this;
}

Value::~Value()
{
  if(gobject_)
    gconf_value_free(gobject_);
}

GConfValue* Value::gobj_copy() const
{
  return gconf_value_copy(gobject_);
}


void Value::set(gint val)
{
  gconf_value_set_int(gobj(), val);
}

void Value::set(gdouble val)
{
  gconf_value_set_float(gobj(), val);
}

void Value::set(bool val)
{
  gconf_value_set_bool(gobj(), static_cast<int>(val));
}

void Value::set(const Schema& sc)
{
  gconf_value_set_schema(gobj(), (sc).gobj());
}

void Value::set_car(const Value& car)
{
  gconf_value_set_car(gobj(), (car).gobj());
}

void Value::set_cdr(const Value& cdr)
{
  gconf_value_set_cdr(gobj(), (cdr).gobj());
}

void Value::set(const Glib::ustring& val)
{
  gconf_value_set_string(gobj(), val.c_str());
}

void Value::set_list_type(ValueType type)
{
  gconf_value_set_list_type(gobj(), ((GConfValueType)(type)));
}

void Value::set_int_list(const SListHandle_ValueInt& list)
{
  gconf_value_set_list_nocopy(gobj(), list.data());
}

void Value::set_bool_list(const SListHandle_ValueBool& list)
{
  gconf_value_set_list_nocopy(gobj(), list.data());
}

void Value::set_float_list(const SListHandle_ValueFloat& list)
{
  gconf_value_set_list_nocopy(gobj(), list.data());
}

void Value::set_string_list(const SListHandle_ValueString& list)
{
  gconf_value_set_list_nocopy(gobj(), list.data());
}

void Value::set_schema_list(const SListHandle_ValueSchema& list)
{
  gconf_value_set_list_nocopy(gobj(), list.data());
}

ValueType Value::get_list_type() const
{
  return ((ValueType)(gconf_value_get_list_type(const_cast<GConfValue*>(gobj()))));
}

int Value::get_int() const
{
  return gconf_value_get_int(const_cast<GConfValue*>(gobj()));
}

bool Value::get_bool() const
{
  return gconf_value_get_bool(const_cast<GConfValue*>(gobj()));
}

double Value::get_float() const
{
  return gconf_value_get_float(const_cast<GConfValue*>(gobj()));
}

Glib::ustring Value::get_string() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gconf_value_get_string(const_cast<GConfValue*>(gobj())));
}

SListHandle_ValueFloat Value::get_float_list() const
{
  return SListHandle_ValueFloat(gconf_value_get_list(const_cast<GConfValue*>(gobj())), Glib::OWNERSHIP_NONE);
}

SListHandle_ValueInt Value::get_int_list() const
{
  return SListHandle_ValueInt(gconf_value_get_list(const_cast<GConfValue*>(gobj())), Glib::OWNERSHIP_NONE);
}

SListHandle_ValueBool Value::get_bool_list() const
{
  return SListHandle_ValueBool(gconf_value_get_list(const_cast<GConfValue*>(gobj())), Glib::OWNERSHIP_NONE);
}

SListHandle_ValueString Value::get_string_list() const
{
  return SListHandle_ValueString(gconf_value_get_list(const_cast<GConfValue*>(gobj())), Glib::OWNERSHIP_NONE);
}

SListHandle_ValueSchema Value::get_schema_list() const
{
  return SListHandle_ValueSchema(gconf_value_get_list(const_cast<GConfValue*>(gobj())), Glib::OWNERSHIP_NONE);
}

Glib::ustring Value::to_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gconf_value_to_string(const_cast<GConfValue*>(gobj())));
}


} // namespace Conf

} // namespace Gnome


