/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermTarget;
import org.dita.dost.util.XMLSerializer;
import org.dita.dost.writer.AbstractExtendDitaWriter;
import org.xml.sax.SAXException;

public final class CHMIndexWriter
extends AbstractExtendDitaWriter {
    public void write(File filename) throws DITAOTException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filename);
            XMLSerializer serializer = XMLSerializer.newInstance((OutputStream)out);
            Transformer transformer = serializer.getTransformerHandler().getTransformer();
            transformer.setOutputProperty("doctype-public", "-//IETF//DTD HTML//EN");
            transformer.setOutputProperty("method", "html");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "no");
            serializer.writeStartDocument();
            serializer.writeStartElement("html");
            serializer.writeStartElement("head");
            serializer.writeStartElement("meta");
            serializer.writeAttribute("name", "GENERATOR");
            serializer.writeAttribute("content", "Microsoft\u00ae HTML Help Workshop 4.1");
            serializer.writeEndElement();
            serializer.writeComment("Sitemap 1.0");
            serializer.writeEndElement();
            serializer.writeStartElement("body");
            serializer.writeStartElement("ul");
            for (IndexTerm term : this.termList) {
                this.outputIndexTerm(term, serializer);
            }
            serializer.writeEndElement();
            serializer.writeEndElement();
            serializer.writeEndElement();
            serializer.writeEndDocument();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void outputIndexTerm(IndexTerm term, XMLSerializer serializer) throws SAXException {
        List targets = term.getTargetList();
        List subTerms = term.getSubTerms();
        int targetNum = targets.size();
        int subTermNum = subTerms.size();
        serializer.writeStartElement("li");
        serializer.writeStartElement("object");
        serializer.writeAttribute("type", "text/sitemap");
        serializer.writeStartElement("param");
        serializer.writeAttribute("name", "Name");
        serializer.writeAttribute("value", term.getTermFullName());
        serializer.writeEndElement();
        if (targets.isEmpty()) {
            this.findTargets(term);
            targets = term.getTargetList();
            targetNum = targets.size();
        }
        for (int i = 0; i < targetNum; ++i) {
            IndexTermTarget target = (IndexTermTarget)targets.get(i);
            serializer.writeStartElement("param");
            serializer.writeAttribute("name", "Name");
            serializer.writeAttribute("value", target.getTargetName());
            serializer.writeEndElement();
            serializer.writeStartElement("param");
            serializer.writeAttribute("name", "Local");
            serializer.writeAttribute("value", target.getTargetURI());
            serializer.writeEndElement();
        }
        serializer.writeEndElement();
        if (subTermNum > 0) {
            serializer.writeStartElement("ul");
            for (IndexTerm subTerm : subTerms) {
                this.outputIndexTerm(subTerm, serializer);
            }
            serializer.writeEndElement();
        }
        serializer.writeEndElement();
    }

    private void findTargets(IndexTerm term) {
        List subTerms = term.getSubTerms();
        List subTargets = null;
        if (subTerms != null && !subTerms.isEmpty()) {
            for (IndexTerm subTerm : subTerms) {
                subTargets = subTerm.getTargetList();
                if (subTargets != null && !subTargets.isEmpty()) {
                    term.addTargets(subTerm.getTargetList());
                } else {
                    this.findTargets(subTerm);
                }
                term.addTargets(subTerm.getTargetList());
            }
        }
    }

    public String getIndexFileName(String outputFileRoot) {
        return outputFileRoot + ".hhk";
    }
}

