/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.lib.CatalogResourceResolver;
import net.sf.saxon.lib.CollationURIResolver;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.s9api.DOMDestination;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.s9api.MessageListener2;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SAXDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.streams.Predicates;
import net.sf.saxon.s9api.streams.Step;
import net.sf.saxon.s9api.streams.Steps;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import org.apache.commons.io.FileUtils;
import org.apache.xerces.util.SecurityManager;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.module.saxon.DelegatingCollationUriResolver;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xmlresolver.Resolver;

public final class XMLUtils {
    private static final SecurityManager securityManager = new SecurityManager();
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static final SAXParserFactory saxParserFactory;
    private DITAOTLogger logger;
    private final Resolver catalogResolver = CatalogUtils.getCatalogResolver();
    private final Processor processor;
    private final XsltCompiler xsltCompiler;
    public static final Attributes EMPTY_ATTRIBUTES;
    private static final List<String> excludeList;

    public static Step<XdmNode> rootElement() {
        return Steps.child().where(Predicates.isElement()).first();
    }

    public XMLUtils() {
        net.sf.saxon.Configuration config = net.sf.saxon.Configuration.newConfiguration();
        config.setResourceResolver((ResourceResolver)new CatalogResourceResolver(this.catalogResolver));
        XMLUtils.configureSaxonExtensions(config);
        XMLUtils.configureSaxonCollationResolvers(config);
        this.processor = new Processor(config);
        this.xsltCompiler = this.processor.newXsltCompiler();
        this.xsltCompiler.setURIResolver((URIResolver)this.catalogResolver);
    }

    @VisibleForTesting
    static void configureSaxonExtensions(net.sf.saxon.Configuration conf) {
        for (ExtensionFunctionDefinition def : ServiceLoader.load(ExtensionFunctionDefinition.class)) {
            try {
                conf.registerExtensionFunction((ExtensionFunctionDefinition)def.getClass().newInstance());
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Failed to register " + def.getFunctionQName().getDisplayName() + ". Cannot create instance of " + def.getClass().getName() + ": " + e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @VisibleForTesting
    static void configureSaxonCollationResolvers(net.sf.saxon.Configuration conf) {
        for (DelegatingCollationUriResolver resolver : ServiceLoader.load(DelegatingCollationUriResolver.class)) {
            try {
                DelegatingCollationUriResolver newResolver = (DelegatingCollationUriResolver)resolver.getClass().newInstance();
                CollationURIResolver currentResolver = conf.getCollationURIResolver();
                if (currentResolver != null) {
                    newResolver.setBaseResolver(currentResolver);
                }
                conf.setCollationURIResolver((CollationURIResolver)newResolver);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Failed to register " + resolver.getClass().getSimpleName() + ". Cannot create instance of " + resolver.getClass().getName() + ": " + e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public Resolver getCatalogResolver() {
        return this.catalogResolver;
    }

    public static <T extends Node> List<T> toList(NodeList nodes) {
        ArrayList<Node> res = new ArrayList<Node>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            res.add(nodes.item(i));
        }
        return res;
    }

    public static MessageListener2 toMessageListener(DITAOTLogger logger, Configuration.Mode mode) {
        return (content, code, terminate, locator) -> {
            Optional<String> errorCode = content.select(Steps.descendant((Predicate)Predicates.isProcessingInstruction()).where(Predicates.hasLocalName((String)"error-code"))).findAny().map(XdmItem::getStringValue);
            String level = terminate ? "FATAL" : content.select(Steps.descendant((Predicate)Predicates.isProcessingInstruction()).where(Predicates.hasLocalName((String)"level"))).findAny().map(XdmItem::getStringValue).orElse("INFO");
            String msg = content.select(Steps.child(Predicates.hasLocalName((String)"level").or(Predicates.hasLocalName((String)"error-code")).and(Predicates.hasType((ItemType)ItemType.PROCESSING_INSTRUCTION_NODE)).negate())).map(XdmItem::getStringValue).collect(Collectors.joining());
            switch (level) {
                case "FATAL": {
                    TerminationException err = new TerminationException(msg);
                    errorCode.ifPresent(arg_0 -> ((TerminationException)err).setErrorCode(arg_0));
                    throw new SaxonApiUncheckedException((Throwable)err);
                }
                case "ERROR": {
                    if (mode == Configuration.Mode.STRICT) {
                        throw new UncheckedXPathException(msg);
                    }
                    logger.error(msg);
                    break;
                }
                case "WARN": {
                    logger.warn(msg);
                    break;
                }
                case "INFO": {
                    logger.info(msg);
                    break;
                }
                case "DEBUG": {
                    logger.debug(msg);
                    break;
                }
                default: {
                    logger.error("Message level " + level + " not supported");
                    logger.info(msg);
                }
            }
        };
    }

    public static ErrorReporter toErrorReporter(DITAOTLogger logger) {
        return error -> {
            if (error.isWarning()) {
                logger.warn(error.getMessage());
            } else if (error.getCause() instanceof FileNotFoundException) {
                error = error.asWarning();
                StringBuilder buf = new StringBuilder();
                Location location = error.getLocation();
                if (location != null) {
                    buf.append(location.getSystemId()).append(":").append(location.getLineNumber()).append(":").append(location.getColumnNumber()).append(": ");
                }
                buf.append(error.getMessage());
                logger.warn(buf.toString());
            } else {
                logger.error(error.getMessage());
            }
        };
    }

    public static String getPrefix(String qname) {
        int sep = qname.indexOf(58);
        return sep != -1 ? qname.substring(0, sep) : "";
    }

    public static List<Element> getChildElements(Element elem, DitaClass cls, boolean deep) {
        NodeList children = deep ? elem.getElementsByTagName("*") : elem.getChildNodes();
        ArrayList<Element> res = new ArrayList<Element>(children.getLength());
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!cls.matches(child)) continue;
            res.add((Element)child);
        }
        return res;
    }

    public static Optional<Element> getChildElement(Element elem, String ns, String name) {
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !Objects.equals(child.getNamespaceURI(), ns) || !name.equals(child.getLocalName())) continue;
            return Optional.of((Element)child);
        }
        return Optional.empty();
    }

    public static Optional<Element> getChildElement(Element elem, DitaClass cls) {
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!cls.matches(child)) continue;
            return Optional.of((Element)child);
        }
        return Optional.empty();
    }

    public static List<Element> getChildElements(Element elem, String ns, String name) {
        NodeList children = elem.getChildNodes();
        ArrayList<Element> res = new ArrayList<Element>(children.getLength());
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !Objects.equals(child.getNamespaceURI(), ns) || !name.equals(child.getLocalName())) continue;
            res.add((Element)child);
        }
        return res;
    }

    public static List<Element> getChildElements(Element elem, DitaClass cls) {
        return XMLUtils.getChildElements(elem, cls, false);
    }

    public static List<Element> getChildElements(Element elem) {
        return XMLUtils.getChildElements(elem, false);
    }

    public static List<Element> getChildElements(Element elem, boolean deep) {
        NodeList children = deep ? elem.getElementsByTagName("*") : elem.getChildNodes();
        ArrayList<Element> res = new ArrayList<Element>(children.getLength());
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            res.add((Element)child);
        }
        return res;
    }

    public static boolean nonDitaContext(Deque<DitaClass> classes) {
        Iterator<DitaClass> it = classes.iterator();
        it.next();
        while (it.hasNext()) {
            DitaClass cls = it.next();
            if (cls != null && cls.isValid() && (Constants.TOPIC_FOREIGN.matches(cls) || Constants.TOPIC_UNKNOWN.matches(cls))) {
                return true;
            }
            if (cls == null || !cls.isValid()) continue;
            return false;
        }
        return false;
    }

    public static Element getElementNode(Element element, DitaClass classValue) {
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element child;
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !classValue.matches(child = (Element)node)) continue;
            return child;
        }
        return null;
    }

    public static String getText(Node root) {
        if (root == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(1024);
        if (root.hasChildNodes()) {
            NodeList list = root.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node childNode = list.item(i);
                if (childNode.getNodeType() == 1) {
                    Element e = (Element)childNode;
                    String value = e.getAttribute("class");
                    if (excludeList.contains(value)) continue;
                    String s = XMLUtils.getText(e);
                    result.append(s);
                    continue;
                }
                if (childNode.getNodeType() != 3) continue;
                result.append(childNode.getNodeValue());
            }
        } else if (root.getNodeType() == 3) {
            result.append(root.getNodeValue());
        }
        return result.toString();
    }

    public static Element searchForNode(Element root, String searchKey, String attrName, DitaClass classValue) {
        if (root == null) {
            return null;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.offer(root);
        while (!queue.isEmpty()) {
            Attr value;
            Element pe = (Element)queue.poll();
            NodeList pchildrenList = pe.getChildNodes();
            for (int i = 0; i < pchildrenList.getLength(); ++i) {
                Node node = pchildrenList.item(i);
                if (node.getNodeType() != 1) continue;
                queue.offer((Element)node);
            }
            if (pe.getAttribute("class") == null || !classValue.matches(pe) || (value = pe.getAttributeNode(attrName)) == null || !searchKey.equals(value.getValue())) continue;
            return pe;
        }
        return null;
    }

    public static void addOrSetAttribute(AttributesImpl atts, String uri, String localName, String qName, String type, String value) {
        int i = atts.getIndex(qName);
        if (i != -1) {
            atts.setAttribute(i, uri, localName, qName, type, value);
        } else {
            atts.addAttribute(uri, localName, qName, type, value);
        }
    }

    public static void addOrSetAttribute(AttributesImpl atts, QName name, String value) {
        XMLUtils.addOrSetAttribute(atts, name.getNamespaceURI(), name.getLocalPart(), (String)(name.getPrefix().isEmpty() ? name.getLocalPart() : name.getPrefix() + ":" + name.getLocalPart()), "CDATA", value);
    }

    public static void addOrSetAttribute(AttributesImpl atts, XdmNode attr) {
        net.sf.saxon.s9api.QName name = attr.getNodeName();
        XMLUtils.addOrSetAttribute(atts, name.getNamespaceURI(), name.getLocalName(), (String)(name.getPrefix().isEmpty() ? name.getLocalName() : name.getPrefix() + ":" + name.getLocalName()), "CDATA", attr.getStringValue());
    }

    public static void addOrSetAttribute(AttributesImpl atts, String localName, String value) {
        XMLUtils.addOrSetAttribute(atts, "", localName, localName, "CDATA", value);
    }

    public static void addOrSetAttribute(AttributesImpl atts, Node att) {
        int i;
        if (att.getNodeType() != 2) {
            throw new IllegalArgumentException();
        }
        Attr a = (Attr)att;
        String localName = a.getLocalName();
        if (localName == null && (i = (localName = a.getName()).indexOf(58)) != -1) {
            localName = localName.substring(i + 1);
        }
        XMLUtils.addOrSetAttribute(atts, a.getNamespaceURI() != null ? a.getNamespaceURI() : "", localName, a.getName() != null ? a.getName() : localName, a.isId() ? "ID" : "CDATA", a.getValue());
    }

    public static void removeAttribute(AttributesImpl atts, String qName) {
        int i = atts.getIndex(qName);
        if (i != -1) {
            atts.removeAttribute(i);
        }
    }

    public static String getStringValue(Element element) {
        StringBuilder buf = new StringBuilder();
        NodeList children = element.getChildNodes();
        block4: for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            switch (n.getNodeType()) {
                case 3: {
                    buf.append(n.getNodeValue());
                    continue block4;
                }
                case 1: {
                    buf.append(XMLUtils.getStringValue((Element)n));
                }
            }
        }
        return buf.toString();
    }

    @Deprecated
    public void transform(URI input, List<XMLFilter> filters) throws DITAOTException {
        assert (input.isAbsolute());
        if (!input.getScheme().equals("file")) {
            throw new IllegalArgumentException("Only file URI scheme supported: " + String.valueOf(input));
        }
        this.transform(new File(input), filters);
    }

    @Deprecated
    public void transform(File inputFile, List<XMLFilter> filters) throws DITAOTException {
        File outputFile = new File(inputFile.getAbsolutePath() + ".temp");
        this.transformFile(inputFile, outputFile, filters);
        try {
            FileUtils.deleteQuietly((File)inputFile);
            FileUtils.moveFile((File)outputFile, (File)inputFile);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to replace " + String.valueOf(inputFile) + ": " + e.getMessage());
        }
    }

    @Deprecated
    public void transform(File inputFile, File outputFile, List<XMLFilter> filters) throws DITAOTException {
        if (inputFile.equals(outputFile)) {
            this.transform(inputFile, filters);
        } else {
            this.transformFile(inputFile, outputFile, filters);
        }
    }

    @Deprecated
    private void transformFile(File inputFile, File outputFile, List<XMLFilter> filters) throws DITAOTException {
        if (!outputFile.getParentFile().exists()) {
            try {
                Files.createDirectories(outputFile.getParentFile().toPath(), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                throw new DITAOTException(e);
            }
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));){
            XMLReader reader = XMLUtils.getXMLReader();
            for (XMLFilter filter : filters) {
                filter.setContentHandler(null);
                filter.setParent(reader);
                reader = filter;
            }
            Serializer result = this.processor.newSerializer((OutputStream)out);
            ContentHandler serializer = result.getContentHandler();
            reader.setContentHandler(serializer);
            InputSource inputSource = new InputSource(in);
            inputSource.setSystemId(inputFile.toURI().toString());
            reader.parse(inputSource);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to transform " + String.valueOf(inputFile) + ": " + e.getMessage(), e);
        }
    }

    @Deprecated
    public void transform(URI input, URI output, List<XMLFilter> filters) throws DITAOTException {
        if (input.equals(output)) {
            this.transform(input, filters);
        } else {
            this.transformURI(input, output, filters);
        }
    }

    @Deprecated
    private void transformURI(URI input, URI output, List<XMLFilter> filters) throws DITAOTException {
        File outputFile = new File(output);
        if (!outputFile.getParentFile().exists()) {
            try {
                Files.createDirectories(outputFile.getParentFile().toPath(), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                throw new DITAOTException(e);
            }
        }
        try {
            XMLReader reader = XMLUtils.getXMLReader();
            for (XMLFilter filter : filters) {
                filter.setContentHandler(null);
                filter.setParent(reader);
                reader = filter;
            }
            Serializer result = this.processor.newSerializer(outputFile);
            ContentHandler serializer = result.getContentHandler();
            reader.setContentHandler(serializer);
            InputSource inputSource = new InputSource(input.toString());
            reader.parse(inputSource);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to transform " + String.valueOf(input) + ": " + e.getMessage(), e);
        }
    }

    public static void close(InputSource input) throws IOException {
        if (input != null) {
            InputStream i = input.getByteStream();
            if (i != null) {
                i.close();
            } else {
                Reader w = input.getCharacterStream();
                if (w != null) {
                    w.close();
                }
            }
        }
    }

    public static void close(Source input) throws IOException {
        if (input != null && input instanceof StreamSource) {
            StreamSource s = (StreamSource)input;
            InputStream i = s.getInputStream();
            if (i != null) {
                i.close();
            } else {
                Reader w = s.getReader();
                if (w != null) {
                    w.close();
                }
            }
        }
    }

    public static void close(Result result) throws IOException {
        if (result != null && result instanceof StreamResult) {
            StreamResult r = (StreamResult)result;
            OutputStream o = r.getOutputStream();
            if (o != null) {
                o.close();
            } else {
                Writer w = r.getWriter();
                if (w != null) {
                    w.close();
                }
            }
        }
    }

    public static String escapeXML(String s) {
        char[] chars = s.toCharArray();
        return XMLUtils.escapeXML(chars, 0, chars.length);
    }

    public static String escapeXML(char[] chars, int offset, int length) {
        StringBuilder escaped = new StringBuilder();
        int end = offset + length;
        block7: for (int i = offset; i < end; ++i) {
            char c = chars[i];
            switch (c) {
                case '\'': {
                    escaped.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    escaped.append("&quot;");
                    continue block7;
                }
                case '<': {
                    escaped.append("&lt;");
                    continue block7;
                }
                case '>': {
                    escaped.append("&gt;");
                    continue block7;
                }
                case '&': {
                    escaped.append("&amp;");
                    continue block7;
                }
                default: {
                    escaped.append(c);
                }
            }
        }
        return escaped.toString();
    }

    public static XMLReader getXMLReader() throws SAXException {
        try {
            XMLReader reader = saxParserFactory.newSAXParser().getXMLReader();
            try {
                reader.setProperty("http://apache.org/xml/properties/security-manager", securityManager);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                // empty catch block
            }
            return reader;
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public static Optional<XMLReader> getXmlReader(String format, Configuration.Mode processingMode) throws SAXException {
        if (format == null || format.equals("dita") || format.equals("ditamap")) {
            return Optional.empty();
        }
        for (Map.Entry<String, String> e : Configuration.parserMap.entrySet()) {
            if (!format.equals(e.getKey())) continue;
            try {
                XMLReader r = (XMLReader)Class.forName(e.getValue()).newInstance();
                Map features = Configuration.parserFeatures.getOrDefault(e.getKey(), Collections.emptyMap());
                for (Map.Entry feature : features.entrySet()) {
                    try {
                        r.setFeature((String)feature.getKey(), (Boolean)feature.getValue());
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {}
                }
                try {
                    r.setProperty("https://dita-ot.org/property/formats", Configuration.parserMap.keySet());
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                    // empty catch block
                }
                try {
                    r.setProperty("https://dita-ot.org/property/processing-mode", processingMode.name().toLowerCase());
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                    // empty catch block
                }
                try {
                    r.setProperty("http://apache.org/xml/properties/security-manager", securityManager);
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                    // empty catch block
                }
                return Optional.of(r);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new SAXException(ex);
            }
        }
        return Optional.empty();
    }

    public DocumentBuilder getDocumentBuilder() {
        DocumentBuilder builder;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        builder.setEntityResolver((EntityResolver)this.catalogResolver);
        return builder;
    }

    public Document newDocument() {
        try {
            return factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeDocument(Document doc, File dst) throws IOException {
        try {
            Serializer serializer = this.processor.newSerializer(dst);
            XdmNode source = this.processor.newDocumentBuilder().wrap((Object)doc);
            serializer.serializeNode(source);
        }
        catch (SaxonApiException e) {
            throw new IOException(e);
        }
    }

    public void writeDocument(Node doc, ContentHandler dst) throws IOException {
        this.writeDocument(this.processor.newDocumentBuilder().wrap((Object)doc), dst);
    }

    public void writeDocument(XdmNode source, ContentHandler dst) throws IOException {
        try {
            SAXDestination destination = new SAXDestination(dst);
            this.processor.writeXdmValue((XdmValue)source, (Destination)destination);
        }
        catch (SaxonApiException e) {
            throw new IOException(e);
        }
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public XsltCompiler getXsltCompiler() {
        XsltCompiler res = this.processor.newXsltCompiler();
        res.setURIResolver((URIResolver)this.catalogResolver);
        return res;
    }

    public static String getValue(Element elem, String attrName) {
        Attr attr = elem.getAttributeNode(attrName);
        if (attr != null && !attr.getValue().isEmpty()) {
            return attr.getValue();
        }
        return null;
    }

    public static String getCascadeValue(Element elem, String attrName) {
        Element current = elem;
        while (current != null) {
            Attr attr = current.getAttributeNode(attrName);
            if (attr != null) {
                return attr.getValue();
            }
            Node parent = current.getParentNode();
            if (parent == null || parent.getNodeType() != 1) break;
            current = (Element)parent;
        }
        return null;
    }

    public static String getCascadeValue(XdmNode node, String attrName) {
        return node.select(Steps.ancestorOrSelf((Predicate)Predicates.hasAttribute((String)attrName)).first().then(Steps.attribute((String)attrName))).findFirst().map(XdmItem::getStringValue).orElse(null);
    }

    public static Stream<Element> ancestors(Element element) {
        Stream.Builder<Element> builder = Stream.builder();
        for (Node current = element.getParentNode(); current != null; current = current.getParentNode()) {
            if (current.getNodeType() != 1) continue;
            builder.accept((Element)current);
        }
        return builder.build();
    }

    public static void insertBefore(Node ref, DocumentFragment fragment) {
        Document doc = ref.getOwnerDocument();
        Node parent = ref.getParentNode();
        List<Node> children = XMLUtils.toList(fragment.getChildNodes());
        for (Node child : children) {
            parent.insertBefore(doc.importNode(child, true), ref);
        }
    }

    public static void insertAfter(Node ref, DocumentFragment fragment) {
        Document doc = ref.getOwnerDocument();
        Node parent = ref.getParentNode();
        List<Node> children = XMLUtils.toList(fragment.getChildNodes());
        Node nextSibling = ref.getNextSibling();
        if (nextSibling != null) {
            for (Node child : children) {
                parent.insertBefore(doc.importNode(child, true), nextSibling);
            }
        } else {
            for (Node child : children) {
                parent.appendChild(doc.importNode(child, true));
            }
        }
    }

    public static Predicate<XdmNode> isDitaFormat() {
        return Predicates.attributeEq((String)"format", (String)"dita").or(Predicates.empty((Step)Steps.attribute((String)"format")));
    }

    public Document cloneDocument(XdmNode node) throws IOException {
        try {
            Document doc = this.newDocument();
            DOMDestination destination = new DOMDestination((Node)doc);
            Receiver receiver = destination.getReceiver(this.getProcessor().getUnderlyingConfiguration().makePipelineConfiguration(), new SerializationProperties());
            Sender.send((Source)node.asSource(), (Receiver)receiver, (ParseOptions)new ParseOptions());
            return doc;
        }
        catch (XPathException e) {
            throw new IOException(e);
        }
    }

    static {
        factory.setNamespaceAware(true);
        factory.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        EMPTY_ATTRIBUTES = new AttributesImpl();
        ArrayList<String> el = new ArrayList<String>();
        el.add(Constants.TOPIC_INDEXTERM.toString());
        el.add(Constants.TOPIC_DRAFT_COMMENT.toString());
        el.add(Constants.TOPIC_REQUIRED_CLEANUP.toString());
        el.add(Constants.TOPIC_DATA.toString());
        el.add(Constants.TOPIC_DATA_ABOUT.toString());
        el.add(Constants.TOPIC_UNKNOWN.toString());
        el.add(Constants.TOPIC_FOREIGN.toString());
        excludeList = Collections.unmodifiableList(el);
    }

    private static final class DebugDocumentBuilder
    extends DocumentBuilder {
        private final DocumentBuilder b;

        public DebugDocumentBuilder(DocumentBuilder b) {
            this.b = b;
        }

        @Override
        public Document parse(InputSource is) throws SAXException, IOException {
            System.out.println("DOM parse: " + (is.getSystemId() != null ? is.getSystemId() : is.toString()));
            return this.b.parse(is);
        }

        @Override
        public boolean isNamespaceAware() {
            return this.b.isNamespaceAware();
        }

        @Override
        public boolean isValidating() {
            return this.b.isValidating();
        }

        @Override
        public void setEntityResolver(EntityResolver er) {
            this.b.setEntityResolver(er);
        }

        @Override
        public void setErrorHandler(ErrorHandler eh) {
            this.b.setErrorHandler(eh);
        }

        @Override
        public Document newDocument() {
            return this.b.newDocument();
        }

        @Override
        public DOMImplementation getDOMImplementation() {
            return this.b.getDOMImplementation();
        }
    }

    private record DebugXMLReader(XMLReader r) implements XMLReader
    {
        @Override
        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return this.r.getFeature(name);
        }

        @Override
        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
            this.r.setFeature(name, value);
        }

        @Override
        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return this.r.getProperty(name);
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
            this.r.setProperty(name, value);
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
            this.r.setEntityResolver(resolver);
        }

        @Override
        public EntityResolver getEntityResolver() {
            return this.r.getEntityResolver();
        }

        @Override
        public void setDTDHandler(DTDHandler handler) {
            this.r.setDTDHandler(handler);
        }

        @Override
        public DTDHandler getDTDHandler() {
            return this.r.getDTDHandler();
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            this.r.setContentHandler(handler);
        }

        @Override
        public ContentHandler getContentHandler() {
            return this.r.getContentHandler();
        }

        @Override
        public void setErrorHandler(ErrorHandler handler) {
            this.r.setErrorHandler(handler);
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return this.r.getErrorHandler();
        }

        @Override
        public void parse(InputSource input) throws IOException, SAXException {
            System.out.println("SAX parse: " + (input.getSystemId() != null ? input.getSystemId() : input.toString()));
            this.r.parse(input);
        }

        @Override
        public void parse(String systemId) throws IOException, SAXException {
            System.out.println("SAX parse: " + systemId);
            this.r.parse(systemId);
        }
    }

    public static final class DebugURIResolver
    implements URIResolver {
        private final URIResolver r;

        public DebugURIResolver(URIResolver r) {
            this.r = r;
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            System.out.println("XSLT parse: " + href);
            return this.r.resolve(href, base);
        }
    }

    public static final class AttributesBuilder {
        final AttributesImpl atts;

        public AttributesBuilder() {
            this.atts = new AttributesImpl();
        }

        public AttributesBuilder(Attributes atts) {
            this.atts = new AttributesImpl(atts);
        }

        public AttributesBuilder add(String uri, String localName, String qName, String type, String value) {
            int i = this.atts.getIndex(uri, localName);
            if (i != -1) {
                this.atts.setAttribute(i, uri, localName, qName, type, value);
            } else {
                this.atts.addAttribute(uri, localName, qName, type, value);
            }
            return this;
        }

        public AttributesBuilder add(String localName, String value) {
            return this.add("", localName, localName, "CDATA", value);
        }

        public AttributesBuilder add(String uri, String localName, String value) {
            return this.add(uri, localName, localName, "CDATA", value);
        }

        public AttributesBuilder add(QName name, String value) {
            return this.add(name.getNamespaceURI(), name.getLocalPart(), name.getPrefix() + ":" + name.getLocalPart(), "CDATA", value);
        }

        public AttributesBuilder add(Attr attr) {
            return this.add(attr.getNamespaceURI() != null ? attr.getNamespaceURI() : "", attr.getLocalName() != null ? attr.getLocalName() : attr.getNodeName(), attr.getNodeName(), attr.isId() ? "ID" : "CDATA", attr.getNodeValue());
        }

        public void addAll(Attributes attrs) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                this.add(attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getType(i), attrs.getValue(i));
            }
        }

        public Attributes build() {
            return new AttributesImpl(this.atts);
        }
    }
}

