/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

public abstract class HeapSort<T, C> {
    public void heapSort(T a, int count, C comparator) {
        this.heapify(a, count, comparator);
        int end = count - 1;
        while (end > 0) {
            this.swap(a, end, 0);
            this.siftDown(a, 0, --end, comparator);
        }
    }

    protected abstract void swap(T var1, int var2, int var3);

    protected abstract int compare(T var1, int var2, int var3, C var4);

    void heapify(T a, int count, C comparator) {
        for (int start = count - 2 >> 1; start >= 0; --start) {
            this.siftDown(a, start, count - 1, comparator);
        }
    }

    static int parent(int i) {
        return i - 1 >> 1;
    }

    void siftDown(T a, int start, int end, C comparator) {
        int root = start;
        while (2 * root + 1 <= end) {
            int swap = root;
            int child = 2 * root + 1;
            if (this.compare(a, swap, child, comparator) < 0) {
                swap = child;
            }
            if (child + 1 <= end && this.compare(a, swap, child + 1, comparator) < 0) {
                swap = child + 1;
            }
            if (swap == root) {
                return;
            }
            this.swap(a, root, swap);
            root = swap;
        }
    }

    public static abstract class IndexSort
    extends HeapSort<int[], Object> {
        @Override
        protected void swap(int[] a, int i, int j) {
            int t = a[i];
            a[i] = a[j];
            a[j] = t;
        }

        protected abstract Object lookup(Object var1, int var2);

        protected abstract int compare(Object var1, Object var2);

        @Override
        protected int compare(int[] a, int i, int j, Object comparator) {
            Object y;
            int ai = a[i];
            int aj = a[j];
            Object x = this.lookup(comparator, ai);
            int cmp = this.compare(x, y = this.lookup(comparator, aj));
            if (cmp != 0) {
                return cmp;
            }
            return ai < aj ? -1 : (ai > aj ? 1 : 0);
        }
    }
}

