/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.IntSequence;
import gnu.lists.Range;
import gnu.lists.Sequence;
import gnu.lists.Sequences;

public abstract class IndirectIndexable<E>
extends AbstractSequence<E>
implements Sequence<E> {
    protected IntSequence indexes;
    public static final Range.IntRange cantWriteMarker = Range.IntRange.cantWriteMarker;

    @Override
    public int size() {
        return this.indexes == null || this.indexes == cantWriteMarker ? this.getBufferLength() : this.indexes.size();
    }

    public abstract int getBufferLength();

    protected void checkCanWrite() {
        if (this.indexes == cantWriteMarker) {
            throw new UnsupportedOperationException();
        }
    }

    protected IntSequence getIndexesForce() {
        return this.indexes == null ? cantWriteMarker : this.indexes;
    }

    protected abstract IndirectIndexable<E> withIndexes(IntSequence var1);

    protected IntSequence indexesSelect(IntSequence selected) {
        IntSequence ind = this.indexes == null || this.indexes == cantWriteMarker ? new Range.IntRange(0, 1, this.getBufferLength()) : this.indexes;
        return Sequences.indirectIndexed(ind, selected);
    }

    protected IntSequence indexesSubList(int fromIx, int toIx) {
        if (this.indexes == null || this.indexes == cantWriteMarker) {
            return new Range.IntRange(fromIx, 1, toIx - fromIx);
        }
        return this.indexes.subList(fromIx, toIx);
    }

    public IndirectIndexable<E> select(IntSequence indexes) {
        return this.withIndexes(this.indexesSelect(indexes));
    }

    @Override
    public IndirectIndexable<E> subList(int fromIx, int toIx) {
        return this.withIndexes(this.indexesSubList(fromIx, toIx));
    }

    @Override
    protected boolean isAfterPos(int ipos) {
        return this.indexes != cantWriteMarker && this.indexes instanceof AbstractSequence ? ((AbstractSequence)((Object)this.indexes)).isAfterPos(ipos) : super.isAfterPos(ipos);
    }

    @Override
    public int nextPos(int ipos) {
        return this.indexes != cantWriteMarker && this.indexes instanceof AbstractSequence ? ((AbstractSequence)((Object)this.indexes)).nextPos(ipos) : super.nextPos(ipos);
    }
}

