/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.swing;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.Marker;
import gnu.jemacs.buffer.Signal;
import gnu.jemacs.swing.BufferContent;
import gnu.jemacs.swing.BufferReader;
import gnu.lists.CharSeq;
import gnu.mapping.InPort;
import gnu.mapping.WrappedException;
import java.awt.Color;
import java.io.Reader;
import java.io.Writer;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Segment;
import javax.swing.text.StringContent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class SwingBuffer
extends Buffer {
    public DefaultStyledDocument doc;
    public Caret curPosition = null;
    public BufferContent content;
    public StyledDocument modelineDocument;
    public static StyleContext styles = new StyleContext();
    public static Style defaultStyle = styles.addStyle("default", null);
    public Style inputStyle = defaultStyle;
    public static Style redStyle = styles.addStyle("red", null);
    static Style blueStyle = styles.addStyle("blue", null);

    public SwingBuffer(String string) {
        this(string, new BufferContent());
    }

    public SwingBuffer(String string, BufferContent bufferContent) {
        super(string);
        this.doc = new DefaultStyledDocument((AbstractDocument.Content)bufferContent, styles);
        this.content = bufferContent;
        this.pointMarker = new Marker(this, 0, true);
        this.markMarker = new Marker();
        this.modelineDocument = new DefaultStyledDocument((AbstractDocument.Content)new StringContent(), styles);
        this.doc.putProperty("i18n", Boolean.TRUE);
        this.redrawModeline();
    }

    public void removeRegion(int n, int n2) throws BadLocationException {
        this.doc.remove(n, n2 - n);
    }

    public void removeAll() {
        try {
            this.doc.remove(0, this.maxDot());
        }
        catch (BadLocationException badLocationException) {
            throw new WrappedException(badLocationException);
        }
    }

    public void removeChar(int n) {
        this.remove(this.getDot(), n);
    }

    void remove(int n, int n2) {
        try {
            if (n2 < 0) {
                if (n - (n2 = -n2) < this.minDot()) {
                    Signal.signal("Beginning of buffer");
                }
                n -= n2;
            } else if (n + n2 > this.maxDot()) {
                Signal.signal("End of buffer");
            }
            this.doc.remove(n, n2);
            this.setDot(n);
        }
        catch (BadLocationException badLocationException) {
            throw new Error("bad location: " + badLocationException);
        }
    }

    public void removePos(int n, int n2) {
        this.remove(this.nextIndex(n), n2);
    }

    public void save(Writer writer) throws Exception {
        int n;
        int n2;
        int n3 = n2 = this.getLength();
        Segment segment = new Segment();
        for (int i = 0; i < n2; i += n) {
            n = n2;
            if (n > 4096) {
                n = 4096;
            }
            this.doc.getText(i, n, segment);
            writer.write(segment.array, segment.offset, segment.count);
        }
    }

    public void insert(char c, int n) {
        this.pointMarker.insert(c, n, this.inputStyle);
    }

    public void insert(int n, String string, Object object2) {
        if (object2 == null) {
            object2 = defaultStyle;
        }
        try {
            this.doc.insertString(n, string, (Style)object2);
        }
        catch (BadLocationException badLocationException) {
            throw new Error("bad location: " + badLocationException);
        }
    }

    public void insert(String string, Object object2) {
        this.insert(this.getDot(), string, object2);
    }

    public void insert(String string, Object object2, int n) {
        this.insert(this.nextIndex(n), string, object2);
    }

    public void insertFile(Reader reader) throws Exception {
        int n;
        char[] cArray = new char[2048];
        int n2 = this.getDot();
        while ((n = reader.read(cArray, 0, cArray.length)) > 0) {
            this.doc.insertString(n2, new String(cArray, 0, n), null);
            n2 += n;
        }
    }

    public void redrawModeline() {
        try {
            this.modelineDocument.remove(0, this.modelineDocument.getLength());
            this.modelineDocument.insertString(0, "-----", redStyle);
            this.modelineDocument.insertString(this.modelineDocument.getLength(), "JEmacs: " + this.getName(), blueStyle);
            this.modelineDocument.insertString(this.modelineDocument.getLength(), " ---", redStyle);
        }
        catch (BadLocationException badLocationException) {
            throw new Error("internal error in redraw-modeline- " + badLocationException);
        }
    }

    public long scan(char c, int n, int n2, int n3, boolean bl) {
        if (n2 == 0) {
            n2 = n3 > 0 ? this.content.length() - 1 : 0;
        }
        return this.content.scan(c, n, n2, n3, bl);
    }

    public int lineStartOffset(int n) {
        return (int)this.content.scan('\n', n, this.minDot(), -1, true);
    }

    public int getDot() {
        if (this.pointMarker.sequence == null) {
            return this.curPosition.getDot();
        }
        return this.pointMarker.getOffset();
    }

    public void setDot(int n) {
        if (n > this.maxDot()) {
            throw new Error("set dot to " + n + " max:" + this.maxDot());
        }
        if (this.pointMarker.sequence == null) {
            this.curPosition.setDot(n);
        } else {
            this.pointMarker.set(this, n);
        }
    }

    public int maxDot() {
        return this.content.length() - 1;
    }

    public int getLength() {
        return this.doc.getLength();
    }

    public CharSeq getStringContent() {
        return this.content;
    }

    public int createPos(int n, boolean bl) {
        return this.content.createPos(n, bl);
    }

    public Object get(int n) {
        return this.content.get(n);
    }

    public int size() {
        return this.content.size();
    }

    public int nextIndex(int n) {
        return this.content.nextIndex(n);
    }

    public long savePointMark() {
        int n = this.content.createPos(this.getDot(), false);
        int n2 = 0;
        return (long)n2 << 32 | (long)n & 0xFFFFFFFFL;
    }

    public void restorePointMark(long l) {
        int n = (int)l;
        int n2 = (int)(l >> 32);
        this.setDot(this.content.nextIndex(n));
        this.content.releasePos(n);
    }

    public InPort openReader(int n, int n2) {
        return new BufferReader(this, n, n2);
    }

    public void invoke(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            throw new WrappedException(exception);
        }
    }

    static {
        String string = System.getProperty("java.version");
        if (string != null && (string.startsWith("1.2") || string.startsWith("1.3"))) {
            StyleConstants.setFontFamily(defaultStyle, "Lucida Sans TypeWriter");
            StyleConstants.setFontSize(defaultStyle, 14);
        }
        StyleConstants.setForeground(redStyle, Color.red);
        StyleConstants.setForeground(blueStyle, Color.blue);
    }
}

