/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.expr.Keyword;
import gnu.kawa.xml.KNode;
import gnu.kawa.xml.UntypedAtomic;
import gnu.kawa.xml.XmlNamespace;
import gnu.lists.AbstractFormat;
import gnu.lists.Array;
import gnu.lists.CharSeq;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.ConsumerWriter;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.SimpleVector;
import gnu.lists.Strings;
import gnu.mapping.Namespace;
import gnu.mapping.OutPort;
import gnu.mapping.Promise;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.mapping.Values;
import gnu.math.IntNum;
import gnu.math.RatNum;
import gnu.text.Char;
import gnu.text.PrettyWriter;
import gnu.text.Printable;
import gnu.xml.XMLPrinter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.regex.Pattern;

public class DisplayFormat
extends AbstractFormat {
    public static final ThreadLocation outBase = new ThreadLocation("out-base");
    public static final ThreadLocation outRadix;
    public boolean checkSharing = false;
    boolean readable;
    char language;
    static Pattern r5rsIdentifierMinusInteriorColons;

    public DisplayFormat(boolean readable, char language) {
        this.readable = readable;
        this.language = language;
    }

    public static DisplayFormat getEmacsLispFormat(boolean readable) {
        return new DisplayFormat(readable, 'E');
    }

    public static DisplayFormat getCommonLispFormat(boolean readable) {
        return new DisplayFormat(readable, 'C');
    }

    public static DisplayFormat getSchemeFormat(boolean readable) {
        return new DisplayFormat(readable, 'S');
    }

    public boolean getReadableOutput() {
        return this.readable;
    }

    public void writeBoolean(boolean v, Consumer out) {
        this.write(this.language == 'S' ? (v ? "#t" : "#f") : (v ? "t" : "nil"), out);
    }

    public void write(int v, Consumer out) {
        if (!this.getReadableOutput()) {
            Char.print(v, out);
        } else if (this.language == 'E' && v > 32) {
            out.write(63);
            Char.print(v, out);
        } else {
            this.write(Char.toScmReadableString(v), out);
        }
    }

    public void writeList(LList value, OutPort out) {
        PrettyWriter pout = out.getPrettyWriter();
        int[] posnStack = null;
        int stackTail = 0;
        Object list = value;
        out.startLogicalBlock("(", false, ")");
        while (list instanceof Pair) {
            Pair pair = (Pair)list;
            this.writeObject(pair.getCar(), (Consumer)out);
            list = pair.getCdr();
            if (!this.getReadableOutput()) {
                list = Promise.force(list);
            }
            if (list == LList.Empty) break;
            out.writeSpaceFill();
            if (!(list instanceof Pair)) {
                out.write(". ");
                this.writeObject(LList.checkNonList(list), (Consumer)out);
                break;
            }
            if (!this.checkSharing) continue;
            int hashIndex = pout.IDHashLookup(list);
            int posn = pout.IDHashGetFromIndex(hashIndex);
            if (posn == -1) {
                posn = pout.writePositionMarker(true);
                if (posnStack == null) {
                    posnStack = new int[128];
                } else if (stackTail >= posnStack.length) {
                    int[] newStack = new int[posnStack.length << 1];
                    System.arraycopy(posnStack, 0, newStack, 0, stackTail);
                    posnStack = newStack;
                }
                posnStack[stackTail++] = posn;
                pout.IDHashPutAtIndex(list, posn, hashIndex);
                continue;
            }
            out.write(".");
            out.writeSpaceFill();
            pout.writeBackReference(posn);
            list = LList.Empty;
            break;
        }
        while (--stackTail >= 0) {
            pout.writePairEnd((int)posnStack[stackTail]);
        }
        out.endLogicalBlock(")");
    }

    public void writeObject(Object obj, Consumer out) {
        PrettyWriter pout = ((OutPort)out).getPrettyWriter();
        boolean space = false;
        boolean skip = false;
        if (!(!(out instanceof OutPort) || obj instanceof UntypedAtomic || obj instanceof Values || !this.getReadableOutput() && (obj instanceof Char || obj instanceof CharSequence || obj instanceof Character))) {
            ((OutPort)out).writeWordStart();
            space = true;
        }
        if (this.checkSharing && this.isInteresting(obj)) {
            int hashIndex = pout.IDHashLookup(obj);
            int posn = pout.IDHashGetFromIndex(hashIndex);
            if (posn == -1) {
                posn = pout.writePositionMarker(false);
                pout.IDHashPutAtIndex(obj, posn, hashIndex);
                skip = false;
            } else {
                pout.writeBackReference(posn);
                skip = true;
                space = true;
            }
        }
        if (!skip) {
            this.writeObjectRaw(obj, out);
        }
        if (space) {
            ((OutPort)out).writeWordEnd();
        }
    }

    public void writeObjectRaw(Object obj, Consumer out) {
        if (!this.readable) {
            obj = Promise.force(obj);
        }
        if (obj instanceof Boolean) {
            this.writeBoolean((Boolean)obj, out);
        } else if (obj instanceof Char) {
            this.write(((Char)obj).intValue(), out);
        } else if (obj instanceof Character) {
            this.write(((Character)obj).charValue(), out);
        } else if (obj instanceof Symbol) {
            Symbol sym = (Symbol)obj;
            if (sym.getNamespace() == XmlNamespace.HTML) {
                this.write("html:", out);
                this.write(sym.getLocalPart(), out);
            } else {
                this.writeSymbol(sym, out, this.readable);
            }
        } else if (obj instanceof URI && this.getReadableOutput() && out instanceof PrintWriter) {
            this.write("#,(URI ", out);
            Strings.printQuoted(obj.toString(), (PrintWriter)((Object)out), 1);
            out.write(41);
        } else if (obj instanceof CharSequence) {
            CharSequence str = (CharSequence)obj;
            if (this.getReadableOutput() && out instanceof PrintWriter) {
                Strings.printQuoted(str, (PrintWriter)((Object)out), 1);
            } else if (obj instanceof String) {
                out.write((String)obj);
            } else if (obj instanceof CharSeq) {
                CharSeq seq = (CharSeq)obj;
                seq.consume(0, seq.size(), out);
            } else {
                int len = str.length();
                for (int i = 0; i < len; ++i) {
                    out.write(str.charAt(i));
                }
            }
        } else if (obj instanceof LList && out instanceof OutPort) {
            this.writeList((LList)obj, (OutPort)out);
        } else if (obj instanceof SimpleVector) {
            String end;
            String start;
            SimpleVector vec = (SimpleVector)obj;
            String tag = vec.getTag();
            if (this.language == 'E') {
                start = "[";
                end = "]";
            } else {
                start = tag == null ? "#(" : "#" + tag + "(";
                end = ")";
            }
            if (out instanceof OutPort) {
                ((OutPort)out).startLogicalBlock(start, false, end);
            } else {
                this.write(start, out);
            }
            int endpos = vec.size() << 1;
            for (int ipos = 0; ipos < endpos; ipos += 2) {
                if (ipos > 0 && out instanceof OutPort) {
                    ((OutPort)out).writeSpaceFill();
                }
                if (!vec.consumeNext(ipos, out)) break;
            }
            if (out instanceof OutPort) {
                ((OutPort)out).endLogicalBlock(end);
            } else {
                this.write(end, out);
            }
        } else if (obj instanceof Array) {
            this.write((Array)obj, 0, 0, out);
        } else if (obj instanceof KNode) {
            if (this.getReadableOutput()) {
                this.write("#", out);
            }
            Writer wout = out instanceof Writer ? (Writer)((Object)out) : new ConsumerWriter(out);
            XMLPrinter xout = new XMLPrinter(wout);
            xout.writeObject(obj);
            xout.closeThis();
        } else if (obj == Values.empty && this.getReadableOutput()) {
            this.write("#!void", out);
        } else if (!(!(obj instanceof Consumable) || this.readable && obj instanceof Printable)) {
            ((Consumable)obj).consume(out);
        } else if (obj instanceof Printable) {
            ((Printable)obj).print(out);
        } else if (obj instanceof RatNum) {
            int b = 10;
            boolean showRadix = false;
            Object base = outBase.get(null);
            Object printRadix = outRadix.get(null);
            if (printRadix != null && (printRadix == Boolean.TRUE || "yes".equals(printRadix.toString()))) {
                showRadix = true;
            }
            if (base instanceof Number) {
                b = ((IntNum)base).intValue();
            } else if (base != null) {
                b = Integer.parseInt(base.toString());
            }
            String asString = ((RatNum)obj).toString(b);
            if (showRadix) {
                if (b == 16) {
                    this.write("#x", out);
                } else if (b == 8) {
                    this.write("#o", out);
                } else if (b == 2) {
                    this.write("#b", out);
                } else if (b != 10 || !(obj instanceof IntNum)) {
                    this.write("#" + base + "r", out);
                }
            }
            this.write(asString, out);
            if (showRadix && b == 10 && obj instanceof IntNum) {
                this.write(".", out);
            }
        } else if (obj instanceof Enum && this.getReadableOutput()) {
            this.write(obj.getClass().getName(), out);
            this.write(":", out);
            this.write(((Enum)obj).name(), out);
        } else {
            String asString;
            if (obj == null) {
                asString = null;
            } else {
                Class<?> cl = obj.getClass();
                if (cl.isArray()) {
                    int len = java.lang.reflect.Array.getLength(obj);
                    if (out instanceof OutPort) {
                        ((OutPort)out).startLogicalBlock("[", false, "]");
                    } else {
                        this.write("[", out);
                    }
                    for (int i = 0; i < len; ++i) {
                        if (i > 0) {
                            this.write(" ", out);
                            if (out instanceof OutPort) {
                                ((OutPort)out).writeBreakFill();
                            }
                        }
                        this.writeObject(java.lang.reflect.Array.get(obj, i), out);
                    }
                    if (out instanceof OutPort) {
                        ((OutPort)out).endLogicalBlock("]");
                    } else {
                        this.write("]", out);
                    }
                    return;
                }
                asString = obj.toString();
            }
            if (asString == null) {
                this.write("#!null", out);
            } else {
                this.write(asString, out);
            }
        }
    }

    int write(Array array, int index, int level, Consumer out) {
        String start;
        int rank = array.rank();
        int count = 0;
        String string = level > 0 ? "(" : (start = rank == 1 ? "#(" : "#" + rank + "a(");
        if (out instanceof OutPort) {
            ((OutPort)out).startLogicalBlock(start, false, ")");
        } else {
            this.write(start, out);
        }
        if (rank > 0) {
            int size = array.getSize(level);
            ++level;
            for (int i = 0; i < size; ++i) {
                int step;
                if (i > 0) {
                    this.write(" ", out);
                    if (out instanceof OutPort) {
                        ((OutPort)out).writeBreakFill();
                    }
                }
                if (level == rank) {
                    this.writeObject(array.getRowMajor(index), out);
                    step = 1;
                } else {
                    step = this.write(array, index, level, out);
                }
                index += step;
                count += step;
            }
        }
        if (out instanceof OutPort) {
            ((OutPort)out).endLogicalBlock(")");
        } else {
            this.write(")", out);
        }
        return count;
    }

    void writeSymbol(Symbol sym, Consumer out, boolean readable) {
        String prefix = sym.getPrefix();
        Namespace namespace = sym.getNamespace();
        String uri = namespace == null ? null : namespace.getName();
        boolean hasUri = uri != null && uri.length() > 0;
        boolean hasPrefix = prefix != null && prefix.length() > 0;
        boolean suffixColon = false;
        if (namespace == Keyword.keywordNamespace) {
            if (this.language == 'C' || this.language == 'E') {
                out.write(58);
            } else {
                suffixColon = true;
            }
        } else if (hasPrefix || hasUri) {
            if (hasPrefix) {
                this.writeSymbol(prefix, out, readable);
            }
            if (hasUri && (readable || !hasPrefix)) {
                out.write(123);
                out.write(uri);
                out.write(125);
            }
            out.write(58);
        }
        this.writeSymbol(sym.getName(), out, readable);
        if (suffixColon) {
            out.write(58);
        }
    }

    void writeSymbol(String sym, Consumer out, boolean readable) {
        if (readable && !r5rsIdentifierMinusInteriorColons.matcher(sym).matches()) {
            int len = sym.length();
            if (len == 0) {
                this.write("||", out);
            } else {
                boolean inVerticalBars = false;
                for (int i = 0; i < len; ++i) {
                    char ch = sym.charAt(i);
                    if (ch == '|') {
                        this.write(inVerticalBars ? "|\\" : "\\", out);
                        inVerticalBars = false;
                    } else if (!inVerticalBars) {
                        out.write(124);
                        inVerticalBars = true;
                    }
                    out.write(ch);
                }
                if (inVerticalBars) {
                    out.write(124);
                }
            }
            return;
        }
        this.write(sym, out);
    }

    private boolean isInteresting(Object obj) {
        return obj instanceof Pair || obj instanceof SimpleVector;
    }

    static {
        outBase.setGlobal(IntNum.ten());
        outRadix = new ThreadLocation("out-radix");
        r5rsIdentifierMinusInteriorColons = Pattern.compile("(([a-zA-Z]|[!$%&*/:<=>?^_~])([a-zA-Z]|[!$%&*/<=>?^_~]|[0-9]|([-+.@]))*[:]?)|([-+]|[.][.][.])");
    }
}

