/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.IndirectableLocation;
import gnu.mapping.Namespace;
import gnu.mapping.PlainLocation;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.mapping.UnboundLocationException;
import java.io.PrintWriter;

public abstract class Location {
    public static final String UNBOUND = new String("(unbound)");

    public Symbol getKeySymbol() {
        return null;
    }

    public Object getKeyProperty() {
        return null;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.getClass().getName());
        Symbol sym = this.getKeySymbol();
        sbuf.append('[');
        if (sym != null) {
            sbuf.append(sym);
            Object property = this.getKeyProperty();
            if (property != null && property != this) {
                sbuf.append('/');
                sbuf.append(property);
            }
        }
        sbuf.append("]");
        return sbuf.toString();
    }

    public abstract Object get(Object var1);

    public final Object get() {
        String unb = UNBOUND;
        Object val = this.get(unb);
        if (val == unb) {
            throw new UnboundLocationException(this);
        }
        return val;
    }

    public abstract void set(Object var1);

    public void undefine() {
        this.set(UNBOUND);
    }

    public Object setWithSave(Object newValue) {
        Object old = this.get(UNBOUND);
        this.set(newValue);
        return old;
    }

    public void setRestore(Object oldValue) {
        this.set(oldValue);
    }

    public boolean isBound() {
        String unb = UNBOUND;
        return this.get(unb) != unb;
    }

    public boolean isConstant() {
        return false;
    }

    public Location getBase() {
        return this;
    }

    public final Object getValue() {
        return this.get(null);
    }

    public final Object setValue(Object newValue) {
        Object value = this.get(null);
        this.set(newValue);
        return value;
    }

    public boolean entered() {
        return false;
    }

    public void print(PrintWriter ps) {
        String unb;
        Object value;
        ps.print("#<location ");
        Symbol name = this.getKeySymbol();
        if (name != null) {
            ps.print(name);
        }
        if ((value = this.get(unb = UNBOUND)) != unb) {
            ps.print(" -> ");
            ps.print(value);
        } else {
            ps.print("(unbound)");
        }
        ps.print('>');
    }

    public static Location make(Object init, String name) {
        ThreadLocation loc = new ThreadLocation(name);
        loc.setGlobal(init);
        return loc;
    }

    public static IndirectableLocation make(String name) {
        Symbol sym = Namespace.EmptyNamespace.getSymbol(name.intern());
        PlainLocation loc = new PlainLocation(sym, null);
        loc.base = null;
        loc.value = UNBOUND;
        return loc;
    }

    public static IndirectableLocation make(Symbol name) {
        PlainLocation loc = new PlainLocation(name, null);
        loc.base = null;
        loc.value = UNBOUND;
        return loc;
    }
}

