/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.lispexpr.ReadTableEntry;
import gnu.lists.Pair;
import gnu.mapping.Values;
import gnu.text.Lexer;
import gnu.text.LineBufferedReader;
import gnu.text.SyntaxException;
import java.io.IOException;

public class ReaderParens
extends ReadTableEntry {
    char open;
    char close;
    int kind;
    Object command;
    private static ReaderParens instance;

    public int getKind() {
        return this.kind;
    }

    public static ReaderParens getInstance(char open, char close) {
        return ReaderParens.getInstance(open, close, 5);
    }

    public static ReaderParens getInstance(char open, char close, int kind) {
        if (open == '(' && close == ')' && kind == 5) {
            if (instance == null) {
                instance = new ReaderParens(open, close, kind, null);
            }
            return instance;
        }
        return new ReaderParens(open, close, kind, null);
    }

    public static ReaderParens getInstance(char open, char close, int kind, Object command) {
        if (command == null) {
            return ReaderParens.getInstance(open, close, kind);
        }
        return new ReaderParens(open, close, kind, command);
    }

    public ReaderParens(char open, char close, int kind, Object command) {
        this.open = open;
        this.close = close;
        this.kind = kind;
        this.command = command;
    }

    public Object read(Lexer in, int ch, int count) throws IOException, SyntaxException {
        Object r = ReaderParens.readList((LispReader)in, ch, count, this.close);
        if (this.command != null) {
            LineBufferedReader port = in.getPort();
            int startLine = port.getLineNumber();
            int startColumn = port.getColumnNumber();
            Pair p = ((LispReader)in).makePair(this.command, startLine, startColumn);
            ((LispReader)in).setCdr(p, r);
            r = p;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readList(LispReader lexer, int ch, int count, int close) throws IOException, SyntaxException {
        LineBufferedReader port = lexer.getPort();
        char saveReadState = lexer.pushNesting(close == 93 ? (char)'[' : '(');
        int startLine = port.getLineNumber();
        int startColumn = port.getColumnNumber();
        try {
            Object last = null;
            Object list = lexer.makeNil();
            boolean sawDot = false;
            boolean sawDotCdr = false;
            ReadTable readTable = ReadTable.getCurrent();
            while (true) {
                ReadTableEntry entry;
                int line = port.getLineNumber();
                int column = port.getColumnNumber();
                ch = port.read();
                if (ch == close) break;
                if (ch < 0) {
                    lexer.eofError("unexpected EOF in list starting here", startLine + 1, startColumn);
                }
                if (ch == 46) {
                    ch = port.peek();
                    entry = readTable.lookup(ch);
                    int kind = entry.getKind();
                    if (kind == 1 || kind == 5 || kind == 0) {
                        port.skip();
                        ++column;
                        if (ch == close) {
                            lexer.error("unexpected '" + (char)close + "' after '.'");
                            break;
                        }
                        if (ch < 0) {
                            lexer.eofError("unexpected EOF in list starting here", startLine + 1, startColumn);
                        }
                        if (sawDot) {
                            lexer.error("multiple '.' in list");
                            sawDotCdr = false;
                            list = lexer.makeNil();
                            last = null;
                        }
                        sawDot = true;
                    } else {
                        ch = 46;
                        entry = ReadTableEntry.getConstituentInstance();
                    }
                } else {
                    entry = readTable.lookup(ch);
                }
                Object value = lexer.readValues(ch, entry, readTable);
                if (value == Values.empty) continue;
                value = lexer.handlePostfix(value, readTable, line, column);
                if (sawDotCdr) {
                    lexer.error("multiple values after '.'");
                    last = null;
                    list = lexer.makeNil();
                    sawDotCdr = false;
                    continue;
                }
                if (sawDot) {
                    sawDotCdr = true;
                } else {
                    if (last == null) {
                        line = startLine;
                        column = startColumn - 1;
                    }
                    value = lexer.makePair(value, line, column);
                }
                if (last == null) {
                    list = value;
                } else {
                    lexer.setCdr(last, value);
                }
                last = value;
            }
            Object object2 = list;
            return object2;
        }
        finally {
            lexer.popNesting(saveReadState);
        }
    }
}

