/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

package org.mozilla.gecko;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;

import android.app.Activity;

public final class RobocopUtils {
    private static final int MAX_WAIT_MS = 20000;

    private RobocopUtils() {}

    public static void runOnUiThreadSync(Activity activity, final Runnable runnable) {
        final SynchronousQueue syncQueue = new SynchronousQueue();
        activity.runOnUiThread(
            new Runnable() {
                public void run() {
                    runnable.run();
                    try {
                        syncQueue.put(new Object());
                    } catch (InterruptedException e) {
                        IceCatMobileNativeDriver.log(IceCatMobileNativeDriver.LogLevel.ERROR, e);
                    }
                }
            });
        try {
            // Wait for the UiThread code to finish running
            if (syncQueue.poll(MAX_WAIT_MS, TimeUnit.MILLISECONDS) == null) {
                IceCatMobileNativeDriver.log(IceCatMobileNativeDriver.LogLevel.ERROR,
                                       "time-out waiting for UI thread");
                IceCatMobileNativeDriver.logAllStackTraces(IceCatMobileNativeDriver.LogLevel.ERROR);
            }
        } catch (InterruptedException e) {
            IceCatMobileNativeDriver.log(IceCatMobileNativeDriver.LogLevel.ERROR, e);
        }
    }
}
