/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.technology.Layer;
import com.sun.electric.util.JavaCompatiblity;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpTransform;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PolySweepMerge
extends GeometryHandler {
    public PolySweepMerge() {
    }

    public PolySweepMerge(int initialSize) {
        super(initialSize);
    }

    public void setMode(int mode) {
    }

    @Override
    public void add(Layer key, Object element) {
        PolySweepContainer container = (PolySweepContainer)this.layers.get(key);
        if (container == null) {
            container = new PolySweepContainer(true);
            this.layers.put(key, container);
        }
        container.add(element);
    }

    @Override
    public void subtract(Object key, Object element) {
        PolySweepContainer container = (PolySweepContainer)this.layers.get(key);
        if (container == null) {
            return;
        }
        container.subtract(element);
    }

    @Override
    public void subtractAll(Map<Layer, List<PolyBase>> map) {
        for (Map.Entry<Layer, List<PolyBase>> e : map.entrySet()) {
            PolySweepContainer container = (PolySweepContainer)this.layers.get(e.getKey());
            if (container == null) continue;
            for (PolyBase p : e.getValue()) {
                container.subtract(p);
            }
        }
    }

    @Override
    public void addAll(GeometryHandler subMerge, FixpTransform tTrans) {
        PolySweepMerge other = (PolySweepMerge)subMerge;
        ArrayList<Area> list = new ArrayList<Area>();
        for (Map.Entry e : other.layers.entrySet()) {
            Layer layer = (Layer)e.getKey();
            PolySweepContainer container = (PolySweepContainer)this.layers.get(layer);
            PolySweepContainer otherContainer = (PolySweepContainer)e.getValue();
            if (container == null) {
                container = new PolySweepContainer(false);
                this.layers.put(layer, container);
                container.areas = new ArrayList<Area>(otherContainer.areas.size());
            }
            ArrayList<Area> otherAreas = new ArrayList<Area>(otherContainer.areas.size());
            for (Area area : otherContainer.areas) {
                otherAreas.add((Area)area.clone());
            }
            Collections.sort(otherAreas, areaSort);
            Collections.sort(container.areas, areaSort);
            for (Area area : otherAreas) {
                Area thisArea;
                Rectangle2D thisRect;
                if (tTrans != null) {
                    area.transform(tTrans);
                }
                Rectangle2D rect = area.getBounds2D();
                double areaMinX = rect.getMinX();
                double areaMaxX = rect.getMaxX();
                list.clear();
                Iterator<Area> iterator = container.areas.iterator();
                while (iterator.hasNext() && !(areaMaxX < (thisRect = (thisArea = iterator.next()).getBounds2D()).getMinX())) {
                    if (!(areaMinX <= thisRect.getMaxX())) continue;
                    list.add(thisArea);
                    area.add(thisArea);
                }
                container.areas.removeAll(list);
                container.areas.add(area);
            }
            otherAreas = null;
        }
    }

    @Override
    public void postProcess(boolean merge) {
        if (merge) {
            this.mergeProcess();
        } else {
            this.disjointProcess();
        }
    }

    private void disjointProcess() {
        for (Object obj : this.layers.values()) {
            PolySweepContainer container = (PolySweepContainer)obj;
            if (container == null) continue;
            Collections.sort(container.areas, areaSort);
            double maxXSweep = -1.7976931348623157E308;
            Area areaXTmp = null;
            ArrayList<Area> twoFrontierAreas = new ArrayList<Area>();
            ArrayList<Area> tmp = new ArrayList<Area>();
            for (Area geomArea : container.areas) {
                Rectangle2D rectX = geomArea.getBounds2D();
                double minX = rectX.getX();
                double maxX = rectX.getMaxX();
                if (minX > maxXSweep) {
                    if (areaXTmp != null) {
                        PolySweepMerge.sweepYFrontier(twoFrontierAreas, tmp, false);
                        areaXTmp = null;
                    }
                    tmp.clear();
                }
                tmp.add(geomArea);
                if (areaXTmp == null) {
                    areaXTmp = geomArea;
                }
                if (!(maxX > maxXSweep)) continue;
                maxXSweep = maxX;
            }
            PolySweepMerge.sweepYFrontier(twoFrontierAreas, tmp, false);
            container.areas = twoFrontierAreas;
        }
    }

    private void mergeProcess() {
        for (Object obj : this.layers.values()) {
            PolySweepContainer container = (PolySweepContainer)obj;
            if (container == null) continue;
            Collections.sort(container.areas, areaSort);
            double maxXSweep = -1.7976931348623157E308;
            Area areaXTmp = null;
            ArrayList<Area> areas = new ArrayList<Area>();
            for (Area geom : container.areas) {
                Rectangle2D rectX = geom.getBounds2D();
                double minX = rectX.getX();
                double maxX = rectX.getMaxX();
                if (minX > maxXSweep && areaXTmp != null) {
                    if (!areas.contains(areaXTmp)) {
                        areas.add(areaXTmp);
                    }
                    areaXTmp = null;
                }
                if (areaXTmp == null) {
                    areaXTmp = geom;
                    areas.add(areaXTmp);
                } else {
                    areaXTmp.add(geom);
                }
                if (!(maxX > maxXSweep)) continue;
                maxXSweep = maxX;
            }
            if (areaXTmp != null && !areas.contains(areaXTmp)) {
                areas.add(areaXTmp);
            }
            container.areas = areas;
        }
    }

    private static void sweepYFrontier(List<Area> twoFrontierAreas, List<Area> tmp, boolean merge) {
        if (merge) {
            return;
        }
        Collections.sort(tmp, areaSort);
        double maxYSweep = -1.7976931348623157E308;
        Area areaYTmp = null;
        for (Area area : tmp) {
            Rectangle2D rectY = area.getBounds2D();
            double minY = rectY.getY();
            double maxY = rectY.getMaxY();
            if (minY > maxYSweep) {
                if (areaYTmp != null && !twoFrontierAreas.contains(areaYTmp)) {
                    twoFrontierAreas.add(areaYTmp);
                }
                areaYTmp = null;
            }
            if (areaYTmp == null) {
                if (!merge) {
                    areaYTmp = (Area)area.clone();
                    twoFrontierAreas.add(area);
                } else {
                    areaYTmp = area;
                    twoFrontierAreas.add(areaYTmp);
                }
            } else if (merge) {
                areaYTmp.add(area);
            } else {
                Area clone = (Area)area.clone();
                clone.intersect(areaYTmp);
                if (!clone.isEmpty()) {
                    area.subtract(areaYTmp);
                }
                if (!area.isEmpty()) {
                    twoFrontierAreas.add(area);
                    areaYTmp.add(area);
                }
            }
            if (!(maxY > maxYSweep)) continue;
            maxYSweep = maxY;
        }
        if (areaYTmp != null && merge && !twoFrontierAreas.contains(areaYTmp)) {
            twoFrontierAreas.add(areaYTmp);
        }
    }

    @Override
    public Collection<PolyBase> getObjects(Object layer, boolean modified, boolean simple) {
        PolySweepContainer container = (PolySweepContainer)this.layers.get(layer);
        if (container == null) {
            return null;
        }
        ArrayList<PolyBase> list = new ArrayList<PolyBase>();
        for (Area area : container.areas) {
            list.addAll(PolyBase.getPointsInArea(area, (Layer)layer, simple, false));
        }
        return list;
    }

    public List<Area> getAreas(Layer layer) {
        PolySweepContainer container = (PolySweepContainer)this.layers.get(layer);
        return container != null ? container.areas : null;
    }

    @Override
    public Collection<PolyBase.PolyBaseTree> getTreeObjects(Object layer) {
        PolySweepContainer container = (PolySweepContainer)this.layers.get(layer);
        if (container == null) {
            return null;
        }
        ArrayList<PolyBase.PolyBaseTree> list = new ArrayList<PolyBase.PolyBaseTree>();
        for (Area area : container.areas) {
            list.addAll(PolyBase.getPolyTrees(area, (Layer)layer));
        }
        return list;
    }

    private static Set<Point2D> getPoints(Area area) {
        double[] coords = new double[6];
        LinkedHashSet<Point2D> pointSet = JavaCompatiblity.JAVA8 ? new LinkedHashSet() : new HashSet();
        PathIterator pIt = area.getPathIterator(null);
        while (!pIt.isDone()) {
            int type = pIt.currentSegment(coords);
            if (type != 4 && (type == 0 || type == 1)) {
                Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                pointSet.add(pt);
            }
            pIt.next();
        }
        return pointSet;
    }

    private static List<PolyEdge> getEdges(Area area) {
        double[] coords = new double[6];
        ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
        ArrayList<PolyEdge> edgesList = new ArrayList<PolyEdge>();
        PathIterator pIt = area.getPathIterator(null);
        while (!pIt.isDone()) {
            int type = pIt.currentSegment(coords);
            if (type == 4) {
                int size = pointList.size();
                for (int i = 0; i < size; ++i) {
                    PolyEdge edge = new PolyEdge((Point2D)pointList.get(i), (Point2D)pointList.get((i + 1) % size));
                    edgesList.add(edge);
                }
                pointList.clear();
            } else if (type == 0 || type == 1) {
                Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                pointList.add(pt);
            }
            pIt.next();
        }
        return edgesList;
    }

    public Collection<PolyBase> getPolyPartition(Object layer) {
        ArrayList<PolyBase> list = new ArrayList<PolyBase>();
        PolySweepContainer container = (PolySweepContainer)this.layers.get(layer);
        Collections.sort(container.areas, areaSort);
        for (Area area : container.areas) {
            GeometryHandlerQTree g = new GeometryHandlerQTree(area);
            g.refine();
            g.getSimplePolygons(list);
        }
        return list;
    }

    private static class PolySweepContainer {
        private List<Area> areas = null;

        public PolySweepContainer(boolean createPolyList) {
            this.areas = createPolyList ? new ArrayList() : null;
        }

        public void add(Object value) {
            Area a = null;
            if (value instanceof Shape) {
                a = new Area((Shape)value);
            } else {
                System.out.println("Error: invalid class for addition in PolySweepMerge");
            }
            this.areas.add(a);
        }

        public void subtract(Object element) {
            Area elem = null;
            if (element instanceof Shape) {
                elem = new Area((Shape)element);
            } else {
                System.out.println("Error: invalid class for subtraction in PolySweepMerge");
            }
            for (Area a : this.areas) {
                a.subtract(elem);
            }
        }
    }

    static class PolyEdge {
        Point2D start;
        Point2D end;
        int dir;

        PolyEdge(Point2D s, Point2D e) {
            this.start = s;
            this.end = e;
            boolean alignX = DBMath.areEquals(s.getX(), e.getX());
            boolean alignY = DBMath.areEquals(s.getY(), e.getY());
            if (alignX && alignY) {
                System.out.println("Degenerated edge in 1 point :" + this.start);
            }
            this.dir = alignX ? 0 : (alignY ? 1 : 4);
        }
    }

    static class GeometryHandlerQTree {
        Area area;
        List<GeometryHandlerQTree> sons = new ArrayList<GeometryHandlerQTree>();

        GeometryHandlerQTree(Area a) {
            this.area = a;
        }

        void refineDir(CutBucket cut) {
            Rectangle2D origRec = this.area.getBounds2D();
            Rectangle2D.Double leftCut = null;
            Rectangle2D.Double rightCut = null;
            if (cut.dir == 0) {
                leftCut = new Rectangle2D.Double(origRec.getX(), origRec.getY(), cut.best - origRec.getX(), origRec.getHeight());
                rightCut = new Rectangle2D.Double(cut.best, origRec.getY(), origRec.getMaxX() - cut.best, origRec.getHeight());
            } else if (cut.dir == 1) {
                leftCut = new Rectangle2D.Double(origRec.getX(), origRec.getY(), origRec.getWidth(), cut.best - origRec.getY());
                rightCut = new Rectangle2D.Double(origRec.getX(), cut.best, origRec.getWidth(), origRec.getMaxY() - cut.best);
            } else assert (false);
            Area son1 = new Area(this.area);
            son1.intersect(new Area(leftCut));
            Area son2 = new Area(this.area);
            son2.intersect(new Area(rightCut));
            this.sons.add(new GeometryHandlerQTree(son1));
            this.sons.add(new GeometryHandlerQTree(son2));
        }

        void refine() {
            if (this.area.isRectangular()) {
                return;
            }
            Set<Point2D> pointsList = PolySweepMerge.getPoints(this.area);
            List<PolyEdge> edgesList = PolySweepMerge.getEdges(this.area);
            Rectangle2D rect = this.area.getBounds2D();
            CutBucket cutX = new CutBucket(0, rect.getMinX(), rect.getMaxX(), edgesList);
            CutBucket cutY = new CutBucket(1, rect.getMinY(), rect.getMaxY(), edgesList);
            for (Point2D p : pointsList) {
                cutX.analyzePoint(p.getX());
                cutY.analyzePoint(p.getY());
            }
            if (!cutX.found && !cutY.found) {
                return;
            }
            if (cutX.found && !cutY.found) {
                this.refineDir(cutX);
            } else if (!cutX.found && cutY.found) {
                this.refineDir(cutY);
            } else if (cutX.totalCuts > cutY.totalCuts) {
                this.refineDir(cutX);
            } else {
                this.refineDir(cutY);
            }
            for (GeometryHandlerQTree s : this.sons) {
                s.refine();
            }
        }

        private void getSimplePolygons(List<PolyBase> list) {
            if (this.sons.isEmpty()) {
                List<PolyBase> l = PolyBase.getLoopsFromArea(this.area, null);
                assert (l.size() == 1);
                list.addAll(l);
            } else {
                for (GeometryHandlerQTree s : this.sons) {
                    s.getSimplePolygons(list);
                }
            }
        }

        private static class CutBucket {
            int totalCuts;
            double best;
            double min;
            double max;
            int dir;
            boolean found;

            CutBucket(int d, double m, double n, List<PolyEdge> list) {
                this.dir = d;
                this.found = false;
                this.min = m;
                this.max = n;
            }

            void analyzePoint(double p) {
                if (!DBMath.isInBetweenExclusive(p, this.min, this.max)) {
                    return;
                }
                this.found = true;
                this.best = p;
                ++this.totalCuts;
            }
        }
    }
}

