/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.result;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.result.NetObjReport;
import com.sun.electric.tool.ncc.result.PartReport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EquivRecReport
implements Serializable {
    static final long serialVersionUID = 0L;
    private final boolean hashMismatch;
    private final List<List<NetObjReport>> matched;
    private final List<List<NetObjReport>> notMatched;
    private final List<String> reasons;

    private List<NetObjReport> makeReports1(List<NetObjReport.NetObjReportable> nor) {
        ArrayList<NetObjReport> ans = new ArrayList<NetObjReport>();
        for (NetObjReport.NetObjReportable j : nor) {
            ans.add(NetObjReport.newNetObjReport(j));
        }
        return ans;
    }

    private List<List<NetObjReport>> makeReports(List<List<NetObjReport.NetObjReportable>> nors) {
        ArrayList<List<NetObjReport>> ans = new ArrayList<List<NetObjReport>>();
        for (List<NetObjReport.NetObjReportable> i : nors) {
            ans.add(this.makeReports1(i));
        }
        return ans;
    }

    public EquivRecReport(EquivRecReportable er, boolean hashMismatch) {
        this.hashMismatch = hashMismatch;
        this.reasons = er.getPartitionReasonsFromRootToMe();
        ArrayList<List<NetObjReport.NetObjReportable>> m = new ArrayList<List<NetObjReport.NetObjReportable>>();
        ArrayList<List<NetObjReport.NetObjReportable>> nm = new ArrayList<List<NetObjReport.NetObjReportable>>();
        er.getNetObjReportablesFromEntireTree(m, nm);
        this.matched = this.makeReports(m);
        this.notMatched = this.makeReports(nm);
    }

    public EquivRecReport(boolean hashMismatch, boolean hasParts, List<List<NetObjReport>> matched, List<List<NetObjReport>> notMatched, List<String> reasons) {
        this.hashMismatch = hashMismatch;
        this.matched = matched;
        this.notMatched = notMatched;
        this.reasons = reasons;
    }

    public int maxSize() {
        return Math.max(this.matched.get(0).size() + this.notMatched.get(0).size(), this.matched.get(1).size() + this.notMatched.get(1).size());
    }

    public boolean hashMismatch() {
        return this.hashMismatch;
    }

    public List<String> getReasons() {
        return this.reasons;
    }

    public boolean hasParts() {
        Iterator<NetObjReport> iterator;
        for (List<NetObjReport> i : this.matched) {
            iterator = i.iterator();
            if (!iterator.hasNext()) continue;
            NetObjReport j = iterator.next();
            return j instanceof PartReport;
        }
        for (List<NetObjReport> i : this.notMatched) {
            iterator = i.iterator();
            if (!iterator.hasNext()) continue;
            NetObjReport j = iterator.next();
            return j instanceof PartReport;
        }
        Job.error(true, "EquivRecord with no NetObjects?");
        return false;
    }

    public List<List<NetObjReport>> getMatchedNetObjs() {
        return this.matched;
    }

    public List<List<NetObjReport>> getNotMatchedNetObjs() {
        return this.notMatched;
    }

    public static interface EquivRecReportable {
        public List<String> getPartitionReasonsFromRootToMe();

        public void getNetObjReportablesFromEntireTree(List<List<NetObjReport.NetObjReportable>> var1, List<List<NetObjReport.NetObjReportable>> var2);
    }
}

