/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Equipment;
import com.sun.electric.tool.simulation.test.Infrastructure;

public class Agilent6031A
extends Equipment {
    String s = new String("null");
    private static final float VOLTAGE_RESOLUTION = 0.005f;
    public static final int FOLDBACK_OFF = 0;
    public static final int FOLDBACK_CV = 1;
    public static final int FOLDBACK_CC = 2;

    protected Agilent6031A(String newName) {
        super(newName);
    }

    public String getState() {
        String result2 = "Set: " + this.getVoltageSetpoint() + " V, " + this.getCurrentSetpoint() + " A\n";
        result2 = result2 + "Got " + this.readVoltage() + " V, " + this.readCurrent() + " A";
        return result2;
    }

    public static float getVoltageResolution() {
        return 0.005f;
    }

    public float readVoltage() {
        this.write("VOUT?");
        String[] s2 = this.read(200).split("\\s+");
        return Float.parseFloat(s2[1]);
    }

    public float getVoltageSetpoint() {
        this.logOther("Reading voltage setpoint on Agilent 6031A");
        this.write("VSET?");
        String[] s2 = this.read(200).split("\\s+");
        return Float.parseFloat(s2[1]);
    }

    public void setVoltage(float voltage) {
        this.write("VSET " + voltage);
    }

    public float readCurrent() {
        this.write("IOUT?");
        String[] s2 = this.read(200).split("\\s+");
        return Float.parseFloat(s2[1]);
    }

    public float getCurrentSetpoint() {
        this.write("ISET?");
        String[] s2 = this.read(200).split("\\s+");
        return Float.parseFloat(s2[1]);
    }

    public void setCurrent(float setAmps) {
        this.write("ISET " + setAmps);
    }

    public int getFoldback() {
        this.write("FOLD?");
        String[] s2 = this.read(200).split("\\s+");
        return Integer.parseInt(s2[1]);
    }

    public void setFoldback(int mode) {
        if (mode < 0 || mode > 2) {
            throw new IllegalArgumentException("Fallback " + mode + " outside of allowed range 0..2");
        }
        this.write("FOLD " + mode);
    }

    public float getOverVoltageProtection() {
        this.write("OVP?");
        String[] s2 = this.read(200).split("\\s+");
        return Float.parseFloat(s2[1]);
    }

    public static void main(String[] args) {
        Infrastructure.gpibControllers = new int[]{3};
        Agilent6031A supply = new Agilent6031A("A6031A");
        supply.interactive();
    }
}

