/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEditWizard;

import com.sun.electric.technology.GDSLayers;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizard;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizardData;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizardPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class GDS
extends TechEditWizardPanel {
    private JPanel gds;
    private JScrollPane gdsPane;
    private LabelContainer[] metalContainers;
    private LabelContainer[] viaContainers;
    private LabelContainer[] basicContainers;

    public GDS(TechEditWizard parent, boolean modal) {
        super(parent, modal);
        this.setTitle("GDS");
        this.setName("");
        this.gds = new JPanel();
        this.gds.setLayout(new GridBagLayout());
        this.gdsPane = new JScrollPane();
        JLabel heading = new JLabel("Name");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)heading, gbc);
        heading = new JLabel("DRAWING");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)heading, gbc);
        heading = new JLabel("Pin");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)heading, gbc);
        heading = new JLabel("Text");
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)heading, gbc);
        heading = new JLabel("H. Voltage");
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)heading, gbc);
        this.gdsPane.setViewportView(this.gds);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.gdsPane, new GridBagConstraints());
        TechEditWizardData data = this.wizard.getTechEditData();
        TechEditWizardData.LayerInfo[] basics = data.getBasicLayers();
        this.basicContainers = new LabelContainer[basics.length];
        for (int i = 0; i < basics.length; ++i) {
            this.basicContainers[i] = this.addRow(basics[i], i + 1, 4);
        }
    }

    private void setValues(LabelContainer con, TechEditWizardData.LayerInfo info) {
        con.valueField.setText(info.getString(GDSLayers.GDSLayerType.DRAWING));
    }

    @Override
    public Component getComponent() {
        return this.gdsPane;
    }

    @Override
    public String getName() {
        return "GDS";
    }

    @Override
    public void init() {
        TechEditWizardData data = this.wizard.getTechEditData();
        TechEditWizardData.LayerInfo[] basics = data.getBasicLayers();
        for (int i = 0; i < this.basicContainers.length; ++i) {
            this.setValues(this.basicContainers[i], basics[i]);
        }
        if (this.metalContainers != null) {
            for (LabelContainer mc : this.metalContainers) {
                this.gds.remove(mc.label);
                this.gds.remove(mc.valueField);
                this.gds.remove(mc.textField);
                this.gds.remove(mc.hVoltField);
            }
        }
        if (this.viaContainers != null) {
            for (LabelContainer vc : this.viaContainers) {
                this.gds.remove(vc.label);
                this.gds.remove(vc.valueField);
            }
        }
        int numMetals = data.getNumMetalLayers();
        this.metalContainers = new LabelContainer[numMetals];
        this.viaContainers = new LabelContainer[numMetals - 1];
        int base = basics.length + 1;
        for (int i = 0; i < numMetals; ++i) {
            this.metalContainers[i] = this.addRow(data.getGDSMetal()[i], base + i * 2, 4);
            if (i >= numMetals - 1) continue;
            this.viaContainers[i] = this.addRow(data.getGDSVia()[i], base + 1 + i * 2, 10);
        }
        this.pack();
    }

    private LabelContainer addRow(TechEditWizardData.LayerInfo gdsValue, int posY, int left) {
        LabelContainer cont = new LabelContainer();
        cont.label = new JLabel(gdsValue.name);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = posY;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, left, 1, 0);
        this.gds.add((Component)cont.label, gbc);
        cont.valueField = new JTextField();
        cont.valueField.setText(gdsValue.getString(GDSLayers.GDSLayerType.DRAWING));
        cont.valueField.setColumns(4);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = posY;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.gds.add((Component)cont.valueField, gbc);
        cont.pinField = new JTextField();
        cont.pinField.setText(gdsValue.getString(GDSLayers.GDSLayerType.PIN));
        cont.pinField.setColumns(4);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = posY;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.gds.add((Component)cont.pinField, gbc);
        cont.textField = new JTextField();
        cont.textField.setText(gdsValue.getString(GDSLayers.GDSLayerType.TEXT));
        cont.textField.setColumns(4);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = posY;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.gds.add((Component)cont.textField, gbc);
        cont.hVoltField = new JTextField();
        cont.hVoltField.setText(gdsValue.getString(GDSLayers.GDSLayerType.HIGHVOLTAGE));
        cont.hVoltField.setColumns(4);
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = posY;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.gds.add((Component)cont.hVoltField, gbc);
        return cont;
    }

    private void setData(TechEditWizardData.LayerInfo info, LabelContainer cont) {
        String s2 = cont.valueField.getText();
        if (!cont.pinField.getText().isEmpty()) {
            s2 = s2 + "," + cont.pinField.getText() + "p";
        }
        if (!cont.textField.getText().isEmpty()) {
            s2 = s2 + "," + cont.textField.getText() + "t";
        }
        if (!cont.hVoltField.getText().isEmpty()) {
            s2 = s2 + "," + cont.hVoltField.getText() + "h";
        }
        info.setGDSData(s2);
    }

    @Override
    public void term() {
        TechEditWizardData data = this.wizard.getTechEditData();
        TechEditWizardData.LayerInfo[] metalLayers = data.getGDSMetal();
        TechEditWizardData.LayerInfo[] viaLayers = data.getGDSVia();
        for (int i = 0; i < metalLayers.length; ++i) {
            this.setData(metalLayers[i], this.metalContainers[i]);
            if (i >= metalLayers.length - 1) continue;
            this.setData(viaLayers[i], this.viaContainers[i]);
        }
        TechEditWizardData.LayerInfo[] basics = data.getBasicLayers();
        for (int i = 0; i < this.basicContainers.length; ++i) {
            this.setData(basics[i], this.basicContainers[i]);
        }
    }

    private class LabelContainer {
        JLabel label;
        JTextField valueField;
        JTextField pinField;
        JTextField textField;
        JTextField hVoltField;

        private LabelContainer() {
        }
    }
}

