/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.geometry.PolySweepMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.GDSReader;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.CellArrayBuilder;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpCoord;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.MutableInteger;
import com.sun.electric.util.math.Orientation;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class GDS
extends Input<Object> {
    private static final boolean DEBUGALL = false;
    private static final boolean SHOWPROGRESS = false;
    private static final boolean TALLYCONTENTS = false;
    public static final Variable.Key SKELETON_ORIGIN = Variable.newKey("ATTR_GDS_original");
    public static final Variable.Key ORIGINAL_EXPORT_NAME = Variable.newKey("GDS_original_export_name");
    public static final boolean INSTANTIATE_ARRAYS_VIA_BISECTION = true;
    private static final int MAXPOINTS = 4096;
    private static final int MINFONTWIDTH = 130;
    private static final int MINFONTHEIGHT = 190;
    private static final ShapeType SHAPEPOLY = new ShapeType();
    private static final ShapeType SHAPERECTANGLE = new ShapeType();
    private static final ShapeType SHAPEOBLIQUE = new ShapeType();
    private static final ShapeType SHAPELINE = new ShapeType();
    private static final ShapeType SHAPECLOSED = new ShapeType();
    private GDSReader gdsRead;
    private int countBox;
    private int countText;
    private int countNode;
    private int countPath;
    private int countShape;
    private int countSRef;
    private int countARef;
    private int countATotal;
    private Library theLibrary;
    private CellArrayBuilder cellArrayBuilder;
    private Map<Library, Cell> currentCells;
    private CellBuilder theCell;
    private NodeProto theNodeProto;
    private PrimitiveNode layerNodeProto;
    private UnknownLayerMessage currentUnknownLayerMessage;
    private PrimitiveNode pinNodeProto;
    private int randomLayerSelection;
    private boolean layerIsPin;
    private Technology curTech;
    private int curLayerNum;
    private int curLayerType;
    private Point2D[] theVertices;
    private int numVertices;
    private double theScale;
    private Map<Integer, List<Layer>> layerNames;
    private Map<Integer, UnknownLayerMessage> layerErrorMessages;
    private static Map<Integer, UnknownLayerMessage> layerWarningMessages;
    private static Map<UnknownLayerMessage, Set<Cell>> cellLayerErrors;
    private Set<Integer> pinLayers;
    private PolyMerge merge;
    private static boolean arraySimplificationUseful;
    private Set<Cell> missingCells;
    private MakeInstance lastExportInstance = null;
    private static GDSReader.GSymbol[] optionSet;
    private static GDSReader.GSymbol[] shapeSet;
    private static GDSReader.GSymbol[] goodOpSet;
    private static GDSReader.GSymbol[] maskSet;
    private static GDSReader.GSymbol[] unsupportedSet;
    private GDSPreferences localPrefs;
    private Map<CellId, CellBuilder> allBuilders;

    public GDS(EditingPreferences ep, GDSPreferences ap) {
        super(ep);
        this.localPrefs = ap;
    }

    @Override
    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        this.currentCells = currentCells;
        arraySimplificationUseful = false;
        this.init();
        this.theLibrary = lib;
        this.cellArrayBuilder = new CellArrayBuilder(this.theLibrary);
        this.curTech = tech;
        this.initialize();
        try {
            this.loadFile();
        }
        catch (IllegalArgumentException e) {
            System.out.println("ERROR reading GDS file: " + e.getMessage());
            if (Job.getDebug()) {
                e.printStackTrace();
            }
            return null;
        }
        catch (GDSReader.GDSException e) {
            Cell cell = this.theCell != null ? this.theCell.cell : null;
            String message = e.getMessage();
            System.out.println(message);
            errorLogger.logError(message, cell, 0);
            return null;
        }
        catch (Exception e) {
            System.out.println("ERROR reading GDS file: check input file, " + e.getMessage());
            if (Job.getDebug()) {
                e.printStackTrace();
            }
            return null;
        }
        Map<Cell, Cell> foundCellMap = this.substituteExternalCells(this.missingCells, this.theLibrary);
        if (foundCellMap.size() > 0) {
            System.out.println("Note: these cells from other libraries were referenced in the GDS:");
            for (Cell mCell : foundCellMap.keySet()) {
                Cell found = foundCellMap.get(mCell);
                System.out.println("    " + found.libDescribe());
                this.missingCells.remove(mCell);
            }
        }
        if (this.missingCells.size() > 0) {
            System.out.println("Note: these cells are missing in the GDS and were created with no contents:");
            for (Cell cell : this.missingCells) {
                System.out.println("    " + cell.noLibDescribe());
            }
        }
        this.buildInstances();
        this.term();
        this.printUnknownLayersInCell(cellLayerErrors);
        for (UnknownLayerMessage message : layerWarningMessages.values()) {
            if (message == null) continue;
            System.out.println(message.message);
            errorLogger.logWarning(message.message, null, -1);
        }
        if (arraySimplificationUseful) {
            System.out.println("NOTE: Found array references that could be simplified to save space and time");
            System.out.println("   To simplify arrays, set the 'Input array simplification' in GDS Preferences");
        }
        return lib;
    }

    private void printUnknownLayersInCell(Map<UnknownLayerMessage, Set<Cell>> map2) {
        if (map2 == null) {
            return;
        }
        for (UnknownLayerMessage message : map2.keySet()) {
            Set<Cell> cellList = map2.get(message);
            System.out.println(message.message + " in cells:");
            String prev = "    ";
            int count2 = 0;
            for (Cell cell : cellList) {
                System.out.print(prev + cell.describe(false));
                prev = ", ";
                if (count2 > 10) {
                    count2 = 0;
                    System.out.print("\n\t");
                }
                ++count2;
            }
            System.out.println();
        }
    }

    private void initialize() {
        boolean valid;
        this.layerNodeProto = Generic.tech().drcNode;
        this.missingCells = new HashSet<Cell>();
        this.theVertices = new Point2D[4096];
        for (int i = 0; i < 4096; ++i) {
            this.theVertices[i] = new Point2D.Double();
        }
        this.layerErrorMessages = new HashMap<Integer, UnknownLayerMessage>();
        layerWarningMessages = new HashMap<Integer, UnknownLayerMessage>();
        cellLayerErrors = new HashMap<UnknownLayerMessage, Set<Cell>>();
        this.pinLayers = new HashSet<Integer>();
        this.randomLayerSelection = 0;
        this.layerNames = this.curTech.getLayersPerGDSNumber(this.pinLayers);
        boolean bl = valid = !this.layerNames.isEmpty();
        if (!valid) {
            System.out.println("There are no GDS layer names assigned in the " + this.curTech.getTechName() + " technology");
        }
    }

    private void init() {
        this.allBuilders = new HashMap<CellId, CellBuilder>();
    }

    private void term() {
        this.allBuilders = null;
    }

    private Map<Cell, Cell> substituteExternalCells(Set<Cell> missingCells, Library theLibrary) {
        Cell found;
        HashMap<Cell, Cell> missingCellMap = new HashMap<Cell, Cell>();
        ArrayList<Library> otherLibraries = new ArrayList<Library>();
        for (Library lib : Library.getVisibleLibraries()) {
            if (lib == theLibrary) continue;
            otherLibraries.add(lib);
        }
        if (otherLibraries.size() == 0) {
            return missingCellMap;
        }
        block1: for (Cell mCell : missingCells) {
            for (Library lib : otherLibraries) {
                found = lib.findNodeProto(mCell.getName());
                if (found == null) continue;
                missingCellMap.put(mCell, found);
                mCell.kill();
                continue block1;
            }
        }
        for (CellBuilder cellBuilder : this.allBuilders.values()) {
            for (MakeInstance mi : cellBuilder.insts) {
                if (!(mi.proto instanceof Cell) || (found = (Cell)missingCellMap.get(mi.proto)) == null) continue;
                mi.proto = found;
            }
            for (MakeInstanceArray mia : cellBuilder.instArrays) {
                if (!(mia.proto instanceof Cell) || (found = (Cell)missingCellMap.get(mia.proto)) == null) continue;
                mia.proto = found;
            }
        }
        return missingCellMap;
    }

    private void buildInstances() {
        if (this.localPrefs.skeletonize) {
            for (CellBuilder cellBuilder : this.allBuilders.values()) {
                this.gatherSubCellSkeletonData(cellBuilder);
            }
        }
        HashSet builtCells = new HashSet();
        for (CellBuilder cellBuilder : this.allBuilders.values()) {
            cellBuilder.makeInstances(builtCells);
        }
        if (this.localPrefs.skeletonize) {
            CellBuilder lastTopCell = null;
            for (CellBuilder cellBuilder : this.allBuilders.values()) {
                if (cellBuilder.topLevel) {
                    lastTopCell = cellBuilder;
                    continue;
                }
                cellBuilder.cell.kill();
                cellBuilder.cell = null;
            }
            if (lastTopCell == null) {
                String msg = "No topcell found while building GDS Skeleton for '" + this.filePath + "'";
                errorLogger.logMessage(msg, null, null, -1, true);
                return;
            }
            this.currentCells.put(this.theLibrary, lastTopCell.cell);
            String origFile = this.filePath;
            lastTopCell.cell.newDisplayVar(SKELETON_ORIGIN, origFile, this.ep);
        }
    }

    private void gatherSubCellSkeletonData(CellBuilder cb) {
        CellBuilder subCB;
        if (cb.skeletonCellInstances.size() == 0) {
            return;
        }
        for (SkeletonCellInstance sci : cb.skeletonCellInstances) {
            subCB = this.allBuilders.get(sci.proto.getId());
            if (subCB == null) continue;
            this.gatherSubCellSkeletonData(subCB);
        }
        for (SkeletonCellInstance sci : cb.skeletonCellInstances) {
            subCB = this.allBuilders.get(sci.proto.getId());
            if (subCB == null) continue;
            cb.doSkeleton(subCB.cell, sci.loc, sci.orient, sci.wid, sci.hei, null);
        }
        cb.skeletonCellInstances.clear();
    }

    public void loadFile() throws Exception {
        this.gdsRead.getToken();
        this.readHeader();
        this.gdsRead.getToken();
        this.readLibrary();
        this.gdsRead.getToken();
        while (this.isMember(this.gdsRead.getTokenType(), optionSet)) {
            if (this.gdsRead.getTokenType() == GDSReader.GDS_REFLIBS) {
                this.readRefLibs();
                continue;
            }
            if (this.gdsRead.getTokenType() == GDSReader.GDS_FONTS) {
                this.readFonts();
                continue;
            }
            if (this.gdsRead.getTokenType() == GDSReader.GDS_ATTRTABLE) {
                this.readAttrTable();
                continue;
            }
            if (this.gdsRead.getTokenType() != GDSReader.GDS_GENERATIONS) continue;
            this.readGenerations();
        }
        while (this.gdsRead.getTokenType() != GDSReader.GDS_UNITS) {
            this.gdsRead.getToken();
        }
        this.readUnits();
        this.gdsRead.getToken();
        while (this.gdsRead.getTokenType() != GDSReader.GDS_ENDLIB) {
            this.readStructure();
            this.gdsRead.getToken();
        }
    }

    private void readHeader() throws Exception {
        if (this.gdsRead.getTokenType() != GDSReader.GDS_HEADER) {
            this.gdsRead.handleError("GDS II header statement is missing");
        }
        this.gdsRead.getToken();
        if (this.gdsRead.getTokenType() != GDSReader.GDS_SHORT_NUMBER) {
            this.gdsRead.handleError("GDS II version number is not decipherable");
        }
    }

    private void readLibrary() throws Exception {
        if (this.gdsRead.getTokenType() != GDSReader.GDS_BGNLIB) {
            this.gdsRead.handleError("Begin library statement is missing");
        }
        this.gdsRead.getToken();
        this.gdsRead.determineTime();
        this.gdsRead.determineTime();
        if (this.gdsRead.getTokenType() == GDSReader.GDS_LIBNAME) {
            this.gdsRead.getToken();
            if (this.gdsRead.getTokenType() != GDSReader.GDS_IDENT) {
                this.gdsRead.handleError("Library name is missing");
            }
        }
    }

    private void readRefLibs() throws Exception {
        this.gdsRead.getToken();
        this.gdsRead.getToken();
    }

    private void readFonts() throws Exception {
        this.gdsRead.getToken();
        this.gdsRead.getToken();
    }

    private void readAttrTable() throws Exception {
        this.gdsRead.getToken();
        if (this.gdsRead.getTokenType() == GDSReader.GDS_IDENT) {
            this.gdsRead.getToken();
        }
    }

    private void readUnits() throws Exception {
        if (this.gdsRead.getTokenType() != GDSReader.GDS_UNITS) {
            this.gdsRead.handleError("Units statement is missing");
        }
        this.gdsRead.getToken();
        if (this.gdsRead.getTokenType() != GDSReader.GDS_REALNUM) {
            this.gdsRead.handleError("Units statement has invalid number format");
        }
        this.gdsRead.getToken();
        double meterUnit = this.gdsRead.getDoubleValue();
        double shift = 1.0;
        double roundedScale = meterUnit;
        while (roundedScale < 1.0) {
            roundedScale *= 10.0;
            shift *= 10.0;
        }
        meterUnit = roundedScale = DBMath.round(roundedScale) / shift;
        double microScale = TextUtils.convertFromDistance(1.0, this.curTech, TextUtils.UnitScale.MICRO);
        this.theScale = meterUnit * 1000000.0 * microScale * this.localPrefs.inputScale;
    }

    private double scaleValue(double value) {
        double result2 = value * this.theScale;
        return result2;
    }

    private void showResultsOfCell() {
        System.out.print("**** Cell " + this.theCell.cell.describe(false) + " has");
        if (this.countBox > 0) {
            System.out.print(" " + this.countBox + " boxes");
        }
        if (this.countText > 0) {
            System.out.print(" " + this.countText + " texts");
        }
        if (this.countNode > 0) {
            System.out.print(" " + this.countNode + " nodes");
        }
        if (this.countPath > 0) {
            System.out.print(" " + this.countPath + " paths");
        }
        if (this.countShape > 0) {
            System.out.print(" " + this.countShape + " shapes");
        }
        if (this.countSRef > 0) {
            System.out.print(" " + this.countSRef + " instances");
        }
        if (this.countARef > 0) {
            System.out.print(" " + this.countARef + " arrays with " + this.countATotal + " elements");
        }
        System.out.println();
    }

    private void readStructure() throws Exception {
        this.beginStructure();
        this.gdsRead.getToken();
        if (this.localPrefs.mergeBoxes) {
            this.merge = new PolyMerge();
        }
        this.countATotal = 0;
        this.countARef = 0;
        this.countSRef = 0;
        this.countShape = 0;
        this.countPath = 0;
        this.countNode = 0;
        this.countText = 0;
        this.countBox = 0;
        while (this.gdsRead.getTokenType() != GDSReader.GDS_ENDSTR) {
            this.getElement();
            this.gdsRead.getToken();
        }
        if (this.localPrefs.mergeBoxes) {
            Iterator<Layer> i$ = this.merge.getKeySet().iterator();
            while (i$.hasNext()) {
                Layer layer;
                Layer primLayer = layer = i$.next();
                PrimitiveNode pnp = primLayer.getPureLayerNode();
                List<PolyBase> polys = this.merge.getMergedPoints(layer, false);
                for (PolyBase poly : polys) {
                    EPoint ctr;
                    FixpRectangle box = poly.getBox();
                    if (box == null) {
                        box = poly.getBounds2D();
                        ctr = EPoint.fromLambda(((RectangularShape)box).getCenterX(), ((RectangularShape)box).getCenterY());
                        PolyBase.Point[] pPoints = poly.getPoints();
                        EPoint[] points = new EPoint[pPoints.length];
                        for (int i = 0; i < pPoints.length; ++i) {
                            points[i] = EPoint.fromLambda(((Point2D)pPoints[i]).getX(), ((Point2D)pPoints[i]).getY());
                        }
                        this.theCell.makeInstance(pnp, ctr, Orientation.IDENT, ((RectangularShape)box).getWidth(), ((RectangularShape)box).getHeight(), points, null);
                        continue;
                    }
                    ctr = EPoint.fromLambda(((RectangularShape)box).getCenterX(), ((RectangularShape)box).getCenterY());
                    this.theCell.makeInstance(pnp, ctr, Orientation.IDENT, ((RectangularShape)box).getWidth(), ((RectangularShape)box).getHeight(), null, null);
                }
            }
        }
    }

    private void beginStructure() throws Exception {
        if (this.gdsRead.getTokenType() != GDSReader.GDS_BGNSTR) {
            this.gdsRead.handleError("Begin structure statement is missing");
        }
        this.gdsRead.getToken();
        this.gdsRead.determineTime();
        this.gdsRead.determineTime();
        if (this.gdsRead.getTokenType() != GDSReader.GDS_STRNAME) {
            this.gdsRead.handleError("Strname statement is missing");
        }
        this.gdsRead.getToken();
        if (this.gdsRead.getTokenType() != GDSReader.GDS_IDENT) {
            this.gdsRead.handleError("Structure name is missing");
        }
        String name = this.gdsRead.getStringValue();
        name = this.localPrefs.skeletonize ? name + "{lay.sk}" : name + "{lay}";
        Cell cell = this.findCell(name);
        if (cell == null) {
            cell = Cell.newInstance(this.theLibrary, name);
            if (this.curTech != null) {
                cell.setTechnology(this.curTech);
            }
            if (cell == null) {
                this.gdsRead.handleError("Failed to create structure");
            }
            System.out.println("Reading " + name);
            if (!this.currentCells.containsKey(this.theLibrary)) {
                this.currentCells.put(this.theLibrary, cell);
            }
        } else {
            this.missingCells.remove(cell);
        }
        this.theCell = new CellBuilder(cell, this.curTech, this.localPrefs);
    }

    private Cell findCell(String name) {
        return this.theLibrary.findNodeProto(name);
    }

    private void buildComplexNode(CellBuilder cb, List<EPoint> points, NodeProto pureType, Cell parent, EditingPreferences ep) {
        Point2D[] pointArray = new EPoint[points.size()];
        double lX = 0.0;
        double hX = 0.0;
        double lY = 0.0;
        double hY = 0.0;
        for (int i = 0; i < points.size(); ++i) {
            pointArray[i] = points.get(i);
            if (pointArray[i] == null) continue;
            if (i == 0) {
                lX = hX = pointArray[i].getX();
                lY = hY = pointArray[i].getY();
                continue;
            }
            if (pointArray[i].getX() < lX) {
                lX = pointArray[i].getX();
            }
            if (pointArray[i].getX() > hX) {
                hX = pointArray[i].getX();
            }
            if (pointArray[i].getY() < lY) {
                lY = ((EPoint)pointArray[i]).getY();
            }
            if (!(((EPoint)pointArray[i]).getY() > hY)) continue;
            hY = ((EPoint)pointArray[i]).getY();
        }
        Point2D.Double loc = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
        NodeInst ni = NodeInst.makeInstance(pureType, ep, loc, hX - lX, hY - lY, parent, Orientation.IDENT, null);
        if (ni != null && GenMath.getAreaOfPoints(pointArray) != (hX - lX) * (hY - lY)) {
            ni.setTrace((EPoint[])pointArray);
        }
    }

    private void getElement() throws Exception {
        while (this.isMember(this.gdsRead.getTokenType(), shapeSet)) {
            if (this.gdsRead.getTokenType() == GDSReader.GDS_AREF) {
                this.determineARef();
                continue;
            }
            if (this.gdsRead.getTokenType() == GDSReader.GDS_SREF) {
                this.determineSRef();
                continue;
            }
            if (this.gdsRead.getTokenType() == GDSReader.GDS_BOUNDARY) {
                this.determineShape();
                continue;
            }
            if (this.gdsRead.getTokenType() == GDSReader.GDS_PATH) {
                this.determinePath();
                continue;
            }
            if (this.gdsRead.getTokenType() == GDSReader.GDS_NODE) {
                this.determineNode();
                continue;
            }
            if (this.gdsRead.getTokenType() == GDSReader.GDS_TEXTSYM) {
                this.determineText();
                continue;
            }
            if (this.gdsRead.getTokenType() != GDSReader.GDS_BOX) continue;
            this.determineBox();
        }
        while (this.gdsRead.getTokenType() == GDSReader.GDS_PROPATTR) {
            this.determineProperty();
        }
        if (this.gdsRead.getTokenType() != GDSReader.GDS_ENDEL) {
            this.showResultsOfCell();
            this.gdsRead.handleError("Element end statement is missing");
        }
    }

    private void determineARef() throws Exception {
        this.gdsRead.getToken();
        this.readUnsupported(unsupportedSet);
        if (this.gdsRead.getTokenType() != GDSReader.GDS_SNAME) {
            this.gdsRead.handleError("Array reference name is missing");
        }
        this.gdsRead.getToken();
        this.getPrototype(this.gdsRead.getStringValue());
        this.gdsRead.getToken();
        int angle = 0;
        boolean trans = false;
        if (this.gdsRead.getTokenType() == GDSReader.GDS_STRANS) {
            ReadOrientation ro = new ReadOrientation();
            ro.doIt();
            angle = ro.angle;
            trans = ro.trans;
        }
        int nCols = 0;
        int nRows = 0;
        if (this.gdsRead.getTokenType() == GDSReader.GDS_COLROW) {
            this.gdsRead.getToken();
            nCols = this.gdsRead.getShortValue();
            this.gdsRead.getToken();
            nRows = this.gdsRead.getShortValue();
            this.gdsRead.getToken();
        }
        if (this.gdsRead.getTokenType() != GDSReader.GDS_XY) {
            this.gdsRead.handleError("Array reference has no parameters");
        }
        this.gdsRead.getToken();
        this.determinePoints(3, 3);
        boolean mY = false;
        boolean mX = false;
        if (trans) {
            mY = true;
            angle = (angle + 900) % 3600;
        }
        Point2D.Double colInterval = new Point2D.Double(0.0, 0.0);
        if (nCols != 1) {
            ((Point2D)colInterval).setLocation((this.theVertices[1].getX() - this.theVertices[0].getX()) / (double)nCols, (this.theVertices[1].getY() - this.theVertices[0].getY()) / (double)nCols);
        }
        Point2D.Double rowInterval = new Point2D.Double(0.0, 0.0);
        if (nRows != 1) {
            ((Point2D)rowInterval).setLocation((this.theVertices[2].getX() - this.theVertices[0].getX()) / (double)nRows, (this.theVertices[2].getY() - this.theVertices[0].getY()) / (double)nRows);
        }
        this.theCell.makeInstanceArray(this.theNodeProto, nCols, nRows, Orientation.fromJava(angle, mX, mY), this.theVertices[0], rowInterval, colInterval);
    }

    private void determineSRef() throws Exception {
        this.gdsRead.getToken();
        this.readUnsupported(unsupportedSet);
        if (this.gdsRead.getTokenType() != GDSReader.GDS_SNAME) {
            this.gdsRead.handleError("Structure reference name is missing");
        }
        this.gdsRead.getToken();
        this.getPrototype(this.gdsRead.getStringValue());
        this.gdsRead.getToken();
        int angle = 0;
        boolean trans = false;
        if (this.gdsRead.getTokenType() == GDSReader.GDS_STRANS) {
            ReadOrientation ro = new ReadOrientation();
            ro.doIt();
            angle = ro.angle;
            trans = ro.trans;
        }
        if (this.gdsRead.getTokenType() != GDSReader.GDS_XY) {
            this.gdsRead.handleError("Structure reference has no translation value");
        }
        this.gdsRead.getToken();
        this.determinePoints(1, 1);
        Point2D.Double loc = new Point2D.Double(this.theVertices[0].getX(), this.theVertices[0].getY());
        boolean mY = false;
        if (trans) {
            mY = true;
            angle = (angle + 900) % 3600;
        }
        this.theCell.makeInstance(this.theNodeProto, loc, Orientation.fromJava(angle, false, mY), 0.0, 0.0, null, null);
    }

    private void determineShape() throws Exception {
        this.gdsRead.getToken();
        this.readUnsupported(unsupportedSet);
        this.determineLayer(true);
        this.gdsRead.getToken();
        if (this.gdsRead.getTokenType() != GDSReader.GDS_XY) {
            this.gdsRead.handleError("Boundary has no points");
        }
        this.gdsRead.getToken();
        this.determinePoints(3, 4096);
        this.determineBoundary();
    }

    private void determineBoundary() {
        boolean is90 = true;
        boolean is45 = true;
        for (int i = 0; i < this.numVertices - 1 && i < 4095; ++i) {
            double dx = this.theVertices[i + 1].getX() - this.theVertices[i].getX();
            double dy = this.theVertices[i + 1].getY() - this.theVertices[i].getY();
            if (dx == 0.0 || dy == 0.0) continue;
            is90 = false;
            if (Math.abs(dx) == Math.abs(dy)) continue;
            is45 = false;
        }
        ShapeType perimeter = SHAPELINE;
        if (this.theVertices[0].getX() == this.theVertices[this.numVertices - 1].getX() && this.theVertices[0].getY() == this.theVertices[this.numVertices - 1].getY()) {
            perimeter = SHAPECLOSED;
        }
        ShapeType oclass = SHAPEOBLIQUE;
        if (perimeter == SHAPECLOSED && (is90 || is45)) {
            oclass = SHAPEPOLY;
        }
        if (this.numVertices == 5 && is90 && perimeter == SHAPECLOSED) {
            oclass = SHAPERECTANGLE;
        }
        if (oclass == SHAPERECTANGLE) {
            this.readBox();
            Point2D.Double ctr = new Point2D.Double((this.theVertices[0].getX() + this.theVertices[1].getX()) / 2.0, (this.theVertices[0].getY() + this.theVertices[1].getY()) / 2.0);
            double sX = Math.abs(this.theVertices[1].getX() - this.theVertices[0].getX());
            double sY = Math.abs(this.theVertices[1].getY() - this.theVertices[0].getY());
            if (this.localPrefs.mergeBoxes) {
                if (this.layerNodeProto != null) {
                    PrimitiveNode plnp = this.layerNodeProto;
                    Technology.NodeLayer[] layers = plnp.getNodeLayers();
                    this.merge.addPolygon(layers[0].getLayer(), new Poly(((Point2D)ctr).getX(), ((Point2D)ctr).getY(), sX, sY));
                }
            } else {
                this.theCell.makeInstance(this.layerNodeProto, ctr, Orientation.IDENT, sX, sY, null, this.currentUnknownLayerMessage);
            }
            return;
        }
        if (oclass == SHAPEOBLIQUE || oclass == SHAPEPOLY) {
            if (this.localPrefs.mergeBoxes) {
                Technology.NodeLayer[] layers = this.layerNodeProto.getNodeLayers();
                if (this.layerNodeProto != null) {
                    PolyBase.Point[] points = new PolyBase.Point[this.theVertices.length];
                    for (int i = 0; i < this.theVertices.length; ++i) {
                        points[i] = Poly.from(this.theVertices[i]);
                    }
                    this.merge.addPolygon(layers[0].getLayer(), new Poly(points));
                }
            } else {
                double lx = this.theVertices[0].getX();
                double hx = this.theVertices[0].getX();
                double ly = this.theVertices[0].getY();
                double hy = this.theVertices[0].getY();
                for (int i = 1; i < this.numVertices; ++i) {
                    if (lx > this.theVertices[i].getX()) {
                        lx = this.theVertices[i].getX();
                    }
                    if (hx < this.theVertices[i].getX()) {
                        hx = this.theVertices[i].getX();
                    }
                    if (ly > this.theVertices[i].getY()) {
                        ly = this.theVertices[i].getY();
                    }
                    if (!(hy < this.theVertices[i].getY())) continue;
                    hy = this.theVertices[i].getY();
                }
                EPoint[] points = new EPoint[this.numVertices];
                for (int i = 0; i < this.numVertices; ++i) {
                    points[i] = EPoint.fromLambda(this.theVertices[i].getX(), this.theVertices[i].getY());
                }
                this.theCell.makeInstance(this.layerNodeProto, EPoint.fromLambda((lx + hx) / 2.0, (ly + hy) / 2.0), Orientation.IDENT, hx - lx, hy - ly, points, this.currentUnknownLayerMessage);
            }
            return;
        }
    }

    private void readBox() {
        double pxm = this.theVertices[4].getX();
        double pxs = this.theVertices[4].getX();
        double pym = this.theVertices[4].getY();
        double pys = this.theVertices[4].getY();
        for (int i = 0; i < 4; ++i) {
            if (this.theVertices[i].getX() > pxm) {
                pxm = this.theVertices[i].getX();
            }
            if (this.theVertices[i].getX() < pxs) {
                pxs = this.theVertices[i].getX();
            }
            if (this.theVertices[i].getY() > pym) {
                pym = this.theVertices[i].getY();
            }
            if (!(this.theVertices[i].getY() < pys)) continue;
            pys = this.theVertices[i].getY();
        }
        this.theVertices[0].setLocation(pxs, pys);
        this.theVertices[1].setLocation(pxm, pym);
    }

    private void determinePath() throws Exception {
        double bgnextend;
        int endcode = 0;
        this.gdsRead.getToken();
        this.readUnsupported(unsupportedSet);
        this.determineLayer(false);
        this.gdsRead.getToken();
        if (this.gdsRead.getTokenType() == GDSReader.GDS_PATHTYPE) {
            this.gdsRead.getToken();
            endcode = this.gdsRead.getShortValue();
            this.gdsRead.getToken();
        }
        double width = 0.0;
        if (this.gdsRead.getTokenType() == GDSReader.GDS_WIDTH) {
            this.gdsRead.getToken();
            width = this.scaleValue(this.gdsRead.getIntValue());
            this.gdsRead.getToken();
        }
        double endextend = bgnextend = endcode == 0 || endcode == 4 ? 0.0 : width / 2.0;
        if (this.gdsRead.getTokenType() == GDSReader.GDS_BGNEXTN) {
            this.gdsRead.getToken();
            if (endcode == 4) {
                bgnextend = this.scaleValue(this.gdsRead.getIntValue());
            }
            this.gdsRead.getToken();
        }
        if (this.gdsRead.getTokenType() == GDSReader.GDS_ENDEXTN) {
            this.gdsRead.getToken();
            if (endcode == 4) {
                endextend = this.scaleValue(this.gdsRead.getIntValue());
            }
            this.gdsRead.getToken();
        }
        if (this.gdsRead.getTokenType() == GDSReader.GDS_XY) {
            this.gdsRead.getToken();
            this.determinePoints(2, 4096);
            for (int i = 0; i < this.numVertices - 1; ++i) {
                int ang;
                double fextend;
                Point2D fromPt = this.theVertices[i];
                Point2D toPt = this.theVertices[i + 1];
                double textend = fextend = width / 2.0;
                int thisAngle = GenMath.figureAngle(fromPt, toPt);
                if (i > 0) {
                    Point2D prevPoint = this.theVertices[i - 1];
                    int lastAngle = GenMath.figureAngle(prevPoint, fromPt);
                    if (Math.abs(thisAngle - lastAngle) % 900 != 0) {
                        ang = Math.abs(thisAngle - lastAngle) / 10;
                        if (ang > 180) {
                            ang = 360 - ang;
                        }
                        if (ang > 90) {
                            ang = 180 - ang;
                        }
                        fextend = Poly.getExtendFactor(width, ang);
                    }
                } else {
                    fextend = bgnextend;
                }
                if (i + 1 < this.numVertices - 1) {
                    Point2D nextPoint = this.theVertices[i + 2];
                    int nextAngle = GenMath.figureAngle(toPt, nextPoint);
                    if (Math.abs(thisAngle - nextAngle) % 900 != 0) {
                        ang = Math.abs(thisAngle - nextAngle) / 10;
                        if (ang > 180) {
                            ang = 360 - ang;
                        }
                        if (ang > 90) {
                            ang = 180 - ang;
                        }
                        textend = Poly.getExtendFactor(width, ang);
                    }
                } else {
                    textend = endextend;
                }
                double length = fromPt.distance(toPt);
                Poly poly = Poly.makeEndPointPoly(length, width, GenMath.figureAngle(toPt, fromPt), fromPt, fextend, toPt, textend, Poly.Type.FILLED);
                if (this.localPrefs.mergeBoxes) {
                    if (this.layerNodeProto == null) continue;
                    Technology.NodeLayer[] layers = this.layerNodeProto.getNodeLayers();
                    this.merge.addPolygon(layers[0].getLayer(), poly);
                    continue;
                }
                FixpRectangle polyBox = poly.getBox();
                if (polyBox != null) {
                    this.theCell.makeInstance(this.layerNodeProto, EPoint.fromLambda(((RectangularShape)polyBox).getCenterX(), ((RectangularShape)polyBox).getCenterY()), Orientation.IDENT, ((RectangularShape)polyBox).getWidth(), ((RectangularShape)polyBox).getHeight(), null, this.currentUnknownLayerMessage);
                    continue;
                }
                polyBox = poly.getBounds2D();
                double cx = ((RectangularShape)polyBox).getCenterX();
                double cy = ((RectangularShape)polyBox).getCenterY();
                PolyBase.Point[] polyPoints = poly.getPoints();
                EPoint[] points = new EPoint[polyPoints.length];
                for (int j = 0; j < polyPoints.length; ++j) {
                    points[j] = EPoint.fromLambda(((Point2D)polyPoints[j]).getX(), ((Point2D)polyPoints[j]).getY());
                }
                this.theCell.makeInstance(this.layerNodeProto, EPoint.fromLambda(cx, cy), Orientation.IDENT, ((RectangularShape)polyBox).getWidth(), ((RectangularShape)polyBox).getHeight(), points, this.currentUnknownLayerMessage);
            }
        } else {
            this.gdsRead.handleError("Path element has no points");
        }
    }

    private void determineNode() throws Exception {
        this.gdsRead.getToken();
        this.readUnsupported(unsupportedSet);
        if (this.gdsRead.getTokenType() != GDSReader.GDS_LAYER) {
            this.gdsRead.handleError("Boundary has no points");
        }
        this.gdsRead.getToken();
        int layerNum = this.gdsRead.getShortValue();
        if (this.gdsRead.getTokenType() == GDSReader.GDS_SHORT_NUMBER) {
            this.gdsRead.getToken();
        }
        int layerType = this.gdsRead.getShortValue();
        if (this.gdsRead.getTokenType() == GDSReader.GDS_NODETYPE) {
            this.gdsRead.getToken();
            this.gdsRead.getToken();
        }
        this.setLayer(layerNum, layerType, false);
        if (this.gdsRead.getTokenType() != GDSReader.GDS_XY) {
            this.gdsRead.handleError("Boundary has no points");
        }
        this.gdsRead.getToken();
        this.determinePoints(1, 1);
        if (!this.localPrefs.mergeBoxes) {
            this.theCell.makeInstance(this.layerNodeProto, new Point2D.Double(this.theVertices[0].getX(), this.theVertices[0].getY()), Orientation.IDENT, 0.0, 0.0, null, this.currentUnknownLayerMessage);
        }
    }

    private void determineText() throws Exception {
        String textString;
        double scale;
        boolean trans;
        int angle;
        int horiz_just;
        int vert_just;
        block9: {
            this.gdsRead.getToken();
            this.readUnsupported(unsupportedSet);
            this.determineLayer(true);
            this.gdsRead.getToken();
            vert_just = -1;
            horiz_just = -1;
            if (this.gdsRead.getTokenType() == GDSReader.GDS_PRESENTATION) {
                Point just = this.determineJustification();
                vert_just = just.x;
                horiz_just = just.y;
            }
            if (this.gdsRead.getTokenType() == GDSReader.GDS_PATHTYPE) {
                this.gdsRead.getToken();
                this.gdsRead.getToken();
            }
            if (this.gdsRead.getTokenType() == GDSReader.GDS_WIDTH) {
                this.gdsRead.getToken();
                this.gdsRead.getToken();
            }
            angle = 0;
            trans = false;
            scale = 1.0;
            textString = "";
            while (true) {
                if (this.gdsRead.getTokenType() == GDSReader.GDS_STRANS) {
                    ReadOrientation ro = new ReadOrientation();
                    ro.doIt();
                    angle = ro.angle;
                    trans = ro.trans;
                    scale = ro.scale;
                    continue;
                }
                if (this.gdsRead.getTokenType() == GDSReader.GDS_XY) {
                    this.gdsRead.getToken();
                    this.determinePoints(1, 1);
                    continue;
                }
                if (this.gdsRead.getTokenType() == GDSReader.GDS_ANGLE) {
                    this.gdsRead.getToken();
                    angle = (int)(this.gdsRead.getDoubleValue() * 10.0);
                    this.gdsRead.getToken();
                    continue;
                }
                if (this.gdsRead.getTokenType() == GDSReader.GDS_STRING) {
                    if (this.gdsRead.getRemainingDataCount() != 0) {
                        this.gdsRead.getToken();
                        textString = this.gdsRead.getStringValue();
                    }
                    this.gdsRead.getToken();
                    break block9;
                }
                if (this.gdsRead.getTokenType() != GDSReader.GDS_MAG) break;
                this.gdsRead.getToken();
                this.gdsRead.getToken();
            }
            this.gdsRead.handleError("Text element has no reference point");
        }
        this.readText(textString, vert_just, horiz_just, angle, trans, scale);
    }

    private void readText(String charstring, int vjust, int hjust, int angle, boolean trans, double scale) {
        if (this.layerIsPin) {
            this.theCell.makeExport(this.pinNodeProto, new Point2D.Double(this.theVertices[0].getX(), this.theVertices[0].getY()), Orientation.IDENT, charstring, this.currentUnknownLayerMessage);
            return;
        }
        if (!this.localPrefs.includeText) {
            return;
        }
        double x = this.theVertices[0].getX() + (double)(130 * charstring.length());
        double y = this.theVertices[0].getY() + 190.0;
        this.theVertices[1].setLocation(x, y);
        MutableTextDescriptor td = new MutableTextDescriptor(this.ep.getNodeTextDescriptor());
        double size2 = scale;
        if (size2 <= 0.0) {
            size2 = 2.0;
        }
        if (size2 > 127.75) {
            size2 = 127.75;
        }
        if (size2 < 0.25) {
            size2 = 0.25;
        }
        td.setRelSize(size2);
        td.setPos(AbstractTextDescriptor.Position.CENT);
        block0 : switch (vjust) {
            case 1: {
                switch (hjust) {
                    case 1: {
                        td.setPos(AbstractTextDescriptor.Position.UPRIGHT);
                        break block0;
                    }
                    case 2: {
                        td.setPos(AbstractTextDescriptor.Position.UPLEFT);
                        break block0;
                    }
                }
                td.setPos(AbstractTextDescriptor.Position.UP);
                break;
            }
            case 2: {
                switch (hjust) {
                    case 1: {
                        td.setPos(AbstractTextDescriptor.Position.DOWNRIGHT);
                        break block0;
                    }
                    case 2: {
                        td.setPos(AbstractTextDescriptor.Position.DOWNLEFT);
                        break block0;
                    }
                }
                td.setPos(AbstractTextDescriptor.Position.DOWN);
                break;
            }
            default: {
                switch (hjust) {
                    case 1: {
                        td.setPos(AbstractTextDescriptor.Position.RIGHT);
                        break block0;
                    }
                    case 2: {
                        td.setPos(AbstractTextDescriptor.Position.LEFT);
                        break block0;
                    }
                }
                td.setPos(AbstractTextDescriptor.Position.CENT);
            }
        }
        this.theCell.makeText(this.layerNodeProto, new Point2D.Double(this.theVertices[0].getX(), this.theVertices[0].getY()), charstring, TextDescriptor.newTextDescriptor(td), this.currentUnknownLayerMessage);
    }

    private void determineBox() throws Exception {
        this.gdsRead.getToken();
        this.readUnsupported(unsupportedSet);
        this.determineLayer(false);
        if (this.gdsRead.getTokenType() != GDSReader.GDS_XY) {
            this.gdsRead.handleError("Boundary has no points");
        }
        this.gdsRead.getToken();
        this.determinePoints(2, 4096);
        if (this.localPrefs.mergeBoxes) {
            if (this.layerNodeProto != null) {
                // empty if block
            }
        } else {
            this.theCell.makeInstance(this.layerNodeProto, new Point2D.Double(this.theVertices[0].getX(), this.theVertices[0].getY()), Orientation.IDENT, 0.0, 0.0, null, this.currentUnknownLayerMessage);
        }
    }

    private void setLayer(int layerNum, int layerType, boolean textCase) {
        String message;
        boolean chosenText;
        this.curLayerNum = layerNum;
        this.curLayerType = layerType;
        this.layerIsPin = false;
        this.currentUnknownLayerMessage = null;
        Integer layerInt = new Integer(layerNum + (layerType << 16));
        List<Layer> list = this.layerNames.get(layerInt);
        Layer layer = null;
        int unknownLayerHandling = this.localPrefs.unknownLayerHandling;
        String condition = "unknown";
        if (this.localPrefs.onlyVisibleLayers && list != null && !this.localPrefs.visibility[list.get(0).getIndex()]) {
            unknownLayerHandling = 0;
            condition = "invisible";
            list = null;
        }
        boolean bl = chosenText = this.localPrefs.includeText && this.localPrefs.defaultTextLayer != 0 && this.localPrefs.defaultTextLayer == layerNum && textCase;
        if (list == null) {
            if (chosenText) {
                layer = Generic.tech().invisiblePinNode.getLayerIterator().next();
            } else {
                layer = Generic.tech().drcLay;
                if (unknownLayerHandling == 2) {
                    Iterator<Layer> it = this.curTech.getLayers();
                    while (it.hasNext()) {
                        Layer l = it.next();
                        if (this.layerNames.values().contains(l)) continue;
                        layer = l;
                        break;
                    }
                    if (layer == null) {
                        if (this.randomLayerSelection >= this.curTech.getNumLayers()) {
                            this.randomLayerSelection = 0;
                        }
                        layer = this.curTech.getLayer(this.randomLayerSelection);
                        ++this.randomLayerSelection;
                    }
                }
            }
            list = new ArrayList<Layer>();
            list.add(layer);
            this.layerNames.put(layerInt, list);
            if (!chosenText && !this.localPrefs.skeletonize) {
                message = "GDS layer " + layerNum + ", type " + layerType + " " + condition + ", ";
                switch (unknownLayerHandling) {
                    case 0: {
                        message = message + "ignoring it";
                        break;
                    }
                    case 1: {
                        message = message + "using Generic:DRC layer";
                        break;
                    }
                    case 2: {
                        message = message + "using layer " + layer.getName();
                    }
                }
                this.currentUnknownLayerMessage = this.layerErrorMessages.get(layerInt);
                if (this.currentUnknownLayerMessage == null) {
                    this.currentUnknownLayerMessage = new UnknownLayerMessage(message, "Orig._layer_" + layerNum + "/" + layerType);
                    this.layerErrorMessages.put(layerInt, this.currentUnknownLayerMessage);
                }
            }
        } else {
            layer = list.get(0);
        }
        if (layer != null) {
            if (chosenText) {
                this.layerNodeProto = this.pinNodeProto = Generic.tech().universalPinNode;
                return;
            }
            this.currentUnknownLayerMessage = this.layerErrorMessages.get(layerInt);
            if (layer == Generic.tech().drcLay && unknownLayerHandling == 0) {
                this.layerNodeProto = null;
                this.pinNodeProto = null;
                if (layerWarningMessages.get(layerInt) == null) {
                    layerWarningMessages.put(layerInt, this.currentUnknownLayerMessage);
                }
                return;
            }
            this.layerNodeProto = layer.getPureLayerNode();
            this.pinNodeProto = Generic.tech().universalPinNode;
            if (this.pinLayers.contains(layerInt)) {
                this.layerIsPin = true;
                if (this.layerNodeProto != null && this.layerNodeProto.getNumPorts() > 0) {
                    PrimitivePort pp = this.layerNodeProto.getPort(0);
                    Iterator<ArcProto> it = layer.getTechnology().getArcs();
                    while (it.hasNext()) {
                        ArcProto arc = it.next();
                        if (!pp.connectsTo(arc)) continue;
                        this.pinNodeProto = arc.findOverridablePinProto(this.ep);
                        break;
                    }
                }
            }
            if (this.layerNodeProto == null) {
                message = "Error: no pure layer node for layer '" + layer.getName() + "', ignoring it";
                list.clear();
                list.add(Generic.tech().drcLay);
                this.layerNames.put(layerInt, list);
                if (!this.localPrefs.skeletonize) {
                    this.currentUnknownLayerMessage = new UnknownLayerMessage(message, "No_pure_layer_for_" + layer.getName());
                    this.layerErrorMessages.put(layerInt, this.currentUnknownLayerMessage);
                }
            }
        }
    }

    private void determineLayer(boolean textCase) throws Exception {
        if (this.gdsRead.getTokenType() != GDSReader.GDS_LAYER) {
            this.gdsRead.handleError("Layer statement is missing");
        }
        this.gdsRead.getToken();
        if (this.gdsRead.getTokenType() != GDSReader.GDS_SHORT_NUMBER) {
            this.gdsRead.handleError("Invalid layer number");
        }
        int layerNum = this.gdsRead.getShortValue();
        this.gdsRead.getToken();
        if (!this.isMember(this.gdsRead.getTokenType(), maskSet)) {
            this.gdsRead.handleError("No datatype field");
        }
        this.gdsRead.getToken();
        this.setLayer(layerNum, this.gdsRead.getShortValue(), textCase);
    }

    private Point determineJustification() throws Exception {
        Point just = new Point();
        this.gdsRead.getToken();
        if (this.gdsRead.getTokenType() != GDSReader.GDS_FLAGSYM) {
            this.gdsRead.handleError("Array reference has no parameters");
        }
        int font_libno = this.gdsRead.getFlagsValue() & 0x30;
        font_libno >>= 4;
        just.x = this.gdsRead.getFlagsValue() & 0xC;
        just.x >>= 2;
        just.y = this.gdsRead.getFlagsValue() & 3;
        this.gdsRead.getToken();
        return just;
    }

    private void determineProperty() throws Exception {
        String[] parts;
        this.gdsRead.getToken();
        this.gdsRead.getToken();
        if (this.gdsRead.getTokenType() != GDSReader.GDS_PROPVALUE) {
            this.gdsRead.handleError("Property has no value");
        }
        this.gdsRead.getToken();
        String property = this.gdsRead.getStringValue();
        if (this.lastExportInstance != null && (parts = property.split(" ")).length >= 4) {
            String portName = parts[2];
            String direction = parts[3];
            if (portName.equals(this.lastExportInstance.exportOrTextName)) {
                if (direction.equals("input")) {
                    this.lastExportInstance.pc = PortCharacteristic.IN;
                } else if (direction.equals("output")) {
                    this.lastExportInstance.pc = PortCharacteristic.OUT;
                } else if (direction.equals("inputOutput")) {
                    this.lastExportInstance.pc = PortCharacteristic.BIDIR;
                }
            }
            this.lastExportInstance = null;
        }
        this.gdsRead.getToken();
    }

    private void getPrototype(String name) throws Exception {
        name = this.localPrefs.skeletonize ? name + "{lay.sk}" : name + "{lay}";
        Cell np = this.findCell(name);
        if (np == null) {
            np = Cell.newInstance(this.theLibrary, name);
            if (np == null) {
                this.gdsRead.handleError("Failed to create SREF proto");
            }
            GDS.setProgressValue(0);
            GDS.setProgressNote("Reading " + name);
            this.missingCells.add(np);
        }
        this.theNodeProto = np;
    }

    private void readGenerations() throws Exception {
        this.gdsRead.getToken();
        if (this.gdsRead.getTokenType() != GDSReader.GDS_SHORT_NUMBER) {
            this.gdsRead.handleError("Generations value is invalid");
        }
        this.gdsRead.getToken();
    }

    private boolean isMember(GDSReader.GSymbol tok, GDSReader.GSymbol[] set) {
        for (int i = 0; i < set.length; ++i) {
            if (set[i] != tok) continue;
            return true;
        }
        return false;
    }

    private void readUnsupported(GDSReader.GSymbol[] bad_op_set) throws Exception {
        if (this.isMember(this.gdsRead.getTokenType(), bad_op_set)) {
            do {
                this.gdsRead.getToken();
            } while (!this.isMember(this.gdsRead.getTokenType(), goodOpSet));
        }
    }

    private void determinePoints(int min_points, int max_points) throws Exception {
        this.numVertices = 0;
        while (this.gdsRead.getTokenType() == GDSReader.GDS_NUMBER) {
            double x = this.scaleValue(this.gdsRead.getIntValue());
            this.gdsRead.getToken();
            double y = this.scaleValue(this.gdsRead.getIntValue());
            this.theVertices[this.numVertices].setLocation(x, y);
            ++this.numVertices;
            if (this.numVertices > max_points) {
                System.out.println("Found " + this.numVertices + " points (too many)");
                this.gdsRead.handleError("Too many points in the shape");
            }
            this.gdsRead.getToken();
        }
        if (this.numVertices < min_points) {
            System.out.println("Found " + this.numVertices + " points (too few)");
            this.gdsRead.handleError("Not enough points in the shape");
        }
    }

    static {
        optionSet = new GDSReader.GSymbol[]{GDSReader.GDS_ATTRTABLE, GDSReader.GDS_REFLIBS, GDSReader.GDS_FONTS, GDSReader.GDS_GENERATIONS};
        shapeSet = new GDSReader.GSymbol[]{GDSReader.GDS_AREF, GDSReader.GDS_SREF, GDSReader.GDS_BOUNDARY, GDSReader.GDS_PATH, GDSReader.GDS_NODE, GDSReader.GDS_TEXTSYM, GDSReader.GDS_BOX};
        goodOpSet = new GDSReader.GSymbol[]{GDSReader.GDS_HEADER, GDSReader.GDS_BGNLIB, GDSReader.GDS_LIBNAME, GDSReader.GDS_UNITS, GDSReader.GDS_ENDLIB, GDSReader.GDS_BGNSTR, GDSReader.GDS_STRNAME, GDSReader.GDS_ENDSTR, GDSReader.GDS_BOUNDARY, GDSReader.GDS_PATH, GDSReader.GDS_SREF, GDSReader.GDS_AREF, GDSReader.GDS_TEXTSYM, GDSReader.GDS_LAYER, GDSReader.GDS_DATATYPSYM, GDSReader.GDS_WIDTH, GDSReader.GDS_XY, GDSReader.GDS_ENDEL, GDSReader.GDS_SNAME, GDSReader.GDS_COLROW, GDSReader.GDS_TEXTNODE, GDSReader.GDS_NODE, GDSReader.GDS_TEXTTYPE, GDSReader.GDS_PRESENTATION, GDSReader.GDS_STRING, GDSReader.GDS_STRANS, GDSReader.GDS_MAG, GDSReader.GDS_ANGLE, GDSReader.GDS_REFLIBS, GDSReader.GDS_FONTS, GDSReader.GDS_PATHTYPE, GDSReader.GDS_GENERATIONS, GDSReader.GDS_ATTRTABLE, GDSReader.GDS_NODETYPE, GDSReader.GDS_PROPATTR, GDSReader.GDS_PROPVALUE, GDSReader.GDS_BOX, GDSReader.GDS_BOXTYPE, GDSReader.GDS_FORMAT, GDSReader.GDS_MASK, GDSReader.GDS_ENDMASKS};
        maskSet = new GDSReader.GSymbol[]{GDSReader.GDS_DATATYPSYM, GDSReader.GDS_TEXTTYPE, GDSReader.GDS_BOXTYPE, GDSReader.GDS_NODETYPE};
        unsupportedSet = new GDSReader.GSymbol[]{GDSReader.GDS_ELFLAGS, GDSReader.GDS_PLEX};
    }

    private static class UnknownLayerMessage {
        String message;
        String nodeName;

        UnknownLayerMessage(String message, String nodeName) {
            this.message = message;
            this.nodeName = nodeName;
        }
    }

    private class ReadOrientation {
        private int angle;
        private boolean trans;
        private double scale;

        private ReadOrientation() {
        }

        private void doIt() throws Exception {
            double anglevalue = 0.0;
            this.scale = 1.0;
            boolean mirror_x = false;
            GDS.this.gdsRead.getToken();
            if (GDS.this.gdsRead.getTokenType() != GDSReader.GDS_FLAGSYM) {
                GDS.this.gdsRead.handleError("Structure reference is missing its flags field");
            }
            if ((GDS.this.gdsRead.getFlagsValue() & 0x8000) != 0) {
                mirror_x = true;
            }
            GDS.this.gdsRead.getToken();
            if (GDS.this.gdsRead.getTokenType() == GDSReader.GDS_MAG) {
                GDS.this.gdsRead.getToken();
                this.scale = GDS.this.gdsRead.getDoubleValue();
                GDS.this.gdsRead.getToken();
            }
            if (GDS.this.gdsRead.getTokenType() == GDSReader.GDS_ANGLE) {
                GDS.this.gdsRead.getToken();
                anglevalue = GDS.this.gdsRead.getDoubleValue() * 10.0;
                GDS.this.gdsRead.getToken();
            }
            this.angle = (int)anglevalue % 3600;
            this.trans = mirror_x;
            if (this.trans) {
                this.angle = (2700 - this.angle) % 3600;
            }
            if (this.angle < 0) {
                this.angle += 3600;
            }
        }
    }

    private class MakeInstance {
        private NodeProto proto;
        private final Point2D loc;
        private final Orientation orient;
        private final double wid;
        private final double hei;
        private final EPoint[] points;
        private String exportOrTextName;
        private boolean isVariableText;
        private final Name nodeName;
        private String origNodeName;
        private PortCharacteristic pc;
        private ImmutableNodeInst n;

        private MakeInstance(CellBuilder cb, NodeProto proto, Point2D loc, Orientation orient, double wid, double hei, EPoint[] points, String exportOrTextName, Name nodeName, boolean isVar) {
            Name baseName;
            this.proto = proto;
            this.loc = loc;
            this.orient = orient;
            this.wid = DBMath.round(wid);
            this.hei = DBMath.round(hei);
            this.points = points;
            this.exportOrTextName = exportOrTextName;
            this.isVariableText = isVar;
            this.pc = PortCharacteristic.UNKNOWN;
            if (nodeName != null && !nodeName.isValid()) {
                this.origNodeName = nodeName.toString();
                if (this.origNodeName.equals("[@instanceName]")) {
                    this.origNodeName = null;
                    nodeName = null;
                } else if (this.origNodeName.endsWith(":")) {
                    nodeName = Name.findName(this.origNodeName.substring(0, this.origNodeName.length() - 1));
                    if (nodeName.isValid()) {
                        this.origNodeName = null;
                    }
                } else {
                    nodeName = null;
                }
            }
            cb.count.increment();
            if (nodeName != null) {
                if (!this.validGdsNodeName(nodeName)) {
                    System.out.println("  Warning: Node name '" + nodeName + "' in cell " + cb.cell.describe(false) + " is bad (" + Name.checkName(nodeName.toString()) + ")...ignoring the name");
                } else if (!cb.userNames.contains(nodeName.toString())) {
                    cb.userNames.add(nodeName.toString());
                    this.nodeName = nodeName;
                    return;
                }
            }
            if (proto instanceof Cell) {
                baseName = ((Cell)proto).getBasename();
            } else {
                PrimitiveNode np = (PrimitiveNode)proto;
                baseName = np.getFunction().getBasename();
            }
            String basenameString = baseName.toString();
            MutableInteger maxSuffix = (MutableInteger)cb.maxSuffixes.get(basenameString);
            if (maxSuffix == null) {
                maxSuffix = new MutableInteger(-1);
                cb.maxSuffixes.put(basenameString, maxSuffix);
            }
            maxSuffix.increment();
            this.nodeName = baseName.findSuffixed(maxSuffix.intValue());
        }

        private boolean validGdsNodeName(Name name) {
            return name.isValid() && !name.hasEmptySubnames() && !name.isBus() || !name.isTempname();
        }

        private void instantiate(CellBuilder cb, Map<String, String> exportUnify, List<ImmutableNodeInst> saveHere) {
            Cell parent = cb.cell;
            assert (parent.isLinked());
            int nodeId = cb.nodeId++;
            assert (this.nodeName != null);
            String name = this.nodeName.toString();
            assert (parent.findNode(name) == null);
            assert (!NodeInst.checkNameKey(this.nodeName, parent) && !this.nodeName.isBus());
            TextDescriptor nameDescriptor = GDS.this.ep.getNodeTextDescriptor();
            EPoint anchor = EPoint.snap(this.loc);
            EPoint size2 = EPoint.ORIGIN;
            if (this.proto instanceof PrimitiveNode) {
                ERectangle full = ((PrimitiveNode)this.proto).getFullRectangle();
                long gridWidth = DBMath.lambdaToSizeGrid(this.wid - full.getLambdaWidth());
                long gridHeight = DBMath.lambdaToSizeGrid(this.hei - full.getLambdaHeight());
                try {
                    size2 = EPoint.fromGrid(gridWidth, gridHeight);
                }
                catch (IllegalArgumentException e) {
                    String errorMsg = "Coordinate (" + gridWidth + "," + gridHeight + ") too large to store in 32-bits";
                    Input.errorLogger.logError(errorMsg, parent, -1);
                    System.out.println("ERROR: " + errorMsg);
                }
            } else assert (((Cell)this.proto).isLinked());
            int flags = 0;
            int techBits = 0;
            TextDescriptor protoDescriptor = GDS.this.ep.getInstanceTextDescriptor();
            this.n = ImmutableNodeInst.newInstance(nodeId, this.proto.getId(), this.nodeName, nameDescriptor, this.orient, anchor, size2, flags, techBits, protoDescriptor);
            if (this.points != null && GenMath.getAreaOfPoints(this.points) != this.wid * this.hei) {
                this.n = this.n.withTrace(this.points, null);
            }
            if (this.isVariableText) {
                TextDescriptor td = GDS.this.ep.getExportTextDescriptor().withDisplay(true);
                Variable var = Variable.newInstance(Artwork.ART_MESSAGE, this.exportOrTextName, td);
                this.n = this.n.withVariable(var);
            }
            cb.nodesToCreate.add(this.n);
            if (saveHere != null) {
                saveHere.add(this.n);
            }
            String errorMsg = null;
            if (this.origNodeName != null) {
                errorMsg = "Cell " + parent.describe(false) + ": Original GDS name of '" + name + "' was '" + this.origNodeName + "'";
            }
            if (errorMsg != null) {
                Input.errorLogger.logMessage(errorMsg, Collections.singleton(this.n), parent, -1, false);
                System.out.println(errorMsg);
            }
            if (this.exportOrTextName != null && !this.isVariableText) {
                if (this.exportOrTextName.endsWith(":")) {
                    this.exportOrTextName = this.exportOrTextName.substring(0, this.exportOrTextName.length() - 1);
                }
                this.exportOrTextName = this.exportOrTextName.replace(':', '_');
                String trueName = null;
                if (cb.alreadyExports.contains(this.exportOrTextName)) {
                    String newName = ElectricObject.uniqueObjectName(this.exportOrTextName, parent, Export.class, cb.alreadyExports, cb.nextExportPlainIndex, true, true);
                    exportUnify.put(newName, this.exportOrTextName);
                    trueName = this.exportOrTextName;
                    this.exportOrTextName = newName;
                }
                ExportId exportId = parent.getD().cellId.newPortId(this.exportOrTextName);
                boolean busNamesAllowed = false;
                Name exportNameKey = ImmutableExport.validExportName(this.exportOrTextName, busNamesAllowed);
                if (exportNameKey == null) {
                    String newName = Export.repairExportName(parent, this.exportOrTextName);
                    if (newName == null) {
                        newName = Export.repairExportName(parent, "X");
                    }
                    if (newName != null) {
                        exportNameKey = ImmutableExport.validExportName(newName, busNamesAllowed);
                    }
                    if (exportNameKey == null) {
                        System.out.print("Error: Pin '" + this.exportOrTextName + "' is invalid");
                        if (newName != null) {
                            System.out.print(" and alternate name, '" + newName + "' cannot be used");
                        }
                        System.out.println(".  Pin ignored.");
                        return;
                    }
                    System.out.println("Warning: Pin '" + this.exportOrTextName + "' is invalid and was renamed to '" + newName + "'");
                    this.exportOrTextName = newName;
                }
                TextDescriptor nameTextDescriptor = GDS.this.ep.getExportTextDescriptor();
                PortProtoId portProtoId = this.proto.getPort(0).getId();
                boolean alwaysDrawn = false;
                boolean bodyOnly = false;
                assert (parent.findExport(this.exportOrTextName) == null);
                ImmutableExport d = ImmutableExport.newInstance(exportId, exportNameKey, nameTextDescriptor, nodeId, portProtoId, alwaysDrawn, bodyOnly, this.pc);
                if (trueName != null) {
                    TextDescriptor td = GDS.this.ep.getExportTextDescriptor();
                    Variable var = Variable.newInstance(ORIGINAL_EXPORT_NAME, trueName, td);
                    d = d.withVariable(var);
                }
                cb.exportsByName.put(this.exportOrTextName, d);
            }
        }
    }

    private class MakeInstanceArray {
        private NodeProto proto;
        private int nCols;
        private int nRows;
        private Orientation orient;
        private Point2D startLoc;
        private Point2D rowOffset;
        private Point2D colOffset;
        private GDSPreferences localPrefs;

        private MakeInstanceArray(NodeProto proto, int nCols, int nRows, Orientation orient, Point2D startLoc, Point2D rowOffset, Point2D colOffset, GDSPreferences localPrefs) {
            this.proto = proto;
            this.nCols = nCols;
            this.nRows = nRows;
            this.orient = orient;
            this.startLoc = startLoc;
            this.rowOffset = rowOffset;
            this.colOffset = colOffset;
            this.localPrefs = localPrefs;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void instantiate(CellBuilder cb, Map<NodeProto, List<EPoint>> massiveMerge) {
            int rows;
            int cols;
            double rowspace;
            double colspace;
            Cell parent = cb.cell;
            int arraySimplification = this.localPrefs.arraySimplification;
            NodeInst subNi = null;
            Cell subCell = (Cell)this.proto;
            int numArcs = subCell.getNumArcs();
            int numNodes = subCell.getNumNodes();
            int numExports = subCell.getNumPorts();
            if (numArcs == 0 && numExports == 0 && numNodes == 1 && (subNi = subCell.getNode(0)).getProto().getFunction() != PrimitiveNode.Function.NODE) {
                subNi = null;
            }
            if (subNi != null && subNi.getTrace() != null) {
                subNi = null;
            }
            if (subNi != null) {
                if (arraySimplification > 0) {
                    List<EPoint> points = this.buildArray();
                    if (arraySimplification == 2) {
                        List<EPoint> soFar = massiveMerge.get(subNi.getProto());
                        if (soFar == null) {
                            soFar = new ArrayList<EPoint>();
                            massiveMerge.put(subNi.getProto(), soFar);
                        }
                        if (soFar.size() > 0) {
                            soFar.add(null);
                        }
                        for (EPoint ep : points) {
                            soFar.add(ep);
                        }
                        return;
                    } else {
                        GDS.this.buildComplexNode(cb, points, subNi.getProto(), parent, GDS.this.ep);
                    }
                    return;
                }
                arraySimplificationUseful = true;
            }
            if (this.orient.getAngle() % 1800 == 0) {
                if (this.rowOffset.getX() != 0.0 || this.colOffset.getY() != 0.0) throw new Error("jagged arrays not allowed");
                colspace = this.colOffset.getX();
                rowspace = this.rowOffset.getY();
                cols = this.nCols;
                rows = this.nRows;
            } else {
                if (this.orient.getAngle() % 1800 != 900) throw new Error("nonrectangular arrays not allowed");
                if (this.colOffset.getX() != 0.0 || this.rowOffset.getY() != 0.0) throw new Error("jagged arrays not allowed");
                colspace = this.rowOffset.getX();
                rowspace = this.colOffset.getY();
                cols = this.nRows;
                rows = this.nCols;
            }
            GDS.this.cellArrayBuilder.buildArray(this.proto, parent, EPoint.fromLambda(this.startLoc.getX(), this.startLoc.getY()), this.orient, cols, rows, FixpCoord.fromLambda(colspace), FixpCoord.fromLambda(rowspace), GDS.this.ep);
        }

        private List<EPoint> buildArray() {
            ArrayList<EPoint> points = new ArrayList<EPoint>();
            ERectangle bounds = ((Cell)this.proto).getBounds();
            Rectangle2D.Double boundCopy = new Rectangle2D.Double(((RectangularShape)bounds).getMinX(), ((RectangularShape)bounds).getMinY(), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight());
            DBMath.transformRect(boundCopy, this.orient.pureRotate());
            double ptcX = this.startLoc.getX();
            double ptcY = this.startLoc.getY();
            for (int ic = 0; ic < this.nCols; ++ic) {
                double ptX = ptcX;
                double ptY = ptcY;
                for (int ir = 0; ir < this.nRows; ++ir) {
                    points.add(EPoint.fromLambda(ptX + boundCopy.getMinX(), ptY + boundCopy.getMinY()));
                    points.add(EPoint.fromLambda(ptX + boundCopy.getMaxX(), ptY + boundCopy.getMinY()));
                    points.add(EPoint.fromLambda(ptX + boundCopy.getMaxX(), ptY + boundCopy.getMaxY()));
                    points.add(EPoint.fromLambda(ptX + boundCopy.getMinX(), ptY + boundCopy.getMaxY()));
                    if (ic < this.nCols - 1 || ir < this.nRows - 1) {
                        points.add(null);
                    }
                    ptX += this.rowOffset.getX();
                    ptY += this.rowOffset.getY();
                }
                ptcX += this.colOffset.getX();
                ptcY += this.colOffset.getY();
            }
            return points;
        }
    }

    private class CellBuilder {
        private GDSPreferences localPrefs;
        private Technology tech;
        private Cell cell;
        private List<MakeInstance> insts = new ArrayList<MakeInstance>();
        private Map<UnknownLayerMessage, List<MakeInstance>> allErrorInsts = new LinkedHashMap<UnknownLayerMessage, List<MakeInstance>>();
        private List<MakeInstanceArray> instArrays = new ArrayList<MakeInstanceArray>();
        private boolean topLevel;
        private int nodeId;
        private List<ImmutableNodeInst> nodesToCreate = new ArrayList<ImmutableNodeInst>();
        private Map<String, ImmutableExport> exportsByName = new HashMap<String, ImmutableExport>();
        private Set<String> alreadyExports = this.exportsByName.keySet();
        private Map<String, MutableInteger> nextExportPlainIndex = new HashMap<String, MutableInteger>();
        private Map<String, MutableInteger> maxSuffixes = new HashMap<String, MutableInteger>();
        private Set<String> userNames = new HashSet<String>();
        private MutableInteger count = new MutableInteger(0);
        private boolean skeletonDefined;
        private double skeletonLX;
        private double skeletonHX;
        private double skeletonLY;
        private double skeletonHY;
        private List<SkeletonCellInstance> skeletonCellInstances;

        private CellBuilder(Cell cell, Technology tech, GDSPreferences localPrefs) {
            this.cell = cell;
            this.tech = tech;
            this.localPrefs = localPrefs;
            GDS.this.allBuilders.put(cell.getId(), this);
            this.skeletonDefined = false;
            this.skeletonHY = 0.0;
            this.skeletonLY = 0.0;
            this.skeletonHX = 0.0;
            this.skeletonLX = 0.0;
            this.skeletonCellInstances = new ArrayList<SkeletonCellInstance>();
            this.topLevel = true;
            HashSet<Export> exportsToKill = new HashSet<Export>();
            Iterator<Export> it = cell.getExports();
            while (it.hasNext()) {
                exportsToKill.add(it.next());
            }
            cell.killExports(exportsToKill);
            GDS.this.allBuilders.put(cell.getId(), this);
        }

        private void makeInstance(NodeProto proto, Point2D loc, Orientation orient, double wid, double hei, EPoint[] points, UnknownLayerMessage ulm) {
            if (proto == null) {
                return;
            }
            if (this.localPrefs.skeletonize) {
                if (proto instanceof Cell) {
                    this.skeletonCellInstances.add(new SkeletonCellInstance(proto, loc, orient, wid, hei));
                } else {
                    this.doSkeleton(proto, loc, orient, wid, hei, points);
                }
                return;
            }
            String name = ulm != null ? ulm.nodeName : null;
            MakeInstance mi = new MakeInstance(this, proto, loc, orient, wid, hei, points, null, Name.findName(name), false);
            this.insts.add(mi);
            if (ulm != null) {
                List<MakeInstance> errorList = this.allErrorInsts.get(ulm);
                if (errorList == null) {
                    errorList = new ArrayList<MakeInstance>();
                    this.allErrorInsts.put(ulm, errorList);
                }
                errorList.add(mi);
            }
        }

        private void makeInstanceArray(NodeProto proto, int nCols, int nRows, Orientation orient, Point2D startLoc, Point2D rowOffset, Point2D colOffset) {
            if (this.localPrefs.skeletonize) {
                double ptcX = startLoc.getX();
                double ptcY = startLoc.getY();
                for (int ic = 0; ic < nCols; ++ic) {
                    double ptX = ptcX;
                    double ptY = ptcY;
                    for (int ir = 0; ir < nRows; ++ir) {
                        Point2D.Double loc = new Point2D.Double(ptX, ptY);
                        double wid = proto.getDefWidth(GDS.this.ep);
                        double hei = proto.getDefHeight(GDS.this.ep);
                        if (proto instanceof Cell) {
                            this.skeletonCellInstances.add(new SkeletonCellInstance(proto, loc, orient, wid, hei));
                        } else {
                            this.doSkeleton(proto, loc, orient, wid, hei, null);
                        }
                        ptX += rowOffset.getX();
                        ptY += rowOffset.getY();
                    }
                    ptcX += colOffset.getX();
                    ptcY += colOffset.getY();
                }
                return;
            }
            MakeInstanceArray mia = new MakeInstanceArray(proto, nCols, nRows, orient, new Point2D.Double(startLoc.getX(), startLoc.getY()), rowOffset, colOffset, this.localPrefs);
            this.instArrays.add(mia);
        }

        private void makeExport(NodeProto proto, Point2D loc, Orientation orient, String exportName, UnknownLayerMessage ulm) {
            if (this.localPrefs.cadenceCompatibility && exportName.contains("<") && exportName.contains("<")) {
                exportName = exportName.replace("<", "[");
                exportName = exportName.replace(">", "]");
            }
            if (proto != null && proto.getNumPorts() > 0) {
                double wid = proto.getDefWidth(GDS.this.ep);
                double hei = proto.getDefHeight(GDS.this.ep);
                if (this.localPrefs.skeletonize) {
                    this.doSkeleton(proto, loc, orient, wid, hei, null);
                    if (!this.topLevel) {
                        return;
                    }
                }
                GDS.this.lastExportInstance = new MakeInstance(this, proto, loc, orient, wid, hei, null, exportName, null, false);
                this.insts.add(GDS.this.lastExportInstance);
                if (ulm != null) {
                    List<MakeInstance> errorList = this.allErrorInsts.get(ulm);
                    if (errorList == null) {
                        errorList = new ArrayList<MakeInstance>();
                        this.allErrorInsts.put(ulm, errorList);
                    }
                    errorList.add(GDS.this.lastExportInstance);
                }
            }
        }

        private void makeText(NodeProto proto, Point2D loc, String text, TextDescriptor textDescriptor, UnknownLayerMessage ulm) {
            if (proto == null) {
                return;
            }
            if (this.localPrefs.skeletonize) {
                this.doSkeleton(proto, loc, Orientation.IDENT, 0.0, 0.0, null);
                return;
            }
            MakeInstance mi = new MakeInstance(this, proto, loc, Orientation.IDENT, 0.0, 0.0, null, text, null, true);
            this.insts.add(mi);
            if (ulm != null) {
                List<MakeInstance> errorList = this.allErrorInsts.get(ulm);
                if (errorList == null) {
                    errorList = new ArrayList<MakeInstance>();
                    this.allErrorInsts.put(ulm, errorList);
                }
                errorList.add(mi);
            }
        }

        private void makeInstances(Set<CellId> builtCells) {
            CellBuilder cellBuilder;
            Cell subCell;
            if (builtCells.contains(this.cell.getId())) {
                return;
            }
            builtCells.add(this.cell.getId());
            for (MakeInstance mi : this.insts) {
                if (!(mi.proto instanceof Cell)) continue;
                subCell = (Cell)mi.proto;
                cellBuilder = (CellBuilder)GDS.this.allBuilders.get(subCell.getId());
                if (cellBuilder == null) continue;
                cellBuilder.makeInstances(builtCells);
                cellBuilder.topLevel = false;
            }
            for (MakeInstanceArray mia : this.instArrays) {
                if (!(mia.proto instanceof Cell)) continue;
                subCell = (Cell)mia.proto;
                cellBuilder = (CellBuilder)GDS.this.allBuilders.get(subCell.getId());
                if (cellBuilder == null) continue;
                cellBuilder.makeInstances(builtCells);
                cellBuilder.topLevel = false;
            }
            this.makeInstances();
            if (this.localPrefs.skeletonize) {
                PrimitiveNode corner = Generic.tech().essentialBoundsNode;
                double width = corner.getDefWidth(GDS.this.ep);
                double height = corner.getDefHeight(GDS.this.ep);
                NodeInst.makeInstance((NodeProto)corner, GDS.this.ep, new Point2D.Double(this.skeletonHX, this.skeletonHY), width, height, this.cell, Orientation.IDENT, null);
                NodeInst.makeInstance((NodeProto)corner, GDS.this.ep, new Point2D.Double(this.skeletonLX, this.skeletonHY), width, height, this.cell, Orientation.R, null);
                NodeInst.makeInstance((NodeProto)corner, GDS.this.ep, new Point2D.Double(this.skeletonLX, this.skeletonLY), width, height, this.cell, Orientation.RR, null);
                NodeInst.makeInstance((NodeProto)corner, GDS.this.ep, new Point2D.Double(this.skeletonHX, this.skeletonLY), width, height, this.cell, Orientation.RRR, null);
            }
            assert (builtCells.contains(this.cell.getId()));
        }

        private void makeInstances() {
            boolean countOff = false;
            int count2 = 0;
            HashMap exportUnify = new HashMap();
            for (MakeInstance mi : this.insts) {
                if (mi.exportOrTextName != null) continue;
                if (countOff && ++count2 % 1000 == 0) {
                    System.out.println("        Made " + count2 + " instances");
                }
                mi.instantiate(this, exportUnify, null);
            }
            this.createNodes();
            for (MakeInstance mi : this.insts) {
                if (mi.exportOrTextName == null) continue;
                if (countOff && ++count2 % 1000 == 0) {
                    System.out.println("        Made " + count2 + " instances");
                }
                if (this.localPrefs.cadenceCompatibility) {
                    double scaledResolution;
                    ArcProto theArc = mi.proto.getPort(0).getBasePort().getConnections()[0];
                    Layer theLayer = theArc.getLayer(0);
                    PrimitiveNode theProto = theLayer.getPureLayerNode();
                    Rectangle2D.Double search = new Rectangle2D.Double(mi.loc.getX(), mi.loc.getY(), 0.0, 0.0);
                    Iterator<Geometric> it = this.cell.searchIterator(search);
                    block2: while (it.hasNext()) {
                        NodeInst ni;
                        Geometric geom = it.next();
                        if (!(geom instanceof NodeInst) || (ni = (NodeInst)geom).getProto() != theProto) continue;
                        ERectangle pointBounds = ni.getBounds();
                        double cX = ((RectangularShape)pointBounds).getCenterX();
                        double cY = ((RectangularShape)pointBounds).getCenterY();
                        EPoint[] trace = ni.getTrace();
                        if (trace != null) {
                            PolyBase.Point[] newPoints = new PolyBase.Point[trace.length];
                            for (int i = 0; i < trace.length; ++i) {
                                if (trace[i] == null) continue;
                                newPoints[i] = PolyBase.fromLambda(trace[i].getX() + cX, trace[i].getY() + cY);
                            }
                            PolyBase poly = new PolyBase(newPoints);
                            poly.transform(ni.rotateOut());
                            if (!poly.contains(mi.loc)) continue;
                            GeometryHandler thisMerge = GeometryHandler.createGeometryHandler(GeometryHandler.GHMode.ALGO_SWEEP, 1);
                            thisMerge.add(theLayer, poly);
                            thisMerge.postProcess(true);
                            Collection<PolyBase> set = ((PolySweepMerge)thisMerge).getPolyPartition(theLayer);
                            for (PolyBase simplePoly : set) {
                                FixpRectangle polyBounds = simplePoly.getBounds2D();
                                if (!polyBounds.contains(mi.loc)) continue;
                                mi.loc.setLocation(((RectangularShape)polyBounds).getCenterX(), ((RectangularShape)polyBounds).getCenterY());
                                break block2;
                            }
                            break;
                        }
                        if (!pointBounds.contains(mi.loc)) continue;
                        mi.loc.setLocation(cX, cY);
                        break;
                    }
                    if ((scaledResolution = this.tech.getFactoryResolution().getLambda()) > 0.0) {
                        double x = (double)Math.round(mi.loc.getX() / scaledResolution) * scaledResolution;
                        double y = (double)Math.round(mi.loc.getY() / scaledResolution) * scaledResolution;
                        mi.loc.setLocation(x, y);
                    }
                }
                mi.instantiate(this, exportUnify, null);
            }
            for (UnknownLayerMessage ulm : this.allErrorInsts.keySet()) {
                ArrayList<ImmutableNodeInst> instantiated = new ArrayList<ImmutableNodeInst>();
                List<MakeInstance> errorList = this.allErrorInsts.get(ulm);
                for (MakeInstance mi : errorList) {
                    if (mi == null) continue;
                    if (countOff && ++count2 % 1000 == 0) {
                        System.out.println("        Made " + count2 + " instances");
                    }
                    if (mi.n == null) continue;
                    instantiated.add(mi.n);
                }
                String msg = "Cell " + this.cell.noLibDescribe() + ": " + ulm.message;
                TreeSet<Cell> cellsWithError = (TreeSet<Cell>)cellLayerErrors.get(ulm);
                if (cellsWithError == null) {
                    cellsWithError = new TreeSet<Cell>();
                    cellLayerErrors.put(ulm, cellsWithError);
                }
                cellsWithError.add(this.cell);
                Input.errorLogger.logMessage(msg, instantiated, this.cell, -1, true);
            }
            this.createNodes();
            HashMap massiveMerge = new HashMap();
            for (MakeInstanceArray mia : this.instArrays) {
                if (countOff && ++count2 % 1000 == 0) {
                    System.out.println("        Made " + count2 + " instances");
                }
                mia.instantiate(this, massiveMerge);
            }
            ArrayList<NodeProto> mergeNodeSet = new ArrayList<NodeProto>();
            for (NodeProto np : massiveMerge.keySet()) {
                mergeNodeSet.add(np);
            }
            for (NodeProto np : mergeNodeSet) {
                List points = (List)massiveMerge.get(np);
                GDS.this.buildComplexNode(this, points, np, this.cell, GDS.this.ep);
            }
            this.cell.addExports(this.exportsByName.values());
            if (!exportUnify.isEmpty()) {
                System.out.println("Cell " + this.cell.describe(false) + ": Renamed and NCC-unified " + exportUnify.size() + " exports with duplicate names");
                HashMap<String, String> unifyStrings = new HashMap<String, String>();
                Set finalNames = exportUnify.keySet();
                for (String finalName : finalNames) {
                    String singleName = (String)exportUnify.get(finalName);
                    String us = (String)unifyStrings.get(singleName);
                    if (us == null) {
                        us = singleName;
                    }
                    us = us + " " + finalName;
                    unifyStrings.put(singleName, us);
                }
                ArrayList<String> annotations = new ArrayList<String>();
                for (String us : unifyStrings.keySet()) {
                    annotations.add("exportsConnectedByParent " + (String)unifyStrings.get(us));
                }
                if (annotations.size() > 0) {
                    String[] anArr = new String[annotations.size()];
                    for (int i = 0; i < annotations.size(); ++i) {
                        anArr[i] = (String)annotations.get(i);
                    }
                    TextDescriptor td = GDS.this.ep.getCellTextDescriptor().withInterior(true).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
                    this.cell.newVar(NccCellAnnotations.NCC_ANNOTATION_KEY, (Object)anArr, td);
                }
            }
            if (this.localPrefs.simplifyCells && !this.localPrefs.skeletonize) {
                this.simplifyNodes(this.cell, this.tech);
            }
        }

        private void createNodes() {
            this.cell.addNodes(this.nodesToCreate);
            this.nodesToCreate.clear();
        }

        private void doSkeleton(NodeProto proto, Point2D loc, Orientation orient, double wid, double hei, EPoint[] points) {
            double lX = 0.0;
            double hX = 0.0;
            double lY = 0.0;
            double hY = 0.0;
            if (proto instanceof PrimitiveNode) {
                if (points != null) {
                    lX = hX = points[0].getX();
                    lY = hY = points[0].getY();
                    for (int i = 1; i < points.length; ++i) {
                        if (points[i].getX() < lX) {
                            lX = points[i].getX();
                        }
                        if (points[i].getX() > hX) {
                            hX = points[i].getX();
                        }
                        if (points[i].getY() < lY) {
                            lY = points[i].getY();
                        }
                        if (!(points[i].getY() > hY)) continue;
                        hY = points[i].getY();
                    }
                } else {
                    double sX = DBMath.round(wid);
                    double sY = DBMath.round(hei);
                    if (orient.getAngle() == 900 || orient.getAngle() == 2700) {
                        double swap = sX;
                        sX = sY;
                        sY = swap;
                    }
                    lX = loc.getX() - sX / 2.0;
                    hX = loc.getX() + sX / 2.0;
                    lY = loc.getY() - sY / 2.0;
                    hY = loc.getY() + sY / 2.0;
                }
            } else {
                CellBuilder subCB = (CellBuilder)GDS.this.allBuilders.get(proto.getId());
                if (subCB != null) {
                    lX = subCB.skeletonLX;
                    hX = subCB.skeletonHX;
                    lY = subCB.skeletonLY;
                    hY = subCB.skeletonHY;
                    if (orient != Orientation.IDENT) {
                        Point2D p1 = orient.transformPoint(new Point2D.Double(lX, lY));
                        Point2D p2 = orient.transformPoint(new Point2D.Double(lX, hY));
                        Point2D p3 = orient.transformPoint(new Point2D.Double(hX, hY));
                        Point2D p4 = orient.transformPoint(new Point2D.Double(hX, lY));
                        lX = Math.min(Math.min(p1.getX(), p2.getX()), Math.min(p3.getX(), p4.getX()));
                        hX = Math.max(Math.max(p1.getX(), p2.getX()), Math.max(p3.getX(), p4.getX()));
                        lY = Math.min(Math.min(p1.getY(), p2.getY()), Math.min(p3.getY(), p4.getY()));
                        hY = Math.max(Math.max(p1.getY(), p2.getY()), Math.max(p3.getY(), p4.getY()));
                    }
                    lX += loc.getX();
                    hX += loc.getX();
                    lY += loc.getY();
                    hY += loc.getY();
                    subCB.topLevel = false;
                }
            }
            if (this.skeletonDefined) {
                this.skeletonLX = Math.min(this.skeletonLX, lX);
                this.skeletonHX = Math.max(this.skeletonHX, hX);
                this.skeletonLY = Math.min(this.skeletonLY, lY);
                this.skeletonHY = Math.max(this.skeletonHY, hY);
            } else {
                this.skeletonLX = lX;
                this.skeletonHX = hX;
                this.skeletonLY = lY;
                this.skeletonHY = hY;
                this.skeletonDefined = true;
            }
        }

        private void simplifyNodes(Cell cell, Technology tech) {
            HashMap<Layer, ArrayList<NodeInst>> map2 = new HashMap<Layer, ArrayList<NodeInst>>();
            Iterator<NodeInst> itNi = cell.getNodes();
            while (itNi.hasNext()) {
                PrimitiveNode pn;
                NodeInst ni = itNi.next();
                if (!(ni.getProto() instanceof PrimitiveNode) || (pn = (PrimitiveNode)ni.getProto()).getFunction() != PrimitiveNode.Function.NODE) continue;
                Layer layer = pn.getLayerIterator().next();
                ArrayList<NodeInst> list = (ArrayList<NodeInst>)map2.get(layer);
                if (list == null) {
                    list = new ArrayList<NodeInst>();
                    map2.put(layer, list);
                }
                list.add(ni);
            }
            HashSet<NodeInst> toDelete = new HashSet<NodeInst>();
            HashSet<NodeInst> viaToDelete = new HashSet<NodeInst>();
            ArrayList<NodeInst> geomList = new ArrayList<NodeInst>();
            Iterator<PrimitiveNode> itPn = tech.getNodes();
            while (itPn.hasNext()) {
                PrimitiveNode pn = itPn.next();
                boolean allFound = true;
                if (!pn.getFunction().isContact()) continue;
                Layer m1Layer = null;
                Layer m2Layer = null;
                Layer viaLayer = null;
                SizeOffset so = pn.getProtoSizeOffset();
                Iterator<Layer> itLa = pn.getLayerIterator();
                while (itLa.hasNext()) {
                    Layer l = itLa.next();
                    if (map2.get(l) == null) {
                        allFound = false;
                        break;
                    }
                    if (l.getFunction().isMetal()) {
                        if (m1Layer == null) {
                            m1Layer = l;
                            continue;
                        }
                        m2Layer = l;
                        continue;
                    }
                    if (!l.getFunction().isContact()) continue;
                    viaLayer = l;
                }
                if (!allFound || viaLayer == null) continue;
                assert (m1Layer != null);
                List list = (List)map2.get(m1Layer);
                assert (list != null);
                Layer.Function.Set thisLayer = new Layer.Function.Set(viaLayer.getFunction());
                List viasList = (List)map2.get(viaLayer);
                for (NodeInst ni : list) {
                    Poly[] polys = tech.getShapeOfNode(ni, true, false, null);
                    assert (polys.length == 1);
                    Poly m1P = polys[0];
                    List nList = (List)map2.get(m2Layer);
                    if (nList == null) continue;
                    for (NodeInst n : nList) {
                        double hei;
                        Poly[] otherPolys = tech.getShapeOfNode(n, true, false, null);
                        assert (otherPolys.length == 1);
                        Poly m2P = otherPolys[0];
                        if (!m2P.getBounds2D().equals(m1P.getBounds2D())) continue;
                        ImmutableNodeInst d = ni.getD();
                        String name = ni.getName();
                        int atIndex = name.indexOf(64);
                        name = atIndex < 0 ? name + "tmp" : name.substring(0, atIndex) + "tmp" + name.substring(atIndex);
                        double wid = m2P.getBounds2D().getWidth() + so.getLowXOffset() + so.getHighXOffset();
                        NodeInst newNi = NodeInst.makeInstance((NodeProto)pn, GDS.this.ep, d.anchor, wid, hei = m2P.getBounds2D().getHeight() + so.getLowYOffset() + so.getHighYOffset(), ni.getParent(), ni.getOrient(), name);
                        if (newNi == null) continue;
                        assert (viasList != null);
                        Poly[] viaPolys = tech.getShapeOfNode(newNi, true, false, thisLayer);
                        boolean found = false;
                        viaToDelete.clear();
                        for (int i = 0; i < viaPolys.length; ++i) {
                            Poly poly = viaPolys[i];
                            FixpRectangle bb = poly.getBounds2D();
                            ((Rectangle2D)bb).setRect(ERectangle.fromLambda(bb));
                            found = false;
                            for (NodeInst viaNi : viasList) {
                                Poly[] thisViaList = tech.getShapeOfNode(viaNi, true, false, thisLayer);
                                assert (thisViaList.length == 1);
                                Poly p = thisViaList[0];
                                FixpRectangle b = p.getBounds2D();
                                ((Rectangle2D)b).setRect(ERectangle.fromLambda(b));
                                if (!thisViaList[0].polySame(poly)) continue;
                                viaToDelete.add(viaNi);
                                assert (!found);
                                found = true;
                            }
                            if (!found) break;
                        }
                        if (!found) {
                            newNi.kill();
                            continue;
                        }
                        toDelete.clear();
                        geomList.clear();
                        toDelete.add(ni);
                        toDelete.add(n);
                        toDelete.addAll(viaToDelete);
                        String message = toDelete.size() + " nodes were replaced for more complex primitives in cell '" + cell.getName() + "'";
                        geomList.add(newNi);
                        Input.errorLogger.logMessage(message, geomList, cell, -1, false);
                        cell.killNodes(toDelete);
                    }
                }
            }
        }
    }

    private static class SkeletonCellInstance {
        NodeProto proto;
        Point2D loc;
        Orientation orient;
        double wid;
        double hei;

        public SkeletonCellInstance(NodeProto proto, Point2D loc, Orientation orient, double wid, double hei) {
            this.proto = proto;
            this.loc = loc;
            this.orient = orient;
            this.wid = wid;
            this.hei = hei;
        }
    }

    public static class GDSPreferences
    extends Input.InputPreferences {
        public double inputScale;
        public boolean simplifyCells;
        public int arraySimplification;
        public boolean instantiateArrays;
        public boolean expandCells;
        public boolean mergeBoxes;
        public boolean includeText;
        public int unknownLayerHandling;
        public boolean cadenceCompatibility;
        public boolean skeletonize = false;
        boolean onlyVisibleLayers;
        boolean[] visibility;
        boolean[][] techVisibility;
        int defaultTextLayer = IOTool.getGDSDefaultTextLayer();

        public GDSPreferences(boolean factory) {
            super(factory);
            if (factory) {
                this.inputScale = IOTool.getFactoryGDSInputScale();
                this.simplifyCells = IOTool.isFactoryGDSInSimplifyCells();
                this.arraySimplification = IOTool.getFactoryGDSArraySimplification();
                this.instantiateArrays = IOTool.isFactoryGDSInInstantiatesArrays();
                this.expandCells = IOTool.isFactoryGDSInExpandsCells();
                this.mergeBoxes = IOTool.isFactoryGDSInMergesBoxes();
                this.includeText = IOTool.isFactoryGDSIncludesText();
                this.unknownLayerHandling = IOTool.getFactoryGDSInUnknownLayerHandling();
                this.cadenceCompatibility = IOTool.isFactoryGDSCadenceCompatibility();
                this.onlyVisibleLayers = IOTool.isFactoryGDSOnlyInvisibleLayers();
            } else {
                this.inputScale = IOTool.getGDSInputScale();
                this.simplifyCells = IOTool.isGDSInSimplifyCells();
                this.arraySimplification = IOTool.getGDSArraySimplification();
                this.instantiateArrays = IOTool.isGDSInInstantiatesArrays();
                this.expandCells = IOTool.isGDSInExpandsCells();
                this.mergeBoxes = IOTool.isGDSInMergesBoxes();
                this.includeText = IOTool.isGDSIncludesText();
                this.unknownLayerHandling = IOTool.getGDSInUnknownLayerHandling();
                this.cadenceCompatibility = IOTool.isGDSCadenceCompatibility();
                this.onlyVisibleLayers = IOTool.isGDSOnlyInvisibleLayers();
            }
            if (this.onlyVisibleLayers) {
                this.techVisibility = LayerVisibility.getLayerVisibility().getTechDataArray();
            }
        }

        @Override
        public void setSkeleton(boolean sk) {
            this.skeletonize = sk;
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, EditingPreferences ep, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            GDS in = new GDS(ep, this);
            if (in.openBinaryInput(fileURL)) {
                return null;
            }
            if (this.techVisibility != null) {
                this.visibility = this.techVisibility[tech.getId().techIndex];
            }
            in.gdsRead = new GDSReader(in.filePath, in.dataInputStream, in.fileLength);
            HashSet<Library> oldLibs = new HashSet<Library>();
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                oldLibs.add(it.next());
            }
            oldLibs.remove(lib);
            lib = in.importALibrary(lib, tech, currentCells);
            in.closeInput();
            if (this.expandCells) {
                EDatabase database = EDatabase.currentDatabase();
                Iterator<Library> it2 = Library.getLibraries();
                while (it2.hasNext()) {
                    Library l = it2.next();
                    if (oldLibs.contains(l)) continue;
                    Iterator<Cell> cit = l.getCells();
                    while (cit.hasNext()) {
                        Cell cell = cit.next();
                        Iterator<NodeInst> nit = cell.getNodes();
                        while (nit.hasNext()) {
                            NodeInst ni = nit.next();
                            if (!ni.isCellInstance()) continue;
                            database.addToNodes(nodesToExpand, ni);
                        }
                    }
                }
            }
            return lib;
        }
    }

    private static class ShapeType {
        private ShapeType() {
        }
    }
}

