/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.forceDirected.util;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.forceDirected2.AdditionalNodeData;
import com.sun.electric.tool.placement.forceDirected2.PlacementForceDirectedStaged;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.OverlapDirection;
import java.awt.geom.Point2D;
import java.util.concurrent.atomic.AtomicInteger;

public class CheckboardingField {
    private Point2D location;
    private double cellX;
    private double cellY;
    private PlacementFrame.PlacementNode node;
    private int cellId;
    private FieldBoardingDTO fieldBoarding;
    private AtomicInteger counter = new AtomicInteger(0);
    private int coordX;
    private int coordY;
    private int notMovedCounter;

    public CheckboardingField(Point2D loc, double x2, double y, int cellId) {
        this.location = loc;
        this.cellX = x2;
        this.cellY = y;
        this.setCellId(cellId);
        this.fieldBoarding = new FieldBoardingDTO();
        this.calculateFieldBoarding();
    }

    public CheckboardingField(Point2D loc, double x2, double y, int cellId, int cellIdX, int cellIdY) {
        this.location = loc;
        this.cellX = x2;
        this.cellY = y;
        this.setCellId(cellId);
        this.setCoordX(cellIdX);
        this.setCoordY(cellIdY);
        this.fieldBoarding = new FieldBoardingDTO();
        this.calculateFieldBoarding();
    }

    private void calculateFieldBoarding() {
        this.fieldBoarding.cellMinX = this.location.getX() - this.cellX / 2.0;
        this.fieldBoarding.cellMaxX = this.location.getX() + this.cellX / 2.0;
        this.fieldBoarding.cellMinY = this.location.getY() - this.cellY / 2.0;
        this.fieldBoarding.cellMaxY = this.location.getY() + this.cellY / 2.0;
    }

    public synchronized int getCellId() {
        return this.cellId;
    }

    public double getCellX() {
        return this.cellX;
    }

    public double getCellY() {
        return this.cellY;
    }

    public int getCoordX() {
        return this.coordX;
    }

    public int getCoordY() {
        return this.coordY;
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public Point2D getLocation() {
        return this.location;
    }

    public synchronized PlacementFrame.PlacementNode getNode() {
        return this.node;
    }

    public int getNotMovedCounter() {
        return this.notMovedCounter;
    }

    public OverlapDirection getOverlapDirection() {
        if (this.node == null) {
            return OverlapDirection.none;
        }
        return this.getOverlapDirection(this.node.getPlacementX(), this.node.getPlacementY(), this.node.getWidth(), this.node.getHeight());
    }

    public synchronized OverlapDirection getOverlapDirection(double xPos, double yPos, double x2, double y) {
        OverlapDirection result2 = OverlapDirection.none;
        double minX = xPos - x2 / 2.0;
        double maxX = xPos + x2 / 2.0;
        double minY = yPos - y / 2.0;
        double maxY = yPos + y / 2.0;
        if (this.fieldBoarding.cellMinX > minX) {
            result2 = OverlapDirection.west;
        } else if (this.fieldBoarding.cellMaxX < maxX) {
            result2 = OverlapDirection.east;
        }
        if (this.fieldBoarding.cellMinY > minY) {
            result2 = OverlapDirection.mixDirections(result2, OverlapDirection.south);
        } else if (this.fieldBoarding.cellMaxY < maxY) {
            result2 = OverlapDirection.mixDirections(result2, OverlapDirection.north);
        }
        return result2;
    }

    public synchronized double getOverlappingFractionInX() {
        double result2 = this.node != null ? this.getOverlappingFractionInX(this.node.getPlacementX(), this.node.getPlacementY(), this.node.getWidth(), this.node.getHeight()) : 0.0;
        return result2;
    }

    public synchronized double getOverlappingFractionInX(double xPos, double yPos, double x2, double y) {
        double minX = xPos - x2 / 2.0;
        double maxX = xPos + x2 / 2.0;
        double overlapping = 0.0;
        if (this.fieldBoarding.cellMinX > minX) {
            overlapping = this.fieldBoarding.cellMinX - minX;
        } else if (this.fieldBoarding.cellMaxX < maxX) {
            overlapping = this.fieldBoarding.cellMaxX - maxX;
        }
        return Math.abs(overlapping / x2);
    }

    public double getOverlappingFractionInY() {
        if (this.node == null) {
            return 0.0;
        }
        return this.getOverlappingFractionInY(this.node.getPlacementX(), this.node.getPlacementY(), this.node.getWidth(), this.node.getHeight());
    }

    public synchronized double getOverlappingFractionInY(double xPos, double yPos, double x2, double y) {
        double minY = yPos - y / 2.0;
        double maxY = yPos + y / 2.0;
        double overlapping = 0.0;
        if (this.fieldBoarding.cellMinY > minY) {
            overlapping = this.fieldBoarding.cellMinY - minY;
        } else if (this.fieldBoarding.cellMaxY < maxY) {
            overlapping = this.fieldBoarding.cellMaxY - maxY;
        }
        return Math.abs(overlapping / y);
    }

    public boolean isOverlapping(double xPos, double yPos, double x2, double y) {
        return this.getOverlapDirection(xPos, yPos, x2, y) != OverlapDirection.none;
    }

    public boolean isOverlappingBiggerThreshold(double threshold) {
        double x2 = this.getOverlappingFractionInX();
        double y = this.getOverlappingFractionInY();
        return x2 > threshold || y > threshold;
    }

    public synchronized void placeCentralized(PlacementFrame.PlacementNode node) {
        if (node != null) {
            AdditionalNodeData data2 = PlacementForceDirectedStaged.getNodeData().get(node);
            node.setPlacement(this.location.getX(), this.location.getY());
            PlacementForceDirectedStaged.getNodeData().put(node, data2);
        }
        this.node = node;
    }

    public void setCellId(int cellId) {
        this.cellId = cellId;
    }

    public void setCellX(double cellX) {
        this.cellX = cellX;
        this.calculateFieldBoarding();
    }

    public void setCellY(double cellY) {
        this.cellY = cellY;
        this.calculateFieldBoarding();
    }

    public void setCoordX(int coordX) {
        this.coordX = coordX;
    }

    public void setCoordY(int coordY) {
        this.coordY = coordY;
    }

    public void setCounter(AtomicInteger counter) {
        this.counter = counter;
    }

    public void setLocation(Point2D location) {
        this.location = location;
        this.calculateFieldBoarding();
    }

    public void setNode(PlacementFrame.PlacementNode node) {
        this.node = node;
    }

    public void setNotMovedCounter(int notMovedCounter) {
        this.notMovedCounter = notMovedCounter;
    }

    private class FieldBoardingDTO {
        double cellMinX;
        double cellMinY;
        double cellMaxX;
        double cellMaxY;

        private FieldBoardingDTO() {
        }
    }
}

