/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitiveNodeGroup;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.XMLRules;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.tecEdit.ArcInfo;
import com.sun.electric.tool.user.tecEdit.GeneralInfo;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.tecEdit.NodeInfo;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class TechToLib {
    public static void makeLibFromTech() {
        ArrayList<Technology> techs = new ArrayList<Technology>();
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            if (tech.isNonStandard()) continue;
            techs.add(tech);
        }
        Object[] techChoices = new String[techs.size()];
        for (int i = 0; i < techs.size(); ++i) {
            techChoices[i] = ((Technology)techs.get(i)).getTechName();
        }
        String chosen = (String)JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Technology to Edit", "Choose a technology to edit", 3, null, techChoices, Technology.getCurrent().getTechName());
        if (chosen == null) {
            return;
        }
        Technology tech = Technology.findTechnology(chosen);
        Library already = Library.findLibrary(tech.getTechName());
        if (already != null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "There is already a library called '" + tech.getTechName() + "'.  Delete it first.", "Cannot Convert Technology", 0);
            System.out.println();
            return;
        }
        new LibFromTechJob(tech, false);
    }

    public static Library makeLibFromTech(Technology tech, GraphicsPreferences gp) {
        Library lib = Library.newInstance(tech.getTechName(), null);
        if (lib == null) {
            System.out.println("Cannot create library " + tech.getTechName());
            return null;
        }
        System.out.println("Created library " + tech.getTechName() + "...");
        Cell fNp = Cell.newInstance(lib, "factors");
        if (fNp == null) {
            return null;
        }
        fNp.setInTechnologyLibrary();
        int layerTotal = 0;
        Iterator<Layer> it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            if (layer.isPseudoLayer()) continue;
            ++layerTotal;
        }
        GeneralInfo gi = new GeneralInfo();
        gi.shortName = tech.getTechShortName();
        if (gi.shortName == null) {
            gi.shortName = tech.getTechName();
        }
        gi.nonElectrical = tech.isNonElectrical();
        gi.scale = tech.getScale();
        gi.scaleRelevant = tech.isScaleRelevant();
        gi.resolution = tech.getFactoryResolution();
        gi.defaultFoundry = tech.getPrefFoundry();
        gi.defaultNumMetals = tech.getNumMetals();
        gi.description = tech.getTechDesc();
        gi.minRes = tech.getMinResistanceSetting().getDoubleFactoryValue();
        gi.minCap = tech.getMinCapacitanceSetting().getDoubleFactoryValue();
        gi.maxSeriesResistance = tech.getMaxSeriesResistance();
        gi.gateShrinkage = tech.getGateLengthSubtraction();
        gi.includeGateInResistance = tech.isGateIncluded();
        gi.includeGround = tech.isGroundNetIncluded();
        gi.gateCapacitance = tech.getGateCapacitanceSetting().getDoubleFactoryValue();
        gi.wireRatio = tech.getWireRatioSetting().getDoubleFactoryValue();
        gi.diffAlpha = tech.getDiffAlphaSetting().getDoubleFactoryValue();
        Color[] wholeMap = gp.getColorMap(tech);
        int numLayers = gp.getNumTransparentLayers(tech);
        gi.transparentColors = new Color[numLayers];
        for (int i = 0; i < numLayers; ++i) {
            gi.transparentColors[i] = wholeMap[1 << i];
        }
        gi.spiceLevel1Header = tech.getSpiceHeaderLevel1();
        gi.spiceLevel2Header = tech.getSpiceHeaderLevel2();
        gi.spiceLevel3Header = tech.getSpiceHeaderLevel3();
        XMLRules drcRules = tech.getFactoryDesignRules();
        if (drcRules != null) {
            int rulesSize = layerTotal * (layerTotal + 1) / 2;
            gi.conDist = new double[rulesSize];
            gi.unConDist = new double[rulesSize];
            Arrays.fill(gi.conDist, -1.0);
            Arrays.fill(gi.unConDist, -1.0);
            int ruleIndex = 0;
            for (int i1 = 0; i1 < layerTotal; ++i1) {
                for (int i2 = i1; i2 < layerTotal; ++i2) {
                    for (DRCTemplate t : drcRules.getSpacingRules(drcRules.getRuleIndex(i1, i2), DRCTemplate.DRCRuleType.SPACING, false)) {
                        if (t.ruleType == DRCTemplate.DRCRuleType.CONSPA) {
                            gi.conDist[ruleIndex] = t.getValue(0);
                            continue;
                        }
                        if (t.ruleType != DRCTemplate.DRCRuleType.UCONSPA) continue;
                        gi.unConDist[ruleIndex] = t.getValue(0);
                    }
                    ++ruleIndex;
                }
            }
        }
        gi.generate(fNp);
        HashMap<Layer, Cell> layerCells = new HashMap<Layer, Cell>();
        System.out.println("Creating the layers...");
        ArrayList<String> layerSequence = new ArrayList<String>();
        LayerInfo[] lList = new LayerInfo[layerTotal];
        Map<Layer, String> gdsLayers = tech.getGDSLayers();
        int layIndex = 0;
        Iterator<Layer> it2 = tech.getLayers();
        block5: while (it2.hasNext()) {
            Cell lNp;
            Layer layer = it2.next();
            if (layer.isPseudoLayer()) continue;
            EGraphics desc = gp.getGraphics(layer);
            String fName = "layer-" + layer.getName() + "{lay}";
            if (lib.findNodeProto(fName) != null) {
                System.out.println("Warning: already a cell '" + fName + "'.  Creating a new version");
            }
            if ((lNp = Cell.newInstance(lib, fName)) == null) {
                return null;
            }
            lNp.setTechnology(Artwork.tech());
            lNp.setInTechnologyLibrary();
            layerCells.put(layer, lNp);
            LayerInfo li = new LayerInfo();
            lList[layIndex++] = li;
            li.name = layer.getName();
            li.fun = layer.getFunction();
            li.funExtra = layer.getFunctionExtras();
            li.pseudo = layer.isPseudoLayer();
            li.desc = desc;
            if (li.pseudo) {
                String masterName = layer.getNonPseudoLayer().getName();
                for (int j = 0; j < layIndex; ++j) {
                    if (!lList[j].name.equals(masterName)) continue;
                    lList[j].myPseudo = li;
                    continue block5;
                }
                continue;
            }
            li.cif = (String)layer.getCIFLayerSetting().getFactoryValue();
            li.dxf = (String)layer.getDXFLayerSetting().getFactoryValue();
            li.skill = (String)layer.getSkillLayerSetting().getFactoryValue();
            String gdsLayer = gdsLayers.get(layer);
            if (gdsLayer != null) {
                li.gds = gdsLayer;
            }
            li.spiRes = layer.getResistanceSetting().getDoubleFactoryValue();
            li.spiCap = layer.getCapacitanceSetting().getDoubleFactoryValue();
            li.spiECap = layer.getEdgeCapacitanceSetting().getDoubleFactoryValue();
            li.height3d = layer.getDistance();
            li.thick3d = layer.getThickness();
            li.generate(lNp);
            layerSequence.add(lNp.getName().substring(6));
        }
        if (layIndex != layerTotal) {
            System.out.println("INTERNAL ERROR: ");
        }
        String[] layerSequenceArray = layerSequence.toArray(new String[layerSequence.size()]);
        lib.newVar(Info.LAYERSEQUENCE_KEY, (Object)layerSequenceArray);
        System.out.println("Creating the arcs...");
        int arcTotal = 0;
        Iterator<ArcProto> it3 = tech.getArcs();
        while (it3.hasNext()) {
            if (it3.next().isNotUsed()) continue;
            ++arcTotal;
        }
        ArcInfo[] aList = new ArcInfo[arcTotal];
        String[] arcSequence = new String[arcTotal];
        int arcCount = 0;
        HashMap<ArcProto, Cell> arcCells = new HashMap<ArcProto, Cell>();
        Iterator<ArcProto> it4 = tech.getArcs();
        while (it4.hasNext()) {
            Cell aNp;
            ArcInfo aIn;
            ArcProto ap = it4.next();
            if (ap.isNotUsed()) continue;
            aList[arcCount] = aIn = TechToLib.makeArcInfo(ap, lList);
            arcSequence[arcCount] = ap.getName();
            ++arcCount;
            String fName = "arc-" + ap.getName() + "{lay}";
            if (lib.findNodeProto(fName) != null) {
                System.out.println("Warning: already a cell '" + fName + "'.  Creating a new version");
            }
            if ((aNp = Cell.makeInstance(lib, fName)) == null) {
                return null;
            }
            aNp.setTechnology(Artwork.tech());
            aNp.setInTechnologyLibrary();
            arcCells.put(ap, aNp);
            aIn.generate(aNp);
            double wid = ap.getDefaultLambdaBaseWidth();
            double widX4 = wid * 4.0;
            if (widX4 <= 0.0) {
                widX4 = 10.0;
            }
            Poly[] polys = ap.getShapeOfDummyArc(widX4);
            double xOff = wid * 2.0 + DBMath.gridToLambda(ap.getMaxLayerGridExtend());
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                Layer arcLayer = poly.getLayer().getNonPseudoLayer();
                if (arcLayer == null) continue;
                EGraphics arcDesc = gp.getGraphics(arcLayer);
                Point2D[] points = poly.getPoints();
                for (int k = 0; k < points.length; ++k) {
                    poly.setPoint(k, points[k].getX() - xOff - 20.0, points[k].getY() - 5.0);
                }
                List<NodeInst> placedNodes = TechToLib.placeGeometry(poly, aNp);
                if (placedNodes == null) continue;
                for (NodeInst ni : placedNodes) {
                    Manipulate.setPatch(ni, arcDesc);
                    Cell layerCell = (Cell)layerCells.get(arcLayer);
                    if (layerCell != null) {
                        ni.newVar(Info.LAYER_KEY, (Object)layerCell.getId());
                    }
                    ni.newVar(Info.OPTION_KEY, (Object)new Integer(8));
                }
            }
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().boxNode, new Point2D.Double(-20.0 - xOff, -5.0), wid * 5.0, wid, aNp);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_COLOR, (Object)new Integer(2));
            ni.newVar(Info.OPTION_KEY, (Object)new Integer(19));
            ArcInfo.compactCell(aNp);
        }
        lib.newVar(Info.ARCSEQUENCE_KEY, (Object)arcSequence);
        System.out.println("Creating the nodes...");
        ArrayList<String> nodeSequence = new ArrayList<String>();
        ArrayList<NodeInfo> nList = new ArrayList<NodeInfo>();
        Cell dummyCell = Cell.newInstance(lib, "dummyCell{lay}");
        ArrayList<PrimitiveNode> nodesToWrite = new ArrayList<PrimitiveNode>();
        Iterator<PrimitiveNode> it5 = tech.getNodes();
        while (it5.hasNext()) {
            PrimitiveNode pnp = it5.next();
            if (pnp.isNotUsed()) continue;
            if (pnp.getPrimitiveNodeGroup() == null) {
                nodesToWrite.add(pnp);
                continue;
            }
            if (pnp.getPrimitiveNodeGroup().getNodes().get(0) != pnp) continue;
            NodeInst ni = NodeInst.makeDummyInstance(pnp);
            Poly[] polys = tech.getShapeOfNode(ni);
            HashSet<Layer> inPolys = new HashSet<Layer>();
            for (int i = 0; i < polys.length; ++i) {
                inPolys.add(polys[i].getLayer());
            }
            boolean differentLayers = false;
            for (PrimitiveNode alt : pnp.getPrimitiveNodeGroup().getNodes()) {
                if (alt == pnp) continue;
                NodeInst altNi = NodeInst.makeDummyInstance(alt);
                Poly[] altPolys = tech.getShapeOfNode(altNi);
                HashSet<Layer> inAltPolys = new HashSet<Layer>();
                for (int i = 0; i < altPolys.length; ++i) {
                    inAltPolys.add(altPolys[i].getLayer());
                }
                for (Layer l : inPolys) {
                    if (inAltPolys.contains(l)) {
                        inAltPolys.remove(l);
                        continue;
                    }
                    differentLayers = true;
                    break;
                }
                if (inAltPolys.size() > 0) {
                    differentLayers = true;
                }
                if (!differentLayers) continue;
                break;
            }
            if (differentLayers) {
                for (PrimitiveNode alt : pnp.getPrimitiveNodeGroup().getNodes()) {
                    nodesToWrite.add(alt);
                }
            } else {
                nodesToWrite.add(pnp);
            }
            if (pnp.getPrimitiveNodeGroup().getNodes().get(0) == pnp) continue;
        }
        for (PrimitiveNode pnp : nodesToWrite) {
            int j;
            Poly[] polys;
            NodeInst oNi;
            NodeInfo nIn = TechToLib.makeNodeInfo(pnp, lList, aList);
            nList.add(nIn);
            nodeSequence.add(pnp.getName());
            boolean first = true;
            double xS = pnp.getDefWidth() * 2.0;
            double yS = pnp.getDefHeight() * 2.0;
            if (xS < 3.0) {
                xS = 3.0;
            }
            if (yS < 3.0) {
                yS = 3.0;
            }
            double nodeXPos = -xS * 2.0;
            Point2D[] pos = new Point2D[]{new Point2D.Double(nodeXPos - xS, -5.0 + yS), new Point2D.Double(nodeXPos + xS, -5.0 + yS), new Point2D.Double(nodeXPos - xS, -5.0 - yS), new Point2D.Double(nodeXPos + xS, -5.0 - yS)};
            SizeOffset so = pnp.getProtoSizeOffset();
            xS = pnp.getDefWidth() - so.getLowXOffset() - so.getHighXOffset();
            yS = pnp.getDefHeight() - so.getLowYOffset() - so.getHighYOffset();
            double[] xsc = new double[4];
            double[] ysc = new double[4];
            xsc[0] = xS * 1.0;
            ysc[0] = yS * 1.0;
            xsc[1] = xS * 2.0;
            ysc[1] = yS * 1.0;
            xsc[2] = xS * 1.0;
            ysc[2] = yS * 2.0;
            xsc[3] = xS * 2.0;
            ysc[3] = yS * 2.0;
            if (pnp.isMulticut()) {
                EPoint min2size = pnp.getMulticut2Size();
                double min2X = min2size.getLambdaX();
                double min2Y = min2size.getLambdaY();
                xsc[1] = min2X;
                xsc[3] = min2X;
                ysc[2] = min2Y;
                ysc[3] = min2Y;
            }
            Cell nNp = null;
            Rectangle2D mainBounds = null;
            for (int e = 0; e < 4; ++e) {
                if (e != 0 && first || pnp.isSquare() && (e == 1 || e == 2)) continue;
                double newXSize = xsc[e] + so.getLowXOffset() + so.getHighXOffset();
                double newYSize = ysc[e] + so.getLowYOffset() + so.getHighYOffset();
                oNi = NodeInst.makeInstance(pnp, EPoint.snap(pos[e]), newXSize, newYSize, dummyCell);
                polys = tech.getShapeOfNode(oNi);
                j = polys.length;
                for (int i = 0; i < j; ++i) {
                    List<NodeInst> placedNodes;
                    Poly poly = polys[i];
                    Layer nodeLayer = poly.getLayer().getNonPseudoLayer();
                    if (nodeLayer == null) continue;
                    EGraphics desc = gp.getGraphics(nodeLayer);
                    if (e == 0) {
                        Rectangle2D polyBounds = poly.getBounds2D();
                        if (i == 0) {
                            mainBounds = polyBounds;
                        } else {
                            Rectangle2D.union(mainBounds, polyBounds, mainBounds);
                        }
                    }
                    if (first) {
                        first = false;
                        String fName = "node-" + pnp.getName() + "{lay}";
                        if (lib.findNodeProto(fName) != null) {
                            System.out.println("Warning: already a cell '" + fName + "'.  Creating a new version");
                        }
                        if ((nNp = Cell.newInstance(lib, fName)) == null) {
                            return null;
                        }
                        nNp.setTechnology(Artwork.tech());
                        nNp.setInTechnologyLibrary();
                        nIn.generate(nNp);
                    }
                    if ((placedNodes = TechToLib.placeGeometry(poly, nNp)) == null) {
                        System.out.println("Error placing geometry " + (Object)((Object)poly.getStyle()) + " on " + nNp);
                        continue;
                    }
                    for (NodeInst ni : placedNodes) {
                        Manipulate.setPatch(ni, desc);
                        Cell layerCell = (Cell)layerCells.get(nodeLayer);
                        if (layerCell != null) {
                            ni.newVar(Info.LAYER_KEY, (Object)layerCell.getId());
                        }
                        ni.newVar(Info.OPTION_KEY, (Object)new Integer(8));
                    }
                }
                if (first) continue;
                xS = pnp.getDefWidth() - so.getLowXOffset() - so.getHighXOffset();
                yS = pnp.getDefHeight() - so.getLowYOffset() - so.getHighYOffset();
                Point2D.Double loc = new Point2D.Double(pos[e].getX() + (so.getLowXOffset() - so.getHighXOffset()) / 2.0, pos[e].getY() + (so.getLowYOffset() - so.getHighYOffset()) / 2.0);
                NodeInst ni = NodeInst.makeInstance(Artwork.tech().boxNode, loc, xsc[e], ysc[e], nNp);
                if (ni == null) {
                    return null;
                }
                ni.newVar(Artwork.ART_COLOR, (Object)new Integer(EGraphics.makeIndex(Color.WHITE)));
                ni.newVar(Info.OPTION_KEY, (Object)new Integer(19));
                if (TechToLib.addPortsToPrimitive(pnp, oNi, tech, arcCells, aList, nNp)) {
                    return null;
                }
                oNi.kill();
            }
            PrimitiveNodeGroup primitiveNodeGroup = pnp.getPrimitiveNodeGroup();
            if (primitiveNodeGroup != null) {
                int yOffset = 0;
                for (int k = 1; k < primitiveNodeGroup.getNodes().size(); ++k) {
                    Point2D.Double loc;
                    NodeInst ni;
                    PrimitiveNode altPNp = pnp.getPrimitiveNodeGroup().getNodes().get(k);
                    if (nodesToWrite.contains(altPNp)) continue;
                    xS = altPNp.getDefWidth() * 2.0;
                    yS = altPNp.getDefHeight() * 2.0;
                    Point2D.Double nPos = new Point2D.Double(nodeXPos + xS * 5.0, -5.0 - yS * (double)(++yOffset * 2 - 3));
                    xS = altPNp.getDefWidth();
                    yS = altPNp.getDefHeight();
                    oNi = NodeInst.makeInstance(altPNp, EPoint.snap(nPos), xS, yS, dummyCell);
                    polys = tech.getShapeOfNode(oNi);
                    j = polys.length;
                    NodeInst centerNI = null;
                    for (int i = 0; i < j; ++i) {
                        Poly poly = polys[i];
                        Layer nodeLayer = poly.getLayer().getNonPseudoLayer();
                        if (nodeLayer == null) continue;
                        EGraphics desc = gp.getGraphics(nodeLayer);
                        List<NodeInst> placedNodes = TechToLib.placeGeometry(poly, nNp);
                        if (placedNodes == null) {
                            System.out.println("Error placing geometry " + (Object)((Object)poly.getStyle()) + " on " + nNp);
                            continue;
                        }
                        for (NodeInst ni2 : placedNodes) {
                            if (nodeLayer.getFunction().isContact()) {
                                centerNI = ni2;
                            }
                            if (centerNI == null && ni2.getAnchorCenterX() == ((Point2D)nPos).getX() && ni2.getAnchorCenterY() == ((Point2D)nPos).getY()) {
                                centerNI = ni2;
                            }
                            Manipulate.setPatch(ni2, desc);
                            Cell layerCell = (Cell)layerCells.get(nodeLayer);
                            if (layerCell != null) {
                                ni2.newVar(Info.LAYER_KEY, (Object)layerCell.getId());
                            }
                            ni2.newVar(Info.OPTION_KEY, (Object)new Integer(8));
                        }
                    }
                    if (centerNI != null) {
                        centerNI.setName(altPNp.getName());
                        TextDescriptor td = centerNI.getTextDescriptor(NodeInst.NODE_NAME).withOff(0.0, -altPNp.getFactoryDefaultLambdaBaseHeight() * 1.5);
                        centerNI.setTextDescriptor(NodeInst.NODE_NAME, td);
                    }
                    if ((ni = NodeInst.makeInstance(Artwork.tech().boxNode, loc = new Point2D.Double(((Point2D)nPos).getX() + (so.getLowXOffset() - so.getHighXOffset()) / 2.0, ((Point2D)nPos).getY() + (so.getLowYOffset() - so.getHighYOffset()) / 2.0), xS = altPNp.getDefWidth() - so.getLowXOffset() - so.getHighXOffset(), yS = altPNp.getDefHeight() - so.getLowYOffset() - so.getHighYOffset(), nNp)) == null) {
                        return null;
                    }
                    ni.newVar(Artwork.ART_COLOR, (Object)new Integer(EGraphics.makeIndex(Color.WHITE)));
                    ni.newVar(Info.OPTION_KEY, (Object)new Integer(19));
                    if (TechToLib.addPortsToPrimitive(pnp, oNi, tech, arcCells, aList, nNp)) {
                        return null;
                    }
                    oNi.kill();
                }
            }
            NodeInfo.compactCell(nNp);
        }
        dummyCell.kill();
        String[] nodeSequenceArray = new String[nodeSequence.size()];
        for (int i = 0; i < nodeSequence.size(); ++i) {
            nodeSequenceArray[i] = (String)nodeSequence.get(i);
        }
        lib.newVar(Info.NODESEQUENCE_KEY, (Object)nodeSequenceArray);
        gi.menuPalette = tech.getFactoryMenuPalette();
        System.out.println("Done.");
        return lib;
    }

    private static boolean addPortsToPrimitive(PrimitiveNode pnp, NodeInst oNi, Technology tech, Map<ArcProto, Cell> arcCells, ArcInfo[] aList, Cell nNp) {
        HashMap<PrimitivePort, NodeInst> portNodes = new HashMap<PrimitivePort, NodeInst>();
        Iterator<PortProto> pIt = pnp.getPorts();
        block0: while (pIt.hasNext()) {
            PrimitivePort opp;
            PrimitivePort pp = (PrimitivePort)pIt.next();
            Poly poly = tech.getShapeOfPort(oNi, pp);
            SizeOffset pSo = Generic.tech().portNode.getProtoSizeOffset();
            double width = poly.getBounds2D().getWidth() + pSo.getLowXOffset() + pSo.getHighXOffset();
            double height = poly.getBounds2D().getHeight() + pSo.getLowYOffset() + pSo.getHighYOffset();
            NodeInst pNi = NodeInst.makeInstance(Generic.tech().portNode, new Point2D.Double(poly.getCenterX(), poly.getCenterY()), width, height, nNp);
            if (pNi == null) {
                return true;
            }
            portNodes.put(pp, pNi);
            pNi.newVar(Info.OPTION_KEY, (Object)new Integer(8));
            pNi.newDisplayVar(Info.PORTNAME_KEY, pp.getName());
            if (pp.getAngle() != 0 || pp.getAngleRange() != 180) {
                pNi.newVar(Info.PORTANGLE_KEY, (Object)new Integer(pp.getAngle()));
                pNi.newVar(Info.PORTRANGE_KEY, (Object)new Integer(pp.getAngleRange()));
            }
            ArcProto[] connects = pp.getConnections();
            ArrayList<Cell> validConns = new ArrayList<Cell>();
            for (int i = 0; i < connects.length; ++i) {
                Cell cell;
                if (connects[i].getTechnology() != tech || (cell = arcCells.get(connects[i])) == null) continue;
                validConns.add(cell);
            }
            int meaning = 0;
            if (validConns.size() > 0) {
                CellId[] aplist = new CellId[validConns.size()];
                block2: for (int i = 0; i < validConns.size(); ++i) {
                    Cell cell = (Cell)validConns.get(i);
                    aplist[i] = cell.getId();
                    String arcName = cell.getName().substring(4);
                    for (int l = 0; l < aList.length; ++l) {
                        if (!aList[l].name.equals(arcName)) continue;
                        if (aList[l].func.isDiffusion()) {
                            meaning = 2;
                            continue block2;
                        }
                        if (!aList[l].func.isPoly()) continue block2;
                        meaning = 1;
                        continue block2;
                    }
                }
                pNi.newVar(Info.CONNECTION_KEY, (Object)aplist);
            }
            if (pnp.getFunction().isTransistor()) {
                pNi.newVar(Info.PORTMEANING_KEY, (Object)new Integer(meaning));
            }
            Iterator<PortProto> oPIt = pnp.getPorts();
            while (oPIt.hasNext() && (opp = (PrimitivePort)oPIt.next()) != pp) {
                NodeInst nni;
                if (opp.getTopology() != pp.getTopology() || (nni = (NodeInst)portNodes.get(opp)) == null) continue;
                PortInst head2 = nni.getOnlyPortInst();
                PortInst tail = pNi.getOnlyPortInst();
                ArcInst.newInstanceBase(Generic.tech().universal_arc, 0.0, head2, tail);
                continue block0;
            }
        }
        return false;
    }

    private static ArcInfo makeArcInfo(ArcProto ap, LayerInfo[] lList) {
        ArcInfo aIn = new ArcInfo();
        ImmutableArcInst defA = ap.getFactoryDefaultInst();
        aIn.name = ap.getName();
        aIn.func = ap.getFunction();
        aIn.widthOffset = ap.getLambdaElibWidthOffset();
        aIn.fixAng = defA.isFixedAngle();
        aIn.wipes = ap.isWipable();
        aIn.noExtend = !defA.isTailExtended();
        aIn.curvable = ap.isCurvable();
        aIn.special = ap.isSpecialArc();
        aIn.notUsed = ap.isNotUsed();
        aIn.skipSizeInPalette = ap.isSkipSizeInPalette();
        aIn.slidable = defA.isSlidable();
        aIn.angInc = ap.getFactoryAngleIncrement();
        aIn.antennaRatio = ap.getFactoryAntennaRatio();
        aIn.arcDetails = new ArcInfo.LayerDetails[ap.getNumArcLayers()];
        for (int i = 0; i < aIn.arcDetails.length; ++i) {
            ArcInfo.LayerDetails ald;
            aIn.arcDetails[i] = ald = new ArcInfo.LayerDetails();
            String layerName = ap.getLayer(i).getName();
            for (int j = 0; j < lList.length; ++j) {
                if (!lList[j].name.equals(layerName)) continue;
                ald.layer = lList[j];
                break;
            }
            ald.style = ap.getLayerStyle(i);
            ald.width = ap.getLayerGridExtend(i);
        }
        return aIn;
    }

    private static NodeInfo makeNodeInfo(PrimitiveNode pnp, LayerInfo[] lList, ArcInfo[] aList) {
        Technology tech = pnp.getTechnology();
        NodeInfo nIn = new NodeInfo();
        nIn.name = pnp.getName();
        nIn.func = pnp.getFunction();
        nIn.serp = false;
        if (nIn.func.isFET() && pnp.isHoldsOutline()) {
            nIn.serp = true;
        }
        nIn.arcsShrink = pnp.isArcsShrink();
        assert (pnp.isArcsWipe() == nIn.arcsShrink);
        nIn.square = pnp.isSquare();
        assert (pnp.isHoldsOutline() == (pnp.getSpecialType() == 2 || pnp.getSpecialType() == 1));
        nIn.canBeZeroSize = pnp.isCanBeZeroSize();
        nIn.wipes = pnp.isWipeOn1or2();
        nIn.lockable = pnp.isLockedPrim();
        nIn.edgeSelect = pnp.isEdgeSelect();
        nIn.skipSizeInPalette = pnp.isSkipSizeInPalette();
        nIn.notUsed = pnp.isNotUsed();
        nIn.lowVt = pnp.isNodeBitOn(8);
        nIn.highVt = pnp.isNodeBitOn(16);
        nIn.nativeBit = pnp.isNodeBitOn(32);
        nIn.od18 = pnp.isNodeBitOn(64);
        nIn.od25 = pnp.isNodeBitOn(128);
        nIn.od33 = pnp.isNodeBitOn(256);
        nIn.xSize = pnp.getDefWidth();
        nIn.ySize = pnp.getDefHeight();
        nIn.so = pnp.getProtoSizeOffset();
        if (nIn != null && nIn.so.getLowXOffset() == 0.0 && nIn.so.getHighXOffset() == 0.0 && nIn.so.getLowYOffset() == 0.0 && nIn.so.getHighYOffset() == 0.0) {
            nIn.so = null;
        }
        nIn.nodeSizeRule = pnp.getMinSizeRule();
        nIn.autoGrowth = pnp.getAutoGrowth();
        nIn.specialType = pnp.getSpecialType();
        nIn.specialValues = pnp.getSpecialValues();
        nIn.spiceTemplate = pnp.getSpiceTemplate();
        ArrayList<Technology.NodeLayer> nodeLayers = new ArrayList<Technology.NodeLayer>();
        for (Technology.NodeLayer nld : pnp.getNodeLayers()) {
            nodeLayers.add(nld);
        }
        ArrayList<Technology.NodeLayer> electricalNodeLayers = nodeLayers;
        if (pnp.getElectricalLayers() != null) {
            electricalNodeLayers = new ArrayList();
            for (Technology.NodeLayer nld : pnp.getElectricalLayers()) {
                electricalNodeLayers.add(nld);
            }
        }
        ArrayList<NodeInfo.LayerDetails> layerDetails = new ArrayList<NodeInfo.LayerDetails>();
        EPoint correction = EPoint.fromGrid(pnp.getFullRectangle().getGridWidth(), pnp.getFullRectangle().getGridHeight());
        int m = 0;
        for (Technology.NodeLayer nld : electricalNodeLayers) {
            int j = nodeLayers.indexOf(nld);
            if (j < 0) {
                layerDetails.add(TechToLib.makeNodeLayerDetails(nld, lList, correction, false, true));
                continue;
            }
            while (m < j) {
                layerDetails.add(TechToLib.makeNodeLayerDetails((Technology.NodeLayer)nodeLayers.get(m++), lList, correction, true, false));
            }
            layerDetails.add(TechToLib.makeNodeLayerDetails((Technology.NodeLayer)nodeLayers.get(m++), lList, correction, true, true));
        }
        while (m < nodeLayers.size()) {
            layerDetails.add(TechToLib.makeNodeLayerDetails((Technology.NodeLayer)nodeLayers.get(m++), lList, correction, true, false));
        }
        nIn.nodeLayers = layerDetails.toArray(new NodeInfo.LayerDetails[layerDetails.size()]);
        nIn.nodePortDetails = new NodeInfo.PortDetails[pnp.getNumPorts()];
        for (int i = 0; i < nIn.nodePortDetails.length; ++i) {
            NodeInfo.PortDetails pd;
            PrimitivePort pp = pnp.getPort(i);
            nIn.nodePortDetails[i] = pd = new NodeInfo.PortDetails();
            pd.name = pp.getName();
            pd.netIndex = pp.getTopology();
            pd.angle = pp.getAngle();
            pd.range = pp.getAngleRange();
            EdgeH left = new EdgeH(pp.getLeft().getMultiplier(), pp.getLeft().getAdder() - pp.getLeft().getMultiplier() * nIn.xSize);
            EdgeH right = new EdgeH(pp.getRight().getMultiplier(), pp.getRight().getAdder() - pp.getRight().getMultiplier() * nIn.xSize);
            EdgeV bottom = new EdgeV(pp.getBottom().getMultiplier(), pp.getBottom().getAdder() - pp.getBottom().getMultiplier() * nIn.ySize);
            EdgeV top = new EdgeV(pp.getTop().getMultiplier(), pp.getTop().getAdder() - pp.getTop().getMultiplier() * nIn.ySize);
            pd.values = new Technology.TechPoint[]{new Technology.TechPoint(left, bottom), new Technology.TechPoint(right, top)};
            pd.characterisitic = pp.getCharacteristic();
            pd.isolated = pp.isIsolated();
            pd.negatable = pp.isNegatable();
            ArcProto[] connects = pp.getConnections();
            ArrayList<ArcInfo> validArcInfoConns = new ArrayList<ArcInfo>();
            block6: for (int j = 0; j < connects.length; ++j) {
                ArcProto ap = connects[j];
                if (ap.getTechnology() != tech) continue;
                for (int k = 0; k < aList.length; ++k) {
                    if (!aList[k].name.equals(ap.getName())) continue;
                    validArcInfoConns.add(aList[k]);
                    continue block6;
                }
            }
            pd.connections = validArcInfoConns.toArray(new ArcInfo[validArcInfoConns.size()]);
        }
        if (nIn.func == PrimitiveNode.Function.NODE) {
            assert (nIn.nodeLayers.length == 1);
            LayerInfo l = nIn.nodeLayers[0].layer;
            if (l.pureLayerNode != null) {
                System.out.println("Warning: technology has two pure-layer nodes for layer " + l.name + ": " + l.pureLayerNode.name + " and " + nIn.name);
            }
            l.pureLayerNode = nIn;
        }
        return nIn;
    }

    private static NodeInfo.LayerDetails makeNodeLayerDetails(Technology.NodeLayer nl, LayerInfo[] lList, EPoint correction, boolean inLayers, boolean inElectricalLayers) {
        int k;
        NodeInfo.LayerDetails nld = new NodeInfo.LayerDetails();
        nld.inLayers = inLayers;
        nld.inElectricalLayers = inElectricalLayers;
        nld.style = nl.getStyle();
        nld.portIndex = nl.getPortNum();
        nld.representation = nl.getRepresentation();
        nld.values = (Technology.TechPoint[])nl.getPoints().clone();
        for (k = 0; k < nld.values.length; ++k) {
            Technology.TechPoint p = nld.values[k];
            EdgeH x2 = p.getX();
            x2 = x2.withAdder(x2.getAdder() - x2.getMultiplier() * correction.getLambdaX());
            EdgeV y = p.getY();
            y = y.withAdder(y.getAdder() - y.getMultiplier() * correction.getLambdaY());
            nld.values[k] = p.withX(x2).withY(y);
        }
        for (k = 0; k < lList.length; ++k) {
            if (!nl.getLayer().getNonPseudoLayer().getName().equals(lList[k].name)) continue;
            nld.layer = lList[k];
            break;
        }
        nld.multiCut = nld.representation == 3;
        nld.multiXS = nl.getMulticutSizeX();
        nld.multiYS = nl.getMulticutSizeY();
        nld.multiSep = nl.getMulticutSep1D();
        nld.multiSep2D = nl.getMulticutSep2D();
        return nld;
    }

    private static List<NodeInst> placeGeometry(Poly poly, Cell cell) {
        ArrayList<NodeInst> placedNodes = new ArrayList<NodeInst>();
        Rectangle2D box = poly.getBox();
        Rectangle2D bounds = poly.getBounds2D();
        Poly.Type style = poly.getStyle();
        if (style == Poly.Type.FILLED) {
            if (box != null) {
                NodeInst ni = NodeInst.makeInstance(Artwork.tech().filledBoxNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
                if (ni == null) {
                    return null;
                }
                placedNodes.add(ni);
            } else {
                NodeInst ni = NodeInst.makeInstance(Artwork.tech().filledPolygonNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
                if (ni == null) {
                    return null;
                }
                ni.setTrace(poly.getPoints());
                placedNodes.add(ni);
            }
            return placedNodes;
        }
        if (style == Poly.Type.CLOSED) {
            if (box != null) {
                NodeInst ni = NodeInst.makeInstance(Artwork.tech().boxNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
                if (ni == null) {
                    return null;
                }
                placedNodes.add(ni);
            } else {
                NodeInst ni = NodeInst.makeInstance(Artwork.tech().closedPolygonNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
                if (ni == null) {
                    return null;
                }
                ni.setTrace(poly.getPoints());
                placedNodes.add(ni);
            }
            return placedNodes;
        }
        if (style == Poly.Type.CROSSED) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().crossedBoxNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.OPENED) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().openedPolygonNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.OPENEDT1) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().openedDottedPolygonNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.OPENEDT2) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().openedDashedPolygonNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.OPENEDT3) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().openedThickerPolygonNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.VECTORS) {
            Point2D[] points = poly.getPoints();
            for (int i = 0; i < points.length; i += 2) {
                double hY;
                double lY;
                double hX;
                double lX = Math.min(points[i].getX(), points[i + 1].getX());
                NodeInst ni = NodeInst.makeInstance(Artwork.tech().openedPolygonNode, new Point2D.Double((lX + (hX = Math.max(points[i].getX(), points[i + 1].getX()))) / 2.0, ((lY = Math.min(points[i].getY(), points[i + 1].getY())) + (hY = Math.max(points[i].getY(), points[i + 1].getY()))) / 2.0), hX - lX, hY - lY, cell);
                if (ni == null) {
                    return null;
                }
                Point2D[] line = new Point2D[]{points[i], points[i + 1]};
                ni.setTrace(line);
                placedNodes.add(ni);
            }
            return placedNodes;
        }
        if (style == Poly.Type.CIRCLE) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().circleNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.THICKCIRCLE) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().thickCircleNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.DISC) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().filledCircleNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.CIRCLEARC) {
            double endAngle;
            Point2D[] points = poly.getPoints();
            Point2D center = points[0];
            double radius = points[1].distance(center);
            double startAngle = GenMath.figureAngle(center, points[2]) / 10;
            double amt = startAngle > (endAngle = (double)(GenMath.figureAngle(center, points[1]) / 10)) ? endAngle - startAngle + 360.0 : endAngle - startAngle;
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().circleNode, center, radius * 2.0, radius * 2.0, cell);
            if (ni == null) {
                return null;
            }
            ni.setArcDegrees(startAngle / 180.0 * Math.PI, amt / 180.0 * Math.PI);
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.THICKCIRCLEARC) {
            double endAngle;
            Point2D[] points = poly.getPoints();
            Point2D center = points[0];
            double radius = points[1].distance(center);
            double startAngle = GenMath.figureAngle(center, points[2]) / 10;
            double amt = startAngle > (endAngle = (double)(GenMath.figureAngle(center, points[1]) / 10)) ? endAngle - startAngle + 360.0 : endAngle - startAngle;
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().thickCircleNode, center, radius * 2.0, radius * 2.0, cell);
            if (ni == null) {
                return null;
            }
            ni.setArcDegrees(startAngle / 180.0 * Math.PI, amt / 180.0 * Math.PI);
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.TEXTCENT) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_MESSAGE, (Object)poly.getString(), TextDescriptor.getNodeTextDescriptor().withPos(AbstractTextDescriptor.Position.CENT));
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.TEXTBOTLEFT) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_MESSAGE, (Object)poly.getString(), TextDescriptor.getNodeTextDescriptor().withPos(AbstractTextDescriptor.Position.UPRIGHT));
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.TEXTBOTRIGHT) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_MESSAGE, (Object)poly.getString(), TextDescriptor.getNodeTextDescriptor().withPos(AbstractTextDescriptor.Position.UPLEFT));
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.TEXTBOX) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_MESSAGE, (Object)poly.getString(), TextDescriptor.getNodeTextDescriptor().withPos(AbstractTextDescriptor.Position.BOXED));
            placedNodes.add(ni);
            return placedNodes;
        }
        return null;
    }

    private static class LibFromTechJob
    extends Job {
        private Technology tech;
        private String libraryName;
        private boolean doItNow;
        private Library lib;
        private GraphicsPreferences gp = UserInterfaceMain.getGraphicsPreferences();

        private LibFromTechJob(Technology tech, boolean doItNow) {
            super("Make Technology Library from Technology", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.tech = tech;
            this.doItNow = doItNow;
            if (!doItNow) {
                this.startJob();
            }
        }

        public String getLibraryName() {
            return this.libraryName;
        }

        @Override
        public boolean doIt() {
            this.lib = TechToLib.makeLibFromTech(this.tech, this.gp);
            if (this.lib == null) {
                return false;
            }
            this.fieldVariableChanged("lib");
            if (!this.doItNow) {
                this.fieldVariableChanged("libraryName");
            }
            this.libraryName = this.lib.getName();
            return true;
        }

        @Override
        public void terminateOK() {
            User.setCurrentLibrary(this.lib);
        }
    }
}

