/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.Main;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.constraint.Layout;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Applicon860;
import com.sun.electric.tool.io.input.CIF;
import com.sun.electric.tool.io.input.DEF;
import com.sun.electric.tool.io.input.DSPFReader;
import com.sun.electric.tool.io.input.DXF;
import com.sun.electric.tool.io.input.EDIF;
import com.sun.electric.tool.io.input.GDS;
import com.sun.electric.tool.io.input.Gerber;
import com.sun.electric.tool.io.input.LEF;
import com.sun.electric.tool.io.input.LibDirs;
import com.sun.electric.tool.io.input.Spice;
import com.sun.electric.tool.io.input.Sue;
import com.sun.electric.tool.io.input.bookshelf.Bookshelf;
import com.sun.electric.tool.io.input.verilog.VerilogReader;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.util.concurrent.utils.ElapseTimer;
import com.sun.electric.util.TextUtils;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.BitSet;
import java.util.Map;
import javax.swing.SwingUtilities;

public class Input<ResultType> {
    protected static final int READ_BUFFER_SIZE = 65536;
    public static ErrorLogger errorLogger;
    private static boolean doChangesQuietly;
    private static boolean newLibraryCreated;
    protected String filePath;
    protected InputStream inputStream;
    protected LineNumberReader lineReader;
    protected PushbackInputStream pushbackInputStream;
    protected DataInputStream dataInputStream;
    protected long fileLength;
    protected long byteCount;
    protected EditingPreferences ep = EditingPreferences.getThreadEditingPreferences();
    private String lineBuffer;
    private int lineBufferPosition;

    protected ResultType processInput(URL url, Cell cell, Stimuli sd) throws IOException {
        return null;
    }

    public static boolean isNewLibraryCreated() {
        return newLibraryCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Library importLibrary(InputPreferences prefs, URL fileURL, FileType type, Library lib, Technology tech, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
        if (fileURL == null) {
            return null;
        }
        StringBuilder errmsg = new StringBuilder();
        if (!TextUtils.URLExists(fileURL, errmsg)) {
            System.out.print(errmsg.toString());
            return null;
        }
        boolean bl = newLibraryCreated = lib == null;
        if (lib == null && type != FileType.EDIF) {
            String libName = TextUtils.getFileNameWithoutExtension(fileURL);
            lib = Library.newInstance(libName, fileURL);
        }
        long startTime = System.currentTimeMillis();
        errorLogger = ErrorLogger.newInstance("File Import");
        File f2 = new File(fileURL.getPath());
        if (f2 != null && f2.exists()) {
            LibDirs.readLibDirs(f2.getParent());
        }
        try {
            Input.startProgressDialog("import", fileURL.getFile());
            if (prefs != null) {
                lib = prefs.doInput(fileURL, lib, tech, currentCells, nodesToExpand, job);
            }
        }
        finally {
            Input.stopProgressDialog();
            errorLogger.termLogging(true);
        }
        if (lib == null) {
            System.out.println("Error importing " + fileURL.getFile() + " as " + type + " format.");
        } else {
            long endTime = System.currentTimeMillis();
            ElapseTimer et = ElapseTimer.createInstanceByValues(startTime, endTime);
            System.out.println("Library " + fileURL.getFile() + " read, took " + et);
        }
        return lib;
    }

    public static InputPreferences getInputPreferences(FileType type, boolean factory) {
        if (!factory && !SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Current default Prefs can be accessed only from client thread");
        }
        if (type == FileType.APPLICON860) {
            return new Applicon860.Applicon860Preferences(factory);
        }
        if (type == FileType.CIF) {
            return new CIF.CIFPreferences(factory);
        }
        if (type == FileType.DAIS) {
            return new IOTool.DaisPreferences(factory, Input.isNewLibraryCreated());
        }
        if (type == FileType.DEF) {
            return new DEF.DEFPreferences(factory);
        }
        if (type == FileType.DXF) {
            return new DXF.DXFPreferences(factory);
        }
        if (type == FileType.EDIF) {
            return new EDIF.EDIFPreferences(factory);
        }
        if (type == FileType.GDS) {
            return new GDS.GDSPreferences(factory);
        }
        if (type == FileType.GERBER) {
            return new Gerber.GerberPreferences(factory);
        }
        if (type == FileType.LEF) {
            return new LEF.LEFPreferences(factory);
        }
        if (type == FileType.SPICE) {
            return new Spice.SpicePreferences(factory);
        }
        if (type == FileType.SUE) {
            return new Sue.SuePreferences(factory);
        }
        if (type == FileType.VERILOG) {
            return new VerilogReader.VerilogPreferences(factory);
        }
        if (type == FileType.DSPF) {
            return new DSPFReader.DSPFReaderPreferences(factory);
        }
        if (type == FileType.BOOKSHELF) {
            return new Bookshelf.BookshelfPreferences(factory);
        }
        return null;
    }

    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        return lib;
    }

    protected boolean openBinaryInput(URL fileURL) {
        this.filePath = fileURL.getFile();
        try {
            URLConnection urlCon = fileURL.openConnection();
            String contentLength = urlCon.getHeaderField("content-length");
            this.fileLength = -1L;
            try {
                this.fileLength = Long.parseLong(contentLength);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.inputStream = urlCon.getInputStream();
        }
        catch (IOException e) {
            System.out.println("Could not find file: " + this.filePath);
            return true;
        }
        this.byteCount = 0L;
        BufferedInputStream bufStrm = new BufferedInputStream(this.inputStream, 65536);
        this.pushbackInputStream = new PushbackInputStream(bufStrm);
        this.dataInputStream = new DataInputStream(this.pushbackInputStream);
        return false;
    }

    protected boolean openStringsInput(String[] lines2) {
        StringBuffer buffer = new StringBuffer();
        try {
            for (String l : lines2) {
                String s = l + "\n";
                buffer.append(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fileLength = lines2.length;
        StringReader reader = new StringReader(buffer.toString());
        this.lineReader = new LineNumberReader(reader);
        return false;
    }

    protected boolean openTextInput(URL fileURL) {
        if (this.openBinaryInput(fileURL)) {
            return true;
        }
        InputStreamReader is = new InputStreamReader(this.inputStream);
        this.lineReader = new LineNumberReader(is);
        return false;
    }

    protected static void setProgressNote(String msg) {
        Job.getUserInterface().setProgressNote(msg);
    }

    protected static String getProgressNote() {
        return Job.getUserInterface().getProgressNote();
    }

    protected static void startProgressDialog(String type, String filePath) {
        Job.getUserInterface().startProgressDialog(type, filePath);
    }

    protected static void stopProgressDialog() {
        Job.getUserInterface().stopProgressDialog();
    }

    protected static void setProgressValue(int value2) {
        Job.getUserInterface().setProgressValue(value2);
    }

    protected void updateProgressDialog(int bytesRead) {
        this.byteCount += (long)bytesRead;
        if (this.fileLength == 0L) {
            return;
        }
        long pct = this.byteCount * 100L / this.fileLength;
        UserInterface ui = Job.getUserInterface();
        if (ui != null) {
            ui.setProgressValue((int)pct);
        }
    }

    protected void closeInput() {
        try {
            this.dataInputStream = null;
            if (this.lineReader != null) {
                this.lineReader.close();
                this.lineReader = null;
            }
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String getLine() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int c;
            if ((c = this.lineReader.read()) == -1) {
                return null;
            }
            if (c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected String getLineAndUpdateProgress() throws IOException {
        StringBuffer sb = new StringBuffer();
        int bytesRead = 0;
        while (true) {
            int ch;
            if ((ch = this.lineReader.read()) == -1) {
                return null;
            }
            ++bytesRead;
            if (ch == 10 || ch == 13) break;
            sb.append((char)ch);
        }
        this.updateProgressDialog(bytesRead);
        return sb.toString();
    }

    protected String getLineFromBinary() throws IOException {
        StringBuffer sb = new StringBuffer();
        int lastCharacter = 0;
        while (true) {
            int c;
            if ((c = this.dataInputStream.read()) == -1) {
                return null;
            }
            if (lastCharacter == 10) {
                if (c == 13) break;
                this.pushbackInputStream.unread(c);
                break;
            }
            if (lastCharacter == 13) {
                if (c == 10) break;
                this.pushbackInputStream.unread(c);
                break;
            }
            sb.append((char)c);
            lastCharacter = c;
        }
        return sb.toString();
    }

    protected String getLineAndUpdateProgressBinary() throws IOException {
        StringBuffer sb = new StringBuffer();
        int lastCharacter = 0;
        int bytesRead = 0;
        while (true) {
            int c;
            if ((c = this.dataInputStream.read()) == -1) {
                if (sb.length() > 0) break;
                return null;
            }
            ++bytesRead;
            if (lastCharacter == 10) {
                if (c == 13) break;
                this.pushbackInputStream.unread(c);
                break;
            }
            if (lastCharacter == 13) {
                if (c == 10) break;
                this.pushbackInputStream.unread(c);
                break;
            }
            sb.append((char)c);
            lastCharacter = c;
        }
        this.updateProgressDialog(bytesRead);
        return sb.toString();
    }

    protected void initKeywordParsing() {
        this.lineBufferPosition = 0;
        this.lineBuffer = "";
    }

    protected String getRestOfLine() throws IOException {
        int next2 = this.lineBufferPosition + 1;
        String rest = next2 < this.lineBuffer.length() ? this.lineBuffer.substring(next2, this.lineBuffer.length()) : "";
        this.lineBufferPosition = this.lineBuffer.length();
        this.readNewLine();
        if (this.lineBuffer == null) {
            throw new IOException("Premature End of Verilog");
        }
        return rest;
    }

    protected void getRestOfComment() throws IOException {
        ++this.lineBufferPosition;
        while (true) {
            int next2;
            String rest;
            int index;
            if ((index = (rest = (next2 = this.lineBufferPosition) < this.lineBuffer.length() ? this.lineBuffer.substring(next2, this.lineBuffer.length()) : "").indexOf("*/")) != -1) {
                this.lineBufferPosition = index + 2;
                return;
            }
            this.lineBufferPosition = this.lineBuffer.length();
            this.readNewLine();
        }
    }

    private void readNewLine() throws IOException {
        this.lineBuffer = this.lineReader.readLine();
        if (this.lineBuffer != null) {
            this.updateProgressDialog(this.lineBuffer.length());
            this.lineBuffer = this.preprocessLine(this.lineBuffer);
        }
        this.lineBufferPosition = 0;
    }

    protected String readWholeLine() throws IOException {
        this.readNewLine();
        return this.lineBuffer;
    }

    protected String getAKeyword() throws IOException {
        while (true) {
            char chr;
            if (this.lineBuffer == null) {
                return null;
            }
            if (this.lineBufferPosition >= this.lineBuffer.length()) {
                this.readNewLine();
                continue;
            }
            while (this.lineBufferPosition < this.lineBuffer.length() && ((chr = this.lineBuffer.charAt(this.lineBufferPosition)) == ' ' || chr == '\t')) {
                ++this.lineBufferPosition;
            }
            if (this.lineBufferPosition < this.lineBuffer.length()) break;
        }
        int start = this.lineBufferPosition;
        char chr = this.lineBuffer.charAt(this.lineBufferPosition);
        if (this.isBreakCharacter(chr)) {
            ++this.lineBufferPosition;
            return Character.toString(chr);
        }
        while (this.lineBufferPosition < this.lineBuffer.length() && (chr = this.lineBuffer.charAt(this.lineBufferPosition)) != ' ' && chr != '\t' && !this.isBreakCharacter(chr)) {
            ++this.lineBufferPosition;
        }
        return this.lineBuffer.substring(start, this.lineBufferPosition);
    }

    protected boolean isBreakCharacter(char chr) {
        return false;
    }

    protected String preprocessLine(String line) {
        return line;
    }

    public static boolean isChangeQuiet() {
        return doChangesQuietly;
    }

    public static boolean changesQuiet(boolean quiet) {
        Layout.changesQuiet(quiet);
        boolean formerQuiet = doChangesQuietly;
        doChangesQuietly = quiet;
        return formerQuiet;
    }

    protected boolean eofDuring(String when) {
        System.out.println("File " + this.filePath + ", line " + this.lineReader.getLineNumber() + ": End of file while reading " + when);
        return false;
    }

    static {
        doChangesQuietly = false;
        newLibraryCreated = true;
    }

    public static abstract class InputPreferences
    implements Serializable {
        protected InputPreferences(boolean factory) {
            if (!(factory || SwingUtilities.isEventDispatchThread() || Main.isBatch())) {
                throw new IllegalStateException("Current default Prefs can be accessed only from client thread");
            }
        }

        public abstract Library doInput(URL var1, Library var2, Technology var3, Map<Library, Cell> var4, Map<CellId, BitSet> var5, Job var6);
    }
}

