/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class AbutRouter {
    private final List<ArcProto> layers;
    private boolean horizBoundary;

    private static void prln(String msg) {
        System.out.println(msg);
    }

    private AbutRouter(List<ArcProto> layers) {
        this.layers = layers;
    }

    private double coordParallelToBoundary(PortInst pi) {
        return this.horizBoundary ? pi.getCenter().getX() : pi.getCenter().getY();
    }

    private double coordPerpedicularToBoundary(PortInst pi) {
        return this.horizBoundary ? pi.getCenter().getY() : pi.getCenter().getX();
    }

    private void sortByCoordParallelToBoundary(List<PortInst> ports) {
        Collections.sort(ports, new Comparator<PortInst>(){

            @Override
            public int compare(PortInst pi1, PortInst pi2) {
                double delta = AbutRouter.this.coordParallelToBoundary(pi1) - AbutRouter.this.coordParallelToBoundary(pi2);
                return (int)Math.signum(delta);
            }
        });
    }

    private List<PortInst> findPortsNearBoundary(NodeInst ni, double boundaryXY, double distFromBoundary) {
        ArrayList<PortInst> boundaryPorts = new ArrayList<PortInst>();
        Iterator<PortInst> piIt = ni.getPortInsts();
        while (piIt.hasNext()) {
            PortInst pi = piIt.next();
            double xy = this.coordPerpedicularToBoundary(pi);
            if (!(Math.abs(xy - boundaryXY) <= distFromBoundary)) continue;
            boundaryPorts.add(pi);
        }
        this.sortByCoordParallelToBoundary(boundaryPorts);
        return boundaryPorts;
    }

    private List<PortInst> getAndRemovePortsAtCoord(double xy, List<PortInst> ports) {
        ArrayList<PortInst> portsAtXY = new ArrayList<PortInst>();
        while (ports.size() != 0 && this.coordParallelToBoundary(ports.get(0)) == xy) {
            portsAtXY.add(ports.get(0));
            ports.remove(0);
        }
        return portsAtXY;
    }

    private boolean powerToGroundShort(PortInst pi1, PortInst pi2) {
        PortCharacteristic ch1 = pi1.getPortProto().getCharacteristic();
        PortCharacteristic ch2 = pi2.getPortProto().getCharacteristic();
        return ch1 == PortCharacteristic.PWR && ch2 == PortCharacteristic.GND || ch1 == PortCharacteristic.GND && ch2 == PortCharacteristic.PWR;
    }

    private ArcProto getHighestLayer(PortInst pi) {
        PortProto pp = pi.getPortProto();
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            ArcProto ap = this.layers.get(i);
            if (!pp.connectsTo(ap)) continue;
            return ap;
        }
        return null;
    }

    private void connectAlignedPorts(List<PortInst> loPorts, List<PortInst> hiPorts) {
        block0: for (PortInst piB : loPorts) {
            ArcProto arcB = this.getHighestLayer(piB);
            if (arcB == null) continue;
            for (PortInst piT : hiPorts) {
                if (!piT.getPortProto().connectsTo(arcB)) continue;
                if (this.powerToGroundShort(piB, piT)) {
                    AbutRouter.prln("Power and Ground ports overlap: " + piB + " " + piT);
                    continue;
                }
                double w = LayoutLib.widestWireWidth(piB);
                LayoutLib.newArcInst(arcB, w, piB, piT);
                continue block0;
            }
        }
    }

    private void abutRouteBotTop(NodeInst bot, NodeInst top, double distFromBoundary) {
        this.horizBoundary = true;
        double botMaxY = bot.findEssentialBounds().getMaxY();
        double topMinY = top.findEssentialBounds().getMinY();
        this.abutRoute(bot, top, botMaxY, topMinY, distFromBoundary);
    }

    private void abutRoute(NodeInst niLo, NodeInst niHi, double xyLo, double xyHi, double distFromBoundary) {
        List<PortInst> portsLo = this.findPortsNearBoundary(niLo, xyLo, distFromBoundary);
        List<PortInst> portsHi = this.findPortsNearBoundary(niHi, xyHi, distFromBoundary);
        while (portsLo.size() != 0 && portsHi.size() != 0) {
            PortInst firstHi;
            double hiXY;
            PortInst firstLo = portsLo.get(0);
            double loXY = this.coordParallelToBoundary(firstLo);
            if (loXY < (hiXY = this.coordParallelToBoundary(firstHi = portsHi.get(0)))) {
                portsLo.remove(0);
                continue;
            }
            if (loXY > hiXY) {
                portsHi.remove(0);
                continue;
            }
            List<PortInst> alignedBotPorts = this.getAndRemovePortsAtCoord(loXY, portsLo);
            List<PortInst> alignedTopPorts = this.getAndRemovePortsAtCoord(loXY, portsHi);
            this.connectAlignedPorts(alignedBotPorts, alignedTopPorts);
        }
    }

    private void abutRouteLeftRight(NodeInst left, NodeInst right, double distFromBoundary) {
        this.horizBoundary = false;
        double leftMaxX = left.findEssentialBounds().getMaxX();
        double rightMinX = right.findEssentialBounds().getMinX();
        this.abutRoute(left, right, leftMaxX, rightMinX, distFromBoundary);
    }

    public static void abutRouteBotTop(NodeInst bot, NodeInst top, double distFromBoundary, List<ArcProto> layers) {
        AbutRouter ar = new AbutRouter(layers);
        ar.abutRouteBotTop(bot, top, distFromBoundary);
    }

    public static void abutRouteLeftRight(NodeInst left, NodeInst right, double distFromBoundary, List<ArcProto> layers) {
        AbutRouter ar = new AbutRouter(layers);
        ar.abutRouteLeftRight(left, right, distFromBoundary);
    }
}

