/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightEOBJ;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HighlightText
extends Highlight {
    protected final ElectricObject eobj;
    protected final Variable.Key varKey;

    public HighlightText(ElectricObject e, Cell c, Variable.Key key) {
        super(c);
        this.eobj = e;
        this.varKey = key;
        Class cls = null;
        if (key == NodeInst.NODE_NAME || key == NodeInst.NODE_PROTO) {
            cls = NodeInst.class;
        } else if (key == ArcInst.ARC_NAME) {
            cls = ArcInst.class;
        } else if (key == Export.EXPORT_NAME) {
            cls = Export.class;
        }
        if (cls != null && !cls.isInstance(e)) {
            throw new IllegalArgumentException(key + " in " + e);
        }
    }

    @Override
    void internalDescribe(StringBuffer desc) {
        if (this.varKey != null) {
            if (this.varKey == NodeInst.NODE_NAME) {
                desc.append(", name: ");
                desc.append(((NodeInst)this.eobj).getName());
            } else if (this.varKey == NodeInst.NODE_PROTO) {
                desc.append(", instance: ");
                desc.append(((NodeInst)this.eobj).getProto().getName());
            } else if (this.varKey == ArcInst.ARC_NAME) {
                desc.append(", name: ");
                desc.append(((ArcInst)this.eobj).getName());
            } else if (this.varKey == Export.EXPORT_NAME) {
                desc.append(", export: ");
                desc.append(((Export)this.eobj).getName());
            } else {
                desc.append(", var: ");
                desc.append(this.eobj.getParameterOrVariable(this.varKey).describe(-1));
            }
        }
    }

    @Override
    public ElectricObject getElectricObject() {
        return this.eobj;
    }

    @Override
    public boolean isHighlightText() {
        return true;
    }

    @Override
    public Variable.Key getVarKey() {
        return this.varKey;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.eobj == null || this.varKey == null) {
            return false;
        }
        if (!this.eobj.isLinked()) {
            return false;
        }
        if (this.varKey == NodeInst.NODE_NAME || this.varKey == ArcInst.ARC_NAME || this.varKey == NodeInst.NODE_PROTO || this.varKey == Export.EXPORT_NAME) {
            return true;
        }
        return this.eobj.getParameterOrVariable(this.varKey) != null;
    }

    @Override
    boolean sameThing(Highlight obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HighlightText other = (HighlightText)obj;
        if (this.eobj != other.eobj) {
            return false;
        }
        if (this.cell != other.cell) {
            return false;
        }
        return this.varKey == other.varKey;
    }

    @Override
    public void showInternalHighlight(EditWindow wnd, Graphics g, int highOffX, int highOffY, boolean onlyHighlight, boolean setConnected) {
        Geometric geom;
        ElectricObject eObj;
        Graphics2D g2 = (Graphics2D)g;
        Point2D[] points = Highlighter.describeHighlightText(wnd, this.eobj, this.varKey);
        if (points == null) {
            return;
        }
        Point2D[] linePoints = new Point2D[2];
        for (int i = 0; i < points.length; i += 2) {
            linePoints[0] = points[i];
            linePoints[1] = points[i + 1];
            HighlightText.drawOutlineFromPoints(wnd, g, linePoints, highOffX, highOffY, false, false);
        }
        if (onlyHighlight && (eObj = this.eobj) != null && eObj instanceof Geometric && ((geom = (Geometric)eObj) instanceof ArcInst || !((NodeInst)geom).isInvisiblePinWithText())) {
            Point2D objCtr = geom.getTrueCenter();
            Point c = wnd.databaseToScreen(objCtr);
            TextDescriptor td = this.eobj.getTextDescriptor(this.varKey);
            double locX = objCtr.getX() + td.getXOff();
            double locY = objCtr.getY() + td.getYOff();
            Point2D.Double txtAnchor = new Point2D.Double(locX, locY);
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                AffineTransform trans = ni.rotateOut();
                trans.transform(txtAnchor, txtAnchor);
            }
            Point a = wnd.databaseToScreen(txtAnchor);
            int cX = a.x;
            int cY = a.y;
            if (Math.abs(cX - c.x) > 4 || Math.abs(cY - c.y) > 4) {
                g.fillOval(c.x - 4, c.y - 4, 8, 8);
                g2.setStroke(dottedLine);
                HighlightText.drawLine(g, wnd, c.x, c.y, cX, cY);
                g2.setStroke(solidLine);
            }
        }
    }

    @Override
    public Geometric getGeometric() {
        if (DisplayedText.objectMovesWithText(this.eobj, this.varKey)) {
            if (this.eobj instanceof Export) {
                return ((Export)this.eobj).getOriginalPort().getNodeInst();
            }
            if (this.eobj instanceof Geometric) {
                return (Geometric)this.eobj;
            }
        }
        return null;
    }

    @Override
    void getHighlightedEObjs(Highlighter highlighter, List<Geometric> list2, boolean wantNodes, boolean wantArcs) {
        HighlightText.getHighlightedEObjsInternal(this.getGeometric(), list2, wantNodes, wantArcs);
    }

    @Override
    void getHighlightedNodes(Highlighter highlighter, List<NodeInst> list2) {
        HighlightText.getHighlightedNodesInternal(this.getGeometric(), list2);
    }

    @Override
    void getHighlightedArcs(Highlighter highlighter, List<ArcInst> list2) {
        HighlightText.getHighlightedArcsInternal(this.getGeometric(), list2);
    }

    @Override
    void getHighlightedNetworks(Set<Network> nets, Netlist netlist) {
        if (this.eobj instanceof Export) {
            Export pp = (Export)this.eobj;
            int width = netlist.getBusWidth(pp);
            for (int i = 0; i < width; ++i) {
                Network net = netlist.getNetwork(pp, i);
                if (net == null) continue;
                nets.add(net);
            }
        }
    }

    DisplayedText makeDisplayedText() {
        if (this.varKey != null) {
            return new DisplayedText(this.eobj, this.varKey);
        }
        return null;
    }

    @Override
    void getHighlightedText(List<DisplayedText> list2, boolean unique, List<Highlight> getHighlights) {
        DisplayedText dt = this.makeDisplayedText();
        if (dt == null) {
            return;
        }
        if (list2.contains(dt)) {
            return;
        }
        if (unique) {
            ElectricObject onObj = null;
            if (this.varKey != null) {
                if (this.eobj instanceof Export) {
                    onObj = ((Export)this.eobj).getOriginalPort().getNodeInst();
                } else if (this.eobj instanceof PortInst) {
                    onObj = ((PortInst)this.eobj).getNodeInst();
                } else if (this.eobj instanceof Geometric) {
                    onObj = this.eobj;
                }
            }
            if (this.eobj != null) {
                boolean found = false;
                for (Highlight oH : getHighlights) {
                    if (!(oH instanceof HighlightEOBJ)) continue;
                    ElectricObject fobj = ((HighlightEOBJ)oH).eobj;
                    if (fobj instanceof PortInst) {
                        fobj = ((PortInst)fobj).getNodeInst();
                    }
                    if (fobj != onObj) continue;
                    found = true;
                    break;
                }
                if (found) {
                    return;
                }
            }
        }
        list2.add(dt);
    }

    @Override
    Rectangle2D getHighlightedArea(EditWindow wnd) {
        Poly poly;
        if (wnd != null && (poly = this.eobj.computeTextPoly(wnd, this.varKey)) != null) {
            return poly.getBounds2D();
        }
        return null;
    }

    @Override
    boolean overHighlighted(EditWindow wnd, int x, int y, Highlighter highlighter) {
        Point2D start = wnd.screenToDatabase(x, y);
        Poly poly = this.eobj.computeTextPoly(wnd, this.varKey);
        return poly != null && poly.isInside(start);
    }

    @Override
    public String describe() {
        String description = "Unknown";
        if (this.varKey != null && this.eobj != null) {
            if (this.varKey == NodeInst.NODE_NAME) {
                description = "Node name for " + ((NodeInst)this.eobj).describe(true);
            } else if (this.varKey == ArcInst.ARC_NAME) {
                description = "Arc name for " + ((ArcInst)this.eobj).describe(true);
            } else if (this.varKey == Export.EXPORT_NAME) {
                description = "Export '" + ((Export)this.eobj).getName() + "'";
            } else if (this.varKey == NodeInst.NODE_PROTO) {
                description = "Cell instance name " + ((NodeInst)this.eobj).describe(true);
            } else {
                Variable var = this.eobj.getParameterOrVariable(this.varKey);
                if (var != null) {
                    description = var.getFullDescription(this.eobj);
                }
            }
        }
        return description;
    }

    @Override
    public String getInfo() {
        return "Text: " + this.describe();
    }
}

