/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar2.algorithm;

import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarNode;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarNodeBase;
import com.sun.electric.tool.routing.experimentalAStar2.goal.SimpleGoal;
import com.sun.electric.tool.routing.experimentalAStar2.machine.AStarMachineFast;
import com.sun.electric.tool.routing.experimentalAStar2.map.FieldMap;
import com.sun.electric.tool.routing.experimentalAStar2.memorymanager.AStarNodeObjectPool;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AStarRegionNode
extends AStarNodeBase<AStarRegionNode> {
    public FieldMap<AStarNode> routingMap;
    private FieldMap<AStarNode> hMap;
    private FieldMap<AStarNode> vMap;
    protected int hCap;
    protected int vCap;
    private ArrayList<Integer> hPaths = new ArrayList();
    private ArrayList<Integer> vPaths = new ArrayList();
    private HashSet<AStarNode> hPortals = new HashSet();
    public HashSet<AStarNode> vPortals = new HashSet();
    public int height;
    public int width;
    private boolean horizontalDirty = true;
    private boolean verticalDirty = true;
    private AStarNode entryPoint;
    private AStarNode exitPoint;
    private boolean isStartRegion = false;
    private boolean isGoalRegion = false;

    public void setAsStartRegion(boolean isStartRegion) {
        this.isStartRegion = isStartRegion;
    }

    public void setAsGoalRegion(boolean isGoalRegion) {
        this.isGoalRegion = isGoalRegion;
    }

    public boolean isTerminalRegion() {
        return this.isStartRegion || this.isGoalRegion;
    }

    public AStarRegionNode() {
    }

    public AStarRegionNode(FieldMap<AStarNode> map2, int width, int height) {
        this.routingMap = map2;
        this.height = height;
        this.width = width;
    }

    public AStarRegionNode(FieldMap<AStarNode> map2, int width, int height, int x, int y, int z) {
        this.routingMap = map2;
        this.height = height;
        this.width = width;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getHorizontalCapacity() {
        if (this.horizontalDirty) {
            this.hCap = this.calculateCapacity(false);
            this.fillUpCapacityPathNumbers(false);
            this.horizontalDirty = false;
        }
        return this.hCap;
    }

    public int getVerticalCapacity() {
        if (this.verticalDirty) {
            this.vCap = this.calculateCapacity(true);
            this.fillUpCapacityPathNumbers(true);
            this.verticalDirty = false;
        }
        return this.vCap;
    }

    private int calculateCapacity(boolean calcVertical) {
        int commingFrom;
        FieldMap<AStarNode> capMap;
        if (calcVertical) {
            this.vPaths.clear();
            capMap = this.getMap(true);
        } else {
            this.hPaths.clear();
            capMap = this.getMap(false);
        }
        boolean LEFT = false;
        boolean BOTTOM = true;
        int RIGHT = 2;
        int TOP = 3;
        int x = 0;
        int y = calcVertical ? 0 : this.height - 1;
        int k = 0;
        int n = commingFrom = calcVertical ? 3 : 0;
        while (!calcVertical && y > 0 || calcVertical && x < this.width) {
            x = 0;
            y = calcVertical ? 0 : this.height - 1;
            ++k;
            if (calcVertical) {
                while (this.routingMap.isTileBlocked(x, y, 0) || capMap.nodeAt(x, y, 0).getVerticalCapacityPathNumber() != 0 || !this.isPortal(x, y, true)) {
                    if (++x < this.width) continue;
                    return k - 1;
                }
            } else {
                while (this.routingMap.isTileBlocked(x, y, 0) || capMap.nodeAt(x, y, 0).getHorizontalCapacityPathNumber() != 0 || !this.isPortal(x, y, false)) {
                    if (--y >= 0) continue;
                    return k - 1;
                }
            }
            AStarNode origin = capMap.nodeAt(x, y, 0);
            if (calcVertical) {
                origin.setVerticalCapacityPathNumber(k);
            } else {
                origin.setHorizontalCapacityPathNumber(k);
            }
            block9: while (!calcVertical && x < this.width && y >= -1 && (x == 0 || !this.isPortal(x, y, false)) || calcVertical && x < this.width && y <= this.height - 1 && (y == 0 || !this.isPortal(x, y, true))) {
                switch (commingFrom) {
                    case 0: {
                        int oY;
                        if (!this.routingMap.isTileBlocked(x, y + 1, 0) && (calcVertical ? capMap.nodeAt(x, y + 1, 0).getVerticalCapacityPathNumber() == 0 : capMap.nodeAt(x, y + 1, 0).getHorizontalCapacityPathNumber() == 0)) {
                            AStarNode oldOrigin = origin;
                            origin = capMap.nodeAt(x, ++y, 0);
                            origin.initialize(oldOrigin, 0, 0, 0, x, y, 0);
                            if (calcVertical) {
                                origin.setVerticalCapacityPathNumber(k);
                            } else {
                                origin.setHorizontalCapacityPathNumber(k);
                            }
                            commingFrom = 3;
                            break;
                        }
                        if (!this.routingMap.isTileBlocked(x + 1, y, 0) && (calcVertical ? capMap.nodeAt(x + 1, y, 0).getVerticalCapacityPathNumber() == 0 : capMap.nodeAt(x + 1, y, 0).getHorizontalCapacityPathNumber() == 0)) {
                            AStarNode oldOrigin = origin;
                            origin = capMap.nodeAt(++x, y, 0);
                            origin.initialize(oldOrigin, 0, 0, 0, x, y, 0);
                            if (calcVertical) {
                                origin.setVerticalCapacityPathNumber(k);
                            } else {
                                origin.setHorizontalCapacityPathNumber(k);
                            }
                            commingFrom = 0;
                            break;
                        }
                        if (!this.routingMap.isTileBlocked(x, y - 1, 0) && (calcVertical ? capMap.nodeAt(x, y - 1, 0).getVerticalCapacityPathNumber() == 0 : capMap.nodeAt(x, y - 1, 0).getHorizontalCapacityPathNumber() == 0)) {
                            AStarNode oldOrigin = origin;
                            origin = capMap.nodeAt(x, --y, 0);
                            origin.initialize(oldOrigin, 0, 0, 0, x, y, 0);
                            if (calcVertical) {
                                origin.setVerticalCapacityPathNumber(k);
                            } else {
                                origin.setHorizontalCapacityPathNumber(k);
                            }
                            commingFrom = 1;
                            break;
                        }
                        commingFrom = 2;
                        if ((origin = this.traceBack(capMap.nodeAt(--x, y, 0), calcVertical)) != null) {
                            x = origin.getX();
                            y = origin.getY();
                            if (origin.origin != null) {
                                int oX = ((AStarNode)origin.origin).getX();
                                oY = ((AStarNode)origin.origin).getY();
                                if (oX < x) {
                                    commingFrom = 0;
                                }
                                if (oX > x) {
                                    commingFrom = 2;
                                }
                                if (oY > y) {
                                    commingFrom = 1;
                                }
                                if (oY >= y) continue block9;
                                commingFrom = 3;
                                break;
                            }
                            commingFrom = 0;
                            break;
                        }
                        return k - 1;
                    }
                    case 1: {
                        int oY;
                        if (!this.routingMap.isTileBlocked(x + 1, y, 0) && (calcVertical ? capMap.nodeAt(x + 1, y, 0).getVerticalCapacityPathNumber() == 0 : capMap.nodeAt(x + 1, y, 0).getHorizontalCapacityPathNumber() == 0)) {
                            AStarNode oldOrigin = origin;
                            origin = capMap.nodeAt(++x, y, 0);
                            origin.initialize(oldOrigin, 0, 0, 0, x, y, 0);
                            if (calcVertical) {
                                origin.setVerticalCapacityPathNumber(k);
                            } else {
                                origin.setHorizontalCapacityPathNumber(k);
                            }
                            commingFrom = 0;
                            break;
                        }
                        if (y == this.height) {
                            return k - 1;
                        }
                        if (!this.routingMap.isTileBlocked(x, y - 1, 0) && (calcVertical ? capMap.nodeAt(x, y - 1, 0).getVerticalCapacityPathNumber() == 0 : capMap.nodeAt(x, y - 1, 0).getHorizontalCapacityPathNumber() == 0)) {
                            AStarNode oldOrigin = origin;
                            origin = capMap.nodeAt(x, --y, 0);
                            origin.initialize(oldOrigin, 0, 0, 0, x, y, 0);
                            if (calcVertical) {
                                origin.setVerticalCapacityPathNumber(k);
                            } else {
                                origin.setHorizontalCapacityPathNumber(k);
                            }
                            commingFrom = 1;
                            break;
                        }
                        if (!this.routingMap.isTileBlocked(x - 1, y, 0) && (calcVertical ? capMap.nodeAt(x - 1, y, 0).getVerticalCapacityPathNumber() == 0 : capMap.nodeAt(x - 1, y, 0).getHorizontalCapacityPathNumber() == 0)) {
                            AStarNode oldOrigin = origin;
                            origin = capMap.nodeAt(--x, y, 0);
                            origin.initialize(oldOrigin, 0, 0, 0, x, y, 0);
                            if (calcVertical) {
                                origin.setVerticalCapacityPathNumber(k);
                            } else {
                                origin.setHorizontalCapacityPathNumber(k);
                            }
                            commingFrom = 2;
                            break;
                        }
                        commingFrom = 3;
                        if ((origin = this.traceBack(capMap.nodeAt(x, ++y, 0), calcVertical)) != null) {
                            x = origin.getX();
                            y = origin.getY();
                            if (origin.origin != null) {
                                int oX = ((AStarNode)origin.origin).getX();
                                oY = ((AStarNode)origin.origin).getY();
                                if (oX < x) {
                                    commingFrom = 0;
                                }
                                if (oX > x) {
                                    commingFrom = 2;
                                }
                                if (oY > y) {
                                    commingFrom = 1;
                                }
                                if (oY >= y) continue block9;
                                commingFrom = 3;
                                break;
                            }
                            commingFrom = 0;
                            break;
                        }
                        return k - 1;
                    }
                    case 2: {
                        int oY;
                        if (!this.routingMap.isTileBlocked(x, y - 1, 0) && (calcVertical ? capMap.nodeAt(x, y - 1, 0).getVerticalCapacityPathNumber() == 0 : capMap.nodeAt(x, y - 1, 0).getHorizontalCapacityPathNumber() == 0)) {
                            AStarNode oldOrigin = origin;
                            origin = capMap.nodeAt(x, --y, 0);
                            origin.initialize(oldOrigin, 0, 0, 0, x, y, 0);
                            if (calcVertical) {
                                origin.setVerticalCapacityPathNumber(k);
                            } else {
                                origin.setHorizontalCapacityPathNumber(k);
                            }
                            commingFrom = 1;
                            break;
                        }
                        if (!this.routingMap.isTileBlocked(x - 1, y, 0) && (calcVertical ? capMap.nodeAt(x - 1, y, 0).getVerticalCapacityPathNumber() == 0 : capMap.nodeAt(x - 1, y, 0).getHorizontalCapacityPathNumber() == 0)) {
                            AStarNode oldOrigin = origin;
                            origin = capMap.nodeAt(--x, y, 0);
                            origin.initialize(oldOrigin, 0, 0, 0, x, y, 0);
                            if (calcVertical) {
                                origin.setVerticalCapacityPathNumber(k);
                            } else {
                                origin.setHorizontalCapacityPathNumber(k);
                            }
                            commingFrom = 2;
                            break;
                        }
                        if (!this.routingMap.isTileBlocked(x, y + 1, 0) && (calcVertical ? capMap.nodeAt(x, y + 1, 0).getVerticalCapacityPathNumber() == 0 : capMap.nodeAt(x, y + 1, 0).getHorizontalCapacityPathNumber() == 0)) {
                            AStarNode oldOrigin = origin;
                            origin = capMap.nodeAt(x, ++y, 0);
                            origin.initialize(oldOrigin, 0, 0, 0, x, y, 0);
                            if (calcVertical) {
                                origin.setVerticalCapacityPathNumber(k);
                            } else {
                                origin.setHorizontalCapacityPathNumber(k);
                            }
                            commingFrom = 3;
                            break;
                        }
                        commingFrom = 0;
                        if ((origin = this.traceBack(capMap.nodeAt(++x, y, 0), calcVertical)) != null) {
                            x = origin.getX();
                            y = origin.getY();
                            if (origin.origin != null) {
                                int oX = ((AStarNode)origin.origin).getX();
                                oY = ((AStarNode)origin.origin).getY();
                                if (oX < x) {
                                    commingFrom = 0;
                                }
                                if (oX > x) {
                                    commingFrom = 2;
                                }
                                if (oY > y) {
                                    commingFrom = 1;
                                }
                                if (oY >= y) continue block9;
                                commingFrom = 3;
                                break;
                            }
                            commingFrom = 0;
                            break;
                        }
                        return k - 1;
                    }
                    case 3: {
                        int oY;
                        if (!this.routingMap.isTileBlocked(x - 1, y, 0) && (calcVertical ? capMap.nodeAt(x - 1, y, 0).getVerticalCapacityPathNumber() == 0 : capMap.nodeAt(x - 1, y, 0).getHorizontalCapacityPathNumber() == 0)) {
                            AStarNode oldOrigin = origin;
                            origin = capMap.nodeAt(--x, y, 0);
                            origin.initialize(oldOrigin, 0, 0, 0, x, y, 0);
                            if (calcVertical) {
                                origin.setVerticalCapacityPathNumber(k);
                            } else {
                                origin.setHorizontalCapacityPathNumber(k);
                            }
                            commingFrom = 2;
                            break;
                        }
                        if (!this.routingMap.isTileBlocked(x, y + 1, 0) && (calcVertical ? capMap.nodeAt(x, y + 1, 0).getVerticalCapacityPathNumber() == 0 : capMap.nodeAt(x, y + 1, 0).getHorizontalCapacityPathNumber() == 0)) {
                            AStarNode oldOrigin = origin;
                            origin = capMap.nodeAt(x, ++y, 0);
                            origin.initialize(oldOrigin, 0, 0, 0, x, y, 0);
                            if (calcVertical) {
                                origin.setVerticalCapacityPathNumber(k);
                            } else {
                                origin.setHorizontalCapacityPathNumber(k);
                            }
                            commingFrom = 3;
                            break;
                        }
                        if (!this.routingMap.isTileBlocked(x + 1, y, 0) && (calcVertical ? capMap.nodeAt(x + 1, y, 0).getVerticalCapacityPathNumber() == 0 : capMap.nodeAt(x + 1, y, 0).getHorizontalCapacityPathNumber() == 0)) {
                            AStarNode oldOrigin = origin;
                            origin = capMap.nodeAt(++x, y, 0);
                            origin.initialize(oldOrigin, 0, 0, 0, x, y, 0);
                            if (calcVertical) {
                                origin.setVerticalCapacityPathNumber(k);
                            } else {
                                origin.setHorizontalCapacityPathNumber(k);
                            }
                            commingFrom = 0;
                            break;
                        }
                        commingFrom = 1;
                        if ((origin = this.traceBack(capMap.nodeAt(x, --y, 0), calcVertical)) != null) {
                            x = origin.getX();
                            y = origin.getY();
                            if (origin.origin != null) {
                                int oX = ((AStarNode)origin.origin).getX();
                                oY = ((AStarNode)origin.origin).getY();
                                if (oX < x) {
                                    commingFrom = 0;
                                }
                                if (oX > x) {
                                    commingFrom = 2;
                                }
                                if (oY > y) {
                                    commingFrom = 1;
                                }
                                if (oY >= y) continue block9;
                                commingFrom = 3;
                                break;
                            }
                            commingFrom = 0;
                            break;
                        }
                        return k - 1;
                    }
                }
            }
            if (calcVertical) {
                this.vPaths.add(k);
                continue;
            }
            this.hPaths.add(k);
        }
        return k;
    }

    private void fillUpCapacityPathNumbers(boolean calcVertical) {
        if (calcVertical) {
            for (int x = 0; x < this.width; ++x) {
                int pathNumber = 0;
                int y = 0;
                if (this.isPortal(x, y, true) && this.getMap(true).nodeAt(x, y, 0).getVerticalCapacityPathNumber() == 0) {
                    while (y < this.height && !this.routingMap.isTileBlocked(x, y, 0) && (pathNumber = this.getMap(true).nodeAt(x, y, 0).getVerticalCapacityPathNumber()) == 0) {
                        ++y;
                    }
                    if (y != 0 && y != this.height && !this.routingMap.isTileBlocked(x, y, 0)) {
                        this.getMap(true).nodeAt(x, 0, 0).setVerticalCapacityPathNumber(pathNumber);
                    }
                }
                if (!this.isPortal(x, y = this.height - 1, true) || this.getMap(true).nodeAt(x, y, 0).getVerticalCapacityPathNumber() != 0) continue;
                while (y >= 0 && !this.routingMap.isTileBlocked(x, y, 0) && (pathNumber = this.getMap(true).nodeAt(x, y, 0).getVerticalCapacityPathNumber()) == 0) {
                    --y;
                }
                if (y == this.height - 1 || y == -1 || this.routingMap.isTileBlocked(x, y, 0)) continue;
                this.getMap(true).nodeAt(x, this.height - 1, 0).setVerticalCapacityPathNumber(pathNumber);
            }
        } else {
            for (int y = 0; y < this.height; ++y) {
                int pathNumber = 0;
                int x = 0;
                if (this.isPortal(x, y, true) && this.getMap(false).nodeAt(x, y, 0).getHorizontalCapacityPathNumber() == 0) {
                    while (x < this.width && !this.routingMap.isTileBlocked(x, y, 0) && (pathNumber = this.getMap(false).nodeAt(x, y, 0).getHorizontalCapacityPathNumber()) == 0) {
                        ++x;
                    }
                    if (x != 0 && x != this.width && !this.routingMap.isTileBlocked(x, y, 0)) {
                        this.getMap(false).nodeAt(0, y, 0).setHorizontalCapacityPathNumber(pathNumber);
                    }
                }
                if (!this.isPortal(x = this.width - 1, y, true) || this.getMap(false).nodeAt(x, y, 0).getHorizontalCapacityPathNumber() != 0) continue;
                while (x >= 0 && !this.routingMap.isTileBlocked(x, y, 0) && (pathNumber = this.getMap(false).nodeAt(x, y, 0).getHorizontalCapacityPathNumber()) == 0) {
                    --x;
                }
                if (x == this.width - 1 || x == -1 || this.routingMap.isTileBlocked(x, y, 0)) continue;
                this.getMap(false).nodeAt(this.width - 1, y, 0).setHorizontalCapacityPathNumber(pathNumber);
            }
        }
    }

    protected boolean isPortal(int x, int y, boolean vertical) {
        if (this.routingMap.isTileBlocked(x, y, 0)) {
            AStarNode nodeAt = this.routingMap.nodeAt(x, y, 0);
            this.vPortals.remove(nodeAt);
            this.hPortals.remove(nodeAt);
            return false;
        }
        if (vertical) {
            return this.vPortals.contains(this.routingMap.nodeAt(x, y, 0));
        }
        return this.hPortals.contains(this.routingMap.nodeAt(x, y, 0));
    }

    public void setPortal(int x, int y, boolean vertical) {
        if (vertical) {
            this.vPortals.add(this.routingMap.nodeAt(x, y, 0));
        } else {
            this.hPortals.add(this.routingMap.nodeAt(x, y, 0));
        }
    }

    public boolean isPortalWithPath(int x, int y, boolean calcVertical) {
        if (this.routingMap.isTileBlocked(x, y, 0)) {
            AStarNode nodeAt = this.routingMap.nodeAt(x, y, 0);
            this.vPortals.remove(nodeAt);
            this.hPortals.remove(nodeAt);
            return false;
        }
        if (!this.isPortal(x, y, calcVertical)) {
            return false;
        }
        if (this.isTerminalRegion()) {
            AStarNode to2 = this.isGoalRegion ? this.getExitPoint() : this.getEntryPoint();
            AStarMachineFast machine = new AStarMachineFast(new AStarNodeObjectPool());
            SimpleGoal goal = new SimpleGoal();
            goal.setMaximumRevolutions(300000);
            machine.setUpSearchSpace(this.routingMap, goal);
            if (machine.findPath(x, y, 0, to2.getX(), to2.getY(), 0) != null) {
                return true;
            }
        }
        if (calcVertical) {
            return this.vPaths.contains(this.getMap(true).nodeAt(x, y, 0).getVerticalCapacityPathNumber());
        }
        return this.hPaths.contains(this.getMap(false).nodeAt(x, y, 0).getHorizontalCapacityPathNumber());
    }

    private AStarNode traceBack(AStarNode currentNode, boolean calcVertical) {
        AStarNode result2 = currentNode;
        if (calcVertical) {
            int y;
            int x;
            FieldMap<AStarNode> map2 = this.getMap(true);
            while (!(result2 == null || !this.routingMap.isTileBlocked(x = result2.getX(), (y = result2.getY()) + 1, 0) && map2.nodeAt(x, y + 1, 0).getVerticalCapacityPathNumber() <= 0 || !this.routingMap.isTileBlocked(x, y - 1, 0) && map2.nodeAt(x, y - 1, 0).getVerticalCapacityPathNumber() <= 0 || !this.routingMap.isTileBlocked(x + 1, y, 0) && map2.nodeAt(x + 1, y, 0).getVerticalCapacityPathNumber() <= 0 || !this.routingMap.isTileBlocked(x - 1, y, 0) && map2.nodeAt(x - 1, y, 0).getVerticalCapacityPathNumber() <= 0)) {
                result2 = (AStarNode)result2.origin;
            }
        } else {
            int y;
            int x;
            FieldMap<AStarNode> map3 = this.getMap(false);
            while (!(result2 == null || !this.routingMap.isTileBlocked(x = result2.getX(), (y = result2.getY()) + 1, 0) && map3.nodeAt(x, y + 1, 0).getHorizontalCapacityPathNumber() <= 0 || !this.routingMap.isTileBlocked(x, y - 1, 0) && map3.nodeAt(x, y - 1, 0).getHorizontalCapacityPathNumber() <= 0 || !this.routingMap.isTileBlocked(x + 1, y, 0) && map3.nodeAt(x + 1, y, 0).getHorizontalCapacityPathNumber() <= 0 || !this.routingMap.isTileBlocked(x - 1, y, 0) && map3.nodeAt(x - 1, y, 0).getHorizontalCapacityPathNumber() <= 0)) {
                result2 = (AStarNode)result2.origin;
            }
        }
        return result2;
    }

    public void removePathForNode(int x, int y) {
        if (this.vPaths.remove((Object)this.getMap(true).nodeAt(x, y, 0).getVerticalCapacityPathNumber())) {
            --this.vCap;
        }
        if (this.hPaths.remove((Object)this.getMap(false).nodeAt(x, y, 0).getHorizontalCapacityPathNumber())) {
            --this.hCap;
        }
    }

    @Override
    public int compareTo(AStarRegionNode o) {
        return this.getTotalCost() - o.getTotalCost();
    }

    public FieldMap<AStarNode> getMap(boolean vertical) {
        if (vertical) {
            if (this.vMap == null) {
                this.vMap = (FieldMap)this.routingMap.clone();
                return this.vMap;
            }
            return this.vMap;
        }
        if (this.hMap == null) {
            this.hMap = (FieldMap)this.routingMap.clone();
            return this.hMap;
        }
        return this.hMap;
    }

    public boolean isTileBlocked(int x, int y) {
        return this.routingMap.isTileBlocked(x, y, 0);
    }

    public AStarNode getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(AStarNode node) {
        this.entryPoint = node;
    }

    public AStarNode getExitPoint() {
        return this.exitPoint;
    }

    public void setExitPoint(AStarNode node) {
        this.exitPoint = node;
    }

    public void print() {
        String string2 = "";
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                String value2 = "";
                value2 = this.getEntryPoint() != null && this.getEntryPoint().equals(this.getMap(true).nodeAt(x, y, 0)) ? "E" : (this.isTileBlocked(x, y) ? "X" : "_");
                value2 = this.isPortal(x, y, true) || this.isPortal(x, y, false) ? "P" + value2 : value2 + "_";
                string2 = string2 + "[" + value2 + "]";
            }
            string2 = string2 + "\n";
        }
        System.out.println(string2);
    }
}

