/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.cvspm;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.LibId;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.cvspm.State;
import com.sun.electric.tool.cvspm.Update;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.util.TextUtils;
import java.awt.Color;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVSLibrary {
    private FileType type;
    private State libState;
    private Map<Cell, State> cellStates;
    private Map<Cell, Cell> editing;
    private boolean libEditing;
    private static Map<LibId, CVSLibrary> CVSLibraries = new HashMap<LibId, CVSLibrary>();

    private CVSLibrary(Library lib) {
        String libFile = lib.getLibFile().getPath();
        this.type = OpenFile.getOpenFileType(libFile, FileType.JELIB);
        this.libState = State.NONE;
        this.libEditing = false;
        this.cellStates = new HashMap<Cell, State>();
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            this.cellStates.put(cell, State.NONE);
            if (!CVS.isDELIB(lib) || CVS.isFileInCVS(CVS.getCellFile(cell))) continue;
            this.cellStates.put(cell, State.UNKNOWN);
        }
        this.editing = new HashMap<Cell, Cell>();
    }

    public static void addLibrary(Library lib) {
        CVSLibrary.addLibrary(lib, false);
    }

    private static void addLibrary(Library lib, boolean added) {
        if (lib.isHidden()) {
            return;
        }
        if (!lib.isFromDisk()) {
            return;
        }
        String libFile = lib.getLibFile().getPath();
        if (!added && !CVS.isFileInCVS(new File(libFile))) {
            return;
        }
        CVSLibrary cvslib = new CVSLibrary(lib);
        CVSLibraries.put(lib.getId(), cvslib);
    }

    public static void removeLibrary(LibId libId) {
        CVSLibraries.remove(libId);
    }

    public static LibsCells getNotInCVS(List<Library> libs, List<Cell> cells) {
        if (libs == null) {
            libs = new ArrayList<Library>();
        }
        if (cells == null) {
            cells = new ArrayList<Cell>();
        }
        LibsCells bad = new LibsCells();
        for (Library lib : libs) {
            if (CVS.isInCVS(lib)) continue;
            bad.libs.add(lib);
        }
        for (Cell cell : cells) {
            if (CVS.isInCVS(cell)) continue;
            bad.cells.add(cell);
        }
        return bad;
    }

    public static LibsCells getInCVS(List<Library> libs, List<Cell> cells) {
        if (libs == null) {
            libs = new ArrayList<Library>();
        }
        if (cells == null) {
            cells = new ArrayList<Cell>();
        }
        LibsCells bad = new LibsCells();
        for (Library lib : libs) {
            if (!CVS.isInCVS(lib)) continue;
            bad.libs.add(lib);
        }
        for (Cell cell : cells) {
            if (!CVS.isInCVS(cell)) continue;
            bad.cells.add(cell);
        }
        return bad;
    }

    public static LibsCells getModified(List<Library> libs, List<Cell> cells) {
        if (libs == null) {
            libs = new ArrayList<Library>();
        }
        if (cells == null) {
            cells = new ArrayList<Cell>();
        }
        LibsCells bad = new LibsCells();
        for (Library lib : libs) {
            if (!lib.isChanged()) continue;
            bad.libs.add(lib);
        }
        for (Cell cell : cells) {
            if (!cell.isModified()) continue;
            bad.cells.add(cell);
        }
        return bad;
    }

    public static LibsCells consolidate(List<Library> libs, List<Cell> cells) {
        LibsCells consolidated = new LibsCells();
        consolidated.libs.addAll(libs);
        for (Cell cell : cells) {
            if (libs.contains(cell.getLibrary())) continue;
            consolidated.cells.add(cell);
        }
        return consolidated;
    }

    public static LibsCells notFromDELIB(List<Cell> cells) {
        if (cells == null) {
            cells = new ArrayList<Cell>();
        }
        LibsCells bad = new LibsCells();
        for (Cell cell : cells) {
            if (CVS.isDELIB(cell.getLibrary())) continue;
            bad.cells.add(cell);
        }
        return bad;
    }

    public static LibsCells getInCVSSorted(List<Library> libs, List<Cell> cells) {
        ArrayList<Cell> delibCells = new ArrayList<Cell>();
        ArrayList<Library> jelibs = new ArrayList<Library>();
        for (Library lib : libs) {
            if (CVS.isDELIB(lib)) {
                Iterator<Cell> it = lib.getCells();
                while (it.hasNext()) {
                    cells.add(it.next());
                }
                continue;
            }
            if (jelibs.contains(lib)) continue;
            jelibs.add(lib);
        }
        for (Cell c : cells) {
            if (CVS.isDELIB(c.getLibrary())) {
                delibCells.add(c);
                continue;
            }
            if (jelibs.contains(c.getLibrary())) continue;
            jelibs.add(c.getLibrary());
        }
        return CVSLibrary.getInCVS(jelibs, delibCells);
    }

    public static boolean hasUnknownCells(Library lib) {
        CVSLibrary cvslib = CVSLibraries.get(lib.getId());
        if (cvslib == null) {
            return false;
        }
        if (cvslib.type != FileType.DELIB) {
            return false;
        }
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            State state = cvslib.cellStates.get(cell);
            if (state == null) {
                return true;
            }
            if (state != State.UNKNOWN) continue;
            return true;
        }
        return false;
    }

    public static void setState(Cell cell, State state) {
        CVSLibrary cvslib = CVSLibraries.get(cell.getLibrary().getId());
        if (cvslib == null && state == State.ADDED) {
            CVSLibrary.addLibrary(cell.getLibrary(), true);
            cvslib = CVSLibraries.get(cell.getLibrary().getId());
        }
        if (cvslib == null) {
            return;
        }
        if (state == null) {
            return;
        }
        if (!CVS.isDELIB(cell.getLibrary())) {
            cvslib.libState = state;
        } else {
            cvslib.cellStates.put(cell, state);
        }
    }

    public static void setState(Library lib, State state) {
        CVSLibrary cvslib = CVSLibraries.get(lib.getId());
        if (cvslib == null && state == State.ADDED) {
            CVSLibrary.addLibrary(lib, true);
            cvslib = CVSLibraries.get(lib.getId());
        }
        if (cvslib == null) {
            return;
        }
        if (state == null) {
            return;
        }
        if (cvslib.type != FileType.DELIB) {
            cvslib.libState = state;
            return;
        }
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            State currentState = cvslib.cellStates.get(cell);
            if (currentState == State.UNKNOWN) continue;
            cvslib.cellStates.put(cell, state);
        }
    }

    public static Color getColor(Library lib) {
        return CVSLibrary.getColor(CVSLibrary.getState(lib));
    }

    public static Color getColor(Cell cell) {
        return CVSLibrary.getColor(CVSLibrary.getState(cell));
    }

    public static State getState(Library lib) {
        CVSLibrary cvslib = CVSLibraries.get(lib.getId());
        if (cvslib == null) {
            return State.UNKNOWN;
        }
        if (cvslib.type != FileType.DELIB) {
            return cvslib.libState;
        }
        TreeSet<State> states = new TreeSet<State>();
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            State state = cvslib.cellStates.get(cell);
            if (state == null) continue;
            states.add(state);
        }
        it = states.iterator();
        if (it.hasNext()) {
            return (State)((Object)it.next());
        }
        return State.UNKNOWN;
    }

    public static State getState(Cell cell) {
        CVSLibrary cvslib = CVSLibraries.get(cell.getLibrary().getId());
        if (cvslib == null) {
            return State.UNKNOWN;
        }
        if (!CVS.isDELIB(cell.getLibrary())) {
            return cvslib.libState;
        }
        State state = cvslib.cellStates.get(cell);
        if (state == null) {
            return State.UNKNOWN;
        }
        return state;
    }

    public static Color getColor(Cell.CellGroup cg) {
        TreeSet<State> states = new TreeSet<State>();
        Iterator<Cell> it = cg.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            State state = CVSLibrary.getState(cell);
            states.add(state);
        }
        return CVSLibrary.getColor(states);
    }

    public static Color getColor(State state) {
        if (state == State.NONE) {
            return Color.black;
        }
        if (state == State.UPDATE) {
            return Color.magenta;
        }
        if (state == State.MODIFIED) {
            return Color.blue;
        }
        if (state == State.CONFLICT) {
            return Color.red;
        }
        if (state == State.ADDED) {
            return Color.green;
        }
        if (state == State.REMOVED) {
            return Color.green;
        }
        if (state == State.PATCHED) {
            return Color.black;
        }
        if (state == State.UNKNOWN) {
            return Color.lightGray;
        }
        return Color.black;
    }

    public static Color getColor(Set<State> states) {
        Iterator<State> it = states.iterator();
        if (it.hasNext()) {
            return CVSLibrary.getColor(it.next());
        }
        return Color.black;
    }

    public static void setEditing(Cell cell, boolean editing) {
        CVSLibrary cvslib = CVSLibraries.get(cell.getLibrary().getId());
        if (cvslib == null) {
            return;
        }
        if (editing) {
            cvslib.editing.put(cell, cell);
        } else {
            cvslib.editing.remove(cell);
        }
    }

    public static boolean isEditing(Cell cell) {
        CVSLibrary cvslib = CVSLibraries.get(cell.getLibrary().getId());
        if (cvslib == null) {
            return false;
        }
        return cvslib.editing.containsKey(cell);
    }

    public static void setEditing(Library lib, boolean editing) {
        CVSLibrary cvslib = CVSLibraries.get(lib.getId());
        if (cvslib == null) {
            return;
        }
        if (!CVS.isDELIB(lib)) {
            cvslib.libEditing = editing;
        } else {
            editing = false;
            if (false) {
                cvslib.editing.clear();
            }
        }
    }

    public static boolean isEditing(Library lib) {
        CVSLibrary cvslib = CVSLibraries.get(lib.getId());
        if (cvslib == null) {
            return false;
        }
        if (!CVS.isDELIB(lib)) {
            return cvslib.libEditing;
        }
        return !cvslib.editing.isEmpty();
    }

    private static void savingLibrary(LibId libId, Library lib, URL libFile) {
        if (libFile != null) {
            FileType type = OpenFile.getOpenFileType(libFile.getFile(), FileType.JELIB);
            CVSLibrary cvslib = CVSLibraries.get(libId);
            if (cvslib != null && cvslib.type != type) {
                CVSLibrary.removeLibrary(libId);
                if (lib != null) {
                    CVSLibrary.addLibrary(lib);
                }
            }
        }
    }

    public static void savedLibrary(LibId libId, URL libFile, List<String> deletedCellFiles, List<String> writtenCellFiles) {
        Library lib = EDatabase.clientDatabase().getLib(libId);
        CVSLibrary.savingLibrary(libId, lib, libFile);
        String useDir = TextUtils.getFile(libFile).getParent();
        String cvsProgram = CVS.getCVSProgram();
        String repository = CVS.getRepository();
        if (CVS.isInCVS(libFile) && CVS.isDELIB(libFile)) {
            int exitVal;
            StringBuffer buf = new StringBuffer();
            for (String s : deletedCellFiles) {
                File file = new File(s);
                if (!CVS.isFileInCVS(file) || file.exists()) continue;
                if (s.startsWith(useDir)) {
                    buf.append(s.substring(useDir.length() + 1) + " ");
                    continue;
                }
                buf.append(s + " ");
            }
            String arg = buf.toString();
            if (!arg.trim().equals("")) {
                int exitVal2 = CVS.runCVSCommand(cvsProgram, repository, "-q remove " + arg, "Removing deleted cells from CVS", useDir, System.out);
                if (exitVal2 != 0) {
                    System.out.println("  Error running CVS remove command (exit status " + exitVal2 + ")");
                    return;
                }
                exitVal2 = CVS.runCVSCommandWithQuotes(cvsProgram, repository, "-q commit -m \"Automatic commit of removed cell file by Electric\" " + arg, "Committing removed files to CVS", useDir, System.out);
            }
            buf = new StringBuffer();
            for (String s : writtenCellFiles) {
                File file = new File(s);
                File parent = file.getParentFile();
                if (!CVS.isFileInCVS(parent) && parent.exists()) {
                    if (parent.getAbsolutePath().startsWith(useDir)) {
                        buf.append(parent.getAbsolutePath().substring(useDir.length() + 1) + " ");
                    } else {
                        buf.append(parent.getAbsolutePath() + " ");
                    }
                }
                if (CVS.isFileInCVS(file) || !file.exists()) continue;
                if (s.startsWith(useDir)) {
                    buf.append(s.substring(useDir.length() + 1) + " ");
                    continue;
                }
                buf.append(s + " ");
            }
            arg = buf.toString();
            if (!arg.trim().equals("") && (exitVal = CVS.runCVSCommand(cvsProgram, repository, "-q add " + buf.toString(), "Adding new cells to CVS", useDir, System.out)) != 0) {
                System.out.println("  Error running CVS add command (exit status " + exitVal + ")");
                return;
            }
        }
        if (lib != null && CVS.isInCVS(libFile)) {
            ArrayList<Library> libs = new ArrayList<Library>();
            libs.add(lib);
            Update.statusNoJob(libs, null, false);
        }
    }

    public static void closeLibrary(Library lib) {
        CVSLibrary.removeLibrary(lib.getId());
    }

    protected static class LibsCells {
        public List<Library> libs = new ArrayList<Library>();
        public List<Cell> cells = new ArrayList<Cell>();

        protected LibsCells() {
        }
    }
}

