/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.constraint;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableLibrary;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.constraint.LayoutCell;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layout
extends Constraints {
    static final boolean DEBUG = false;
    private static boolean doChangesQuietly;
    private static Snapshot oldSnapshot;
    private static long revisionDate;
    private static String userName;
    private static Set<Cell> goodSpacingDRCCells;
    private static Set<Cell> goodAreaDRCCells;
    private static Variable goodSpacingDRCDate;
    private static Variable goodSpacingDRCBit;
    private static Variable goodAreaDRCDate;
    private static final ArrayList<LayoutCell> cellInfos;
    private static final HashMap<ArcInst, Boolean> tempRigid;
    public static final Variable.Key DRC_LAST_GOOD_DATE_SPACING;
    public static final Variable.Key DRC_LAST_GOOD_BIT_SPACING;
    public static final int DRC_LAST_GOOD_BIT_DEFAULT = -1;
    public static final Variable.Key DRC_LAST_GOOD_DATE_AREA;

    Layout() {
    }

    public static void changesQuiet(boolean quiet) {
        doChangesQuietly = true;
    }

    @Override
    public void startBatch(Snapshot initialSnapshot) {
        doChangesQuietly = false;
        oldSnapshot = initialSnapshot;
        tempRigid.clear();
        goodSpacingDRCCells = null;
        goodAreaDRCCells = null;
        Layout.makeLayoutCells();
    }

    @Override
    public void endBatch(String userName) {
        Cell cell;
        Iterator<Cell> cIt;
        Library lib;
        Iterator<Library> it;
        TextDescriptor td;
        Layout.userName = userName;
        revisionDate = System.currentTimeMillis();
        if (goodSpacingDRCCells != null) {
            td = TextDescriptor.getCellTextDescriptor().withDisplay(false);
            goodSpacingDRCDate = Variable.newInstance(DRC_LAST_GOOD_DATE_SPACING, new Long(revisionDate + 1L), td);
        }
        if (goodAreaDRCCells != null) {
            td = TextDescriptor.getCellTextDescriptor().withDisplay(false);
            goodAreaDRCDate = Variable.newInstance(DRC_LAST_GOOD_DATE_AREA, new Long(revisionDate + 1L), td);
        }
        if (!doChangesQuietly) {
            it = Library.getLibraries();
            while (it.hasNext()) {
                lib = it.next();
                cIt = lib.getCells();
                while (cIt.hasNext()) {
                    cell = cIt.next();
                    assert (cell.isLinked());
                    LayoutCell cellInfo = Layout.getCellInfo(cell);
                    cellInfo.compute();
                }
            }
        }
        cellInfos.clear();
        tempRigid.clear();
        it = Library.getLibraries();
        while (it.hasNext()) {
            lib = it.next();
            cIt = lib.getCells();
            while (cIt.hasNext()) {
                cell = cIt.next();
                cell.lowLevelMadeRevision(revisionDate, userName, oldSnapshot.getCellRevision(cell.getId()));
                if (goodSpacingDRCCells != null && goodSpacingDRCCells.contains(cell)) {
                    cell.addVar(goodSpacingDRCDate);
                    cell.addVar(goodSpacingDRCBit);
                }
                if (goodAreaDRCCells == null || !goodAreaDRCCells.contains(cell)) continue;
                cell.addVar(goodAreaDRCDate);
            }
        }
        EDatabase.serverDatabase().backup();
        goodSpacingDRCCells = null;
        goodAreaDRCCells = null;
        oldSnapshot = null;
    }

    @Override
    public void modifyNodeInst(NodeInst ni, ImmutableNodeInst oD) {
        if (doChangesQuietly) {
            return;
        }
        Layout.getCellInfo(ni.getParent()).modifyNodeInst(ni, oD);
    }

    @Override
    public void modifyArcInst(ArcInst ai, ImmutableArcInst oD) {
        if (doChangesQuietly) {
            return;
        }
        Layout.getCellInfo(ai.getParent()).modifyArcInst(ai, oD);
    }

    @Override
    public void modifyExport(Export pp, ImmutableExport oldD) {
        if (doChangesQuietly) {
            return;
        }
        PortInst oldPi = pp.getParent().getPortInst(oldD.originalNodeId, oldD.originalPortId);
        if (oldPi == pp.getOriginalPort()) {
            return;
        }
        Layout.getCellInfo(pp.getParent()).modifyExport(pp, oldPi);
    }

    @Override
    public void modifyCell(Cell cell, ImmutableCell oD) {
    }

    @Override
    public void modifyLibrary(Library lib, ImmutableLibrary oldD) {
    }

    @Override
    public void newObject(ElectricObject obj) {
        if (doChangesQuietly) {
            return;
        }
        Cell cell = obj.whichCell();
        if (obj == cell) {
            Layout.newCellInfo(cell, null);
        } else if (cell != null) {
            Layout.getCellInfo(cell).newObject(obj);
        }
    }

    @Override
    public void renameIds(IdMapper idMapper) {
        EDatabase database = EDatabase.serverDatabase();
        for (CellId cellId : idMapper.getNewCellIds()) {
            this.newObject(cellId.inDatabase(database));
        }
    }

    public static void setTempRigid(ArcInst ai, boolean tempRigid) {
        ai.checkChanging();
        Layout.tempRigid.put(ai, tempRigid);
    }

    public static void removeTempRigid(ArcInst ai) {
        ai.checkChanging();
        tempRigid.remove(ai);
    }

    public static void setGoodDRCCells(Set<Cell> goodDRCCells, Variable.Key key, int activeBits, boolean inMemory) {
        assert (!inMemory);
        if (key == DRC_LAST_GOOD_DATE_SPACING) {
            goodSpacingDRCCells = goodDRCCells;
            TextDescriptor td = TextDescriptor.getCellTextDescriptor().withDisplay(false);
            goodSpacingDRCBit = Variable.newInstance(DRC_LAST_GOOD_BIT_SPACING, new Integer(activeBits), td);
        } else {
            goodAreaDRCCells = goodDRCCells;
        }
    }

    static boolean isRigid(ArcInst ai) {
        Boolean override = tempRigid.get(ai);
        return override != null ? override.booleanValue() : ai.isRigid();
    }

    private static void makeLayoutCells() {
        cellInfos.clear();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = cIt.next();
                Layout.newCellInfo(cell, oldSnapshot.getCell(cell.getId()));
            }
        }
    }

    static Poly oldPortPosition(PortInst pi) {
        NodeInst ni = pi.getNodeInst();
        PortProto pp = pi.getPortProto();
        AffineTransform subrot = Layout.makeOldRot(ni);
        if (subrot == null) {
            return null;
        }
        NodeInst bottomNi = ni;
        PortProto bottomPP = pp;
        while (bottomNi.isCellInstance()) {
            AffineTransform localtran = Layout.makeOldTrans(bottomNi);
            subrot.concatenate(localtran);
            PortInst bottomPi = Layout.getOldOriginalPort((Export)bottomPP);
            bottomNi = bottomPi.getNodeInst();
            bottomPP = bottomPi.getPortProto();
            localtran = Layout.makeOldRot(bottomNi);
            subrot.concatenate(localtran);
        }
        ImmutableNodeInst d = Layout.getOldD(bottomNi);
        assert (d != null);
        if (d != bottomNi.getD()) {
            bottomNi = NodeInst.makeDummyInstance(bottomNi.getProto());
            bottomNi.lowLevelModify(d);
        }
        PrimitiveNode np = (PrimitiveNode)bottomNi.getProto();
        Technology tech = np.getTechnology();
        Poly poly = tech.getShapeOfPort(bottomNi, (PrimitivePort)bottomPP);
        poly.transform(subrot);
        return poly;
    }

    private static AffineTransform makeOldRot(NodeInst ni) {
        ImmutableNodeInst d = Layout.getOldD(ni);
        if (d == null) {
            return null;
        }
        double cX = d.anchor.getX();
        double cY = d.anchor.getY();
        return d.orient.rotateAbout(cX, cY);
    }

    private static AffineTransform makeOldTrans(NodeInst ni) {
        ImmutableNodeInst d = Layout.getOldD(ni);
        if (d == null) {
            return null;
        }
        AffineTransform transform2 = new AffineTransform();
        double cX = d.anchor.getX();
        double cY = d.anchor.getY();
        transform2.translate(cX, cY);
        return transform2;
    }

    static PortInst getOldOriginalPort(Export e) {
        return Layout.getCellInfo(e.getParent()).getOldOriginalPort(e);
    }

    static ImmutableNodeInst getOldD(NodeInst ni) {
        return Layout.getCellInfo(ni.getParent()).getOldD(ni);
    }

    private static void newCellInfo(Cell cell, CellBackup oldBackup) {
        int cellIndex = cell.getCellIndex();
        while (cellInfos.size() <= cellIndex) {
            cellInfos.add(null);
        }
        cellInfos.set(cellIndex, new LayoutCell(cell, oldBackup));
    }

    static LayoutCell getCellInfo(Cell cell) {
        return cellInfos.get(cell.getCellIndex());
    }

    static {
        cellInfos = new ArrayList();
        tempRigid = new HashMap();
        DRC_LAST_GOOD_DATE_SPACING = Variable.newKey("DRC_last_good_drc_date");
        DRC_LAST_GOOD_BIT_SPACING = Variable.newKey("DRC_last_good_drc_bit");
        DRC_LAST_GOOD_DATE_AREA = Variable.newKey("DRC_last_good_drc_area_date");
    }
}

