/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BitVector;
import com.sun.electric.tool.simulation.test.ChainNode;
import com.sun.electric.tool.simulation.test.JtagTester;
import com.sun.electric.tool.simulation.test.LogicSettableArray;

public class MockJtag
extends JtagTester {
    public static final int NUM_OUTPUT_PINS = 3;
    private LogicSettableArray logicOutput = new LogicSettableArray(3);

    public MockJtag() {
        this.setParallelIO(this.logicOutput.getLogicStates());
    }

    void configure(float tapVolt, long kiloHerz) {
        this.logSet("MockJTAG configure: set tapVolt=" + tapVolt + ", kiloHerz=" + kiloHerz);
    }

    public void reset() {
        this.logSet("MockJTAG reset()");
    }

    public void tms_reset() {
        this.logSet("MockJTAG reset()");
    }

    void disconnect() {
        this.logSet("MockJTAG disconnect()");
    }

    void shift(ChainNode chain, boolean readEnable, boolean writeEnable, int irBadSeverity) {
        this.logOther("MockJTAG shift: opcode=" + chain.getOpcode() + "\n " + chain.getInBits());
        int length = chain.getLength();
        BitVector outBits = new BitVector(length, "MockJtag.shift().outBits");
        BitVector outBitsExpected = chain.getOutBitsExpected();
        for (int ibit = 0; ibit < length; ++ibit) {
            if (outBitsExpected.isValid(ibit)) {
                if (!writeEnable) {
                    outBits.set(ibit, outBitsExpected.get(ibit));
                    continue;
                }
                outBits.putIndiscriminate(ibit, chain.getShadowState().getIndiscriminate(ibit, 1));
                continue;
            }
            outBits.clear(ibit);
        }
        chain.getOutBits().putIndiscriminate(0, outBits);
    }

    private void setParallelIO(boolean[] newLevel) {
        String msg = "Parallel output state now:";
        for (int ind = 0; ind < newLevel.length; ++ind) {
            msg = msg + " " + newLevel[ind];
        }
        System.out.println(msg);
    }

    void setLogicOutput(int index, boolean newLevel) {
        this.logicOutput.setLogicState(index, newLevel);
        this.setParallelIO(this.logicOutput.getLogicStates());
    }
}

