/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.XMLRules;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.user.User;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoCMOS
extends Technology {
    public static final int SCMOSRULES = 0;
    public static final int SUBMRULES = 1;
    public static final int DEEPRULES = 2;
    public static final Variable.Key TECH_LAST_STATE = Variable.newKey("TECH_last_state");
    public static final Version changeOfMetal6 = Version.parseVersion("8.02o");
    private static final Version scmosTransistorSizeBug = Version.parseVersion("8.08h");
    private static final Version scmosTransistorSizeFix = Version.parseVersion("8.09d");
    private static final String TECH_NAME = "mocmos";
    private static final String XML_PREFIX = "mocmos.";
    private static final String PREF_PREFIX = "technology/technologies/";
    private static final TechFactory.Param techParamRuleSet = new TechFactory.Param("mocmos.MOCMOS Rule Set", "technology/technologies/MoCMOSRuleSet", 1);
    private static final TechFactory.Param techParamNumMetalLayers = new TechFactory.Param("mocmos.NumMetalLayers", "technology/technologies/mocmosNumberOfMetalLayers", 6);
    private static final TechFactory.Param techParamUseSecondPolysilicon = new TechFactory.Param("mocmos.UseSecondPolysilicon", "technology/technologies/mocmosSecondPolysilicon", Boolean.TRUE);
    private static final TechFactory.Param techParamDisallowStackedVias = new TechFactory.Param("mocmos.DisallowStackedVias", "technology/technologies/MoCMOSDisallowStackedVias", Boolean.FALSE);
    private static final TechFactory.Param techParamUseAlternativeActivePolyRules = new TechFactory.Param("mocmos.UseAlternativeActivePolyRules", "technology/technologies/MoCMOSAlternateActivePolyRules", Boolean.FALSE);
    private static final TechFactory.Param techParamAnalog = new TechFactory.Param("mocmos.Analog", "technology/technologies/mocmosAnalog", Boolean.FALSE);
    private Integer paramRuleSet;
    private Boolean paramUseSecondPolysilicon;
    private Boolean paramDisallowStackedVias;
    private Boolean paramUseAlternativeActivePolyRules;
    private Boolean paramAnalog;
    private PrimitiveNode[] metalActiveContactNodes = new PrimitiveNode[2];
    private PrimitiveNode[] scalableTransistorNodes = new PrimitiveNode[2];
    private static final int SCALABLE_ACTIVE_TOP = 0;
    private static final int SCALABLE_METAL_TOP = 1;
    private static final int SCALABLE_CUT_TOP = 2;
    private static final int SCALABLE_ACTIVE_BOT = 3;
    private static final int SCALABLE_METAL_BOT = 4;
    private static final int SCALABLE_CUT_BOT = 5;
    private static final int SCALABLE_ACTIVE_CTR = 6;
    private static final int SCALABLE_POLY = 7;
    private static final int SCALABLE_WELL = 8;
    private static final int SCALABLE_SUBSTRATE = 9;
    private static final int SCALABLE_TOTAL = 10;
    private final Setting cacheRuleSet;
    private final Setting cacheSecondPolysilicon;
    private final Setting cacheDisallowStackedVias;
    private final Setting cacheAlternateActivePolyRules;
    private final Setting cacheAnalog;
    private static final int MOCMOSNOSTACKEDVIAS = 1;
    private static final int MOCMOSMETALS = 28;
    private static final int MOCMOS2METAL = 0;
    private static final int MOCMOS3METAL = 4;
    private static final int MOCMOS4METAL = 8;
    private static final int MOCMOS5METAL = 12;
    private static final int MOCMOS6METAL = 16;
    private static final int MOCMOSRULESET = 96;
    private static final int MOCMOSSUBMRULES = 0;
    private static final int MOCMOSDEEPRULES = 32;
    private static final int MOCMOSSCMOSRULES = 64;
    private static final int MOCMOSALTAPRULES = 128;
    private static final int MOCMOSTWOPOLY = 256;

    public MoCMOS(Generic generic, TechFactory techFactory, Map<TechFactory.Param, Object> techParams, Xml.Technology t) {
        super(generic, techFactory, techParams, t);
        this.cacheRuleSet = this.makeIntSetting("MoCMOSRuleSet", "Technology tab", "MOSIS CMOS rule set", MoCMOS.techParamRuleSet.xmlPath.substring(TECH_NAME.length() + 1), 1, "SCMOS", "Submicron", "Deep");
        this.cacheSecondPolysilicon = this.makeBooleanSetting(this.getTechName() + "SecondPolysilicon", "Technology tab", this.getTechName().toUpperCase() + " CMOS: Second Polysilicon Layer", MoCMOS.techParamUseSecondPolysilicon.xmlPath.substring(TECH_NAME.length() + 1), true);
        this.cacheDisallowStackedVias = this.makeBooleanSetting("MoCMOSDisallowStackedVias", "Technology tab", "MOSIS CMOS: Disallow Stacked Vias", MoCMOS.techParamDisallowStackedVias.xmlPath.substring(TECH_NAME.length() + 1), false);
        this.cacheAlternateActivePolyRules = this.makeBooleanSetting("MoCMOSAlternateActivePolyRules", "Technology tab", "MOSIS CMOS: Alternate Active and Poly Contact Rules", MoCMOS.techParamUseAlternativeActivePolyRules.xmlPath.substring(TECH_NAME.length() + 1), false);
        this.cacheAnalog = this.makeBooleanSetting(this.getTechName() + "Analog", "Technology tab", "MOSIS CMOS: Analog", MoCMOS.techParamAnalog.xmlPath.substring(TECH_NAME.length() + 1), false);
        this.paramRuleSet = (Integer)techParams.get(techParamRuleSet);
        this.paramNumMetalLayers = (Integer)techParams.get(techParamNumMetalLayers);
        this.paramUseSecondPolysilicon = (Boolean)techParams.get(techParamUseSecondPolysilicon);
        this.paramDisallowStackedVias = (Boolean)techParams.get(techParamDisallowStackedVias);
        this.paramUseAlternativeActivePolyRules = (Boolean)techParams.get(techParamUseAlternativeActivePolyRules);
        this.paramAnalog = (Boolean)techParams.get(techParamAnalog);
        this.setStaticTechnology();
        this.metalActiveContactNodes[0] = this.findNodeProto("Metal-1-P-Active-Con");
        this.metalActiveContactNodes[1] = this.findNodeProto("Metal-1-N-Active-Con");
        this.scalableTransistorNodes[0] = this.findNodeProto("P-Transistor-Scalable");
        this.scalableTransistorNodes[1] = this.findNodeProto("N-Transistor-Scalable");
        Iterator<Layer> it = this.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            if (layer.getFunction().isUsed(this.getNumMetals(), this.isSecondPolysilicon() ? 2 : 1)) continue;
            layer.getPureLayerNode().setNotUsed(true);
        }
        PrimitiveNode np = this.findNodeProto("P-Transistor-Scalable");
        if (np != null) {
            np.setCanShrink();
        }
        if ((np = this.findNodeProto("N-Transistor-Scalable")) != null) {
            np.setCanShrink();
        }
        if ((np = this.findNodeProto("NPN-Transistor")) != null) {
            np.setCanShrink();
        }
    }

    @Override
    protected void copyState(Technology that) {
        super.copyState(that);
        MoCMOS mocmos = (MoCMOS)that;
        this.paramRuleSet = mocmos.paramRuleSet;
        this.paramNumMetalLayers = mocmos.paramNumMetalLayers;
        this.paramUseSecondPolysilicon = mocmos.paramUseSecondPolysilicon;
        this.paramDisallowStackedVias = mocmos.paramDisallowStackedVias;
        this.paramUseAlternativeActivePolyRules = mocmos.paramUseAlternativeActivePolyRules;
        this.paramAnalog = mocmos.paramAnalog;
    }

    @Override
    protected void dumpExtraProjectSettings(PrintWriter out, Map<Setting, Object> settings) {
        MoCMOS.printlnSetting(out, settings, this.getRuleSetSetting());
        MoCMOS.printlnSetting(out, settings, this.getSecondPolysiliconSetting());
        MoCMOS.printlnSetting(out, settings, this.getDisallowStackedViasSetting());
        MoCMOS.printlnSetting(out, settings, this.getAlternateActivePolyRulesSetting());
        MoCMOS.printlnSetting(out, settings, this.getAnalogSetting());
    }

    @Override
    protected void genShapeOfNode(AbstractShapeBuilder b, ImmutableNodeInst n, PrimitiveNode pn, Technology.NodeLayer[] primLayers) {
        if (pn != this.scalableTransistorNodes[0] && pn != this.scalableTransistorNodes[1]) {
            b.genShapeOfNode(n, pn, primLayers, null);
            return;
        }
        this.genShapeOfNodeScalable(b, n, pn, null, b.isReasonable());
    }

    private void genShapeOfNodeScalable(AbstractShapeBuilder b, ImmutableNodeInst n, PrimitiveNode pn, VarContext context, boolean reasonable) {
        double activeWidMax;
        int numContacts = 2;
        boolean insetContacts = false;
        String pt = (String)n.getVarValue(TRANS_CONTACT, String.class);
        if (pt != null) {
            for (int i = 0; i < pt.length(); ++i) {
                char chr = pt.charAt(i);
                if (chr == '0' || chr == '1' || chr == '2') {
                    numContacts = chr - 48;
                    continue;
                }
                if (chr != 'i' && chr != 'I') continue;
                insetContacts = true;
            }
        }
        int boxOffset = 6 - numContacts * 3;
        double activeWid = activeWidMax = n.size.getLambdaX() + 3.0;
        Variable var = n.getVar(Schematics.ATTR_WIDTH);
        if (var != null) {
            double requestedWid;
            VarContext evalContext = context;
            if (evalContext == null) {
                evalContext = VarContext.globalContext;
            }
            Object ni = null;
            String extra = var.describe(evalContext, ni);
            Object o = evalContext.evalVar(var, ni);
            if (o != null) {
                extra = o.toString();
            }
            if ((requestedWid = TextUtils.atof(extra)) > activeWid) {
                System.out.println("Warning: " + b.getCellBackup().toString() + ", " + n.name + " requests width of " + requestedWid + " but is only " + activeWid + " wide");
            }
            if (requestedWid < activeWid && requestedWid > 0.0) {
                activeWid = requestedWid;
            }
        }
        double shrinkGate = 0.5 * (activeWidMax - activeWid);
        double shrinkCon = (int)(0.5 * (activeWidMax + 2.0 - Math.max(activeWid, 5.0)));
        Technology.NodeLayer[] layers = pn.getNodeLayers();
        assert (layers.length == 10);
        int count = 10 - boxOffset;
        Technology.NodeLayer[] newNodeLayers = new Technology.NodeLayer[count];
        int fillIndex = 0;
        for (int box = boxOffset; box < 10; ++box) {
            Technology.TechPoint[] oldPoints = layers[box].getPoints();
            Technology.TechPoint[] points = new Technology.TechPoint[oldPoints.length];
            for (int i = 0; i < oldPoints.length; ++i) {
                points[i] = oldPoints[i];
            }
            double shrinkX = 0.0;
            Technology.TechPoint p0 = points[0];
            Technology.TechPoint p1 = points[1];
            double x0 = p0.getX().getAdder();
            double x1 = p1.getX().getAdder();
            double y0 = p0.getY().getAdder();
            double y1 = p1.getY().getAdder();
            switch (box) {
                case 0: 
                case 1: 
                case 2: {
                    shrinkX = shrinkCon;
                    if (!insetContacts) break;
                    y0 -= 0.5;
                    y1 -= 0.5;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    shrinkX = shrinkCon;
                    if (!insetContacts) break;
                    y0 -= 0.5;
                    y1 -= 0.5;
                    break;
                }
                case 6: 
                case 7: {
                    shrinkX = shrinkGate;
                    break;
                }
                case 8: 
                case 9: {
                    if (!insetContacts) break;
                    y0 += 0.5;
                    y1 -= 0.5;
                }
            }
            points[0] = p0.withX(p0.getX().withAdder(x0 += shrinkX)).withY(p0.getY().withAdder(y0));
            points[1] = p1.withX(p1.getX().withAdder(x1 -= shrinkX)).withY(p1.getY().withAdder(y1));
            Technology.NodeLayer oldNl = layers[box];
            newNodeLayers[fillIndex] = oldNl.getRepresentation() == 3 ? Technology.NodeLayer.makeMulticut(oldNl.getLayer(), oldNl.getPortNum(), oldNl.getStyle(), points, oldNl.getMulticutSizeX(), oldNl.getMulticutSizeY(), oldNl.getMulticutSep1D(), oldNl.getMulticutSep2D()) : new Technology.NodeLayer(oldNl.getLayer(), oldNl.getPortNum(), oldNl.getStyle(), oldNl.getRepresentation(), points);
            ++fillIndex;
        }
        b.genShapeOfNode(n, pn, newNodeLayers, null);
    }

    @Override
    protected XMLRules makeFactoryDesignRules() {
        Foundry foundry = this.getSelectedFoundry();
        List<DRCTemplate> theRules = foundry.getRules();
        XMLRules rules = new XMLRules(this);
        boolean pSubstrateProcess = User.isPSubstrateProcessLayoutTechnology();
        assert (foundry != null);
        int numMetals = this.getNumMetals();
        int rulesMode = this.getRuleSet();
        for (int pass = 0; pass < 2; ++pass) {
            for (DRCTemplate rule : theRules) {
                if (pass == 0 ? rule.ruleType == DRCTemplate.DRCRuleType.NODSIZ : rule.ruleType != DRCTemplate.DRCRuleType.NODSIZ) continue;
                int when = rule.when;
                boolean goodrule = true;
                if ((when & (DRCTemplate.DRCMode.DE.mode() | DRCTemplate.DRCMode.SU.mode() | DRCTemplate.DRCMode.SC.mode())) != 0) {
                    switch (rulesMode) {
                        case 2: {
                            if ((when & DRCTemplate.DRCMode.DE.mode()) != 0) break;
                            goodrule = false;
                            break;
                        }
                        case 1: {
                            if ((when & DRCTemplate.DRCMode.SU.mode()) != 0) break;
                            goodrule = false;
                            break;
                        }
                        case 0: {
                            if ((when & DRCTemplate.DRCMode.SC.mode()) != 0) break;
                            goodrule = false;
                        }
                    }
                    if (!goodrule) continue;
                }
                if ((when & (DRCTemplate.DRCMode.M2.mode() | DRCTemplate.DRCMode.M3.mode() | DRCTemplate.DRCMode.M4.mode() | DRCTemplate.DRCMode.M5.mode() | DRCTemplate.DRCMode.M6.mode())) != 0) {
                    switch (numMetals) {
                        case 2: {
                            if ((when & DRCTemplate.DRCMode.M2.mode()) != 0) break;
                            goodrule = false;
                            break;
                        }
                        case 3: {
                            if ((when & DRCTemplate.DRCMode.M3.mode()) != 0) break;
                            goodrule = false;
                            break;
                        }
                        case 4: {
                            if ((when & DRCTemplate.DRCMode.M4.mode()) != 0) break;
                            goodrule = false;
                            break;
                        }
                        case 5: {
                            if ((when & DRCTemplate.DRCMode.M5.mode()) != 0) break;
                            goodrule = false;
                            break;
                        }
                        case 6: {
                            if ((when & DRCTemplate.DRCMode.M6.mode()) != 0) break;
                            goodrule = false;
                        }
                    }
                    if (!goodrule) continue;
                }
                if ((when & DRCTemplate.DRCMode.AC.mode()) != 0 && !this.isAlternateActivePolyRules() || (when & DRCTemplate.DRCMode.NAC.mode()) != 0 && this.isAlternateActivePolyRules() || (when & DRCTemplate.DRCMode.SV.mode()) != 0 && this.isDisallowStackedVias() || (when & DRCTemplate.DRCMode.NSV.mode()) != 0 && !this.isDisallowStackedVias() || (when & DRCTemplate.DRCMode.AN.mode()) != 0 && !this.isAnalog()) continue;
                String proc = "";
                if ((when & (DRCTemplate.DRCMode.DE.mode() | DRCTemplate.DRCMode.SU.mode() | DRCTemplate.DRCMode.SC.mode())) != 0) {
                    switch (rulesMode) {
                        case 2: {
                            proc = "DEEP";
                            break;
                        }
                        case 1: {
                            proc = "SUBM";
                            break;
                        }
                        case 0: {
                            proc = "SCMOS";
                        }
                    }
                }
                String metal = "";
                if ((when & (DRCTemplate.DRCMode.M2.mode() | DRCTemplate.DRCMode.M3.mode() | DRCTemplate.DRCMode.M4.mode() | DRCTemplate.DRCMode.M5.mode() | DRCTemplate.DRCMode.M6.mode())) != 0) {
                    switch (this.getNumMetals()) {
                        case 2: {
                            metal = "2m";
                            break;
                        }
                        case 3: {
                            metal = "3m";
                            break;
                        }
                        case 4: {
                            metal = "4m";
                            break;
                        }
                        case 5: {
                            metal = "5m";
                            break;
                        }
                        case 6: {
                            metal = "6m";
                        }
                    }
                    if (!goodrule) continue;
                }
                String ruleName = rule.ruleName;
                String extraString = metal + proc;
                if (extraString.length() > 0 && ruleName.indexOf(extraString) == -1) {
                    rule = new DRCTemplate(rule);
                    rule.ruleName = rule.ruleName + ", " + extraString;
                }
                rules.loadDRCRules(this, foundry, rule, pSubstrateProcess);
            }
        }
        return rules;
    }

    @Override
    public Technology.SizeCorrector getSizeCorrector(Version version, Map<Setting, Object> projectSettings, boolean isJelib, boolean keepExtendOverMin) {
        Object secondPolysiliconValue;
        Technology.SizeCorrector sc = super.getSizeCorrector(version, projectSettings, isJelib, keepExtendOverMin);
        int ruleSet = 1;
        Object ruleSetValue = projectSettings.get(this.getRuleSetSetting());
        if (ruleSetValue instanceof Integer) {
            ruleSet = (Integer)ruleSetValue;
        }
        if (ruleSet == 0 && version.compareTo(scmosTransistorSizeBug) >= 0 && version.compareTo(scmosTransistorSizeFix) < 0) {
            this.setNodeCorrection(sc, "P-Transistor", 1.0, 2.0);
            this.setNodeCorrection(sc, "N-Transistor", 1.0, 2.0);
        }
        if (!keepExtendOverMin) {
            return sc;
        }
        boolean newDefaults = version.compareTo(Version.parseVersion("8.04u")) >= 0;
        int numMetals = newDefaults ? 6 : 4;
        boolean isSecondPolysilicon = newDefaults;
        Object numMetalsValue = projectSettings.get(this.getNumMetalsSetting());
        if (numMetalsValue instanceof Integer) {
            numMetals = (Integer)numMetalsValue;
        }
        if ((secondPolysiliconValue = projectSettings.get(this.getSecondPolysiliconSetting())) instanceof Boolean) {
            isSecondPolysilicon = (Boolean)secondPolysiliconValue;
        } else if (secondPolysiliconValue instanceof Integer) {
            boolean bl = isSecondPolysilicon = (Integer)secondPolysiliconValue != 0;
        }
        if (numMetals == this.getNumMetals() && isSecondPolysilicon == this.isSecondPolysilicon() && ruleSet == this.getRuleSet() && version.compareTo(changeOfMetal6) >= 0) {
            return sc;
        }
        this.setArcCorrection(sc, "Polysilicon-2", ruleSet == 0 ? 3.0 : 7.0);
        this.setArcCorrection(sc, "Metal-3", numMetals <= 3 ? (double)(ruleSet == 0 ? 6 : 5) : 3.0);
        this.setArcCorrection(sc, "Metal-4", numMetals <= 4 ? 6.0 : 3.0);
        this.setArcCorrection(sc, "Metal-5", numMetals <= 5 ? 4.0 : 3.0);
        if (version.compareTo(changeOfMetal6) < 0) {
            this.setArcCorrection(sc, "Metal-6", 4.0);
        }
        return sc;
    }

    public int getRuleSet() {
        return this.paramRuleSet;
    }

    public Setting getRuleSetSetting() {
        return this.cacheRuleSet;
    }

    public boolean isSecondPolysilicon() {
        return this.paramUseSecondPolysilicon;
    }

    public Setting getSecondPolysiliconSetting() {
        return this.cacheSecondPolysilicon;
    }

    public boolean isDisallowStackedVias() {
        return this.paramDisallowStackedVias;
    }

    public Setting getDisallowStackedViasSetting() {
        return this.cacheDisallowStackedVias;
    }

    public boolean isAlternateActivePolyRules() {
        return this.paramUseAlternativeActivePolyRules;
    }

    public Setting getAlternateActivePolyRulesSetting() {
        return this.cacheAlternateActivePolyRules;
    }

    public boolean isAnalog() {
        return this.paramAnalog;
    }

    public Setting getAnalogSetting() {
        return this.cacheAnalog;
    }

    @Override
    public Map<Setting, Object> convertOldVariable(String varName, Object value) {
        if (varName.equals("MoCMOSNumberOfMetalLayers") || varName.equals("MOCMOSNumberOfMetalLayers")) {
            return Collections.singletonMap(this.getNumMetalsSetting(), value);
        }
        if (varName.equals("MoCMOSSecondPolysilicon")) {
            return Collections.singletonMap(this.getSecondPolysiliconSetting(), value);
        }
        if (!varName.equalsIgnoreCase(TECH_LAST_STATE.getName())) {
            return null;
        }
        if (!(value instanceof Integer)) {
            return null;
        }
        int oldBits = (Integer)value;
        HashMap<Setting, Object> settings = new HashMap<Setting, Object>();
        boolean oldNoStackedVias = (oldBits & 1) != 0;
        settings.put(this.getDisallowStackedViasSetting(), new Integer(oldNoStackedVias ? 1 : 0));
        int numMetals = 0;
        switch (oldBits & 0x1C) {
            case 0: {
                numMetals = 2;
                break;
            }
            case 4: {
                numMetals = 3;
                break;
            }
            case 8: {
                numMetals = 4;
                break;
            }
            case 12: {
                numMetals = 5;
                break;
            }
            case 16: {
                numMetals = 6;
            }
        }
        settings.put(this.getNumMetalsSetting(), new Integer(numMetals));
        int ruleSet = 0;
        switch (oldBits & 0x60) {
            case 0: {
                ruleSet = 1;
                break;
            }
            case 32: {
                ruleSet = 2;
                break;
            }
            case 64: {
                ruleSet = 0;
            }
        }
        settings.put(this.getRuleSetSetting(), new Integer(ruleSet));
        boolean alternateContactRules = (oldBits & 0x80) != 0;
        settings.put(this.getAlternateActivePolyRulesSetting(), new Integer(alternateContactRules ? 1 : 0));
        boolean secondPoly = (oldBits & 0x100) != 0;
        settings.put(this.getSecondPolysiliconSetting(), new Integer(secondPoly ? 1 : 0));
        return settings;
    }

    public static List<TechFactory.Param> getTechParams() {
        return Arrays.asList(techParamRuleSet, techParamNumMetalLayers, techParamUseSecondPolysilicon, techParamDisallowStackedVias, techParamUseAlternativeActivePolyRules, techParamAnalog);
    }

    public static Xml.Technology getPatchedXml(Map<TechFactory.Param, Object> params) {
        boolean polyFlag;
        boolean analogFlag;
        int i;
        int i2;
        int ruleSet = (Integer)params.get(techParamRuleSet);
        int numMetals = (Integer)params.get(techParamNumMetalLayers);
        boolean secondPolysilicon = (Boolean)params.get(techParamUseSecondPolysilicon);
        boolean disallowStackedVias = (Boolean)params.get(techParamDisallowStackedVias);
        boolean alternateContactRules = (Boolean)params.get(techParamUseAlternativeActivePolyRules);
        boolean isAnalog = (Boolean)params.get(techParamAnalog);
        Xml.Technology tech = Xml.parseTechnology(MoCMOS.class.getResource("mocmos.xml"));
        if (tech == null) {
            return null;
        }
        Xml.Layer[] metalLayers = new Xml.Layer[6];
        Xml.ArcProto[] metalArcs = new Xml.ArcProto[6];
        Xml.ArcProto[] activeArcs = new Xml.ArcProto[2];
        Xml.ArcProto[] polyArcs = new Xml.ArcProto[6];
        Xml.PrimitiveNodeGroup[] metalPinNodes = new Xml.PrimitiveNodeGroup[9];
        Xml.PrimitiveNodeGroup[] activePinNodes = new Xml.PrimitiveNodeGroup[2];
        Xml.PrimitiveNodeGroup[] polyPinNodes = new Xml.PrimitiveNodeGroup[2];
        Xml.PrimitiveNodeGroup[] metalContactNodes = new Xml.PrimitiveNodeGroup[8];
        Xml.PrimitiveNodeGroup[] metalWellContactNodes = new Xml.PrimitiveNodeGroup[2];
        Xml.PrimitiveNodeGroup[] metalActiveContactNodes = new Xml.PrimitiveNodeGroup[2];
        ArrayList<Xml.PrimitiveNodeGroup> metal1PolyContactNodes = new ArrayList<Xml.PrimitiveNodeGroup>(4);
        Xml.PrimitiveNodeGroup[] transistorNodeGroups = new Xml.PrimitiveNodeGroup[2];
        Xml.PrimitiveNodeGroup[] scalableTransistorNodes = new Xml.PrimitiveNodeGroup[2];
        Xml.PrimitiveNodeGroup npnTransistorNode = tech.findNodeGroup("NPN-Transistor");
        Xml.PrimitiveNodeGroup polyCapNode = tech.findNodeGroup("Poly1-Poly2-Capacitor");
        HashSet<Xml.PrimitiveNodeGroup> analogElems = new HashSet<Xml.PrimitiveNodeGroup>();
        analogElems.add(tech.findNodeGroup("N-Active-Resistor"));
        analogElems.add(tech.findNodeGroup("N-No-Silicide-Poly-Resistor"));
        analogElems.add(tech.findNodeGroup("N-Well-Resistor"));
        analogElems.add(tech.findNodeGroup("P-Well-Resistor"));
        analogElems.add(tech.findNodeGroup("P-No-Silicide-Poly-Resistor"));
        analogElems.add(tech.findNodeGroup("P-Poly-Resistor"));
        analogElems.add(tech.findNodeGroup("NPN-Transistor"));
        analogElems.add(tech.findNodeGroup("P-Active-Resistor"));
        analogElems.add(tech.findNodeGroup("N-Poly-Resistor"));
        analogElems.add(tech.findNodeGroup("Hi-Res-Poly2-Resistor"));
        analogElems.remove(null);
        assert (analogElems.size() == 10 && polyCapNode != null);
        for (i2 = 0; i2 < metalLayers.length; ++i2) {
            metalLayers[i2] = tech.findLayer("Metal-" + (i2 + 1));
            metalArcs[i2] = tech.findArc("Metal-" + (i2 + 1));
            metalPinNodes[i2] = tech.findNodeGroup("Metal-" + (i2 + 1) + "-Pin");
            if (i2 >= metalContactNodes.length) continue;
            metalContactNodes[i2] = tech.findNodeGroup("Metal-" + (i2 + 1) + "-Metal-" + (i2 + 2) + "-Con");
        }
        for (i2 = 0; i2 < 2; ++i2) {
            polyArcs[i2] = tech.findArc("Polysilicon-" + (i2 + 1));
            polyPinNodes[i2] = tech.findNodeGroup("Polysilicon-" + (i2 + 1) + "-Pin");
            metal1PolyContactNodes.add(tech.findNodeGroup("Metal-1-Polysilicon-" + (i2 + 1) + "-Con"));
        }
        metal1PolyContactNodes.add(tech.findNodeGroup("Metal-1-Polysilicon-1-2-Con"));
        metal1PolyContactNodes.add(polyCapNode);
        for (i2 = 0; i2 <= 1; ++i2) {
            String ts = i2 == 0 ? "P" : "N";
            activeArcs[i2] = tech.findArc(ts + "-Active");
            activePinNodes[i2] = tech.findNodeGroup(ts + "-Active-Pin");
            metalWellContactNodes[i2] = tech.findNodeGroup("Metal-1-" + ts + "-Well-Con");
            metalActiveContactNodes[i2] = tech.findNodeGroup("Metal-1-" + ts + "-Active-Con");
            transistorNodeGroups[i2] = tech.findNodeGroup(ts + "-Transistor");
            scalableTransistorNodes[i2] = tech.findNodeGroup(ts + "-Transistor-Scalable");
        }
        String rules = "";
        switch (ruleSet) {
            case 0: {
                rules = "now standard";
                break;
            }
            case 2: {
                rules = "now deep";
                break;
            }
            case 1: {
                rules = "now submicron";
            }
        }
        int numPolys = 1;
        if (secondPolysilicon) {
            numPolys = 2;
        }
        String description = "MOSIS CMOS (2-6 metals [now " + numMetals + "], 1-2 polys [now " + numPolys + "], flex rules [" + rules + "]";
        if (disallowStackedVias) {
            description = description + ", stacked vias disallowed";
        }
        if (alternateContactRules) {
            description = description + ", alternate contact rules";
        }
        tech.description = description = description + ")";
        ResizeData rd = new ResizeData(ruleSet, numMetals, alternateContactRules);
        for (i = 0; i < 6; ++i) {
            MoCMOS.resizeArcPin(metalArcs[i], metalPinNodes[i], 0.5 * rd.metal_width[i]);
            if (i >= 5) continue;
            Xml.PrimitiveNodeGroup via = metalContactNodes[i];
            Xml.NodeLayer nl = via.nodeLayers.get(2);
            nl.sizex = nl.sizey = rd.via_size[i];
            nl.sep1d = rd.via_inline_spacing[i];
            nl.sep2d = rd.via_array_spacing[i];
            if (i + 1 >= numMetals) continue;
            double halfSize = 0.5 * rd.via_size[i] + rd.via_overhang[i + 1];
            MoCMOS.resizeSquare(via, halfSize, halfSize, halfSize, 0.0);
        }
        for (i = 0; i <= 1; ++i) {
            double activeE = 0.5 * 3.0;
            double wellE = activeE + rd.nwell_overhang_diff_p;
            double selectE = activeE + 2.0;
            MoCMOS.resizeArcPin(activeArcs[i], activePinNodes[i], activeE, wellE, selectE);
            Xml.PrimitiveNodeGroup con = metalActiveContactNodes[i];
            double metalC = 0.5 * 2.0 + 1.0;
            double activeC = 0.5 * 2.0 + rd.diff_contact_overhang;
            double wellC = activeC + rd.nwell_overhang_diff_p;
            double selectC = activeC + 2.0;
            MoCMOS.resizeSquare(con, activeC, metalC, activeC, wellC, selectC, 0.0);
            MoCMOS.resizeContacts(con, rd);
            con = metalWellContactNodes[i];
            wellC = activeC + 3.0;
            MoCMOS.resizeSquare(con, activeC, metalC, activeC, wellC, selectC, 0.0);
            MoCMOS.resizeContacts(con, rd);
            MoCMOS.resizeSerpentineTransistor(transistorNodeGroups[i], rd);
            MoCMOS.resizeScalableTransistor(scalableTransistorNodes[i], rd);
        }
        MoCMOS.resizeContacts(npnTransistorNode, rd);
        Xml.PrimitiveNodeGroup con = (Xml.PrimitiveNodeGroup)metal1PolyContactNodes.get(0);
        double metalC = 0.5 * 2.0 + 1.0;
        double polyC = 0.5 * 2.0 + rd.contact_poly_overhang;
        MoCMOS.resizeSquare(con, polyC, metalC, polyC, 0.0);
        for (Xml.PrimitiveNodeGroup g : metal1PolyContactNodes) {
            MoCMOS.resizeContacts(g, rd);
        }
        MoCMOS.resizeArcPin(polyArcs[0], polyPinNodes[0], 0.5 * 2.0);
        MoCMOS.resizeArcPin(polyArcs[1], polyPinNodes[1], 0.5 * rd.poly2_width);
        for (int i3 = numMetals; i3 < 6; ++i3) {
            metalArcs[i3].notUsed = true;
            metalPinNodes[i3].notUsed = true;
            metalContactNodes[i3 - 1].notUsed = true;
            assert (tech.menuPalette.menuBoxes.get(3 * (6 + numMetals)).get(0) == metalArcs[i3]);
            tech.menuPalette.menuBoxes.remove(3 * (6 + numMetals));
            tech.menuPalette.menuBoxes.remove(3 * (6 + numMetals));
            tech.menuPalette.menuBoxes.remove(3 * (6 + numMetals));
        }
        tech.menuPalette.menuBoxes.get(3 * (6 + numMetals) - 1).clear();
        if (!secondPolysilicon) {
            polyArcs[1].notUsed = true;
            polyPinNodes[1].notUsed = true;
            ((Xml.PrimitiveNodeGroup)metal1PolyContactNodes.get((int)1)).notUsed = true;
            ((Xml.PrimitiveNodeGroup)metal1PolyContactNodes.get((int)2)).notUsed = true;
            assert (tech.menuPalette.menuBoxes.get(15).get(0) == polyArcs[1]);
            tech.menuPalette.menuBoxes.remove(15);
            tech.menuPalette.menuBoxes.remove(15);
            tech.menuPalette.menuBoxes.remove(15);
        }
        if (isAnalog) {
            analogFlag = false;
            polyFlag = false;
            if (!secondPolysilicon) {
                assert (((Xml.MenuNodeInst)tech.menuPalette.menuBoxes.get((int)0).get((int)1)).protoName.equals(polyCapNode.nodes.get((int)0).name));
                tech.menuPalette.menuBoxes.get(0).remove(1);
                polyFlag = true;
            }
        } else {
            assert (tech.menuPalette.menuBoxes.get(0).get(0) == npnTransistorNode.nodes.get(0));
            tech.menuPalette.menuBoxes.get(0).clear();
            analogFlag = true;
            polyFlag = true;
        }
        if (polyCapNode != null) {
            polyCapNode.notUsed = polyFlag;
        }
        for (Xml.PrimitiveNodeGroup elem : analogElems) {
            if (elem == null) continue;
            elem.notUsed = analogFlag;
        }
        return tech;
    }

    private static void resizeArcPin(Xml.ArcProto a, Xml.PrimitiveNodeGroup ng, double ... exts) {
        assert (a.arcLayers.size() == exts.length);
        assert (ng.nodeLayers.size() == exts.length);
        double baseExt = exts[0];
        double maxExt = 0.0;
        for (int i = 0; i < exts.length; ++i) {
            Xml.ArcLayer al = a.arcLayers.get(i);
            Xml.NodeLayer nl = ng.nodeLayers.get(i);
            double ext = exts[i];
            assert (al.layer.equals(nl.layer));
            assert (nl.representation == 1);
            al.extend.value = ext;
            nl.hx.value = nl.hy.value = ext;
            nl.ly.value = ext == 0.0 ? 0.0 : -ext;
            nl.lx.value = nl.ly.value;
            maxExt = Math.max(maxExt, ext);
        }
        Integer version2 = 2;
        if (baseExt != 0.0) {
            a.diskOffset.put(version2, baseExt);
        } else {
            a.diskOffset.clear();
        }
        ng.baseLY.value = baseExt != 0.0 ? -baseExt : 0.0;
        ng.baseLX.value = ng.baseLY.value;
        ng.baseHX.value = ng.baseHY.value = baseExt;
    }

    private static void resizeSquare(Xml.PrimitiveNodeGroup ng, double base, double ... size) {
        assert (size.length == ng.nodeLayers.size());
        double maxSz = 0.0;
        for (int i = 0; i < ng.nodeLayers.size(); ++i) {
            Xml.NodeLayer nl = ng.nodeLayers.get(i);
            assert (nl.representation == 1 || nl.representation == 3);
            double sz = size[i];
            assert (sz >= 0.0);
            nl.hx.value = nl.hy.value = sz;
            nl.ly.value = sz == 0.0 ? 0.0 : -sz;
            nl.lx.value = nl.ly.value;
            maxSz = Math.max(maxSz, sz);
        }
        Integer version1 = 1;
        Integer version2 = 2;
        EPoint sizeCorrector1 = ng.diskOffset.get(version1);
        EPoint sizeCorrector2 = ng.diskOffset.get(version2);
        if (sizeCorrector2 == null) {
            sizeCorrector2 = EPoint.ORIGIN;
        }
        if (sizeCorrector1 == null) {
            sizeCorrector1 = sizeCorrector2;
        }
        ng.baseLY.value = base != 0.0 ? -base : 0.0;
        ng.baseLX.value = ng.baseLY.value;
        ng.baseHX.value = ng.baseHY.value = base;
        sizeCorrector2 = EPoint.fromLambda(base, base);
        ng.diskOffset.put(version2, sizeCorrector2);
        if (sizeCorrector1.equals(sizeCorrector2)) {
            ng.diskOffset.remove(version1);
        } else {
            ng.diskOffset.put(version1, sizeCorrector1);
        }
    }

    private static void resizeContacts(Xml.PrimitiveNodeGroup ng, ResizeData rd) {
        if (ng == null) {
            return;
        }
        for (Xml.NodeLayer nl : ng.nodeLayers) {
            if (nl.representation != 3) continue;
            nl.sizey = 2.0;
            nl.sizex = 2.0;
            nl.sep1d = rd.contact_spacing;
            nl.sep2d = rd.contact_array_spacing;
        }
    }

    private static void resizeSerpentineTransistor(Xml.PrimitiveNodeGroup transistor, ResizeData rd) {
        Xml.NodeLayer activeTNode = transistor.nodeLayers.get(0);
        Xml.NodeLayer activeBNode = transistor.nodeLayers.get(1);
        Xml.NodeLayer polyCNode = transistor.nodeLayers.get(2);
        Xml.NodeLayer polyLNode = transistor.nodeLayers.get(3);
        Xml.NodeLayer polyRNode = transistor.nodeLayers.get(4);
        Xml.NodeLayer activeNode = transistor.nodeLayers.get(5);
        Xml.NodeLayer polyNode = transistor.nodeLayers.get(6);
        Xml.NodeLayer wellNode = transistor.nodeLayers.get(7);
        Xml.NodeLayer selNode = transistor.nodeLayers.get(8);
        Xml.NodeLayer thickNode = transistor.nodeLayers.get(9);
        double hw = 0.5 * 3.0;
        double hl = 0.5 * 2.0;
        double gateX = hw;
        double gateY = hl;
        double polyX = gateX + rd.poly_endcap;
        double polyY = gateY;
        double diffX = gateX;
        double diffY = gateY + rd.diff_poly_overhang;
        double wellX = diffX + rd.nwell_overhang_diff_p;
        double wellY = diffY + rd.nwell_overhang_diff_p;
        double selX = diffX + 2.0;
        double selY = diffY + 2.0;
        double thickX = diffX + 4.0;
        double thickY = diffY + 4.0;
        MoCMOS.resizeSerpentineLayer(activeTNode, hw, -gateX, gateX, gateY, diffY);
        MoCMOS.resizeSerpentineLayer(activeBNode, hw, -diffX, diffX, -diffY, -gateY);
        MoCMOS.resizeSerpentineLayer(polyCNode, hw, -gateX, gateX, -gateY, gateY);
        MoCMOS.resizeSerpentineLayer(polyLNode, hw, -polyX, -gateX, -polyY, polyY);
        MoCMOS.resizeSerpentineLayer(polyRNode, hw, gateX, polyX, -polyY, polyY);
        MoCMOS.resizeSerpentineLayer(activeNode, hw, -diffX, diffX, -diffY, diffY);
        MoCMOS.resizeSerpentineLayer(polyNode, hw, -polyX, polyX, -polyY, polyY);
        MoCMOS.resizeSerpentineLayer(wellNode, hw, -wellX, wellX, -wellY, wellY);
        MoCMOS.resizeSerpentineLayer(selNode, hw, -selX, selX, -selY, selY);
        MoCMOS.resizeSerpentineLayer(thickNode, hw, -thickX, thickX, -thickY, thickY);
    }

    private static void resizeSerpentineLayer(Xml.NodeLayer nl, double hw, double lx, double hx, double ly, double hy) {
        nl.lx.value = lx;
        nl.hx.value = hx;
        nl.ly.value = ly;
        nl.hy.value = hy;
        nl.lWidth = nl.hy.k == 1.0 ? hy : 0.0;
        nl.rWidth = nl.ly.k == -1.0 ? -ly : 0.0;
        nl.tExtent = nl.hx.k == 1.0 ? hx - hw : 0.0;
        nl.bExtent = nl.lx.k == -1.0 ? -lx - hw : 0.0;
    }

    private static void resizeScalableTransistor(Xml.PrimitiveNodeGroup transistor, ResizeData rd) {
        Xml.NodeLayer activeTNode = transistor.nodeLayers.get(0);
        Xml.NodeLayer metalTNode = transistor.nodeLayers.get(1);
        Xml.NodeLayer cutTNode = transistor.nodeLayers.get(2);
        Xml.NodeLayer activeBNode = transistor.nodeLayers.get(3);
        Xml.NodeLayer metalBNode = transistor.nodeLayers.get(4);
        Xml.NodeLayer cutBNode = transistor.nodeLayers.get(5);
        Xml.NodeLayer activeCNode = transistor.nodeLayers.get(6);
        Xml.NodeLayer polyCNode = transistor.nodeLayers.get(7);
        Xml.NodeLayer wellNode = transistor.nodeLayers.get(8);
        Xml.NodeLayer selNode = transistor.nodeLayers.get(9);
        double hw = 0.5 * 3.0;
        double hl = 0.5 * 2.0;
        double gateX = hw;
        double gateY = hl;
        double polyX = gateX + rd.poly_endcap;
        double polyY = gateY;
        double diffX = gateX;
        double diffY = gateY + rd.diff_poly_overhang;
        double metalC = 0.5 * 2.0 + 1.0;
        double activeC = 0.5 * 2.0 + rd.diff_contact_overhang;
        double wellC = activeC + rd.nwell_overhang_diff_p;
        double selectC = activeC + 2.0;
        double cutY = hl + 1.0 + activeC;
        MoCMOS.resizeScalableLayer(activeTNode, -activeC, activeC, cutY - activeC, cutY + activeC);
        MoCMOS.resizeScalableLayer(metalTNode, -metalC, metalC, cutY - metalC, cutY + metalC);
        MoCMOS.resizeScalableLayer(cutTNode, 0.0, 0.0, cutY, cutY);
        MoCMOS.resizeScalableLayer(activeBNode, -activeC, activeC, -cutY - activeC, -cutY + activeC);
        MoCMOS.resizeScalableLayer(metalBNode, -metalC, metalC, -cutY - metalC, -cutY + metalC);
        MoCMOS.resizeScalableLayer(cutBNode, 0.0, 0.0, -cutY, -cutY);
        MoCMOS.resizeScalableLayer(activeCNode, -diffX, diffX, -diffY, diffY);
        MoCMOS.resizeScalableLayer(polyCNode, -polyX, polyX, -polyY, polyY);
        MoCMOS.resizeScalableLayer(wellNode, -wellC, wellC, -cutY - wellC, cutY + wellC);
        MoCMOS.resizeScalableLayer(selNode, -selectC, selectC, -cutY - selectC, cutY + selectC);
        MoCMOS.resizeContacts(transistor, rd);
    }

    private static void resizeScalableLayer(Xml.NodeLayer nl, double lx, double hx, double ly, double hy) {
        nl.lx.value = lx;
        nl.hx.value = hx;
        nl.ly.value = ly;
        nl.hy.value = hy;
    }

    @Override
    protected Technology.State newState(Map<TechFactory.Param, Object> paramValues) {
        int maxNumMetals;
        int minNumMetals;
        LinkedHashMap<TechFactory.Param, Object> fixedParamValues = new LinkedHashMap<TechFactory.Param, Object>();
        for (TechFactory.Param param : this.techFactory.getTechParams()) {
            Object value = paramValues.get(param);
            if (value == null || value.getClass() != param.factoryValue.getClass()) {
                value = param.factoryValue;
            }
            fixedParamValues.put(param, value);
        }
        int ruleSet = (Integer)fixedParamValues.get(techParamRuleSet);
        int numMetals = (Integer)fixedParamValues.get(techParamNumMetalLayers);
        if (ruleSet < 0 || ruleSet > 2) {
            ruleSet = 1;
            fixedParamValues.put(techParamRuleSet, ruleSet);
        }
        switch (ruleSet) {
            case 0: {
                minNumMetals = 2;
                maxNumMetals = 4;
                break;
            }
            case 1: {
                minNumMetals = 2;
                maxNumMetals = 6;
                break;
            }
            case 2: {
                minNumMetals = 5;
                maxNumMetals = 6;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (numMetals < minNumMetals || numMetals > maxNumMetals) {
            numMetals = Math.min(Math.max(numMetals, minNumMetals), maxNumMetals);
            fixedParamValues.put(techParamNumMetalLayers, numMetals);
        }
        return super.newState(fixedParamValues);
    }

    @Override
    public PrimitivePort convertOldPortName(String portName, PrimitiveNode np) {
        String[] transistorPorts = new String[]{"poly-left", "diff-top", "poly-right", "diff-bottom"};
        for (int i = 0; i < transistorPorts.length; ++i) {
            if (!portName.endsWith(transistorPorts[i])) continue;
            return (PrimitivePort)np.findPortProto(transistorPorts[i]);
        }
        return super.convertOldPortName(portName, np);
    }

    @Override
    public PortInst getTransistorBiasPort(NodeInst ni) {
        return ni.getPortInst(4);
    }

    private static class ResizeData {
        private final double diff_width = 3.0;
        private final double diff_poly_overhang;
        private final double diff_contact_overhang;
        private final double thick_overhang = 4.0;
        private final double poly_width = 2.0;
        private final double poly_endcap;
        private final double poly_diff_spacing = 1.0;
        private final double gate_length = 2.0;
        private final double gate_width = 3.0;
        private final double gate_contact_spacing = 2.0;
        private final double poly2_width;
        private final double contact_size = 2.0;
        private final double contact_spacing;
        private final double contact_array_spacing;
        private final double contact_metal_overhang_all_sides = 1.0;
        private final double contact_poly_overhang;
        private final double nplus_overhang_diff = 2.0;
        private final double pplus_overhang_diff = 2.0;
        private final double well_width;
        private final double nwell_overhang_diff_p;
        private final double nwell_overhang_diff_n = 3.0;
        private final double[] metal_width;
        private final double[] via_size;
        private final double[] via_inline_spacing;
        private final double[] via_array_spacing;
        private final double[] via_overhang;

        ResizeData(int ruleSet, int numMetals, boolean alternateContactRules) {
            block0 : switch (ruleSet) {
                case 1: {
                    this.diff_poly_overhang = 3.0;
                    this.poly_endcap = 2.0;
                    this.poly2_width = 7.0;
                    this.contact_spacing = 3.0;
                    this.well_width = 12.0;
                    this.nwell_overhang_diff_p = 6.0;
                    switch (numMetals) {
                        case 2: {
                            this.metal_width = new double[]{3.0, 3.0, 0.0, 0.0, 0.0, 5.0};
                            this.via_size = new double[]{2.0, 2.0, 2.0, 2.0, 3.0};
                            this.via_inline_spacing = new double[]{3.0, 3.0, 3.0, 3.0, 4.0};
                            this.via_overhang = new double[]{1.0, 1.0};
                            break block0;
                        }
                        case 3: {
                            this.metal_width = new double[]{3.0, 3.0, 5.0, 0.0, 0.0, 5.0};
                            this.via_size = new double[]{2.0, 2.0, 2.0, 2.0, 3.0};
                            this.via_inline_spacing = new double[]{3.0, 3.0, 3.0, 3.0, 4.0};
                            this.via_overhang = new double[]{1.0, 1.0, 2.0};
                            break block0;
                        }
                        case 4: {
                            this.metal_width = new double[]{3.0, 3.0, 3.0, 6.0, 0.0, 5.0};
                            this.via_size = new double[]{2.0, 2.0, 2.0, 2.0, 3.0};
                            this.via_inline_spacing = new double[]{3.0, 3.0, 3.0, 3.0, 4.0};
                            this.via_overhang = new double[]{1.0, 1.0, 1.0, 2.0};
                            break block0;
                        }
                        case 5: {
                            this.metal_width = new double[]{3.0, 3.0, 3.0, 3.0, 4.0, 5.0};
                            this.via_size = new double[]{2.0, 2.0, 2.0, 2.0, 3.0};
                            this.via_inline_spacing = new double[]{3.0, 3.0, 3.0, 3.0, 4.0};
                            this.via_overhang = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
                            break block0;
                        }
                        case 6: {
                            this.metal_width = new double[]{3.0, 3.0, 3.0, 3.0, 3.0, 5.0};
                            this.via_size = new double[]{2.0, 2.0, 2.0, 2.0, 3.0};
                            this.via_inline_spacing = new double[]{3.0, 3.0, 3.0, 3.0, 4.0};
                            this.via_overhang = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Illegal number of metals " + numMetals + " in SUB rule set");
                }
                case 2: {
                    this.diff_poly_overhang = 4.0;
                    this.poly_endcap = 2.5;
                    this.poly2_width = 0.0;
                    this.contact_spacing = 4.0;
                    this.well_width = 12.0;
                    this.nwell_overhang_diff_p = 6.0;
                    switch (numMetals) {
                        case 5: {
                            this.metal_width = new double[]{3.0, 3.0, 3.0, 3.0, 4.0, 5.0};
                            this.via_size = new double[]{3.0, 3.0, 3.0, 3.0, 4.0};
                            this.via_inline_spacing = new double[]{3.0, 3.0, 3.0, 3.0, 4.0};
                            this.via_overhang = new double[]{1.0, 1.0, 1.0, 1.0, 2.0};
                            break block0;
                        }
                        case 6: {
                            this.metal_width = new double[]{3.0, 3.0, 3.0, 3.0, 3.0, 5.0};
                            this.via_size = new double[]{3.0, 3.0, 3.0, 3.0, 4.0};
                            this.via_inline_spacing = new double[]{3.0, 3.0, 3.0, 3.0, 4.0};
                            this.via_overhang = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 2.0};
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Illegal number of metals " + numMetals + " in DEEP rule set");
                }
                case 0: {
                    this.diff_poly_overhang = 3.0;
                    this.poly_endcap = 2.0;
                    this.poly2_width = 3.0;
                    this.contact_spacing = 2.0;
                    this.well_width = 10.0;
                    this.nwell_overhang_diff_p = 5.0;
                    switch (numMetals) {
                        case 2: {
                            this.metal_width = new double[]{3.0, 3.0, 0.0, 0.0, 0.0, 5.0};
                            this.via_size = new double[]{2.0, 2.0, 2.0, 0.0, 0.0};
                            this.via_inline_spacing = new double[]{3.0, 3.0, 3.0, 3.0, 4.0};
                            this.via_overhang = new double[]{1.0, 1.0};
                            break block0;
                        }
                        case 3: {
                            this.metal_width = new double[]{3.0, 3.0, 6.0, 0.0, 0.0, 5.0};
                            this.via_size = new double[]{2.0, 2.0, 2.0, 0.0, 0.0};
                            this.via_inline_spacing = new double[]{3.0, 3.0, 3.0, 3.0, 4.0};
                            this.via_overhang = new double[]{1.0, 1.0, 2.0};
                            break block0;
                        }
                        case 4: {
                            this.metal_width = new double[]{3.0, 3.0, 3.0, 6.0, 0.0, 5.0};
                            this.via_size = new double[]{2.0, 2.0, 2.0, 0.0, 0.0};
                            this.via_inline_spacing = new double[]{3.0, 3.0, 3.0, 3.0, 4.0};
                            this.via_overhang = new double[]{1.0, 1.0, 1.0, 2.0};
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Illegal number of metals " + numMetals + " in SCMOS rule set");
                }
                default: {
                    throw new AssertionError((Object)("Illegal rule set " + ruleSet));
                }
            }
            this.diff_contact_overhang = alternateContactRules ? 1.0 : 1.5;
            this.contact_poly_overhang = alternateContactRules ? 1.0 : 1.5;
            this.contact_array_spacing = this.contact_spacing;
            this.via_array_spacing = this.via_inline_spacing;
        }
    }
}

