/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SizeListener
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener {
    private static final boolean NEWWAY = true;
    private Geometric stretchGeom;
    private EventListener oldListener;
    private Cursor oldCursor;
    private Point2D farthestCorner;
    private Point2D farthestEdge;
    private Point2D closestCorner;
    private Point2D closestEdge;
    private static Cursor sizeCursor = ToolBar.readCursor("CursorSize.gif", 14, 14);
    private static SizeListener currentListener = null;

    private SizeListener() {
    }

    public static void sizeObjects() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        List<Geometric> geomList = highlighter.getHighlightedEObjs(true, true);
        if (geomList == null) {
            return;
        }
        if (geomList.size() != 1) {
            System.out.println("Select just one object to size");
            return;
        }
        Geometric geom = geomList.get(0);
        EventListener newListener = null;
        EventListener oldListener = WindowFrame.getListener();
        Cursor oldCursor = TopLevel.getCurrentCursor();
        System.out.println("Click to stretch " + geom);
        newListener = oldListener;
        if (newListener == null || !(newListener instanceof SizeListener)) {
            currentListener = new SizeListener();
            newListener = currentListener;
            WindowFrame.setListener(newListener);
        }
        ((SizeListener)newListener).stretchGeom = geom;
        if (!(oldListener instanceof SizeListener)) {
            ((SizeListener)newListener).oldListener = oldListener;
            ((SizeListener)newListener).oldCursor = oldCursor;
        }
        TopLevel.setCurrentCursor(sizeCursor);
    }

    public static void restorePreviousListener(Object toDelete) {
        if (currentListener == null) {
            return;
        }
        if (SizeListener.currentListener.stretchGeom == toDelete) {
            currentListener.restoringOriginalSetup(null);
        }
    }

    public static void sizeAllNodes() {
        new SizeObjects((Frame)TopLevel.getCurrentJFrame(), true, true);
    }

    public static void sizeAllArcs() {
        new SizeObjects((Frame)TopLevel.getCurrentJFrame(), true, false);
    }

    public void mousePressed(MouseEvent evt) {
        this.farthestEdge = null;
        this.farthestCorner = null;
        this.showHighlight(evt, (EditWindow)evt.getSource(), false);
    }

    public void mouseMoved(MouseEvent evt) {
        this.farthestEdge = null;
        this.farthestCorner = null;
        this.showHighlight(evt, (EditWindow)evt.getSource(), true);
        this.farthestEdge = null;
        this.farthestCorner = null;
    }

    public void mouseDragged(MouseEvent evt) {
        this.showHighlight(evt, (EditWindow)evt.getSource(), false);
    }

    public void mouseReleased(MouseEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        this.restoringOriginalSetup(wnd);
        assert (this.stretchGeom.isLinked());
        if (this.stretchGeom instanceof NodeInst) {
            NodeInst ni = (NodeInst)this.stretchGeom;
            Point2D.Double newCenter = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
            Point2D newSize = this.getNewNodeSize(evt, newCenter);
            new ScaleNode(ni, new EPoint(((Point2D)newCenter).getX(), ((Point2D)newCenter).getY()), newSize.getX(), newSize.getY());
        } else {
            ArcInst ai = (ArcInst)this.stretchGeom;
            double newLambdaBaseWidth = this.getNewArcSize(evt);
            new ScaleArc(ai, newLambdaBaseWidth);
        }
        wnd.repaint();
    }

    private void restoringOriginalSetup(EditWindow wnd) {
        WindowFrame.setListener(this.oldListener);
        TopLevel.setCurrentCursor(this.oldCursor);
        if (wnd != null) {
            this.showHighlight(null, wnd, false);
        }
    }

    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        EditWindow wnd = (EditWindow)evt.getSource();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        if (chr == 27) {
            this.restoringOriginalSetup(wnd);
            System.out.println("Sizing aborted");
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    private void showHighlight(MouseEvent evt, EditWindow wnd, boolean stillUp) {
        Highlighter highlighter = wnd.getHighlighter();
        Cell cell = this.stretchGeom.getParent();
        highlighter.clear();
        highlighter.addElectricObject(this.stretchGeom, cell);
        if (evt != null) {
            double boxSize = 5.0 / wnd.getScale();
            Color dotColor = new Color(User.getColor(User.ColorPrefType.GRID));
            if (this.stretchGeom instanceof NodeInst) {
                NodeInst ni = (NodeInst)this.stretchGeom;
                Point2D.Double newCenter = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
                Point2D newSize = this.getNewNodeSize(evt, newCenter);
                if (stillUp) {
                    newSize.setLocation(ni.getLambdaBaseXSize(), ni.getLambdaBaseYSize());
                    ((Point2D)newCenter).setLocation(ni.getAnchorCenterX(), ni.getAnchorCenterY());
                }
                Poly stretchedPoly = ni.getBaseShape(EPoint.snap(newCenter), newSize.getX(), newSize.getY());
                Point2D[] stretchedPoints = stretchedPoly.getPoints();
                for (int i = 0; i < stretchedPoints.length; ++i) {
                    int lastI = i - 1;
                    if (lastI < 0) {
                        lastI = stretchedPoints.length - 1;
                    }
                    highlighter.addLine(stretchedPoints[lastI], stretchedPoints[i], cell);
                    double cX = (stretchedPoints[lastI].getX() + stretchedPoints[i].getX()) / 2.0;
                    double cY = (stretchedPoints[lastI].getY() + stretchedPoints[i].getY()) / 2.0;
                    Poly poly = new Poly(cX, cY, boxSize, boxSize);
                    poly.setStyle(Poly.Type.FILLED);
                    highlighter.addPoly(poly, cell, dotColor);
                    poly = new Poly(stretchedPoints[i].getX(), stretchedPoints[i].getY(), boxSize, boxSize);
                    poly.setStyle(Poly.Type.FILLED);
                    highlighter.addPoly(poly, cell, dotColor);
                }
            } else {
                ArcInst ai = (ArcInst)this.stretchGeom;
                long newGridWidth = DBMath.lambdaToSizeGrid(this.getNewArcSize(evt));
                Poly stretchedPoly = ai.makeLambdaPoly(newGridWidth, Poly.Type.CLOSED);
                if (stretchedPoly == null) {
                    return;
                }
                Point2D[] stretchedPoints = stretchedPoly.getPoints();
                for (int i = 0; i < stretchedPoints.length; ++i) {
                    int lastI = i - 1;
                    if (lastI < 0) {
                        lastI = stretchedPoints.length - 1;
                    }
                    highlighter.addLine(stretchedPoints[lastI], stretchedPoints[i], cell);
                }
            }
        }
        highlighter.finished();
    }

    private Point2D getNewNodeSize(MouseEvent evt, Point2D newCenter) {
        Point2D farthest;
        boolean square;
        EditWindow wnd = (EditWindow)evt.getSource();
        int oldx = evt.getX();
        int oldy = evt.getY();
        Point2D pt = wnd.screenToDatabase(oldx, oldy);
        NodeInst ni = (NodeInst)this.stretchGeom;
        if (ni.getProto() instanceof Cell) {
            return EPoint.ORIGIN;
        }
        Poly nodePoly = ni.getBaseShape();
        AffineTransform transIn = ni.transformIn();
        transIn.transform(pt, pt);
        nodePoly.transform(transIn);
        Point2D[] points = nodePoly.getPoints();
        if (this.farthestCorner == null && this.farthestEdge == null) {
            double closestDist = Double.MAX_VALUE;
            for (int i = 0; i < points.length; ++i) {
                Point2D.Double edge;
                int lastI;
                double dist = pt.distance(points[i]);
                if (dist < closestDist) {
                    closestDist = dist;
                    this.closestCorner = points[i];
                    this.farthestCorner = points[(i + points.length / 2) % points.length];
                    this.closestEdge = null;
                    this.farthestEdge = null;
                }
                if ((lastI = i - 1) < 0) {
                    lastI = points.length - 1;
                }
                if (!((dist = pt.distance(edge = new Point2D.Double((points[i].getX() + points[lastI].getX()) / 2.0, (points[i].getY() + points[lastI].getY()) / 2.0))) < closestDist)) continue;
                closestDist = dist;
                int oppI = (i + points.length / 2) % points.length;
                lastI = oppI - 1;
                if (lastI < 0) {
                    lastI = points.length - 1;
                }
                this.farthestEdge = new Point2D.Double((points[oppI].getX() + points[lastI].getX()) / 2.0, (points[oppI].getY() + points[lastI].getY()) / 2.0);
                this.closestEdge = edge;
                this.closestCorner = null;
                this.farthestCorner = null;
            }
        }
        boolean centerBased = (evt.getModifiersEx() & 0x40) != 0 && (evt.getModifiersEx() & 0x80) != 0;
        boolean singleAxis = (evt.getModifiersEx() & 0x40) == 0 && (evt.getModifiersEx() & 0x80) != 0 && this.farthestCorner != null;
        boolean bl = square = !ni.isCellInstance() && ((PrimitiveNode)ni.getProto()).isSquare();
        if ((evt.getModifiersEx() & 0x40) != 0 && (evt.getModifiersEx() & 0x80) == 0) {
            square = true;
        }
        double growthRatioX = 1.0;
        double growthRatioY = 1.0;
        Point2D closest = this.closestCorner != null ? this.closestCorner : this.closestEdge;
        Point2D point2D = farthest = this.farthestCorner != null ? this.farthestCorner : this.farthestEdge;
        if (centerBased) {
            double ptToCenterX = Math.abs(pt.getX());
            double closestToCenterX = Math.abs(closest.getX());
            double ptToCenterY = Math.abs(pt.getY());
            double closestToCenterY = Math.abs(closest.getY());
            if (closestToCenterX != 0.0) {
                growthRatioX = ptToCenterX / closestToCenterX;
            }
            if (closestToCenterY != 0.0) {
                growthRatioY = ptToCenterY / closestToCenterY;
            }
        } else {
            double ptToFarthestX = pt.getX() - farthest.getX();
            double closestToFarthestX = closest.getX() - farthest.getX();
            double ptToFarthestY = pt.getY() - farthest.getY();
            double closestToFarthestY = closest.getY() - farthest.getY();
            if (closestToFarthestX != 0.0) {
                growthRatioX = ptToFarthestX / closestToFarthestX;
            }
            if (closestToFarthestY != 0.0) {
                growthRatioY = ptToFarthestY / closestToFarthestY;
            }
        }
        int direction = -1;
        if (singleAxis) {
            double gry;
            double grx = Math.abs(growthRatioX);
            if (grx < 1.0) {
                grx = grx == 0.0 ? 9999.0 : 1.0 / grx;
            }
            if ((gry = Math.abs(growthRatioY)) < 1.0) {
                gry = gry == 0.0 ? 9999.0 : 1.0 / gry;
            }
            if (grx > gry) {
                growthRatioY = 1.0;
                direction = 0;
            } else {
                growthRatioX = 1.0;
                direction = 1;
            }
        }
        if (square) {
            if (Math.abs(growthRatioX) > Math.abs(growthRatioY)) {
                growthRatioY = growthRatioX;
            } else {
                growthRatioX = growthRatioY;
            }
        }
        double newXSize = ni.getLambdaBaseXSize() * growthRatioX;
        double newYSize = ni.getLambdaBaseYSize() * growthRatioY;
        double signX = newXSize < 0.0 ? -1.0 : 1.0;
        double signY = newYSize < 0.0 ? -1.0 : 1.0;
        Point2D.Double newSize = new Point2D.Double(Math.abs(newXSize), Math.abs(newYSize));
        EditWindow.gridAlignSize(newSize, direction);
        if (!centerBased) {
            double newClosestX;
            double closestX = closest.getX();
            double closestY = closest.getY();
            double farthestX = farthest.getX();
            double farthestY = farthest.getY();
            double d = closestX == farthestX ? closestX : (newClosestX = farthestX + ((Point2D)newSize).getX() * signX * (double)(closestX > farthestX ? 1 : -1));
            double newClosestY = closestY == farthestY ? closestY : farthestY + ((Point2D)newSize).getY() * signY * (double)(closestY > farthestY ? 1 : -1);
            newCenter.setLocation((farthestX + newClosestX) / 2.0, (farthestY + newClosestY) / 2.0);
            ni.transformOut().transform(newCenter, newCenter);
        }
        return newSize;
    }

    private double getNewArcSize(MouseEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        int oldx = evt.getX();
        int oldy = evt.getY();
        Point2D pt = wnd.screenToDatabase(oldx, oldy);
        ArcInst ai = (ArcInst)this.stretchGeom;
        Point2D ptOnLine = DBMath.closestPointToLine(ai.getHeadLocation(), ai.getTailLocation(), pt);
        double newLambdaBaseWidth = ptOnLine.distance(pt) * 2.0;
        Point2D.Double newLambdaBaseSize = new Point2D.Double(newLambdaBaseWidth, newLambdaBaseWidth);
        EditWindow.gridAlignSize(newLambdaBaseSize, -1);
        return ((Point2D)newLambdaBaseSize).getX();
    }

    private static class ScaleArc
    extends Job {
        private ArcInst stretchArc;
        private double newLambdaBaseWidth;

        protected ScaleArc(ArcInst stretchArc, double newLambdaBaseWidth) {
            super("Scale arc", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.stretchArc = stretchArc;
            this.newLambdaBaseWidth = newLambdaBaseWidth;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.stretchArc.getParent(), null, true, false, true) != 0) {
                return false;
            }
            this.stretchArc.setLambdaBaseWidth(this.newLambdaBaseWidth);
            return true;
        }
    }

    private static class ScaleNode
    extends Job {
        private NodeInst stretchNode;
        private EPoint newCenter;
        private double newWidth;
        private double newHeight;

        protected ScaleNode(NodeInst stretchNode, EPoint newCenter, double newWidth, double newHeight) {
            super("Scale node", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.stretchNode = stretchNode;
            this.newCenter = newCenter;
            this.newWidth = newWidth;
            this.newHeight = newHeight;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.stretchNode.getParent(), null, true, false, true) != 0) {
                return false;
            }
            EPoint[] points = this.stretchNode.getTrace();
            if (points != null) {
                double percX = this.newWidth / this.stretchNode.getLambdaBaseXSize();
                double percY = this.newHeight / this.stretchNode.getLambdaBaseYSize();
                AffineTransform trans = this.stretchNode.pureRotateOut();
                Point2D[] newPoints = new Point2D[points.length];
                for (int i = 0; i < points.length; ++i) {
                    if (points[i] == null) continue;
                    Point2D.Double newPoint = new Point2D.Double(((Point2D)points[i]).getX() * percX, ((Point2D)points[i]).getY() * percY);
                    trans.transform(newPoint, newPoint);
                    ((Point2D)newPoint).setLocation(((Point2D)newPoint).getX() + this.newCenter.getX(), ((Point2D)newPoint).getY() + this.newCenter.getY());
                    newPoints[i] = newPoint;
                }
                this.stretchNode.setTrace(newPoints);
                return true;
            }
            double dWid = this.newWidth - this.stretchNode.getLambdaBaseXSize();
            double dHei = this.newHeight - this.stretchNode.getLambdaBaseYSize();
            this.stretchNode.modifyInstance(this.newCenter.getX() - this.stretchNode.getAnchorCenterX(), this.newCenter.getY() - this.stretchNode.getAnchorCenterY(), dWid, dHei, Orientation.IDENT);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResizeStuff
    extends Job {
        private Cell cell;
        private List<Geometric> highlighted;
        private double xS;
        private double yS;
        private boolean nodes;

        protected ResizeStuff(Cell cell, List<Geometric> highlighted, double xS, double yS, boolean nodes) {
            super("Resize Objects", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.highlighted = highlighted;
            this.xS = xS;
            this.yS = yS;
            this.nodes = nodes;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            boolean didSomething = false;
            for (Geometric geom : this.highlighted) {
                if (geom instanceof NodeInst && this.nodes) {
                    NodeInst ni = (NodeInst)geom;
                    double x = this.xS;
                    double y = this.yS;
                    if (!ni.isCellInstance() && ((PrimitiveNode)ni.getProto()).isSquare()) {
                        if (y > x) {
                            x = y;
                        } else {
                            y = x;
                        }
                    }
                    ni.resize(x - ni.getLambdaBaseXSize(), y - ni.getLambdaBaseYSize());
                    didSomething = true;
                    continue;
                }
                if (!(geom instanceof ArcInst) || this.nodes) continue;
                ArcInst ai = (ArcInst)geom;
                ai.setLambdaBaseWidth(this.xS);
                didSomething = true;
            }
            if (!didSomething) {
                System.out.println("Could not find any " + (this.nodes ? "nodes" : "arcs") + " to resize");
            }
            return true;
        }
    }

    private static class SizeObjects
    extends EDialog {
        private JTextField xSize;
        private JTextField ySize;
        private boolean nodes;

        public SizeObjects(Frame parent, boolean modal, boolean nodes) {
            super(parent, modal);
            EditWindow wnd = EditWindow.needCurrent();
            if (wnd == null) {
                return;
            }
            Highlighter highlighter = wnd.getHighlighter();
            this.getContentPane().setLayout(new GridBagLayout());
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    SizeObjects.this.closeDialog();
                }
            });
            String label = "Width:";
            this.nodes = nodes;
            if (nodes) {
                label = "X Size:";
                this.setTitle("Set Node Size");
                JLabel ySizeLabel = new JLabel("Y Size:");
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.getContentPane().add((Component)ySizeLabel, gbc);
                this.ySize = new JTextField();
                this.ySize.setColumns(6);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 1;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.getContentPane().add((Component)this.ySize, gbc);
                EDialog.makeTextFieldSelectAllOnTab(this.ySize);
            } else {
                this.setTitle("Set Arc Size");
            }
            this.xSize = new JTextField();
            this.xSize.setColumns(6);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.xSize, gbc);
            EDialog.makeTextFieldSelectAllOnTab(this.xSize);
            JLabel xSizeLabel = new JLabel(label);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)xSizeLabel, gbc);
            double xS = 0.0;
            double yS = 0.0;
            Technology tech = null;
            for (Geometric geom : highlighter.getHighlightedEObjs(true, true)) {
                tech = geom.getParent().getTechnology();
                if (geom instanceof NodeInst && nodes) {
                    NodeInst ni = (NodeInst)geom;
                    xS = ni.getLambdaBaseXSize();
                    yS = ni.getLambdaBaseYSize();
                    continue;
                }
                if (!(geom instanceof ArcInst) || nodes) continue;
                ArcInst ai = (ArcInst)geom;
                xS = ai.getLambdaBaseWidth();
            }
            this.xSize.setText(TextUtils.formatDistance(xS, tech));
            if (nodes) {
                this.ySize.setText(TextUtils.formatDistance(yS, tech));
            }
            JButton ok = new JButton("OK");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SizeObjects.this.ok(evt);
                }
            });
            this.getRootPane().setDefaultButton(ok);
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SizeObjects.this.cancel(evt);
                }
            });
            this.pack();
            this.finishInitialization();
            this.setVisible(true);
        }

        protected void escapePressed() {
            this.closeDialog();
        }

        private void cancel(ActionEvent evt) {
            this.closeDialog();
        }

        private void ok(ActionEvent evt) {
            EditWindow wnd = EditWindow.needCurrent();
            if (wnd == null) {
                return;
            }
            Highlighter highlighter = wnd.getHighlighter();
            List<Geometric> highlighted = highlighter.getHighlightedEObjs(true, true);
            double xS = TextUtils.atofDistance(this.xSize.getText());
            double yS = 0.0;
            if (this.nodes) {
                yS = TextUtils.atofDistance(this.ySize.getText());
            }
            new ResizeStuff(wnd.getCell(), highlighted, xS, yS, this.nodes);
            this.closeDialog();
        }
    }
}

