/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.generator.sclibrary.SCLibraryGen;
import com.sun.electric.tool.io.input.verilog.VerilogData;
import com.sun.electric.tool.io.input.verilog.VerilogReader;
import com.sun.electric.tool.io.output.CellModelPrefs;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.io.output.Topology;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.dialogs.BusParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Verilog
extends Topology {
    private static Set<String> reservedWords = new HashSet<String>();
    private static final int MAXDECLARATIONWIDTH = 80;
    private static final String IMPLICITINVERTERNODENAME = "Imp";
    private static final String IMPLICITINVERTERSIGNAME = "ImpInv";
    public static final Variable.Key VERILOG_CODE_KEY;
    public static final Variable.Key VERILOG_DECLARATION_KEY;
    public static final Variable.Key VERILOG_PARAMETER_KEY;
    public static final Variable.Key VERILOG_EXTERNAL_CODE_KEY;
    public static final Variable.Key WIRE_TYPE_KEY;
    public static final Variable.Key VERILOG_TEMPLATE_KEY;
    public static final Variable.Key VERILOG_DEFPARAM_KEY;
    public static final Variable.Key VERILOG_BEHAVE_FILE_KEY;
    private Set<Cell> modelOverrides = new HashSet<Cell>();
    private Map<String, String> definedModules = new HashMap<String, String>();
    private Map<Cell, VerilogData.VerilogModule> definedPrimitives = new HashMap<Cell, VerilogData.VerilogModule>();
    private SCLibraryGen.StandardCellHierarchy standardCells = new SCLibraryGen.StandardCellHierarchy();
    private String filePath;
    private VerilogPreferences localPrefs;
    private StringBuffer sim_verDeclarationLine;
    private int sim_verdeclarationprefix;
    private static final String[] verilogGates;

    Verilog(VerilogPreferences vp) {
        this.localPrefs = vp;
    }

    @Override
    protected void start() {
        this.setOutputWidth(80, false);
        this.setContinuationString("      ");
        this.printWriter.println("/* Verilog for " + this.topCell + " from " + this.topCell.getLibrary() + " */");
        this.emitCopyright("/* ", " */");
        if (this.localPrefs.includeDateAndVersionInOutput) {
            this.printWriter.println("/* Created on " + TextUtils.formatDate(this.topCell.getCreationDate()) + " */");
            this.printWriter.println("/* Last revised on " + TextUtils.formatDate(this.topCell.getRevisionDate()) + " */");
            this.printWriter.println("/* Written on " + TextUtils.formatDate(new Date()) + " by Electric VLSI Design System, version " + Version.getVersion() + " */");
        } else {
            this.printWriter.println("/* Written by Electric VLSI Design System */");
        }
        if (this.localPrefs.stopAtStandardCells) {
            HierarchyEnumerator.enumerateCell(this.topCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)this.standardCells);
            for (Cell acell : this.standardCells.getDoesNotContainStandardCellsInHier()) {
                this.reportWarning("Warning: Not netlisting cell " + acell.describe(false) + " because it does not contain any standard cells.");
            }
            if (this.standardCells.getNameConflict()) {
                System.out.println("Name conflicts found, please see above messages");
            }
        }
    }

    @Override
    protected void done() {
    }

    @Override
    protected boolean skipCellAndSubcells(Cell cell) {
        if (this.localPrefs.stopAtStandardCells) {
            return !this.standardCells.containsStandardCell(cell);
        }
        if (cell.getVar(VERILOG_TEMPLATE_KEY) != null) {
            return true;
        }
        String unfilteredFileName = this.localPrefs.modelFiles.get(cell);
        if (CellModelPrefs.isUseModelFromFile(unfilteredFileName)) {
            String fileName = CellModelPrefs.getModelFile(unfilteredFileName);
            if (this.filePath.equals(fileName)) {
                this.reportError("Error: Use Model From File file path for cell " + cell.describe(false) + " is the same as the file being written, skipping.");
                return false;
            }
            VerilogReader.VerilogPreferences vp = new VerilogReader.VerilogPreferences(false);
            VerilogReader reader = new VerilogReader(vp);
            VerilogData data = reader.parseVerilog(fileName, true);
            if (data == null) {
                this.reportError("Error reading include file: " + fileName);
                return false;
            }
            if (!this.checkIncludedData(data, cell, fileName)) {
                return false;
            }
            if (!this.modelOverrides.contains(cell)) {
                this.printWriter.println("`include \"" + fileName + "\"");
                this.modelOverrides.add(cell);
            }
            return true;
        }
        Cell verViewCell = cell.otherView(View.VERILOG);
        if (verViewCell != null) {
            String[] stringArray = verViewCell.getTextViewContents();
            if (stringArray != null) {
                String line;
                if (stringArray.length > 0 && (line = stringArray[0].toLowerCase()).startsWith("do not use")) {
                    return false;
                }
                VerilogReader reader = new VerilogReader(this.localPrefs.inputPrefs);
                VerilogData data = reader.parseVerilog(stringArray, cell.getLibrary().getName());
                if (data == null) {
                    this.reportError("Error parsing Verilog View for cell " + cell.describe(false));
                    return false;
                }
                if (!this.checkIncludedData(data, cell, null)) {
                    return false;
                }
                System.out.println("Info: Netlisting Verilog view of " + cell.describe(false));
                this.printWriter.println();
                this.printWriter.println("/* Verilog view of " + verViewCell.libDescribe() + " */");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.printWriter.println(stringArray[i]);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected void writeCellTopology(Cell cell, Topology.CellNetInfo cni, VarContext context, Topology.MyCellInfo info) {
        int ind;
        Topology.CellAggregateSignal cas;
        if (cell == this.topCell) {
            Global global;
            int i;
            Netlist netList = cni.getNetList();
            Global.Set globals = netList.getGlobals();
            int globalSize = globals.size();
            ArrayList<Global> globalsToWrite = new ArrayList<Global>();
            for (i = 0; i < globalSize; ++i) {
                global = globals.get(i);
                if (global == Global.power || global == Global.ground) continue;
                globalsToWrite.add(global);
            }
            if (globalsToWrite.size() > 0) {
                this.printWriter.println("\nmodule glbl();");
                for (i = 0; i < globalsToWrite.size(); ++i) {
                    global = (Global)globalsToWrite.get(i);
                    if (this.localPrefs.useTrireg) {
                        this.printWriter.println("    trireg " + global.getName() + ";");
                        continue;
                    }
                    this.printWriter.println("    wire " + global.getName() + ";");
                }
                this.printWriter.println("endmodule");
            }
        }
        HashMap<ArcInst, Integer> implicitHeadInverters = new HashMap<ArcInst, Integer>();
        HashMap<ArcInst, Integer> implicitTailInverters = new HashMap<ArcInst, Integer>();
        int impInvCount = 0;
        Iterator<ArcInst> it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            for (int e = 0; e < 2; ++e) {
                PortInst pi;
                NodeInst ni;
                if (!ai.isNegated(e) || ((ni = (pi = ai.getPortInst(e)).getNodeInst()).getProto() == Schematics.tech().bufferNode || ni.getProto() == Schematics.tech().andNode || ni.getProto() == Schematics.tech().orNode || ni.getProto() == Schematics.tech().xorNode) && (this.localPrefs.useAssign || pi.getPortProto().getName().equals("y"))) continue;
                if (e == 1) {
                    implicitHeadInverters.put(ai, new Integer(impInvCount));
                } else {
                    implicitTailInverters.put(ai, new Integer(impInvCount));
                }
                if (ai.getProto() != Schematics.tech().bus_arc) {
                    ++impInvCount;
                    continue;
                }
                int wid = cni.getNetList().getBusWidth(ai);
                impInvCount += wid;
            }
        }
        Netlist netList = cni.getNetList();
        this.includeTypedCode(cell, VERILOG_EXTERNAL_CODE_KEY, "external code");
        this.printWriter.println();
        StringBuffer sb = new StringBuffer();
        sb.append("module " + cni.getParameterizedName() + "(");
        boolean first = true;
        Iterator<Object> it2 = cni.getCellAggregateSignals();
        while (it2.hasNext()) {
            cas = it2.next();
            if (cas.getExport() == null) continue;
            if (cas.getLowIndex() <= cas.getHighIndex() && cas.getIndices() != null) {
                int[] indices = cas.getIndices();
                for (int i = 0; i < indices.length; ++i) {
                    int ind2 = i;
                    if (cas.isDescending()) {
                        ind2 = indices.length - i - 1;
                    }
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(" \\" + cas.getName() + "[" + indices[ind2] + "] ");
                    first = false;
                }
                continue;
            }
            if (!first) {
                sb.append(", ");
            }
            sb.append(cas.getName());
            first = false;
        }
        sb.append(");\n");
        this.writeWidthLimited(sb.toString());
        this.definedModules.put(cni.getParameterizedName(), "Cell " + cell.libDescribe());
        this.includeTypedCode(cell, VERILOG_PARAMETER_KEY, "parameters");
        it2 = cell.getArcs();
        while (it2.hasNext()) {
            ArcInst ai = (ArcInst)it2.next();
            Variable var = ai.getVar(WIRE_TYPE_KEY);
            if (var == null) continue;
            String wireType = var.getObject().toString();
            int overrideValue = 0;
            if (wireType.equalsIgnoreCase("wire")) {
                overrideValue = 1;
            } else if (wireType.equalsIgnoreCase("trireg")) {
                overrideValue = 2;
            }
            int busWidth = netList.getBusWidth(ai);
            for (int i = 0; i < busWidth; ++i) {
                Network net = netList.getNetwork(ai, i);
                Topology.CellSignal cs = cni.getCellSignal(net);
                if (cs == null) continue;
                cs.getAggregateSignal().setFlags(overrideValue);
            }
        }
        first = true;
        it2 = cni.getCellAggregateSignals();
        while (it2.hasNext()) {
            cas = (Topology.CellAggregateSignal)it2.next();
            Export pp = cas.getExport();
            if (pp == null) continue;
            String portType = "input";
            if (pp.getCharacteristic() == PortCharacteristic.OUT) {
                portType = "output";
            } else if (pp.getCharacteristic() == PortCharacteristic.BIDIR) {
                portType = "inout";
            }
            sb = new StringBuffer();
            sb.append("  " + portType);
            if (cas.getLowIndex() > cas.getHighIndex()) {
                sb.append(" " + cas.getName() + ";");
            } else {
                int[] indices = cas.getIndices();
                if (indices != null) {
                    for (int i = 0; i < indices.length; ++i) {
                        ind = i;
                        if (cas.isDescending()) {
                            ind = indices.length - i - 1;
                        }
                        if (i != 0) {
                            sb.append(",");
                        }
                        sb.append(" \\" + cas.getName() + "[" + indices[ind] + "] ");
                    }
                    sb.append(";");
                } else {
                    int low = cas.getLowIndex();
                    int high = cas.getHighIndex();
                    if (cas.isDescending()) {
                        low = cas.getHighIndex();
                        high = cas.getLowIndex();
                    }
                    sb.append(" [" + low + ":" + high + "] " + cas.getName() + ";");
                }
            }
            if (cas.getFlags() != 0) {
                if (cas.getFlags() == 1) {
                    sb.append("  wire");
                } else {
                    sb.append("  trireg");
                }
                sb.append(" " + cas.getName() + ";");
            }
            sb.append("\n");
            this.writeWidthLimited(sb.toString());
            first = false;
        }
        if (!first) {
            this.printWriter.println();
        }
        if (this.localPrefs.stopAtStandardCells && SCLibraryGen.isStandardCell(cell)) {
            this.printWriter.println("endmodule   /* " + cni.getParameterizedName() + " */");
            return;
        }
        if (cni.getPowerNet() != null) {
            this.printWriter.println("  supply1 vdd;");
        }
        if (cni.getGroundNet() != null) {
            this.printWriter.println("  supply0 gnd;");
        }
        String wireType = "wire";
        if (this.localPrefs.useTrireg) {
            wireType = "trireg";
        }
        int localWires = 0;
        for (int wt = 0; wt < 2; ++wt) {
            first = true;
            Iterator<Topology.CellAggregateSignal> it3 = cni.getCellAggregateSignals();
            while (it3.hasNext()) {
                Topology.CellAggregateSignal cas2 = it3.next();
                if (cas2.getExport() != null || cas2.isSupply() || cas2.getLowIndex() <= cas2.getHighIndex() || cas2.isGlobal()) continue;
                String impSigName = wireType;
                if (cas2.getFlags() != 0) {
                    impSigName = cas2.getFlags() == 1 ? "wire" : "trireg";
                }
                if (!(wt == 0 ^ !wireType.equals(impSigName))) continue;
                if (first) {
                    this.initDeclaration("  " + impSigName);
                }
                this.addDeclaration(cas2.getName());
                ++localWires;
                first = false;
            }
            if (first) continue;
            this.termDeclaration();
        }
        Iterator<Topology.CellAggregateSignal> it4 = cni.getCellAggregateSignals();
        while (it4.hasNext()) {
            Topology.CellAggregateSignal cas3 = it4.next();
            if (cas3.getExport() != null || cas3.isSupply() || cas3.getLowIndex() > cas3.getHighIndex() || cas3.isGlobal()) continue;
            int[] indices = cas3.getIndices();
            if (indices != null) {
                for (int i = 0; i < indices.length; ++i) {
                    ind = i;
                    if (cas3.isDescending()) {
                        ind = indices.length - i - 1;
                    }
                    this.printWriter.println("  " + wireType + " \\" + cas3.getName() + "[" + indices[ind] + "] ;");
                }
            } else if (cas3.isDescending()) {
                this.printWriter.println("  " + wireType + " [" + cas3.getHighIndex() + ":" + cas3.getLowIndex() + "] " + cas3.getName() + ";");
            } else {
                this.printWriter.println("  " + wireType + " [" + cas3.getLowIndex() + ":" + cas3.getHighIndex() + "] " + cas3.getName() + ";");
            }
            ++localWires;
        }
        if (localWires != 0) {
            this.printWriter.println();
        }
        if (impInvCount > 0) {
            this.initDeclaration("  " + wireType);
            for (int i = 0; i < impInvCount; ++i) {
                String impsigname = IMPLICITINVERTERSIGNAME + i;
                this.addDeclaration(impsigname);
            }
            this.termDeclaration();
        }
        if (!this.localPrefs.stopAtStandardCells) {
            first = this.includeTypedCode(cell, VERILOG_DECLARATION_KEY, "declarations");
            if (!(first |= this.includeTypedCode(cell, VERILOG_CODE_KEY, "code"))) {
                this.printWriter.println("  /* automatically generated Verilog */");
            }
        }
        HashMap<Network, List<Export>> instancePortsOnNet = new HashMap<Network, List<Export>>();
        Iterator<Nodable> nIt = netList.getNodables();
        while (nIt.hasNext()) {
            Variable varDefparamTemplate;
            Nodable no = nIt.next();
            NodeProto niProto = no.getProto();
            PrimitiveNode.Function nodeType = PrimitiveNode.Function.UNKNOWN;
            if (!no.isCellInstance()) {
                NodeInst ni = (NodeInst)no;
                Iterator<PortInst> pIt = ni.getPortInsts();
                if (pIt.hasNext()) {
                    boolean allConnected = true;
                    PortInst firstPi = pIt.next();
                    Network firstNet = netList.getNetwork(firstPi);
                    while (pIt.hasNext()) {
                        PortInst pi = pIt.next();
                        Network thisNet = netList.getNetwork(pi);
                        if (thisNet == firstNet) continue;
                        allConnected = false;
                        break;
                    }
                    if (allConnected) continue;
                }
                if ((nodeType = ni.getFunction()).isResistor() || nodeType.isCapacitor() || nodeType == PrimitiveNode.Function.INDUCT || nodeType == PrimitiveNode.Function.DIODE || nodeType == PrimitiveNode.Function.DIODEZ) continue;
            }
            if (no.isCellInstance()) {
                if (this.localPrefs.stopAtStandardCells && !this.standardCells.containsStandardCell((Cell)niProto) && !SCLibraryGen.isStandardCell((Cell)niProto)) continue;
                Variable varTemplate = ((Cell)niProto).getVar(VERILOG_TEMPLATE_KEY);
                if (varTemplate != null) {
                    if (varTemplate.getObject() instanceof String[]) {
                        String[] lines = (String[])varTemplate.getObject();
                        this.writeWidthLimited("  /* begin Verilog_template for " + no.getProto().describe(false) + "*/\n");
                        for (int i = 0; i < lines.length; ++i) {
                            this.writeTemplate(lines[i], no, cni, context);
                        }
                        this.writeWidthLimited("  // end Verilog_template\n");
                        continue;
                    }
                    if (((String)varTemplate.getObject()).equals("//")) continue;
                    this.writeWidthLimited("  /* begin Verilog_template for " + no.getProto().describe(false) + "*/\n");
                    this.writeTemplate((String)varTemplate.getObject(), no, cni, context);
                    this.writeWidthLimited("  // end Verilog_template\n");
                    continue;
                }
            }
            if (no.isCellInstance() && (varDefparamTemplate = ((Cell)niProto).getVar(VERILOG_DEFPARAM_KEY)) != null) {
                if (varDefparamTemplate.getObject() instanceof String[]) {
                    String[] lines = (String[])varDefparamTemplate.getObject();
                    boolean firstDefparam = true;
                    for (int i = 0; i < lines.length; ++i) {
                        String defparam = new String();
                        defparam = this.writeDefparam(lines[i], no, context);
                        if (defparam.length() == 0) continue;
                        if (firstDefparam) {
                            this.writeWidthLimited("  /* begin Verilog_defparam for " + no.getProto().describe(false) + " */\n");
                            firstDefparam = false;
                        }
                        this.writeWidthLimited(defparam);
                    }
                    if (!firstDefparam) {
                        this.writeWidthLimited("  // end Verilog_defparam\n");
                    }
                } else if (!((String)varDefparamTemplate.getObject()).equals("//")) {
                    String defparam = new String();
                    defparam = this.writeDefparam((String)varDefparamTemplate.getObject(), no, context);
                    if (defparam.length() != 0) {
                        this.writeWidthLimited("  /* begin Verilog_defparam for " + no.getProto().describe(false) + "*/\n");
                        this.writeWidthLimited(defparam);
                        this.writeWidthLimited("  // end Verilog_defparam\n");
                    }
                }
            }
            if (this.localPrefs.useAssign && (nodeType == PrimitiveNode.Function.GATEAND || nodeType == PrimitiveNode.Function.GATEOR || nodeType == PrimitiveNode.Function.GATEXOR || nodeType == PrimitiveNode.Function.BUFFER)) {
                String op = "";
                if (nodeType == PrimitiveNode.Function.GATEAND) {
                    op = " & ";
                } else if (nodeType == PrimitiveNode.Function.GATEOR) {
                    op = " | ";
                } else if (nodeType == PrimitiveNode.Function.GATEXOR) {
                    op = " ^ ";
                }
                StringBuffer infstr = new StringBuffer();
                boolean wholeNegated = false;
                first = true;
                NodeInst ni = (NodeInst)no;
                block25: for (int i = 0; i < 2; ++i) {
                    Iterator<Connection> cIt = ni.getConnections();
                    while (cIt.hasNext()) {
                        Connection con = cIt.next();
                        PortInst pi = con.getPortInst();
                        if (i == 0 ? !pi.getPortProto().getName().equals("y") : !pi.getPortProto().getName().equals("a")) continue;
                        ArcInst ai = con.getArc();
                        Network net = netList.getNetwork(ai, 0);
                        Topology.CellSignal cs = cni.getCellSignal(net);
                        String sigName = this.getSignalName(cs);
                        boolean isNegated = false;
                        if (ai.isTailNegated() || ai.isHeadNegated()) {
                            isNegated = true;
                        }
                        if (i == 0) {
                            infstr.append("assign " + sigName + " = ");
                            if (!isNegated) continue block25;
                            infstr.append("~(");
                            wholeNegated = true;
                            continue block25;
                        }
                        if (!first) {
                            infstr.append(op);
                        }
                        first = false;
                        if (isNegated) {
                            infstr.append("~");
                        }
                        infstr.append(sigName);
                    }
                }
                if (wholeNegated) {
                    infstr.append(")");
                }
                infstr.append(";\n");
                this.writeWidthLimited(infstr.toString());
                continue;
            }
            int implicitPorts = 0;
            boolean dropBias = false;
            String nodeName = "";
            if (no.isCellInstance()) {
                if (((Cell)niProto).isIcon()) continue;
                nodeName = this.parameterizedName(no, context);
                if (this.definedPrimitives.containsKey(niProto)) {
                    implicitPorts = 3;
                }
            } else {
                Variable varWeakNode;
                PrimitiveNode.Function threePortEquiv = nodeType.make3PortTransistor();
                if (threePortEquiv != null) {
                    nodeType = threePortEquiv;
                    dropBias = true;
                }
                if (nodeType.isNTypeTransistor()) {
                    implicitPorts = 2;
                    nodeName = "tranif1";
                    varWeakNode = ((NodeInst)no).getVar(Simulation.WEAK_NODE_KEY);
                    if (varWeakNode != null) {
                        nodeName = "rtranif1";
                    }
                } else if (nodeType.isPTypeTransistor()) {
                    implicitPorts = 2;
                    nodeName = "tranif0";
                    varWeakNode = ((NodeInst)no).getVar(Simulation.WEAK_NODE_KEY);
                    if (varWeakNode != null) {
                        nodeName = "rtranif0";
                    }
                } else if (nodeType == PrimitiveNode.Function.GATEAND) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "and", "nand");
                } else if (nodeType == PrimitiveNode.Function.GATEOR) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "or", "nor");
                } else if (nodeType == PrimitiveNode.Function.GATEXOR) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "xor", "xnor");
                } else if (nodeType == PrimitiveNode.Function.BUFFER) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "buf", "not");
                }
            }
            if (nodeName.length() == 0) continue;
            StringBuffer infstr = new StringBuffer();
            String instName = this.nameNoIndices(no.getName());
            boolean clean = false;
            while (!clean) {
                clean = true;
                Iterator<Topology.CellAggregateSignal> it5 = cni.getCellAggregateSignals();
                while (it5.hasNext()) {
                    Topology.CellAggregateSignal cas4 = it5.next();
                    if (!cas4.getName().equals(instName)) continue;
                    clean = false;
                    break;
                }
                if (clean) continue;
                instName = instName + "_";
            }
            infstr.append("  " + nodeName + " " + instName + "(");
            first = true;
            NodeInst ni = null;
            switch (implicitPorts) {
                case 0: {
                    Network net;
                    Topology.CellNetInfo subCni = this.getCellNetInfo(nodeName);
                    Iterator<Topology.CellAggregateSignal> sIt = subCni.getCellAggregateSignals();
                    while (sIt.hasNext()) {
                        Topology.CellAggregateSignal cas5 = sIt.next();
                        Export pp = cas5.getExport();
                        if (pp == null) continue;
                        if (first) {
                            first = false;
                        } else {
                            infstr.append(", ");
                        }
                        if (cas5.getLowIndex() > cas5.getHighIndex()) {
                            infstr.append("." + cas5.getName() + "(");
                            Network net2 = netList.getNetwork(no, pp, cas5.getExportIndex());
                            Topology.CellSignal cs = cni.getCellSignal(net2);
                            infstr.append(this.getSignalName(cs));
                            infstr.append(")");
                            Verilog.accumulatePortConnectivity(instancePortsOnNet, net2, pp);
                            continue;
                        }
                        int[] indices = cas5.getIndices();
                        if (indices != null) {
                            for (int i = 0; i < indices.length; ++i) {
                                int ind3 = i;
                                if (cas5.isDescending()) {
                                    ind3 = indices.length - i - 1;
                                }
                                Topology.CellSignal cInnerSig = cas5.getSignal(ind3);
                                net = netList.getNetwork(no, cInnerSig.getExport(), cInnerSig.getExportIndex());
                                Topology.CellSignal outerSignal = cni.getCellSignal(net);
                                Verilog.accumulatePortConnectivity(instancePortsOnNet, net, pp);
                                if (i > 0) {
                                    infstr.append(", ");
                                }
                                infstr.append(".\\" + cas5.getName() + "[" + indices[ind3] + "] (");
                                infstr.append(this.getSignalName(outerSignal));
                                infstr.append(")");
                            }
                            continue;
                        }
                        int total = cas5.getNumSignals();
                        Topology.CellSignal[] outerSignalList = new Topology.CellSignal[total];
                        for (int j = 0; j < total; ++j) {
                            Topology.CellSignal cInnerSig = cas5.getSignal(j);
                            Export e = cas5.getExport();
                            if (cInnerSig.getExport() != null) {
                                e = cInnerSig.getExport();
                            }
                            int ind4 = cInnerSig.getExportIndex();
                            Network net3 = netList.getNetwork(no, e, ind4);
                            outerSignalList[j] = cni.getCellSignal(net3);
                            Verilog.accumulatePortConnectivity(instancePortsOnNet, net3, pp);
                        }
                        this.writeBus(outerSignalList, total, cas5.isDescending(), cas5.getName(), cni.getPowerNet(), cni.getGroundNet(), infstr);
                    }
                    infstr.append(");");
                    break;
                }
                case 1: {
                    String sigName;
                    ni = (NodeInst)no;
                    for (int i = 0; i < 2; ++i) {
                        Iterator<Connection> cIt = ni.getConnections();
                        while (cIt.hasNext()) {
                            Integer invIndex;
                            Connection con = cIt.next();
                            PortInst pi = con.getPortInst();
                            if (i != 0 ? !pi.getPortProto().getName().equals("a") : !pi.getPortProto().getName().equals("y")) continue;
                            if (first) {
                                first = false;
                            } else {
                                infstr.append(", ");
                            }
                            ArcInst ai = con.getArc();
                            Network net = netList.getNetwork(ai, 0);
                            Topology.CellSignal cs = cni.getCellSignal(net);
                            if (cs == null) continue;
                            sigName = this.getSignalName(cs);
                            if (i != 0 && con.isNegated() && (invIndex = con.getEndIndex() == 1 ? (Integer)implicitHeadInverters.get(ai) : (Integer)implicitTailInverters.get(ai)) != null) {
                                String invSigName = IMPLICITINVERTERSIGNAME + invIndex;
                                this.printWriter.println("  inv Imp" + invIndex + " (" + invSigName + ", " + sigName + ");");
                                sigName = invSigName;
                            }
                            infstr.append(sigName);
                        }
                    }
                    infstr.append(");");
                    break;
                }
                case 2: {
                    String sigName;
                    ni = (NodeInst)no;
                    Network gateNet = netList.getNetwork(ni.getTransistorGatePort());
                    for (int i = 0; i < 2; ++i) {
                        boolean didGate = false;
                        Iterator<PortInst> pIt = ni.getPortInsts();
                        while (pIt.hasNext()) {
                            Topology.CellSignal cs;
                            PortInst pi = pIt.next();
                            Network net = netList.getNetwork(pi);
                            if (dropBias && pi.getPortProto().getName().equals("b") || (cs = cni.getCellSignal(net)) == null) continue;
                            if (i == 0) {
                                if (net == gateNet) {
                                    continue;
                                }
                            } else {
                                if (net != gateNet || didGate) continue;
                                didGate = true;
                            }
                            if (first) {
                                first = false;
                            } else {
                                infstr.append(", ");
                            }
                            sigName = this.getSignalName(cs);
                            infstr.append(sigName);
                        }
                    }
                    infstr.append(");");
                    break;
                }
                case 3: {
                    Network net;
                    ni = no.getNodeInst();
                    VerilogData.VerilogModule module = this.definedPrimitives.get(niProto);
                    if (module == null) break;
                    System.out.print(cell.getName() + " ports: ");
                    for (VerilogData.VerilogPort port : module.getPorts()) {
                        List<String> portnames = port.getPinNames(true);
                        if (portnames.size() == 0) continue;
                        if (portnames.size() > 1) {
                            this.reportError("Error: bussed ports not allowed on Verilog primitives: " + niProto.getName());
                            continue;
                        }
                        String portname = portnames.get(0);
                        PortInst pi = ni.findPortInst(portname);
                        net = netList.getNetwork(no, pi.getProtoEquivalent(), 0);
                        Topology.CellSignal cs = cni.getCellSignal(net);
                        String sigName = this.getSignalName(cs);
                        if (first) {
                            first = false;
                        } else {
                            infstr.append(", ");
                        }
                        infstr.append(sigName);
                        System.out.print(portname + " ");
                    }
                    System.out.println();
                    infstr.append(");");
                }
            }
            infstr.append("\n");
            this.writeWidthLimited(infstr.toString());
        }
        this.printWriter.println("endmodule   /* " + cni.getParameterizedName() + " */");
        Iterator<Export> it6 = cell.getExports();
        while (it6.hasNext()) {
            Export ex = it6.next();
            PortCharacteristic type = ex.getCharacteristic();
            if (type == PortCharacteristic.BIDIR) continue;
            for (int i = 0; i < ex.getNameKey().busWidth(); ++i) {
                Network net = netList.getNetwork(ex, i);
                List subports = (List)instancePortsOnNet.get(net);
                if (subports == null) continue;
                for (Export subex : subports) {
                    PortCharacteristic subtype = subex.getCharacteristic();
                    if (type == subtype) continue;
                    this.reportWarning("Warning: Port Direction Inconsistency in cell " + cell.describe(false) + " between export " + ex.getNameKey().subname(i) + " (" + (Object)((Object)type) + ") and instance port " + subex.getParent().noLibDescribe() + " - " + subex.getName() + " (" + (Object)((Object)subtype) + ")");
                }
            }
        }
    }

    private String getSignalName(Topology.CellSignal cs) {
        Topology.CellAggregateSignal cas = cs.getAggregateSignal();
        if (cas == null) {
            return cs.getName();
        }
        if (cas.getIndices() == null) {
            return cs.getName();
        }
        return " \\" + cs.getName() + " ";
    }

    private String chooseNodeName(NodeInst ni, String positive, String negative) {
        Iterator<Connection> aIt = ni.getConnections();
        while (aIt.hasNext()) {
            Connection con = aIt.next();
            if (!con.isNegated() || !con.getPortInst().getPortProto().getName().equals("y")) continue;
            return negative;
        }
        return positive;
    }

    private void writeTemplate(String line, Nodable no, Topology.CellNetInfo cni, VarContext context) {
        Netlist netList = cni.getNetList();
        StringBuffer infstr = new StringBuffer();
        infstr.append("  ");
        for (int pt = 0; pt < line.length(); ++pt) {
            Iterator<Object> it;
            int startpt;
            char chr = line.charAt(pt);
            if (chr != '$' || pt + 1 >= line.length() || line.charAt(pt + 1) != '(') {
                infstr.append(chr);
                continue;
            }
            for (pt = startpt = pt + 2; pt < line.length() && line.charAt(pt) != ')'; ++pt) {
            }
            String paramName = line.substring(startpt, pt);
            PortProto pp = no.getProto().findPortProto(paramName);
            String nodeName = this.parameterizedName(no, context);
            Topology.CellNetInfo subCni = this.getCellNetInfo(nodeName);
            Topology.CellAggregateSignal cas = null;
            Topology.CellSignal netcs = null;
            if (pp != null) {
                it = subCni.getCellAggregateSignals();
                while (it.hasNext()) {
                    Topology.CellAggregateSignal cas2 = (Topology.CellAggregateSignal)it.next();
                    if (cas2.getExport() == pp) {
                        cas = cas2;
                    } else {
                        if (!netList.sameNetwork(no, pp, no, cas2.getExport())) continue;
                        cas = cas2;
                    }
                    break;
                }
            } else {
                it = no.getProto().getPorts();
                block3: while (it.hasNext()) {
                    PortProto ppcheck = (PortProto)it.next();
                    for (int i = 0; i < ppcheck.getNameKey().busWidth(); ++i) {
                        if (!paramName.equals(ppcheck.getNameKey().subname(i).toString())) continue;
                        Network net = netList.getNetwork(no, ppcheck, i);
                        netcs = cni.getCellSignal(net);
                        continue block3;
                    }
                }
            }
            if (cas != null) {
                if (cas.getLowIndex() > cas.getHighIndex()) {
                    Network net = netList.getNetwork(no, pp, cas.getExportIndex());
                    Topology.CellSignal cs = cni.getCellSignal(net);
                    infstr.append(this.getSignalName(cs));
                    continue;
                }
                int total = cas.getNumSignals();
                Topology.CellSignal[] outerSignalList = new Topology.CellSignal[total];
                for (int j = 0; j < total; ++j) {
                    Topology.CellSignal cInnerSig = cas.getSignal(j);
                    Network net = netList.getNetwork(no, cas.getExport(), cInnerSig.getExportIndex());
                    outerSignalList[j] = cni.getCellSignal(net);
                }
                this.writeBus(outerSignalList, total, cas.isDescending(), null, cni.getPowerNet(), cni.getGroundNet(), infstr);
                continue;
            }
            if (netcs != null) {
                infstr.append(this.getSignalName(netcs));
                continue;
            }
            if (paramName.equalsIgnoreCase("node_name")) {
                infstr.append(this.getSafeNetName(no.getName(), true));
                continue;
            }
            Variable var = null;
            Variable.Key varKey = Variable.findKey("ATTR_" + paramName);
            if (varKey != null) {
                var = no.getParameterOrVariable(varKey);
            }
            if (var == null) {
                infstr.append("??");
                continue;
            }
            infstr.append(context.evalVar(var));
        }
        infstr.append("\n");
        this.writeWidthLimited(infstr.toString());
    }

    private String writeDefparam(String line, Nodable no, VarContext context) {
        StringBuffer infstr = new StringBuffer();
        infstr.append("  defparam ");
        infstr.append(this.getSafeNetName(no.getName(), true));
        infstr.append(".");
        for (int pt = 0; pt < line.length(); ++pt) {
            int startpt;
            char chr = line.charAt(pt);
            if (chr != '$' || pt + 1 >= line.length() || line.charAt(pt + 1) != '(') {
                infstr.append(chr);
                continue;
            }
            for (pt = startpt = pt + 2; pt < line.length() && line.charAt(pt) != ')'; ++pt) {
            }
            String paramName = line.substring(startpt, pt);
            if (!(no.getProto() instanceof Cell)) {
                this.reportError("Illegal attempt to replace a variable.");
                return "";
            }
            String defaultValue = this.replaceVariable(paramName, (Cell)no.getProto());
            String paramValue = this.replaceVariable(paramName, no, context);
            if (paramValue == "" || paramValue.equals(defaultValue)) {
                return "";
            }
            infstr.append(paramName);
            infstr.append(" = ");
            infstr.append(paramValue);
            infstr.append(";");
        }
        infstr.append("\n");
        return infstr.toString();
    }

    private String replaceVariable(String varName, Nodable no, VarContext context) {
        if (varName.equalsIgnoreCase("node_name")) {
            return this.getSafeNetName(no.getName(), true);
        }
        Variable var = null;
        Variable.Key varKey = Variable.findKey("ATTR_" + varName);
        if (varKey != null && (var = no.getVar(varKey)) == null) {
            var = no.getParameter(varKey);
        }
        if (var == null) {
            return "";
        }
        String val = String.valueOf(context.evalVar(var));
        return this.replaceVarInString(val, no.getParent());
    }

    private String replaceVariable(String varName, Cell cell) {
        if (varName.equalsIgnoreCase("node_name")) {
            return this.getSafeNetName(cell.getName(), true);
        }
        Variable var = null;
        Variable.Key varKey = Variable.findKey("ATTR_" + varName);
        if (varKey != null && (var = cell.getVar(varKey)) == null) {
            var = cell.getParameter(varKey);
        }
        if (var == null) {
            return "";
        }
        CodeExpression.Code code = var.getCode();
        Object value = var.getObject();
        if (code == CodeExpression.Code.JAVA || code == CodeExpression.Code.TCL || code == CodeExpression.Code.SPICE) {
            return "";
        }
        return String.valueOf(value);
    }

    private String replaceVarInString(String line, Cell cell) {
        StringBuffer infstr = new StringBuffer();
        for (int pt = 0; pt < line.length(); ++pt) {
            int startpt;
            char chr = line.charAt(pt);
            if (chr != '$' || pt + 1 >= line.length() || line.charAt(pt + 1) != '(') {
                infstr.append(chr);
                continue;
            }
            for (pt = startpt = pt + 2; pt < line.length() && line.charAt(pt) != ')'; ++pt) {
            }
            String paramName = line.substring(startpt, pt);
            String paramValue = this.replaceVariable(paramName, cell);
            if (paramValue != "") {
                infstr.append(paramValue);
                continue;
            }
            paramValue = BusParameters.replaceBusParameterInt("$(" + paramName + ")");
            if (paramValue != "") {
                infstr.append(paramValue);
                continue;
            }
            infstr.append("$(");
            infstr.append(paramName);
            infstr.append(")");
        }
        return infstr.toString();
    }

    private void writeBus(Topology.CellSignal[] outerSignalList, int total, boolean descending, String name, Network pwrNet, Network gndNet, StringBuffer infstr) {
        Topology.CellSignal cs;
        int j;
        boolean breakBus = false;
        int numExported = 0;
        int numInternal = 0;
        for (j = 0; j < total; ++j) {
            cs = outerSignalList[j];
            Topology.CellAggregateSignal cas = cs.getAggregateSignal();
            if (cas != null && cas.getIndices() != null) {
                breakBus = true;
                break;
            }
            if (cs.isPower() || cs.isGround()) {
                breakBus = true;
                break;
            }
            if (cs.isExported()) {
                ++numExported;
                continue;
            }
            ++numInternal;
        }
        if (numExported > 0 && numInternal > 0) {
            breakBus = true;
        }
        if (!breakBus) {
            for (j = 1; j < total; ++j) {
                Topology.CellSignal oCs;
                int k;
                cs = outerSignalList[j];
                for (k = 0; k < j && cs != (oCs = outerSignalList[k]); ++k) {
                }
                if (k < j) break;
            }
            if (j < total) {
                breakBus = true;
            } else {
                String lastnetname = null;
                for (j = 0; j < total; ++j) {
                    int openSquare;
                    Topology.CellSignal wl = outerSignalList[j];
                    String thisnetname = this.getSignalName(wl);
                    if ((!wl.isDescending() ? descending : !descending) || (openSquare = thisnetname.indexOf(91)) < 0) break;
                    if (j > 0) {
                        int lastIndex;
                        int thisIndex;
                        int li;
                        for (li = 0; li < lastnetname.length() && thisnetname.charAt(li) == lastnetname.charAt(li) && lastnetname.charAt(li) != '['; ++li) {
                        }
                        if (lastnetname.charAt(li) != '[' || thisnetname.charAt(li) != '[' || (thisIndex = TextUtils.atoi(thisnetname.substring(li + 1))) != (lastIndex = TextUtils.atoi(lastnetname.substring(li + 1))) + 1) break;
                    }
                    lastnetname = thisnetname;
                }
                if (j < total) {
                    breakBus = true;
                }
            }
        }
        if (name != null) {
            infstr.append("." + name + "(");
        }
        if (breakBus) {
            infstr.append("{");
            int start = 0;
            int end = total - 1;
            int order = 1;
            if (descending) {
                start = total - 1;
                end = 0;
                order = -1;
            }
            int j2 = start;
            while (true) {
                if (j2 != start) {
                    infstr.append(", ");
                }
                Topology.CellSignal cs2 = outerSignalList[j2];
                infstr.append(this.getSignalName(cs2));
                if (j2 == end) break;
                j2 += order;
            }
            infstr.append("}");
        } else {
            int second;
            int first;
            int i;
            Topology.CellSignal lastCs = outerSignalList[0];
            String lastNetName = this.getSignalName(lastCs);
            int openSquare = lastNetName.indexOf(91);
            Topology.CellSignal cs3 = outerSignalList[total - 1];
            String netName = this.getSignalName(cs3);
            for (i = 0; i < netName.length() && netName.charAt(i) != '['; ++i) {
                infstr.append(netName.charAt(i));
            }
            if (descending) {
                first = TextUtils.atoi(netName.substring(i + 1));
                second = TextUtils.atoi(lastNetName.substring(openSquare + 1));
                infstr.append("[" + first + ":" + second + "]");
            } else {
                first = TextUtils.atoi(netName.substring(i + 1));
                second = TextUtils.atoi(lastNetName.substring(openSquare + 1));
                infstr.append("[" + second + ":" + first + "]");
            }
        }
        if (name != null) {
            infstr.append(")");
        }
    }

    private boolean includeTypedCode(Cell cell, Variable.Key verilogkey, String descript) {
        boolean first = true;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            Object obj;
            Variable var;
            NodeInst ni = it.next();
            if (ni.getProto() != Generic.tech().invisiblePinNode || (var = ni.getVar(verilogkey)) == null || !var.isDisplay() || !((obj = var.getObject()) instanceof String) && !(obj instanceof String[])) continue;
            if (first) {
                first = false;
                this.printWriter.println("  /* user-specified Verilog " + descript + " */");
            }
            if (obj instanceof String) {
                String tmp = this.replaceVarInString((String)obj, cell);
                this.printWriter.println("  " + tmp);
                continue;
            }
            String[] stringArray = (String[])obj;
            int len = stringArray.length;
            for (int i = 0; i < len; ++i) {
                String tmp = this.replaceVarInString(stringArray[i], cell);
                this.printWriter.println("  " + tmp);
            }
        }
        if (!first) {
            this.printWriter.println();
        }
        return first;
    }

    private void initDeclaration(String header) {
        this.sim_verDeclarationLine = new StringBuffer();
        this.sim_verDeclarationLine.append(header);
        this.sim_verdeclarationprefix = header.length();
    }

    private void addDeclaration(String signame) {
        if (this.sim_verDeclarationLine.length() + signame.length() + 3 > 80) {
            this.printWriter.println(this.sim_verDeclarationLine.toString() + ";");
            this.sim_verDeclarationLine.delete(this.sim_verdeclarationprefix, this.sim_verDeclarationLine.length());
        }
        if (this.sim_verDeclarationLine.length() != this.sim_verdeclarationprefix) {
            this.sim_verDeclarationLine.append(",");
        }
        this.sim_verDeclarationLine.append(" " + signame);
    }

    private void termDeclaration() {
        this.printWriter.println(this.sim_verDeclarationLine.toString() + ";");
    }

    private String nameNoIndices(String p) {
        StringBuffer sb = new StringBuffer();
        if (TextUtils.isDigit(p.charAt(0))) {
            sb.append('_');
        }
        for (int i = 0; i < p.length(); ++i) {
            int chr = p.charAt(i);
            if (!TextUtils.isLetterOrDigit((char)chr) && chr != 95 && chr != 36) {
                chr = 95;
            }
            sb.append((char)chr);
        }
        return sb.toString();
    }

    @Override
    protected String getSafeCellName(String name) {
        String n = this.getSafeNetName(name, false);
        return n.replaceAll("[\\[\\]]", "_");
    }

    @Override
    protected String getPowerName(Network net) {
        return "vdd";
    }

    @Override
    protected String getGroundName(Network net) {
        return "gnd";
    }

    @Override
    protected String getGlobalName(Global glob) {
        return "glbl." + glob.getName();
    }

    @Override
    protected boolean isNetworksUseExportedNames() {
        return true;
    }

    @Override
    protected boolean isLibraryNameAlwaysAddedToCellName() {
        return true;
    }

    @Override
    protected boolean isAggregateNamesSupported() {
        return true;
    }

    @Override
    protected boolean isAggregateNameGapsSupported() {
        return true;
    }

    @Override
    protected boolean isSeparateInputAndOutput() {
        return true;
    }

    @Override
    protected boolean isCaseSensitive() {
        return true;
    }

    @Override
    protected String getSafeNetName(String name, boolean bus) {
        boolean allAlnum = true;
        int len = name.length();
        if (len == 0) {
            return name;
        }
        int openSquareCount = 0;
        int openSquarePos = 0;
        for (int i = 0; i < len; ++i) {
            char chr = name.charAt(i);
            if (chr == '[') {
                ++openSquareCount;
                openSquarePos = i;
            }
            if (!TextUtils.isLetterOrDigit(chr)) {
                allAlnum = false;
            }
            if (i != 0 || !TextUtils.isDigit(chr)) continue;
            allAlnum = false;
        }
        if (!allAlnum || !Character.isLetter(name.charAt(0))) {
            if (!(openSquareCount != 1 || openSquarePos + 1 < name.length() && Character.isDigit(name.charAt(openSquarePos + 1)))) {
                openSquareCount = 0;
            }
            if (bus) {
                openSquareCount = 0;
            }
            StringBuffer sb = new StringBuffer();
            for (int t = 0; t < name.length(); ++t) {
                char chr = name.charAt(t);
                if (chr == '[' || chr == ']') {
                    if (openSquareCount == 1) {
                        sb.append(chr);
                        continue;
                    }
                    sb.append('_');
                    continue;
                }
                if (t == 0 && TextUtils.isDigit(chr)) {
                    sb.append('_');
                }
                if (TextUtils.isLetterOrDigit(chr) || chr == '$') {
                    sb.append(chr);
                    continue;
                }
                sb.append('_');
            }
            name = sb.toString();
        }
        if (reservedWords.contains(name)) {
            name = "_" + name;
        }
        return name;
    }

    @Override
    protected Netlist.ShortResistors getShortResistors() {
        return Netlist.ShortResistors.PARASITIC;
    }

    @Override
    protected boolean canParameterizeNames() {
        if (this.localPrefs.stopAtStandardCells) {
            return false;
        }
        return this.localPrefs.parameterizeModuleNames;
    }

    private boolean checkIncludedData(VerilogData data, Cell cell, String includeFile) {
        Collection<VerilogData.VerilogModule> modules = data.getModules();
        VerilogData.VerilogModule main = null;
        VerilogData.VerilogModule alternative = null;
        for (VerilogData.VerilogModule mod : modules) {
            if (mod.getName().equals(this.getVerilogName(cell))) {
                main = mod;
                continue;
            }
            Cell.CellGroup grp = cell.getCellGroup();
            if (grp == null || !mod.getName().equals(grp.getName())) continue;
            alternative = mod;
        }
        if (main == null) {
            main = alternative;
        }
        if (main == null) {
            this.reportError("Error! Expected Verilog module definition '" + this.getVerilogName(cell) + " in Verilog View: " + cell.libDescribe());
            return false;
        }
        if (main.isPrimitive()) {
            this.definedPrimitives.put(cell, main);
        }
        String source = includeFile == null ? "Verilog View for " + cell.libDescribe() : "Include file: " + includeFile;
        for (VerilogData.VerilogModule mod : modules) {
            String prevSource = this.definedModules.get(mod.getName());
            if (!mod.isValid()) continue;
            if (prevSource != null) {
                this.reportError("Error, module " + mod.getName() + " already defined from: " + prevSource);
                continue;
            }
            this.definedModules.put(mod.getName(), source);
        }
        for (VerilogData.VerilogModule mod : modules) {
            for (VerilogData.VerilogInstance inst : mod.getInstances()) {
                String moduleName;
                String found;
                VerilogData.VerilogModule instMod = inst.getModule();
                if (instMod.isValid()) continue;
                boolean primitiveGate = false;
                for (String s : verilogGates) {
                    if (!s.equals(instMod.getName().toLowerCase())) continue;
                    primitiveGate = true;
                    break;
                }
                if (primitiveGate || (found = this.definedModules.get(moduleName = instMod.getName())) != null || includeFile != null) continue;
                Cell missingCell = Verilog.findCell(moduleName, View.VERILOG);
                if (missingCell == null) {
                    this.reportError("Error: Undefined reference to module " + moduleName + ", and no matching cell found");
                    continue;
                }
                System.out.println("Info: Netlisting cell " + missingCell.libDescribe() + " as instanced in: " + source);
                HierarchyEnumerator.enumerateCell(missingCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)new Topology.Visitor(this), this.getShortResistors());
            }
        }
        return true;
    }

    private String getVerilogName(Cell cell) {
        String uniqueCellName = this.getUniqueCellName(cell);
        if (uniqueCellName != null) {
            return uniqueCellName;
        }
        String safeCellName = this.getSafeCellName(cell.getName());
        if (!safeCellName.startsWith("_")) {
            safeCellName = "__" + safeCellName;
        }
        return cell.getLibrary().getName() + safeCellName;
    }

    public static Cell findCell(String verilogName, View preferredView) {
        Cell preferred;
        Cell cell = null;
        String[] parts = verilogName.split("__");
        if (parts.length == 2) {
            Library lib = Library.findLibrary(parts[0]);
            if (lib == null) {
                System.out.println("Cannot find library " + parts[0] + " for Verilog-style module name: " + verilogName);
                return null;
            }
            if (preferredView == null) {
                preferredView = View.SCHEMATIC;
            }
            if ((cell = lib.findNodeProto(parts[1])) == null) {
                System.out.println("Cannot find Cell " + parts[1] + " in Library " + parts[0] + " for Verilog-style module name: " + verilogName);
                return null;
            }
        } else {
            cell = Library.findCellInLibraries(verilogName, View.SCHEMATIC, null);
            if (cell == null) {
                System.out.println("Cannot find Cell '" + verilogName + "' for Verilog-style module name: " + verilogName);
                return null;
            }
        }
        if ((preferred = cell.otherView(preferredView)) != null) {
            return preferred;
        }
        preferred = cell.getCellGroup().getMainSchematics();
        if (preferred != null) {
            return preferred;
        }
        return cell;
    }

    private static void accumulatePortConnectivity(Map<Network, List<Export>> instancePortsOnNet, Network net, Export ex) {
        List<Export> list = instancePortsOnNet.get(net);
        if (list == null) {
            list = new ArrayList<Export>();
            instancePortsOnNet.put(net, list);
        }
        if (!list.contains(ex)) {
            list.add(ex);
        }
    }

    static {
        reservedWords.add("always");
        reservedWords.add("and");
        reservedWords.add("assign");
        reservedWords.add("attribute");
        reservedWords.add("begin");
        reservedWords.add("buf");
        reservedWords.add("bufif0");
        reservedWords.add("bufif1");
        reservedWords.add("case");
        reservedWords.add("casex");
        reservedWords.add("casez");
        reservedWords.add("cmos");
        reservedWords.add("deassign");
        reservedWords.add("default");
        reservedWords.add("defpram");
        reservedWords.add("disable");
        reservedWords.add("edge");
        reservedWords.add("else");
        reservedWords.add("end");
        reservedWords.add("endattribute");
        reservedWords.add("endcase");
        reservedWords.add("endfunction");
        reservedWords.add("endmodule");
        reservedWords.add("endprimitive");
        reservedWords.add("endspecify");
        reservedWords.add("endtable");
        reservedWords.add("endtask");
        reservedWords.add("event");
        reservedWords.add("for");
        reservedWords.add("force");
        reservedWords.add("forever");
        reservedWords.add("fork");
        reservedWords.add("function");
        reservedWords.add("highz0");
        reservedWords.add("highz1");
        reservedWords.add("if");
        reservedWords.add("initial");
        reservedWords.add("inout");
        reservedWords.add("input");
        reservedWords.add("integer");
        reservedWords.add("join");
        reservedWords.add("large");
        reservedWords.add("macromodule");
        reservedWords.add("meduim");
        reservedWords.add("module");
        reservedWords.add("nand");
        reservedWords.add("negedge");
        reservedWords.add("nmos");
        reservedWords.add("nor");
        reservedWords.add("not");
        reservedWords.add("notif0");
        reservedWords.add("notif1");
        reservedWords.add("or");
        reservedWords.add("output");
        reservedWords.add("parameter");
        reservedWords.add("pmos");
        reservedWords.add("posedge");
        reservedWords.add("primitive");
        reservedWords.add("pull0");
        reservedWords.add("pull1");
        reservedWords.add("pulldown");
        reservedWords.add("pullup");
        reservedWords.add("rcmos");
        reservedWords.add("real");
        reservedWords.add("realtime");
        reservedWords.add("reg");
        reservedWords.add("release");
        reservedWords.add("repeat");
        reservedWords.add("rtranif1");
        reservedWords.add("scalared");
        reservedWords.add("signed");
        reservedWords.add("small");
        reservedWords.add("specify");
        reservedWords.add("specpram");
        reservedWords.add("strength");
        reservedWords.add("strong0");
        reservedWords.add("strong1");
        reservedWords.add("supply0");
        reservedWords.add("supply1");
        reservedWords.add("table");
        reservedWords.add("task");
        reservedWords.add("time");
        reservedWords.add("tran");
        reservedWords.add("tranif0");
        reservedWords.add("tranif1");
        reservedWords.add("tri");
        reservedWords.add("tri0");
        reservedWords.add("tri1");
        reservedWords.add("triand");
        reservedWords.add("trior");
        reservedWords.add("trireg");
        reservedWords.add("unsigned");
        reservedWords.add("vectored");
        reservedWords.add("wait");
        reservedWords.add("wand");
        reservedWords.add("weak0");
        reservedWords.add("weak1");
        reservedWords.add("while");
        reservedWords.add("wire");
        reservedWords.add("wor");
        reservedWords.add("xnor");
        reservedWords.add("xor");
        VERILOG_CODE_KEY = Variable.newKey("VERILOG_code");
        VERILOG_DECLARATION_KEY = Variable.newKey("VERILOG_declaration");
        VERILOG_PARAMETER_KEY = Variable.newKey("VERILOG_parameter");
        VERILOG_EXTERNAL_CODE_KEY = Variable.newKey("VERILOG_external_code");
        WIRE_TYPE_KEY = Variable.newKey("SIM_verilog_wire_type");
        VERILOG_TEMPLATE_KEY = Variable.newKey("ATTR_verilog_template");
        VERILOG_DEFPARAM_KEY = Variable.newKey("ATTR_verilog_defparam");
        VERILOG_BEHAVE_FILE_KEY = Variable.newKey("SIM_verilog_behave_file");
        verilogGates = new String[]{"and", "nand", "or", "nor", "xor", "xnor", "buf", "bufif0", "bufif1", "not", "notif0", "notif1", "pulldown", "pullup", "nmos", "rnmos", "pmos", "rpmos", "cmos", "rcmos", "tran", "rtran", "tranif0", "rtranif0", "tranif1", "rtranif1"};
    }

    public static class VerilogPreferences
    extends Output.OutputPreferences {
        public boolean useTrireg = Simulation.getVerilogUseTrireg();
        public boolean useAssign = Simulation.getVerilogUseAssign();
        public boolean stopAtStandardCells = Simulation.getFactoryVerilogStopAtStandardCells();
        public boolean parameterizeModuleNames = Simulation.getFactoryVerilogParameterizeModuleNames();
        public Map<Cell, String> modelFiles = Collections.emptyMap();
        public VerilogReader.VerilogPreferences inputPrefs;

        public VerilogPreferences() {
            this(false);
        }

        public VerilogPreferences(boolean factory) {
            super(factory);
            this.inputPrefs = new VerilogReader.VerilogPreferences(factory);
            if (!factory) {
                this.fillPrefs();
            }
        }

        private void fillPrefs() {
            this.stopAtStandardCells = Simulation.getVerilogStopAtStandardCells();
            this.parameterizeModuleNames = Simulation.getVerilogParameterizeModuleNames();
            this.modelFiles = CellModelPrefs.verilogModelPrefs.getUnfilteredFileNames(EDatabase.clientDatabase());
        }

        public Output doOutput(Cell cell, VarContext context, String filePath) {
            Verilog out = new Verilog(this);
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            out.filePath = filePath;
            if (out.writeCell(cell, context)) {
                return out.finishWrite();
            }
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }
    }
}

