/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.Snapshot;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.tool.AbstractUserInterface;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.ErrorLogger;
import java.io.IOException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Client {
    private static final ReentrantLock lock = new ReentrantLock();
    private static final Condition queueChanged = lock.newCondition();
    private static ServerEvent queueTail = new JobQueueEvent(new Job.Inform[0]);
    int connectionId;
    int serverJobId;
    int clientJobId;
    final String userName = System.getProperty("user.name");
    private static final OS os;

    private static OS OSInitialize() {
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("windows")) {
                return OS.WINDOWS;
            }
            if (osName.startsWith("linux") || osName.startsWith("solaris") || osName.startsWith("sunos")) {
                return OS.UNIX;
            }
            if (osName.startsWith("mac")) {
                return OS.MACINTOSH;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("No OS detected");
        return null;
    }

    public static OS getOperatingSystem() {
        return os;
    }

    public static boolean isOSWindows() {
        return os == OS.WINDOWS;
    }

    public static boolean isOSMac() {
        return os == OS.MACINTOSH;
    }

    public Client(int connectionId) {
        this.connectionId = connectionId;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public synchronized Job.Key newJobId(boolean isServer, boolean doItOnServer) {
        int jobId = isServer ? (this.serverJobId = this.serverJobId + 1) : (this.clientJobId = this.clientJobId - 1);
        return new Job.Key(this, jobId, doItOnServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putEvent(ServerEvent newEvent) {
        lock.lock();
        try {
            assert (queueTail.next == null);
            assert (newEvent.next == null);
            if (newEvent.snapshot == null) {
                newEvent.snapshot = queueTail.snapshot;
            }
            queueTail = queueTail.next = newEvent;
            queueChanged.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServerEvent getEvent(ServerEvent lastEvent) throws InterruptedException {
        lock.lock();
        try {
            while (lastEvent.next == null) {
                queueChanged.await();
            }
            ServerEvent serverEvent = lastEvent.next;
            return serverEvent;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServerEvent getQueueTail() {
        lock.lock();
        try {
            ServerEvent serverEvent = queueTail;
            return serverEvent;
        }
        finally {
            lock.unlock();
        }
    }

    static void fireServerEvent(ServerEvent serverEvent) {
        Client.putEvent(serverEvent);
    }

    static ServerEvent read(IdReader reader, byte tag, long timeStamp, Client connection, Snapshot snapshot) throws IOException {
        ServerEvent event;
        switch (tag) {
            case 2: {
                Job.Key jobKey = Job.Key.read(reader);
                String jobName = reader.readString();
                Tool tool = null;
                if (reader.readBoolean()) {
                    tool = reader.readTool();
                }
                Job.Type jobType = Job.Type.valueOf(reader.readString());
                boolean doItOk = reader.readBoolean();
                EJob.State newState = EJob.State.SERVER_DONE;
                byte[] serializedJob = null;
                if (reader.readBoolean()) {
                    serializedJob = reader.readBytes();
                }
                byte[] serializedResult = reader.readBytes();
                EJob ejob = new EJob(connection, jobKey.jobId, jobType, jobName, serializedJob);
                ejob.state = newState;
                ejob.doItOk = doItOk;
                ejob.serializedResult = serializedResult;
                event = new EJobEvent(jobKey, jobName, tool, jobType, serializedJob, doItOk, serializedResult, snapshot, newState, timeStamp);
                break;
            }
            case 3: {
                String str = reader.readString();
                event = new PrintEvent(connection, str);
                break;
            }
            case 4: {
                int jobQueueSize = reader.readInt();
                Job.Inform[] jobInforms = new Job.Inform[jobQueueSize];
                for (int jobIndex = 0; jobIndex < jobQueueSize; ++jobIndex) {
                    jobInforms[jobIndex] = Job.Inform.read(reader);
                }
                event = new JobQueueEvent(jobInforms);
                break;
            }
            case 5: {
                String filePath = reader.readString();
                if (filePath.length() == 0) {
                    filePath = null;
                }
                event = new SavePrintEvent(connection, filePath);
                break;
            }
            case 6: {
                String message = reader.readString();
                String title = reader.readString();
                boolean isError = reader.readBoolean();
                event = new ShowMessageEvent(connection, message, title, isError);
                break;
            }
            case 7: {
                String progressMsg = reader.readString();
                boolean hasFilePath = reader.readBoolean();
                String progressFilePath = hasFilePath ? reader.readString() : null;
                event = new StartProgressDialogEvent(progressMsg, progressFilePath);
                break;
            }
            case 8: {
                event = new StopProgressDialogEvent();
                break;
            }
            case 9: {
                int pct = reader.readInt();
                event = new ProgressValueEvent(pct);
                break;
            }
            case 10: {
                boolean hasNote = reader.readBoolean();
                String note = hasNote ? reader.readString() : null;
                event = new ProgressNoteEvent(note);
                break;
            }
            case 11: {
                ErrorLogger logger = ErrorLogger.read(reader);
                boolean explain = reader.readBoolean();
                boolean terminate = reader.readBoolean();
                event = new TermLoggingEvent(logger, explain, terminate);
                break;
            }
            case 12: {
                event = new BeepEvent();
                break;
            }
            case 13: {
                event = new ShutdownEvent();
                break;
            }
            default: {
                System.err.println("Unknown tag=" + tag);
                for (int i = 0; i < 20; ++i) {
                    char c = (char)reader.readByte();
                    System.err.print(" " + Integer.toHexString(c) + "(" + c + ")");
                }
                System.err.println();
                throw new AssertionError();
            }
        }
        event.timeStamp = timeStamp;
        event.snapshot = snapshot;
        return event;
    }

    static {
        queueTail.snapshot = IdManager.stdIdManager.getInitialSnapshot();
        os = Client.OSInitialize();
    }

    public static class ShutdownEvent
    extends ServerEvent {
        ShutdownEvent() {
        }

        void write(IdWriter writer) throws IOException {
            this.writeHeader(writer, 13);
        }

        void show(AbstractUserInterface ui) {
            ui.printMessage("SHUTDOWN !", true);
        }
    }

    public static class BeepEvent
    extends ServerEvent {
        BeepEvent() {
        }

        void write(IdWriter writer) throws IOException {
            this.writeHeader(writer, 12);
        }

        void show(AbstractUserInterface ui) {
            ui.beep();
        }
    }

    public static class TermLoggingEvent
    extends ServerEvent {
        final ErrorLogger logger;
        public final boolean explain;
        public final boolean terminate;

        TermLoggingEvent(ErrorLogger logger, boolean explain, boolean terminate) {
            this.logger = logger;
            this.explain = explain;
            this.terminate = terminate;
        }

        void write(IdWriter writer) throws IOException {
            this.writeHeader(writer, 11);
            this.logger.write(writer);
            writer.writeBoolean(this.explain);
            writer.writeBoolean(this.terminate);
        }

        void show(AbstractUserInterface ui) {
            ui.termLogging(this.logger, this.explain, this.terminate);
        }
    }

    public static class ProgressNoteEvent
    extends ServerEvent {
        public final String note;

        ProgressNoteEvent(String note) {
            this.note = note;
        }

        void write(IdWriter writer) throws IOException {
            this.writeHeader(writer, 10);
            writer.writeBoolean(this.note != null);
            if (this.note != null) {
                writer.writeString(this.note);
            }
        }

        void show(AbstractUserInterface ui) {
            ui.setProgressNote(this.note);
        }
    }

    public static class ProgressValueEvent
    extends ServerEvent {
        public final int pct;

        ProgressValueEvent(int pct) {
            this.pct = pct;
        }

        void write(IdWriter writer) throws IOException {
            this.writeHeader(writer, 9);
            writer.writeInt(this.pct);
        }

        void show(AbstractUserInterface ui) {
            ui.setProgressValue(this.pct);
        }
    }

    public static class StopProgressDialogEvent
    extends ServerEvent {
        StopProgressDialogEvent() {
        }

        void write(IdWriter writer) throws IOException {
            this.writeHeader(writer, 8);
        }

        void show(AbstractUserInterface ui) {
            ui.stopProgressDialog();
        }
    }

    public static class StartProgressDialogEvent
    extends ServerEvent {
        public final String msg;
        public final String filePath;

        StartProgressDialogEvent(String msg, String filePath) {
            this.msg = msg;
            this.filePath = filePath;
        }

        void write(IdWriter writer) throws IOException {
            this.writeHeader(writer, 7);
            writer.writeString(this.msg);
            writer.writeBoolean(this.filePath != null);
            if (this.filePath != null) {
                writer.writeString(this.filePath);
            }
        }

        void show(AbstractUserInterface ui) {
            ui.startProgressDialog(this.msg, this.filePath);
        }
    }

    public static class JobQueueEvent
    extends ServerEvent {
        public final Job.Inform[] jobQueue;

        JobQueueEvent(Job.Inform[] jobQueue) {
            this.jobQueue = jobQueue;
        }

        void write(IdWriter writer) throws IOException {
            this.writeHeader(writer, 4);
            writer.writeInt(this.jobQueue.length);
            for (Job.Inform j : this.jobQueue) {
                j.write(writer);
            }
        }

        void show(AbstractUserInterface ui) {
            ui.showServerJobQueue(this.jobQueue);
        }
    }

    public static class ShowMessageEvent
    extends ServerEvent {
        public final String message;
        public final String title;
        public final boolean isError;

        ShowMessageEvent(Client client, String message, String title, boolean isError) {
            this.message = message;
            this.title = title;
            this.isError = isError;
        }

        void write(IdWriter writer) throws IOException {
            this.writeHeader(writer, 6);
            writer.writeString(this.message);
            writer.writeString(this.title);
            writer.writeBoolean(this.isError);
        }

        void show(AbstractUserInterface ui) {
            if (this.isError) {
                ui.showErrorMessage(this.message, this.title);
            } else {
                ui.showInformationMessage(this.message, this.title);
            }
        }
    }

    public static class SavePrintEvent
    extends ServerEvent {
        public final String filePath;

        SavePrintEvent(Client client, String filePath) {
            this.filePath = filePath;
        }

        void write(IdWriter writer) throws IOException {
            this.writeHeader(writer, 5);
            writer.writeString(this.filePath != null ? this.filePath : "");
        }

        void show(AbstractUserInterface ui) {
            ui.saveMessages(this.filePath);
        }
    }

    public static class PrintEvent
    extends ServerEvent {
        public final String s;

        PrintEvent(Client client, String s) {
            this.s = s;
        }

        void write(IdWriter writer) throws IOException {
            this.writeHeader(writer, 3);
            writer.writeString(this.s);
        }

        void show(AbstractUserInterface ui) {
            ui.printMessage(this.s, false);
        }
    }

    public static class EJobEvent
    extends ServerEvent {
        public final Job.Key jobKey;
        public final String jobName;
        public final Tool tool;
        public final Job.Type jobType;
        public final byte[] serializedJob;
        public final boolean doItOk;
        public final byte[] serializedResult;
        public final EJob.State newState;

        EJobEvent(Job.Key jobKey, String jobName, Tool tool, Job.Type jobType, byte[] serializedJob, boolean doItOk, byte[] serializedResult, Snapshot newSnapshot, EJob.State newState) {
            super(newSnapshot);
            assert (jobKey != null);
            this.jobKey = jobKey;
            this.jobName = jobName;
            this.tool = tool;
            this.jobType = jobType;
            this.serializedJob = serializedJob;
            this.doItOk = doItOk;
            this.serializedResult = serializedResult;
            this.newState = newState;
            assert (newState == EJob.State.SERVER_DONE);
        }

        EJobEvent(Job.Key jobKey, String jobName, Tool tool, Job.Type jobType, byte[] serializedJob, boolean doItOk, byte[] serializedResult, Snapshot newSnapshot, EJob.State newState, long timeStamp) {
            super(newSnapshot, timeStamp);
            assert (jobKey != null);
            this.jobKey = jobKey;
            this.jobName = jobName;
            this.tool = tool;
            this.jobType = jobType;
            this.serializedJob = serializedJob;
            this.doItOk = doItOk;
            this.serializedResult = serializedResult;
            this.newState = newState;
            assert (newState == EJob.State.SERVER_DONE);
        }

        void write(IdWriter writer) throws IOException {
            assert (this.newState == EJob.State.SERVER_DONE);
            this.writeHeader(writer, 2);
            this.jobKey.write(writer);
            writer.writeString(this.jobName);
            writer.writeBoolean(this.tool != null);
            if (this.tool != null) {
                writer.writeTool(this.tool);
            }
            writer.writeString(this.jobType.toString());
            writer.writeBoolean(this.doItOk);
            writer.writeBoolean(this.serializedJob != null);
            if (this.serializedJob != null) {
                writer.writeBytes(this.serializedJob);
            }
            writer.writeBytes(this.serializedResult);
        }

        void show(AbstractUserInterface ui) {
            assert (this.newState == EJob.State.SERVER_DONE);
            ui.terminateJob(this.jobKey, this.jobName, this.tool, this.jobType, this.serializedJob, this.doItOk, this.serializedResult, this.getSnapshot());
        }
    }

    public static abstract class ServerEvent
    implements Runnable {
        private Snapshot snapshot;
        private long timeStamp;
        private volatile ServerEvent next;

        ServerEvent() {
            this(null, System.currentTimeMillis());
        }

        ServerEvent(Snapshot snapshot) {
            this(snapshot, System.currentTimeMillis());
        }

        ServerEvent(Snapshot snapshot, long timeStamp) {
            this.snapshot = snapshot;
            this.timeStamp = timeStamp;
        }

        Snapshot getSnapshot() {
            return this.snapshot;
        }

        long getTimeStamp() {
            return this.timeStamp;
        }

        ServerEvent getNext() {
            return this.next;
        }

        public void run() {
            try {
                this.show(Job.currentUI);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        abstract void write(IdWriter var1) throws IOException;

        abstract void show(AbstractUserInterface var1);

        void writeHeader(IdWriter writer, int tag) throws IOException {
            writer.writeByte((byte)tag);
            writer.writeLong(this.timeStamp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        WINDOWS("Windows"),
        UNIX("UNIX"),
        MACINTOSH("Macintosh");

        private String name;

        private OS(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

