/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.output.CellModelPrefs;
import com.sun.electric.tool.ncc.Ncc;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.result.NccResult;
import com.sun.electric.tool.ncc.result.NccResults;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NccCrossProbing
extends HierarchyEnumerator.Visitor {
    private Map<Cell, Integer> visitedCells = new HashMap<Cell, Integer>();
    private static Map<Cell, NccResult> results = new HashMap<Cell, NccResult>();

    public static NccResult getResults(Cell cell) {
        return results.get(cell);
    }

    public static void runNccSchematicCrossProbing(Cell cell, VarContext context) {
        if (!cell.isSchematic()) {
            System.out.println("Error: NCC for Schematic Cross-Probing must be run on a schematic");
            return;
        }
        results.clear();
        new NccCrossProbeJob(cell, context).startJob();
    }

    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        Cell cell = info.getCell();
        if (this.visitedCells.containsKey(cell)) {
            return false;
        }
        this.visitedCells.put(cell, null);
        if (!cell.isSchematic()) {
            System.out.println("Why is there layout cell " + cell.describe(false) + " inside of a schematic?");
            return false;
        }
        if (!CellModelPrefs.spiceModelPrefs.isUseLayoutView(cell)) {
            return true;
        }
        Cell.CellGroup group = cell.getCellGroup();
        Cell layCell = null;
        Iterator<Cell> it = group.getCells();
        while (it.hasNext()) {
            Cell c = it.next();
            if (c.getView() != View.LAYOUT) continue;
            layCell = c;
            break;
        }
        if (layCell == null) {
            return true;
        }
        NccOptions options = new NccOptions();
        options.operation = 2;
        options.checkSizes = false;
        options.maxMatchedEquivRecsToPrint = 0;
        options.maxMismatchedEquivRecsToPrint = 0;
        options.maxEquivRecMembersToPrint = 0;
        options.howMuchStatus = 0;
        NccResults result = Ncc.compare(cell, info.getContext(), layCell, info.getContext(), options);
        if (!result.match()) {
            System.out.println("Flat NCC of " + cell.describe(false) + " vs " + layCell.describe(false) + " Failed!\n" + "   Its ayout will not be used for cross-probing.");
        } else {
            System.out.println("Flat NCC of " + cell.describe(false) + " vs " + layCell.describe(false) + " Passed");
            results.put(cell, result.getResultFromRootCells());
        }
        return false;
    }

    public void exitCell(HierarchyEnumerator.CellInfo info) {
    }

    public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
        return true;
    }

    private static class NccCrossProbeJob
    extends Job {
        private Cell cell;
        private VarContext context;
        private NccCrossProbing visitor = new NccCrossProbing();

        private NccCrossProbeJob(Cell cell, VarContext context) {
            super("NccCrossProb", NetworkTool.getNetworkTool(), Job.Type.CLIENT_EXAMINE, null, null, Job.Priority.ANALYSIS);
            this.cell = cell;
            this.context = context;
        }

        public boolean doIt() {
            HierarchyEnumerator.enumerateCell(this.cell, this.context, (HierarchyEnumerator.Visitor)this.visitor);
            return true;
        }
    }
}

