/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.ArtworkLook;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class GetInfoMulti
extends EModelessDialog
implements HighlightListener,
DatabaseChangeListener {
    private static GetInfoMulti theDialog = null;
    private DefaultListModel listModel;
    private JList list;
    private JPanel changePanel;
    private ChangeType[] currentChangeTypes;
    private JComponent[] currentChangeValues;
    private List<Highlight2> highlightList = new ArrayList<Highlight2>();
    List<NodeInst> nodeList;
    List<ArcInst> arcList;
    List<Export> exportList;
    List<DisplayedText> textList;
    private EditWindow wnd;
    private static final ChangeType[] nodeChanges = new ChangeType[]{ChangeType.CHANGEXSIZE, ChangeType.CHANGEYSIZE, ChangeType.CHANGEXPOS, ChangeType.CHANGEYPOS, ChangeType.CHANGEROTATION, ChangeType.CHANGEMIRRORLR, ChangeType.CHANGEMIRRORUD, ChangeType.CHANGEEXPANDED, ChangeType.CHANGEEASYSELECT, ChangeType.CHANGEINVOUTSIDECELL, ChangeType.CHANGELOCKED};
    private static final ChangeType[] arcChanges = new ChangeType[]{ChangeType.CHANGEWIDTH, ChangeType.CHANGERIGID, ChangeType.CHANGEFIXANGLE, ChangeType.CHANGESLIDABLE, ChangeType.CHANGEEXTENSION, ChangeType.CHANGEDIRECTION, ChangeType.CHANGENEGATION, ChangeType.CHANGEEASYSELECT};
    private static final ChangeType[] exportChanges = new ChangeType[]{ChangeType.CHANGECHARACTERISTICS, ChangeType.CHANGEBODYONLY, ChangeType.CHANGEALWAYSDRAWN, ChangeType.CHANGEPOINTSIZE, ChangeType.CHANGEUNITSIZE, ChangeType.CHANGEXOFF, ChangeType.CHANGEYOFF, ChangeType.CHANGETEXTROT, ChangeType.CHANGEANCHOR, ChangeType.CHANGEFONT, ChangeType.CHANGECOLOR, ChangeType.CHANGEBOLD, ChangeType.CHANGEITALIC, ChangeType.CHANGEUNDERLINE, ChangeType.CHANGEINVOUTSIDECELL};
    private static final ChangeType[] textChanges = new ChangeType[]{ChangeType.CHANGEPOINTSIZE, ChangeType.CHANGEUNITSIZE, ChangeType.CHANGEXOFF, ChangeType.CHANGEYOFF, ChangeType.CHANGETEXTROT, ChangeType.CHANGEANCHOR, ChangeType.CHANGEFONT, ChangeType.CHANGECOLOR, ChangeType.CHANGECODE, ChangeType.CHANGEUNITS, ChangeType.CHANGESHOW, ChangeType.CHANGEBOLD, ChangeType.CHANGEITALIC, ChangeType.CHANGEUNDERLINE, ChangeType.CHANGEINVOUTSIDECELL};
    private static final ChangeType[] nodeArcChanges = new ChangeType[]{ChangeType.CHANGEEASYSELECT};
    private static final ChangeType[] nodeTextChanges = new ChangeType[]{ChangeType.CHANGEINVOUTSIDECELL};
    private static final ChangeType[] nodeExportChanges = new ChangeType[]{ChangeType.CHANGEINVOUTSIDECELL};
    private static final ChangeType[] nodeTextExportChanges = new ChangeType[]{ChangeType.CHANGEINVOUTSIDECELL};
    private static final ChangeType[] textExportChanges = new ChangeType[]{ChangeType.CHANGEPOINTSIZE, ChangeType.CHANGEUNITSIZE, ChangeType.CHANGEXOFF, ChangeType.CHANGEYOFF, ChangeType.CHANGETEXTROT, ChangeType.CHANGEANCHOR, ChangeType.CHANGEFONT, ChangeType.CHANGECOLOR, ChangeType.CHANGEBOLD, ChangeType.CHANGEITALIC, ChangeType.CHANGEUNDERLINE, ChangeType.CHANGEINVOUTSIDECELL};
    private static final ChangeType[][] changeCombos = new ChangeType[][]{null, nodeChanges, arcChanges, nodeArcChanges, exportChanges, nodeExportChanges, null, null, textChanges, nodeTextChanges, null, null, textExportChanges, nodeTextExportChanges, null, null};
    private JButton apply;
    private JButton cancel;
    private JScrollPane listPane;
    private JButton ok;
    private JScrollPane possibleChanges;
    private JButton remove;
    private JButton removeOthers;
    private JLabel selectionCount;

    public static void showDialog() {
        if (Client.getOperatingSystem() == Client.OS.UNIX) {
            if (theDialog != null) {
                theDialog.dispose();
            }
            theDialog = null;
        }
        if (theDialog == null) {
            TopLevel jf = null;
            if (TopLevel.isMDIMode()) {
                jf = TopLevel.getCurrentJFrame();
            }
            theDialog = new GetInfoMulti(jf);
        }
        theDialog.loadMultiInfo();
        theDialog.pack();
        theDialog.ensureMinimumSize();
        theDialog.setVisible(true);
        theDialog.toFront();
    }

    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        Dimension oldDim = this.listPane.getSize();
        this.loadMultiInfo();
        this.listPane.setPreferredSize(oldDim);
        this.pack();
        this.ensureMinimumSize();
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadMultiInfo();
    }

    public void databaseChanged(DatabaseChangeEvent e) {
        if (!this.isVisible()) {
            return;
        }
        boolean reload = false;
        for (Highlight2 h : this.highlightList) {
            if (!e.objectChanged(h.getElectricObject())) continue;
            reload = true;
            break;
        }
        if (reload) {
            this.loadMultiInfo();
            this.pack();
            this.ensureMinimumSize();
        }
    }

    private GetInfoMulti(Frame parent) {
        super(parent, false);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        UserInterfaceMain.addDatabaseChangeListener(this);
        Highlighter.addHighlightListener(this);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(2);
        this.listPane.setViewportView(this.list);
        this.changePanel = new JPanel();
        this.changePanel.setLayout(new BoxLayout(this.changePanel, 1));
        this.possibleChanges.setViewportView(this.changePanel);
        this.loadMultiInfo();
        this.pack();
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void loadMultiInfo() {
        EditWindow curWnd = EditWindow.getCurrent();
        if (curWnd != null) {
            this.wnd = curWnd;
        }
        this.highlightList.clear();
        if (this.wnd != null) {
            for (Highlight2 h : this.wnd.getHighlighter().getHighlights()) {
                this.highlightList.add(h);
            }
            Collections.sort(this.highlightList, new SortMultipleHighlights());
        }
        this.nodeList = new ArrayList<NodeInst>();
        this.arcList = new ArrayList<ArcInst>();
        this.exportList = new ArrayList<Export>();
        this.textList = new ArrayList<DisplayedText>();
        Geometric firstGeom = null;
        Geometric secondGeom = null;
        double xPositionLow = Double.MAX_VALUE;
        double xPositionHigh = -1.7976931348623157E308;
        double yPositionLow = Double.MAX_VALUE;
        double yPositionHigh = -1.7976931348623157E308;
        double xSizeLow = Double.MAX_VALUE;
        double xSizeHigh = -1.7976931348623157E308;
        double ySizeLow = Double.MAX_VALUE;
        double ySizeHigh = -1.7976931348623157E308;
        double widthLow = Double.MAX_VALUE;
        double widthHigh = -1.7976931348623157E308;
        double rotLow = Double.MAX_VALUE;
        double rotHigh = -1.7976931348623157E308;
        this.selectionCount.setText(Integer.toString(this.highlightList.size()) + " selections:");
        ArrayList<String> displayList = new ArrayList<String>();
        for (Highlight2 h : this.highlightList) {
            Variable.Key varKey;
            ElectricObject eobj = h.getElectricObject();
            displayList.add(h.getInfo());
            if (h.isHighlightEOBJ()) {
                if (eobj instanceof PortInst) {
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                if (eobj instanceof Geometric) {
                    if (firstGeom == null) {
                        firstGeom = (Geometric)eobj;
                    } else if (secondGeom == null) {
                        secondGeom = (Geometric)eobj;
                    }
                }
                if (eobj instanceof NodeInst) {
                    NodeInst ni = (NodeInst)eobj;
                    this.nodeList.add(ni);
                    xPositionLow = Math.min(xPositionLow, ni.getAnchorCenterX());
                    xPositionHigh = Math.max(xPositionHigh, ni.getAnchorCenterX());
                    yPositionLow = Math.min(yPositionLow, ni.getAnchorCenterY());
                    yPositionHigh = Math.max(yPositionHigh, ni.getAnchorCenterY());
                    SizeOffset so = ni.getSizeOffset();
                    double xVal = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
                    double yVal = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
                    double angle = ni.getAngle();
                    rotLow = Math.min(rotLow, angle);
                    rotHigh = Math.max(rotHigh, angle);
                    if (angle == 900.0 || angle == 2700.0) {
                        double swap = xVal;
                        xVal = yVal;
                        yVal = swap;
                    }
                    xSizeLow = Math.min(xSizeLow, xVal);
                    xSizeHigh = Math.max(xSizeHigh, xVal);
                    ySizeLow = Math.min(ySizeLow, yVal);
                    ySizeHigh = Math.max(ySizeHigh, yVal);
                    continue;
                }
                if (!(eobj instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)eobj;
                this.arcList.add(ai);
                double trueWidth = ai.getLambdaBaseWidth();
                widthLow = Math.min(widthLow, trueWidth);
                widthHigh = Math.max(widthHigh, trueWidth);
                continue;
            }
            if (!h.isHighlightText() || (varKey = h.getVarKey()) == null) continue;
            if (varKey == Export.EXPORT_NAME) {
                this.exportList.add((Export)h.getElectricObject());
                continue;
            }
            this.textList.add(new DisplayedText(eobj, varKey));
        }
        if (this.nodeList.size() + this.arcList.size() == 2) {
            displayList.add("---------------------------");
            Point2D firstPt = firstGeom.getTrueCenter();
            if (firstGeom instanceof NodeInst) {
                firstPt = ((NodeInst)firstGeom).getAnchorCenter();
            }
            Point2D secondPt = secondGeom.getTrueCenter();
            if (secondGeom instanceof NodeInst) {
                secondPt = ((NodeInst)secondGeom).getAnchorCenter();
            }
            displayList.add("Distance between centers: X=" + Math.abs(firstPt.getX() - secondPt.getX()) + " Y=" + Math.abs(firstPt.getY() - secondPt.getY()));
        }
        this.list.setListData(displayList.toArray());
        int index = 0;
        if (this.nodeList.size() != 0) {
            ++index;
        }
        if (this.arcList.size() != 0) {
            index += 2;
        }
        if (this.exportList.size() != 0) {
            index += 4;
        }
        if (this.textList.size() != 0) {
            index += 8;
        }
        this.changePanel.removeAll();
        this.currentChangeTypes = changeCombos[index];
        if (this.currentChangeTypes == null) {
            return;
        }
        this.currentChangeValues = new JComponent[this.currentChangeTypes.length];
        if (this.currentChangeTypes != null) {
            for (int c = 0; c < this.currentChangeTypes.length; ++c) {
                ChangeType change = this.currentChangeTypes[c];
                JPanel onePanel = new JPanel();
                onePanel.setLayout(new GridBagLayout());
                String msg = null;
                switch (change) {
                    case CHANGEXSIZE: {
                        msg = xSizeLow == xSizeHigh ? "(All are " + TextUtils.formatDouble(xSizeLow) + ")" : "(" + TextUtils.formatDouble(xSizeLow) + " to " + TextUtils.formatDouble(xSizeHigh) + ")";
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("X size:", this.currentChangeValues[c], msg, onePanel);
                        break;
                    }
                    case CHANGEYSIZE: {
                        msg = ySizeLow == ySizeHigh ? "(All are " + TextUtils.formatDouble(ySizeLow) + ")" : "(" + TextUtils.formatDouble(ySizeLow) + " to " + TextUtils.formatDouble(ySizeHigh) + ")";
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("Y size:", this.currentChangeValues[c], msg, onePanel);
                        break;
                    }
                    case CHANGEXPOS: {
                        msg = xPositionLow == xPositionHigh ? "(All are " + TextUtils.formatDouble(xPositionLow) + ")" : "(" + TextUtils.formatDouble(xPositionLow) + " to " + TextUtils.formatDouble(xPositionHigh) + ")";
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("X position:", this.currentChangeValues[c], msg, onePanel);
                        break;
                    }
                    case CHANGEYPOS: {
                        msg = yPositionLow == yPositionHigh ? "(All are " + TextUtils.formatDouble(yPositionLow) + ")" : "(" + TextUtils.formatDouble(yPositionLow) + " to " + TextUtils.formatDouble(yPositionHigh) + ")";
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("Y position:", this.currentChangeValues[c], msg, onePanel);
                        break;
                    }
                    case CHANGEROTATION: {
                        msg = rotLow == rotHigh ? "(All are " + TextUtils.formatDouble(rotHigh / 10.0) + ")" : "(" + TextUtils.formatDouble(rotLow / 10.0) + " to " + TextUtils.formatDouble(rotHigh / 10.0) + ")";
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("Rotation:", this.currentChangeValues[c], msg, onePanel);
                        break;
                    }
                    case CHANGEMIRRORLR: {
                        JComboBox<String> lr = new JComboBox<String>();
                        lr.addItem("Leave alone");
                        lr.addItem("Set");
                        lr.addItem("Clear");
                        this.currentChangeValues[c] = lr;
                        this.addChangePossibility("Mirror L-R:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEMIRRORUD: {
                        JComboBox<String> ud = new JComboBox<String>();
                        ud.addItem("Leave alone");
                        ud.addItem("Set");
                        ud.addItem("Clear");
                        this.currentChangeValues[c] = ud;
                        this.addChangePossibility("Mirror U-D:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEEXPANDED: {
                        JComboBox<String> exp = new JComboBox<String>();
                        exp.addItem("Leave alone");
                        exp.addItem("Expand");
                        exp.addItem("Unexpand");
                        this.currentChangeValues[c] = exp;
                        this.addChangePossibility("Expansion:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEEASYSELECT: {
                        JComboBox<String> es = new JComboBox<String>();
                        es.addItem("Leave alone");
                        es.addItem("Make Easy");
                        es.addItem("Make Hard");
                        this.currentChangeValues[c] = es;
                        this.addChangePossibility("Ease of Selection:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEINVOUTSIDECELL: {
                        JComboBox<String> io = new JComboBox<String>();
                        io.addItem("Leave alone");
                        io.addItem("Make Invisible");
                        io.addItem("Make Visible");
                        this.currentChangeValues[c] = io;
                        this.addChangePossibility("Invisible Outside Cell:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGELOCKED: {
                        JComboBox<String> lo = new JComboBox<String>();
                        lo.addItem("Leave alone");
                        lo.addItem("Lock");
                        lo.addItem("Unlock");
                        this.currentChangeValues[c] = lo;
                        this.addChangePossibility("Locked:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEWIDTH: {
                        msg = widthLow == widthHigh ? "(All are " + TextUtils.formatDouble(widthLow) + ")" : "(" + TextUtils.formatDouble(widthLow) + " to " + TextUtils.formatDouble(widthHigh) + ")";
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("Width:", this.currentChangeValues[c], msg, onePanel);
                        break;
                    }
                    case CHANGERIGID: {
                        JComboBox<String> ri = new JComboBox<String>();
                        ri.addItem("Leave alone");
                        ri.addItem("Make Rigid");
                        ri.addItem("Make Unrigid");
                        this.currentChangeValues[c] = ri;
                        this.addChangePossibility("Rigid:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEFIXANGLE: {
                        JComboBox<String> fa = new JComboBox<String>();
                        fa.addItem("Leave alone");
                        fa.addItem("Make Fixed Angle");
                        fa.addItem("Make Not Fixed Angle");
                        this.currentChangeValues[c] = fa;
                        this.addChangePossibility("Fixed Angle:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGESLIDABLE: {
                        JComboBox<String> sl = new JComboBox<String>();
                        sl.addItem("Leave alone");
                        sl.addItem("Make Slidable");
                        sl.addItem("Make Not Slidable");
                        this.currentChangeValues[c] = sl;
                        this.addChangePossibility("Slidable:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEEXTENSION: {
                        JComboBox<String> ex = new JComboBox<String>();
                        ex.addItem("Leave alone");
                        ex.addItem("Make Both Ends Extend");
                        ex.addItem("Make Neither End Extend");
                        ex.addItem("Make Head Extend");
                        ex.addItem("Make Tail Extend");
                        this.currentChangeValues[c] = ex;
                        this.addChangePossibility("Extension:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEDIRECTION: {
                        JComboBox<String> di = new JComboBox<String>();
                        di.addItem("Leave alone");
                        di.addItem("No directional arrow");
                        di.addItem("Arrow on Head and Body");
                        di.addItem("Arrow on Tail and Body");
                        di.addItem("Arrow on Body Only");
                        di.addItem("Arrow on Head, Tail, and Body");
                        this.currentChangeValues[c] = di;
                        this.addChangePossibility("Directionality:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGENEGATION: {
                        JComboBox<String> ne = new JComboBox<String>();
                        ne.addItem("Leave alone");
                        ne.addItem("No Negation");
                        ne.addItem("Negate Head");
                        ne.addItem("Negate Tail");
                        ne.addItem("Negate Head and Tail");
                        this.currentChangeValues[c] = ne;
                        this.addChangePossibility("Negation:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGECHARACTERISTICS: {
                        JComboBox<String> ch = new JComboBox<String>();
                        ch.addItem("Leave alone");
                        List<PortCharacteristic> chList = PortCharacteristic.getOrderedCharacteristics();
                        for (PortCharacteristic chara : chList) {
                            ch.addItem(chara.getName());
                        }
                        this.currentChangeValues[c] = ch;
                        this.addChangePossibility("Characteristics:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEBODYONLY: {
                        JComboBox<String> bo = new JComboBox<String>();
                        bo.addItem("Leave alone");
                        bo.addItem("Make Body Only");
                        bo.addItem("Make Not Body Only");
                        this.currentChangeValues[c] = bo;
                        this.addChangePossibility("Body Only:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEALWAYSDRAWN: {
                        JComboBox<String> ad = new JComboBox<String>();
                        ad.addItem("Leave alone");
                        ad.addItem("Make Always Drawn");
                        ad.addItem("Make Not Always Drawn");
                        this.currentChangeValues[c] = ad;
                        this.addChangePossibility("Always Drawn:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEPOINTSIZE: {
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("Point Size:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEUNITSIZE: {
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("Unit Size:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEXOFF: {
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("X Offset:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEYOFF: {
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("Y Offset:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGETEXTROT: {
                        JComboBox<String> tr = new JComboBox<String>();
                        tr.addItem("Leave alone");
                        tr.addItem("No Rotation");
                        tr.addItem("Rotate 90 Degrees");
                        tr.addItem("Rotate 180 Degrees");
                        tr.addItem("Rotate 270 Degrees");
                        this.currentChangeValues[c] = tr;
                        this.addChangePossibility("Text Rotation:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEANCHOR: {
                        JComboBox<Object> an = new JComboBox<Object>();
                        an.addItem("Leave alone");
                        Iterator<AbstractTextDescriptor.Position> it = AbstractTextDescriptor.Position.getPositions();
                        while (it.hasNext()) {
                            AbstractTextDescriptor.Position pos = it.next();
                            an.addItem(pos);
                        }
                        this.currentChangeValues[c] = an;
                        this.addChangePossibility("Text Anchor:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEFONT: {
                        JComboBox<String> fo = new JComboBox<String>();
                        fo.addItem("Leave alone");
                        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
                        for (int i = 0; i < fonts.length; ++i) {
                            fo.addItem(fonts[i].getFontName());
                        }
                        this.currentChangeValues[c] = fo;
                        this.addChangePossibility("Text Font:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGECOLOR: {
                        JComboBox<String> co = new JComboBox<String>();
                        co.addItem("Leave alone");
                        int[] colorIndices = EGraphics.getColorIndices();
                        for (int i = 0; i < colorIndices.length; ++i) {
                            co.addItem(EGraphics.getColorIndexName(colorIndices[i]));
                        }
                        this.currentChangeValues[c] = co;
                        this.addChangePossibility("Text Color:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEBOLD: {
                        JComboBox<String> bd = new JComboBox<String>();
                        bd.addItem("Leave alone");
                        bd.addItem("Make Bold");
                        bd.addItem("Make Not Bold");
                        this.currentChangeValues[c] = bd;
                        this.addChangePossibility("Bold:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEITALIC: {
                        JComboBox<String> it = new JComboBox<String>();
                        it.addItem("Leave alone");
                        it.addItem("Make Italic");
                        it.addItem("Make Not Italic");
                        this.currentChangeValues[c] = it;
                        this.addChangePossibility("Italic:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEUNDERLINE: {
                        JComboBox<String> ul = new JComboBox<String>();
                        ul.addItem("Leave alone");
                        ul.addItem("Make Underlined");
                        ul.addItem("Make Not Underlined");
                        this.currentChangeValues[c] = ul;
                        this.addChangePossibility("Underlined:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGECODE: {
                        JComboBox<Object> cd = new JComboBox<Object>();
                        cd.addItem("Leave alone");
                        Iterator<AbstractTextDescriptor.Code> cIt = AbstractTextDescriptor.Code.getCodes();
                        while (cIt.hasNext()) {
                            cd.addItem((Object)cIt.next());
                        }
                        this.currentChangeValues[c] = cd;
                        this.addChangePossibility("Code:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGEUNITS: {
                        JComboBox<Object> un = new JComboBox<Object>();
                        un.addItem("Leave alone");
                        Iterator<AbstractTextDescriptor.Unit> uIt = AbstractTextDescriptor.Unit.getUnits();
                        while (uIt.hasNext()) {
                            un.addItem(uIt.next());
                        }
                        this.currentChangeValues[c] = un;
                        this.addChangePossibility("Units:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case CHANGESHOW: {
                        JComboBox<Object> sh = new JComboBox<Object>();
                        sh.addItem("Leave alone");
                        Iterator<AbstractTextDescriptor.DispPos> sIt = AbstractTextDescriptor.DispPos.getShowStyles();
                        while (sIt.hasNext()) {
                            sh.addItem(sIt.next());
                        }
                        this.currentChangeValues[c] = sh;
                        this.addChangePossibility("Show:", this.currentChangeValues[c], null, onePanel);
                    }
                }
                this.changePanel.add(onePanel);
            }
            boolean hasArtwork = false;
            for (NodeInst ni : this.nodeList) {
                if (ni.isCellInstance() || ni.getProto().getTechnology() != Artwork.tech) continue;
                hasArtwork = true;
            }
            for (ArcInst ai : this.arcList) {
                if (ai.getProto().getTechnology() != Artwork.tech) continue;
                hasArtwork = true;
            }
            if (hasArtwork) {
                JPanel butPanel = new JPanel();
                butPanel.setLayout(new GridBagLayout());
                JButton sh = new JButton("Color and Pattern...");
                sh.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        ArtworkLook.showArtworkLookDialog();
                    }
                });
                this.addChangePossibility(null, sh, null, butPanel);
                this.changePanel.add(butPanel);
            }
        }
    }

    private void addChangePossibility(String label, JComponent comp, String msg, JPanel onePanel) {
        int bottom = 4;
        if (msg != null) {
            bottom = 0;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, bottom, 4);
        if (label == null) {
            gbc.gridx = 0;
            gbc.gridwidth = 2;
        } else {
            GridBagConstraints lgbc = new GridBagConstraints();
            lgbc.gridx = 0;
            lgbc.gridy = 0;
            lgbc.insets = new Insets(4, 4, bottom, 4);
            onePanel.add((Component)new JLabel(label), lgbc);
        }
        onePanel.add((Component)comp, gbc);
        if (msg != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.insets = new Insets(0, 4, 4, 4);
            onePanel.add((Component)new JLabel(msg), gbc);
        }
    }

    private Object findComboBoxValue(ChangeType type) {
        if (this.currentChangeTypes != null) {
            for (int c = 0; c < this.currentChangeTypes.length; ++c) {
                ChangeType change = this.currentChangeTypes[c];
                if (change != type) continue;
                return ((JComboBox)this.currentChangeValues[c]).getSelectedItem();
            }
        }
        return null;
    }

    private int findComboBoxIndex(ChangeType type) {
        if (this.currentChangeTypes != null) {
            for (int c = 0; c < this.currentChangeTypes.length; ++c) {
                ChangeType change = this.currentChangeTypes[c];
                if (change != type) continue;
                return ((JComboBox)this.currentChangeValues[c]).getSelectedIndex();
            }
        }
        return -1;
    }

    private String findComponentStringValue(ChangeType type) {
        if (this.currentChangeTypes != null) {
            for (int c = 0; c < this.currentChangeTypes.length; ++c) {
                ChangeType change = this.currentChangeTypes[c];
                if (change != type) continue;
                return ((JTextField)this.currentChangeValues[c]).getText().trim();
            }
        }
        return "";
    }

    private int findComponentIntValue(ChangeType type) {
        if (this.currentChangeTypes != null) {
            for (int c = 0; c < this.currentChangeTypes.length; ++c) {
                ChangeType change = this.currentChangeTypes[c];
                if (change != type) continue;
                return ((JComboBox)this.currentChangeValues[c]).getSelectedIndex();
            }
        }
        return 0;
    }

    private void initComponents() {
        this.removeOthers = new JButton();
        this.apply = new JButton();
        this.selectionCount = new JLabel();
        this.listPane = new JScrollPane();
        this.ok = new JButton();
        this.remove = new JButton();
        this.cancel = new JButton();
        this.possibleChanges = new JScrollPane();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Multi-Object Properties");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GetInfoMulti.this.closeDialog(evt);
            }
        });
        this.removeOthers.setText("Remove Others");
        this.removeOthers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoMulti.this.removeOthersActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.removeOthers, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoMulti.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.selectionCount.setText("0 selections:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.getContentPane().add((Component)this.selectionCount, gridBagConstraints);
        this.listPane.setMinimumSize(new Dimension(300, 200));
        this.listPane.setPreferredSize(new Dimension(300, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.listPane, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoMulti.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.remove.setText("Remove");
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoMulti.this.removeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.remove, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoMulti.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.possibleChanges, gridBagConstraints);
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void okActionPerformed(ActionEvent evt) {
        this.applyActionPerformed(evt);
        this.closeDialog(null);
    }

    private void removeActionPerformed(ActionEvent evt) {
        int[] items = this.list.getSelectedIndices();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < items.length; ++i) {
            indices.add(new Integer(items[i]));
        }
        Collections.sort(indices, new Comparator<Integer>(){

            @Override
            public int compare(Integer c1, Integer c2) {
                return c2.compareTo(c1);
            }
        });
        for (Integer index : indices) {
            this.highlightList.remove(index);
        }
        if (this.wnd != null) {
            Highlighter highlighter = this.wnd.getHighlighter();
            highlighter.clear();
            highlighter.setHighlightList(this.highlightList);
            highlighter.finished();
        }
    }

    private void applyActionPerformed(ActionEvent evt) {
        Object anValue;
        MultiChangeParameters mcp = new MultiChangeParameters();
        mcp.anchor = (mcp.code = (mcp.units = (mcp.show = -1)));
        if (this.nodeList.size() > 0) {
            mcp.xPos = this.findComponentStringValue(ChangeType.CHANGEXPOS);
            mcp.yPos = this.findComponentStringValue(ChangeType.CHANGEYPOS);
            mcp.xSize = this.findComponentStringValue(ChangeType.CHANGEXSIZE);
            mcp.ySize = this.findComponentStringValue(ChangeType.CHANGEYSIZE);
            mcp.rot = this.findComponentStringValue(ChangeType.CHANGEROTATION);
            mcp.lr = this.findComponentIntValue(ChangeType.CHANGEMIRRORLR);
            mcp.ud = this.findComponentIntValue(ChangeType.CHANGEMIRRORUD);
            mcp.expanded = this.findComponentIntValue(ChangeType.CHANGEEXPANDED);
            mcp.easySelect = this.findComponentIntValue(ChangeType.CHANGEEASYSELECT);
            mcp.invisOutside = this.findComponentIntValue(ChangeType.CHANGEINVOUTSIDECELL);
            mcp.locked = this.findComponentIntValue(ChangeType.CHANGELOCKED);
        }
        if (this.arcList.size() > 0) {
            mcp.width = this.findComponentStringValue(ChangeType.CHANGEWIDTH);
            mcp.rigid = this.findComponentIntValue(ChangeType.CHANGERIGID);
            mcp.fixedangle = this.findComponentIntValue(ChangeType.CHANGEFIXANGLE);
            mcp.slidable = this.findComponentIntValue(ChangeType.CHANGESLIDABLE);
            mcp.extension = this.findComponentIntValue(ChangeType.CHANGEEXTENSION);
            mcp.directional = this.findComponentIntValue(ChangeType.CHANGEDIRECTION);
            mcp.negated = this.findComponentIntValue(ChangeType.CHANGENEGATION);
            mcp.easySelect = this.findComponentIntValue(ChangeType.CHANGEEASYSELECT);
        }
        if (this.exportList.size() > 0) {
            mcp.characteristics = (String)this.findComboBoxValue(ChangeType.CHANGECHARACTERISTICS);
            mcp.bodyOnly = this.findComponentIntValue(ChangeType.CHANGEBODYONLY);
            mcp.alwaysDrawn = this.findComponentIntValue(ChangeType.CHANGEALWAYSDRAWN);
            mcp.pointSize = this.findComponentStringValue(ChangeType.CHANGEPOINTSIZE);
            mcp.unitSize = this.findComponentStringValue(ChangeType.CHANGEUNITSIZE);
            mcp.xOff = this.findComponentStringValue(ChangeType.CHANGEXOFF);
            mcp.yOff = this.findComponentStringValue(ChangeType.CHANGEYOFF);
            mcp.textRotation = this.findComponentIntValue(ChangeType.CHANGETEXTROT);
            anValue = this.findComboBoxValue(ChangeType.CHANGEANCHOR);
            if (anValue instanceof AbstractTextDescriptor.Position) {
                mcp.anchor = ((AbstractTextDescriptor.Position)anValue).getIndex();
            }
            mcp.font = (String)this.findComboBoxValue(ChangeType.CHANGEFONT);
            mcp.color = this.findComboBoxIndex(ChangeType.CHANGECOLOR);
            mcp.bold = this.findComponentIntValue(ChangeType.CHANGEBOLD);
            mcp.italic = this.findComponentIntValue(ChangeType.CHANGEITALIC);
            mcp.underline = this.findComponentIntValue(ChangeType.CHANGEUNDERLINE);
            mcp.invisOutside = this.findComponentIntValue(ChangeType.CHANGEINVOUTSIDECELL);
        }
        if (this.textList.size() > 0) {
            Object shValue;
            Object unValue;
            mcp.pointSize = this.findComponentStringValue(ChangeType.CHANGEPOINTSIZE);
            mcp.unitSize = this.findComponentStringValue(ChangeType.CHANGEUNITSIZE);
            mcp.xOff = this.findComponentStringValue(ChangeType.CHANGEXOFF);
            mcp.yOff = this.findComponentStringValue(ChangeType.CHANGEYOFF);
            mcp.textRotation = this.findComponentIntValue(ChangeType.CHANGETEXTROT);
            anValue = this.findComboBoxValue(ChangeType.CHANGEANCHOR);
            if (anValue instanceof AbstractTextDescriptor.Position) {
                mcp.anchor = ((AbstractTextDescriptor.Position)anValue).getIndex();
            }
            mcp.font = (String)this.findComboBoxValue(ChangeType.CHANGEFONT);
            mcp.color = this.findComboBoxIndex(ChangeType.CHANGECOLOR);
            Object cdValue = this.findComboBoxValue(ChangeType.CHANGECODE);
            if (cdValue instanceof AbstractTextDescriptor.Code) {
                mcp.code = ((AbstractTextDescriptor.Code)((Object)cdValue)).getCFlags();
            }
            if ((unValue = this.findComboBoxValue(ChangeType.CHANGEUNITS)) instanceof AbstractTextDescriptor.Unit) {
                mcp.units = ((AbstractTextDescriptor.Unit)unValue).getIndex();
            }
            if ((shValue = this.findComboBoxValue(ChangeType.CHANGESHOW)) instanceof AbstractTextDescriptor.DispPos) {
                mcp.show = ((AbstractTextDescriptor.DispPos)shValue).getIndex();
            }
            mcp.bold = this.findComponentIntValue(ChangeType.CHANGEBOLD);
            mcp.italic = this.findComponentIntValue(ChangeType.CHANGEITALIC);
            mcp.underline = this.findComponentIntValue(ChangeType.CHANGEUNDERLINE);
            mcp.invisOutside = this.findComponentIntValue(ChangeType.CHANGEINVOUTSIDECELL);
        }
        new MultiChange(mcp, this.nodeList, this.arcList, this.exportList, this.textList);
    }

    private void removeOthersActionPerformed(ActionEvent evt) {
        int[] items = this.list.getSelectedIndices();
        HashSet<Integer> keepIndices = new HashSet<Integer>();
        for (int i = 0; i < items.length; ++i) {
            keepIndices.add(new Integer(items[i]));
        }
        int len = this.highlightList.size();
        for (int i = len - 1; i >= 0; --i) {
            if (keepIndices.contains(new Integer(i))) continue;
            this.highlightList.remove(i);
        }
        if (this.wnd != null) {
            Highlighter highlighter = this.wnd.getHighlighter();
            highlighter.clear();
            highlighter.setHighlightList(this.highlightList);
            highlighter.finished();
        }
    }

    private void closeDialog(WindowEvent evt) {
        super.closeDialog();
        this.highlightList.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiChange
    extends Job {
        private MultiChangeParameters mcp;
        private List<NodeInst> nodeList;
        private List<ArcInst> arcList;
        private List<Export> exportList;
        private List<DisplayedText> textList;

        private MultiChange(MultiChangeParameters mcp, List<NodeInst> nodeList, List<ArcInst> arcList, List<Export> exportList, List<DisplayedText> textList) {
            super("Modify Objects", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.mcp = mcp;
            this.nodeList = nodeList;
            this.arcList = arcList;
            this.exportList = exportList;
            this.textList = textList;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            int numNodes = this.nodeList.size();
            if (numNodes > 0) {
                boolean changes = false;
                for (NodeInst ni : this.nodeList) {
                    if (ni.isCellInstance()) {
                        if (this.mcp.expanded == 1) {
                            ni.setExpanded();
                            changes = true;
                        } else if (this.mcp.expanded == 2) {
                            ni.clearExpanded();
                            changes = true;
                        }
                    }
                    if (this.mcp.easySelect == 1) {
                        ni.clearHardSelect();
                    } else if (this.mcp.easySelect == 2) {
                        ni.setHardSelect();
                    }
                    if (this.mcp.invisOutside == 1) {
                        ni.setVisInside();
                    } else if (this.mcp.invisOutside == 2) {
                        ni.clearVisInside();
                    }
                    if (this.mcp.locked == 1) {
                        ni.setLocked();
                        continue;
                    }
                    if (this.mcp.locked != 2) continue;
                    ni.clearLocked();
                }
                if (this.mcp.xPos.length() > 0 || this.mcp.yPos.length() > 0 || this.mcp.xSize.length() > 0 || this.mcp.ySize.length() > 0 || this.mcp.rot.length() > 0 || this.mcp.lr != 0 || this.mcp.ud != 0 || changes) {
                    if (this.mcp.rot.length() == 0 && this.mcp.lr == 0 && this.mcp.ud == 0) {
                        NodeInst[] nis = new NodeInst[numNodes];
                        double[] dXP = new double[numNodes];
                        double[] dYP = new double[numNodes];
                        double[] dXS = new double[numNodes];
                        double[] dYS = new double[numNodes];
                        double newXPosition = TextUtils.atof(this.mcp.xPos);
                        double newYPosition = TextUtils.atof(this.mcp.yPos);
                        int i = 0;
                        for (NodeInst ni : this.nodeList) {
                            SizeOffset so = ni.getSizeOffset();
                            nis[i] = ni;
                            dXP[i] = this.mcp.xPos.length() == 0 ? 0.0 : newXPosition - ni.getAnchorCenterX();
                            dYP[i] = this.mcp.yPos.equals("") ? 0.0 : newYPosition - ni.getAnchorCenterY();
                            String newXSize = this.mcp.xSize;
                            String newYSize = this.mcp.ySize;
                            if (ni.getAngle() == 900 || ni.getAngle() == 2700) {
                                String swap = newXSize;
                                newXSize = newYSize;
                                newYSize = swap;
                            }
                            if (newXSize.equals("")) {
                                dXS[i] = 0.0;
                            } else {
                                double trueXSize = TextUtils.atof(newXSize) + so.getHighXOffset() + so.getLowXOffset();
                                dXS[i] = trueXSize - ni.getXSize();
                            }
                            if (newYSize.equals("")) {
                                dYS[i] = 0.0;
                            } else {
                                double trueYSize = TextUtils.atof(newYSize) + so.getHighYOffset() + so.getLowYOffset();
                                dYS[i] = trueYSize - ni.getYSize();
                            }
                            ++i;
                        }
                        NodeInst.modifyInstances(nis, dXP, dYP, dXS, dYS);
                    } else {
                        for (NodeInst ni : this.nodeList) {
                            SizeOffset so = ni.getSizeOffset();
                            double dX = 0.0;
                            double dY = 0.0;
                            double dXS = 0.0;
                            double dYS = 0.0;
                            if (this.mcp.xPos.length() > 0) {
                                dX = TextUtils.atof(this.mcp.xPos) - ni.getAnchorCenterX();
                            }
                            if (this.mcp.yPos.length() > 0) {
                                dY = TextUtils.atof(this.mcp.yPos) - ni.getAnchorCenterY();
                            }
                            String newXSize = this.mcp.xSize;
                            String newYSize = this.mcp.ySize;
                            if (ni.getAngle() == 900 || ni.getAngle() == 2700) {
                                String swap = newXSize;
                                newXSize = newYSize;
                                newYSize = swap;
                            }
                            if (newXSize.length() > 0) {
                                double trueXSize = TextUtils.atof(newXSize) + so.getHighXOffset() + so.getLowXOffset();
                                dXS = trueXSize - ni.getXSize();
                            }
                            if (newYSize.length() > 0) {
                                double trueYSize = TextUtils.atof(newYSize) + so.getHighYOffset() + so.getLowYOffset();
                                dYS = trueYSize - ni.getYSize();
                            }
                            int dRot = 0;
                            if (this.mcp.rot.length() > 0) {
                                dRot = ((int)(TextUtils.atof(this.mcp.rot) * 10.0) - ni.getAngle() + 3600) % 3600;
                            }
                            boolean dMirrorLR = false;
                            if (this.mcp.lr == 1 && !ni.isXMirrored()) {
                                dMirrorLR = true;
                            } else if (this.mcp.lr == 2 && ni.isXMirrored()) {
                                dMirrorLR = true;
                            }
                            boolean dMirrorUD = false;
                            if (this.mcp.ud == 1 && !ni.isYMirrored()) {
                                dMirrorUD = true;
                            } else if (this.mcp.ud == 2 && ni.isYMirrored()) {
                                dMirrorUD = true;
                            }
                            Orientation orient = Orientation.fromJava(dRot, dMirrorLR, dMirrorUD);
                            ni.modifyInstance(dX, dY, dXS, dYS, orient);
                        }
                    }
                }
            }
            if (this.arcList.size() > 0) {
                for (ArcInst ai : this.arcList) {
                    if (this.mcp.width.length() > 0) {
                        double newWidth = TextUtils.atof(this.mcp.width);
                        ai.setLambdaBaseWidth(newWidth);
                    }
                    if (this.mcp.rigid == 1) {
                        ai.setRigid(true);
                    } else if (this.mcp.rigid == 2) {
                        ai.setRigid(false);
                    }
                    if (this.mcp.fixedangle == 1) {
                        ai.setFixedAngle(true);
                    } else if (this.mcp.fixedangle == 2) {
                        ai.setFixedAngle(false);
                    }
                    if (this.mcp.slidable == 1) {
                        ai.setSlidable(true);
                    } else if (this.mcp.slidable == 2) {
                        ai.setSlidable(false);
                    }
                    switch (this.mcp.extension) {
                        case 1: {
                            ai.setHeadExtended(true);
                            ai.setTailExtended(true);
                            break;
                        }
                        case 2: {
                            ai.setHeadExtended(false);
                            ai.setTailExtended(false);
                            break;
                        }
                        case 3: {
                            ai.setHeadExtended(true);
                            ai.setTailExtended(false);
                            break;
                        }
                        case 4: {
                            ai.setHeadExtended(false);
                            ai.setTailExtended(true);
                        }
                    }
                    switch (this.mcp.directional) {
                        case 1: {
                            ai.setHeadArrowed(false);
                            ai.setTailArrowed(false);
                            ai.setBodyArrowed(false);
                            break;
                        }
                        case 2: {
                            ai.setHeadArrowed(true);
                            ai.setTailArrowed(false);
                            ai.setBodyArrowed(true);
                            break;
                        }
                        case 3: {
                            ai.setHeadArrowed(false);
                            ai.setTailArrowed(true);
                            ai.setBodyArrowed(true);
                            break;
                        }
                        case 4: {
                            ai.setHeadArrowed(false);
                            ai.setTailArrowed(false);
                            ai.setBodyArrowed(true);
                            break;
                        }
                        case 5: {
                            ai.setHeadArrowed(true);
                            ai.setTailArrowed(true);
                            ai.setBodyArrowed(true);
                        }
                    }
                    switch (this.mcp.negated) {
                        case 1: {
                            ai.setHeadNegated(false);
                            ai.setTailNegated(false);
                            break;
                        }
                        case 2: {
                            ai.setHeadNegated(true);
                            ai.setTailNegated(false);
                            break;
                        }
                        case 3: {
                            ai.setHeadNegated(false);
                            ai.setTailNegated(true);
                            break;
                        }
                        case 4: {
                            ai.setHeadNegated(true);
                            ai.setTailNegated(true);
                        }
                    }
                    if (this.mcp.easySelect == 1) {
                        ai.setHardSelect(false);
                        continue;
                    }
                    if (this.mcp.easySelect != 2) continue;
                    ai.setHardSelect(true);
                }
            }
            if (this.exportList.size() > 0) {
                for (Export e : this.exportList) {
                    PortCharacteristic ch;
                    if (this.mcp.characteristics != null && (ch = PortCharacteristic.findCharacteristic(this.mcp.characteristics)) != null) {
                        e.setCharacteristic(ch);
                    }
                    if (this.mcp.bodyOnly == 1) {
                        e.setBodyOnly(true);
                    } else if (this.mcp.bodyOnly == 2) {
                        e.setBodyOnly(false);
                    }
                    if (this.mcp.alwaysDrawn == 1) {
                        e.setAlwaysDrawn(true);
                    } else if (this.mcp.alwaysDrawn == 2) {
                        e.setAlwaysDrawn(false);
                    }
                    MutableTextDescriptor td = e.getMutableTextDescriptor(Export.EXPORT_NAME);
                    boolean tdChanged = false;
                    if (this.mcp.pointSize.length() > 0) {
                        td.setAbsSize(TextUtils.atoi(this.mcp.pointSize));
                        tdChanged = true;
                    }
                    if (this.mcp.unitSize.length() > 0) {
                        td.setRelSize(TextUtils.atof(this.mcp.unitSize));
                        tdChanged = true;
                    }
                    if (this.mcp.xOff.length() > 0) {
                        td.setOff(TextUtils.atof(this.mcp.xOff), td.getYOff());
                        tdChanged = true;
                    }
                    if (this.mcp.yOff.length() > 0) {
                        td.setOff(td.getXOff(), TextUtils.atof(this.mcp.yOff));
                        tdChanged = true;
                    }
                    if (this.mcp.textRotation > 0) {
                        switch (this.mcp.textRotation) {
                            case 1: {
                                td.setRotation(AbstractTextDescriptor.Rotation.ROT0);
                                break;
                            }
                            case 2: {
                                td.setRotation(AbstractTextDescriptor.Rotation.ROT90);
                                break;
                            }
                            case 3: {
                                td.setRotation(AbstractTextDescriptor.Rotation.ROT180);
                                break;
                            }
                            case 4: {
                                td.setRotation(AbstractTextDescriptor.Rotation.ROT270);
                            }
                        }
                        tdChanged = true;
                    }
                    if (this.mcp.anchor >= 0) {
                        AbstractTextDescriptor.Position newPosition = AbstractTextDescriptor.Position.getPositionAt(this.mcp.anchor);
                        td.setPos(newPosition);
                        tdChanged = true;
                    }
                    if (this.mcp.font != null) {
                        AbstractTextDescriptor.ActiveFont newFont = AbstractTextDescriptor.ActiveFont.findActiveFont(this.mcp.font);
                        int newFontIndex = newFont != null ? newFont.getIndex() : 0;
                        td.setFace(newFontIndex);
                        tdChanged = true;
                    }
                    if (this.mcp.color > 0) {
                        int[] colorIndices = EGraphics.getColorIndices();
                        int newColorIndex = colorIndices[this.mcp.color - 1];
                        td.setColorIndex(newColorIndex);
                        tdChanged = true;
                    }
                    if (this.mcp.bold == 1) {
                        td.setBold(true);
                        tdChanged = true;
                    } else if (this.mcp.bold == 2) {
                        td.setBold(false);
                        tdChanged = true;
                    }
                    if (this.mcp.italic == 1) {
                        td.setItalic(true);
                        tdChanged = true;
                    } else if (this.mcp.italic == 2) {
                        td.setItalic(false);
                        tdChanged = true;
                    }
                    if (this.mcp.underline == 1) {
                        td.setUnderline(true);
                        tdChanged = true;
                    } else if (this.mcp.underline == 2) {
                        td.setUnderline(false);
                        tdChanged = true;
                    }
                    if (this.mcp.invisOutside == 1) {
                        td.setInterior(true);
                        tdChanged = true;
                    } else if (this.mcp.invisOutside == 2) {
                        td.setInterior(false);
                        tdChanged = true;
                    }
                    if (!tdChanged) continue;
                    e.setTextDescriptor(Export.EXPORT_NAME, TextDescriptor.newTextDescriptor(td));
                }
            }
            if (this.textList.size() > 0) {
                for (DisplayedText dt : this.textList) {
                    ElectricObject eobj = dt.getElectricObject();
                    Variable.Key descKey = dt.getVariableKey();
                    MutableTextDescriptor td = eobj.getMutableTextDescriptor(descKey);
                    boolean tdChanged = false;
                    if (this.mcp.pointSize.length() > 0) {
                        td.setAbsSize(TextUtils.atoi(this.mcp.pointSize));
                        tdChanged = true;
                    }
                    if (this.mcp.unitSize.length() > 0) {
                        td.setRelSize(TextUtils.atof(this.mcp.unitSize));
                        tdChanged = true;
                    }
                    if (this.mcp.xOff.length() > 0) {
                        td.setOff(TextUtils.atof(this.mcp.xOff), td.getYOff());
                        tdChanged = true;
                    }
                    if (this.mcp.yOff.length() > 0) {
                        td.setOff(td.getXOff(), TextUtils.atof(this.mcp.yOff));
                        tdChanged = true;
                    }
                    if (this.mcp.textRotation > 0) {
                        switch (this.mcp.textRotation) {
                            case 1: {
                                td.setRotation(AbstractTextDescriptor.Rotation.ROT0);
                                break;
                            }
                            case 2: {
                                td.setRotation(AbstractTextDescriptor.Rotation.ROT90);
                                break;
                            }
                            case 3: {
                                td.setRotation(AbstractTextDescriptor.Rotation.ROT180);
                                break;
                            }
                            case 4: {
                                td.setRotation(AbstractTextDescriptor.Rotation.ROT270);
                            }
                        }
                        tdChanged = true;
                    }
                    if (this.mcp.anchor >= 0) {
                        AbstractTextDescriptor.Position newPosition = AbstractTextDescriptor.Position.getPositionAt(this.mcp.anchor);
                        td.setPos(newPosition);
                        tdChanged = true;
                    }
                    if (this.mcp.font != null) {
                        AbstractTextDescriptor.ActiveFont newFont = AbstractTextDescriptor.ActiveFont.findActiveFont(this.mcp.font);
                        int newFontIndex = newFont != null ? newFont.getIndex() : 0;
                        td.setFace(newFontIndex);
                        tdChanged = true;
                    }
                    if (this.mcp.color > 0) {
                        int[] colorIndices = EGraphics.getColorIndices();
                        int newColorIndex = colorIndices[this.mcp.color - 1];
                        td.setColorIndex(newColorIndex);
                        tdChanged = true;
                    }
                    if (this.mcp.code > 0) {
                        AbstractTextDescriptor.Code cd = AbstractTextDescriptor.Code.getByCBits(this.mcp.code);
                        td.setCode(cd);
                        tdChanged = true;
                    }
                    if (this.mcp.units > 0) {
                        AbstractTextDescriptor.Unit un = AbstractTextDescriptor.Unit.getUnitAt(this.mcp.units);
                        td.setUnit(un);
                        tdChanged = true;
                    }
                    if (this.mcp.show > 0) {
                        AbstractTextDescriptor.DispPos sh = AbstractTextDescriptor.DispPos.getShowStylesAt(this.mcp.show);
                        td.setDispPart(sh);
                        tdChanged = true;
                    }
                    if (this.mcp.bold == 1) {
                        td.setBold(true);
                        tdChanged = true;
                    } else if (this.mcp.bold == 2) {
                        td.setBold(false);
                        tdChanged = true;
                    }
                    if (this.mcp.italic == 1) {
                        td.setItalic(true);
                        tdChanged = true;
                    } else if (this.mcp.italic == 2) {
                        td.setItalic(false);
                        tdChanged = true;
                    }
                    if (this.mcp.underline == 1) {
                        td.setUnderline(true);
                        tdChanged = true;
                    } else if (this.mcp.underline == 2) {
                        td.setUnderline(false);
                        tdChanged = true;
                    }
                    if (this.mcp.invisOutside == 1) {
                        td.setInterior(true);
                        tdChanged = true;
                    } else if (this.mcp.invisOutside == 2) {
                        td.setInterior(false);
                        tdChanged = true;
                    }
                    if (!tdChanged) continue;
                    eobj.setTextDescriptor(descKey, TextDescriptor.newTextDescriptor(td));
                }
            }
            return true;
        }
    }

    private static class MultiChangeParameters
    implements Serializable {
        private String xPos;
        private String yPos;
        private String xSize;
        private String ySize;
        private String rot;
        private int lr;
        private int ud;
        private int expanded;
        private int easySelect;
        private int invisOutside;
        private int locked;
        private String width;
        private int rigid;
        private int fixedangle;
        private int slidable;
        private int extension;
        private int directional;
        private int negated;
        private String characteristics;
        private int bodyOnly;
        private int alwaysDrawn;
        private String pointSize;
        private String unitSize;
        private String xOff;
        private String yOff;
        private int textRotation;
        private int anchor;
        private String font;
        private int color;
        private int bold;
        private int italic;
        private int underline;
        private int code;
        private int units;
        private int show;

        private MultiChangeParameters() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortMultipleHighlights
    implements Comparator<Highlight2> {
        private SortMultipleHighlights() {
        }

        @Override
        public int compare(Highlight2 h1, Highlight2 h2) {
            if (h1.getClass() != h2.getClass()) {
                return h1.getClass().hashCode() - h2.getClass().hashCode();
            }
            if (!h1.isHighlightEOBJ()) {
                return 0;
            }
            ElectricObject e1 = h1.getElectricObject();
            int type1 = 0;
            if (e1 instanceof NodeInst) {
                type1 = 1;
            } else if (e1 instanceof ArcInst) {
                type1 = 2;
            }
            ElectricObject e2 = h2.getElectricObject();
            int type2 = 0;
            if (e2 instanceof NodeInst) {
                type2 = 1;
            } else if (e2 instanceof ArcInst) {
                type2 = 2;
            }
            if (type1 != type2) {
                return type1 - type2;
            }
            String s1 = null;
            String s2 = null;
            s1 = e1 instanceof Geometric ? ((Geometric)e1).describe(false) : e1.toString();
            s2 = e2 instanceof Geometric ? ((Geometric)e2).describe(false) : e2.toString();
            return TextUtils.canonicString(s1).compareTo(TextUtils.canonicString(s2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ChangeType {
        CHANGEXSIZE,
        CHANGEYSIZE,
        CHANGEXPOS,
        CHANGEYPOS,
        CHANGEROTATION,
        CHANGEMIRRORLR,
        CHANGEMIRRORUD,
        CHANGEEXPANDED,
        CHANGEEASYSELECT,
        CHANGEINVOUTSIDECELL,
        CHANGELOCKED,
        CHANGEWIDTH,
        CHANGERIGID,
        CHANGEFIXANGLE,
        CHANGESLIDABLE,
        CHANGEEXTENSION,
        CHANGEDIRECTION,
        CHANGENEGATION,
        CHANGECHARACTERISTICS,
        CHANGEBODYONLY,
        CHANGEALWAYSDRAWN,
        CHANGEPOINTSIZE,
        CHANGEUNITSIZE,
        CHANGEXOFF,
        CHANGEYOFF,
        CHANGETEXTROT,
        CHANGEANCHOR,
        CHANGEFONT,
        CHANGECOLOR,
        CHANGEBOLD,
        CHANGEITALIC,
        CHANGEUNDERLINE,
        CHANGECODE,
        CHANGEUNITS,
        CHANGESHOW;

    }
}

