/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SeaOfGatesEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SeaOfGates {
    public static void seaOfGatesRoute() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        Netlist netList = cell.acquireUserNetlist();
        if (netList == null) {
            System.out.println("Sorry, a deadlock aborted routing (network information unavailable).  Please try again");
            return;
        }
        Set<Network> nets = null;
        boolean didSelection = false;
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd != null && (nets = wnd.getHighlightedNetworks()).size() > 0) {
            didSelection = true;
        }
        if (!didSelection) {
            nets = new HashSet<Network>();
            Iterator<Network> it = netList.getNetworks();
            while (it.hasNext()) {
                nets.add(it.next());
            }
        }
        HashSet<Network> netsToRoute = new HashSet<Network>();
        Iterator<ArcInst> it = cell.getArcs();
        while (it.hasNext()) {
            Network net;
            ArcInst ai = it.next();
            if (ai.getProto() != Generic.tech.unrouted_arc || !nets.contains(net = netList.getNetwork(ai, 0))) continue;
            netsToRoute.add(net);
        }
        if (netsToRoute.size() <= 0) {
            ui.showErrorMessage(didSelection ? "Must select one or more Unrouted Arcs" : "There are no Unrouted Arcs in this cell", "Routing Error");
            return;
        }
        ArrayList<NetsToRoute> orderedNetsToRoute = new ArrayList<NetsToRoute>();
        for (Network net : netsToRoute) {
            boolean isPwrGnd = false;
            Iterator<Export> it2 = net.getExports();
            while (it2.hasNext()) {
                Export e = it2.next();
                if (!e.isGround() && !e.isPower()) continue;
                isPwrGnd = true;
                break;
            }
            double length = 0.0;
            Iterator<ArcInst> it3 = net.getArcs();
            while (it3.hasNext()) {
                ArcInst ai = it3.next();
                length += ai.getLambdaLength();
                PortProto headPort = ai.getHeadPortInst().getPortProto();
                PortProto tailPort = ai.getTailPortInst().getPortProto();
                if (!headPort.isGround() && !headPort.isPower() && !tailPort.isGround() && !tailPort.isPower()) continue;
                isPwrGnd = true;
            }
            NetsToRoute ntr = new NetsToRoute(net, length, isPwrGnd);
            orderedNetsToRoute.add(ntr);
        }
        Collections.sort(orderedNetsToRoute, new NetsToRouteByLength());
        ArrayList<ArcInst> arcsToRoute = new ArrayList<ArcInst>();
        block5: for (NetsToRoute ntr : orderedNetsToRoute) {
            Iterator<ArcInst> it4 = ntr.net.getArcs();
            while (it4.hasNext()) {
                ArcInst ai = it4.next();
                if (ai.getProto() != Generic.tech.unrouted_arc) continue;
                arcsToRoute.add(ai);
                continue block5;
            }
        }
        new SeaOfGatesJob(cell, arcsToRoute);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SeaOfGatesJob
    extends Job {
        private Cell cell;
        private List<ArcInst> arcsToRoute;

        protected SeaOfGatesJob(Cell cell, List<ArcInst> arcsToRoute) {
            super("Sea-Of-Gates Route", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.arcsToRoute = arcsToRoute;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            SeaOfGatesEngine router = new SeaOfGatesEngine();
            router.routeIt(this, this.cell, this.arcsToRoute);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NetsToRouteByLength
    implements Comparator<NetsToRoute> {
        @Override
        public int compare(NetsToRoute ntr1, NetsToRoute ntr2) {
            if (ntr1.isPwrGnd != ntr2.isPwrGnd) {
                if (ntr1.isPwrGnd) {
                    return -1;
                }
                return 1;
            }
            if (ntr1.length < ntr2.length) {
                return -1;
            }
            if (ntr1.length > ntr2.length) {
                return 1;
            }
            return 0;
        }
    }

    private static class NetsToRoute {
        private Network net;
        private double length;
        private boolean isPwrGnd;

        NetsToRoute(Network net, double length, boolean isPwrGnd) {
            this.net = net;
            this.length = length;
            this.isPwrGnd = isPwrGnd;
        }
    }
}

