/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class MullerC_sy {
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double inbY = 4.0;
    private static final double inaY = -4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        int i;
        int i2;
        int nbSeries;
        double totWid;
        sz = stdCell.roundSize(sz);
        String nm = "mullerC_sy";
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        double spaceAvail = -9.0 - (stdCell.getCellBot() + 6.0);
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid = sz * 3.0 * (double)(nbSeries = 2), 2);
        MullerC_sy.error(fwN == null, "can't make " + nm + " this small: " + sz);
        spaceAvail = stdCell.getCellTop() - 6.0 - 9.0;
        totWid = sz * 6.0 * (double)nbSeries;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 2);
        MullerC_sy.error(fwP == null, "can't make " + nm + " this small: " + sz);
        Cell mull = stdCell.findPart(nm, sz);
        if (mull != null) {
            return mull;
        }
        mull = stdCell.newPart(nm, sz);
        double inaX = 3.5;
        LayoutLib.newExport(mull, "ina", PortCharacteristic.IN, Tech.m1(), 4.0, inaX, -4.0);
        double mosX = inaX + 2.0 + 3.0 + 2.0;
        double nmosY = -9.0 - fwN.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(mosX, nmosY, fwN.nbFolds, nbSeries, fwN.gateWid, mull, stdCell);
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedPmos pmos = new FoldedPmos(mosX, pmosY, fwP.nbFolds, nbSeries, fwP.gateWid, mull, stdCell);
        double rightDiffX = StdCellParams.getRightDiffX(nmos, pmos);
        double inbX = rightDiffX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(mull, "inb", PortCharacteristic.IN, Tech.m1(), 4.0, inbX, 4.0);
        double outX = inbX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(mull, "out", PortCharacteristic.OUT, Tech.m1(), 4.0, outX, -11.0);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, mull);
        stdCell.wireVddGnd(pmos, StdCellParams.EVEN, mull);
        TrackRouterH ina = new TrackRouterH(Tech.m1(), 3.0, -4.0, mull);
        ina.connect(mull.findExport("ina"));
        for (i2 = 0; i2 < nmos.nbGates(); i2 += 2) {
            ina.connect(nmos.getGate(i2, 'T'), -1.5);
        }
        for (i2 = 0; i2 < pmos.nbGates(); i2 += 2) {
            ina.connect(pmos.getGate(i2, 'B'), -1.5);
        }
        TrackRouterH inb = new TrackRouterH(Tech.m1(), 3.0, 4.0, mull);
        inb.connect(mull.findExport("inb"));
        for (i = 1; i < pmos.nbGates(); i += 2) {
            inb.connect(pmos.getGate(i, 'B'), 1.5);
        }
        for (i = 1; i < nmos.nbGates(); i += 2) {
            inb.connect(nmos.getGate(i, 'T'), 1.5);
        }
        TrackRouterH outLo = new TrackRouterH(Tech.m2(), 4.0, -11.0, mull);
        outLo.connect(mull.findExport("out"));
        for (int i3 = 1; i3 < nmos.nbSrcDrns(); i3 += 2) {
            outLo.connect(nmos.getSrcDrn(i3));
        }
        TrackRouterH outHi = new TrackRouterH(Tech.m2(), 4.0, 11.0, mull);
        outHi.connect(mull.findExport("out"));
        for (int i4 = 1; i4 < pmos.nbSrcDrns(); i4 += 2) {
            outHi.connect(pmos.getSrcDrn(i4));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, mull);
        stdCell.addPmosWell(wellMinX, wellMaxX, mull);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, mull);
        stdCell.doNCC(mull, nm + "{sch}");
        return mull;
    }
}

