/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.io.output.PNG;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.GetInfoText;
import com.sun.electric.tool.user.dialogs.SelectObject;
import com.sun.electric.tool.user.ui.EditWindowFocusBrowser;
import com.sun.electric.tool.user.ui.ElectricPrinter;
import com.sun.electric.tool.user.ui.ExplorerTree;
import com.sun.electric.tool.user.ui.LayerDrawing;
import com.sun.electric.tool.user.ui.LayerTab;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.PixelDrawing;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.print.attribute.standard.ColorSupported;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;

public class EditWindow
extends JPanel
implements EditWindow_,
WindowContent,
MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener,
ActionListener,
HighlightListener,
DatabaseChangeListener {
    private double scale;
    private double offx = 0.0;
    private double offy = 0.0;
    private Rectangle2D databaseBounds;
    private Dimension sz;
    private Drawing drawing;
    private int szHalfWidth;
    private int szHalfHeight;
    private Cell cell;
    private int pageNumber;
    private List<GetInfoText.EditInPlaceListener> inPlaceTextObjects = new ArrayList<GetInfoText.EditInPlaceListener>();
    private boolean inPlaceDisplay;
    private AffineTransform intoCell;
    private AffineTransform outofCell;
    private Cell topLevelCell;
    private List<NodeInst> inPlaceDescent;
    private VarContext cellVarContext;
    private WindowFrame wf;
    private JPanel overall;
    private JScrollBar bottomScrollBar;
    private JScrollBar rightScrollBar;
    private boolean showGrid = false;
    private double gridXSpacing;
    private double gridYSpacing;
    private boolean doingAreaDrag = false;
    private Point startDrag = new Point();
    private Point endDrag = new Point();
    private boolean showPopupCloud = false;
    private Highlighter highlighter;
    private Highlighter mouseOverHighlighter;
    private Highlighter rulerHighlighter;
    private EditWindowFocusBrowser viewBrowser;
    private static List<EditWindow> redrawThese = new ArrayList<EditWindow>();
    private static List<WindowChangeRequest> windowChangeRequests = new ArrayList<WindowChangeRequest>();
    private static EditWindow runningNow = null;
    private static Logger logger = Logger.getLogger("com.sun.electric.tool.user.ui");
    private static String CLASS_NAME = EditWindow.class.getName();
    private static final int SCROLLBARRESOLUTION = 200;
    private static final BasicStroke selectionLine = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f}, 3.0f);
    private static final BasicStroke inPlaceMarker = new BasicStroke(3.0f);
    private static EditWindowDropTarget editWindowDropTarget = new EditWindowDropTarget();
    private int lastXPosition;
    private int lastYPosition;
    private static final String RENDER_JOB_CLASS_NAME = CLASS_NAME + ".RenderJob";
    private List<CrossProbe> crossProbeObjects = new ArrayList<CrossProbe>();
    private StringSearch textSearch = new StringSearch();
    private static final double scrollPagePercent = 0.2;
    private boolean ignoreScrollChange = false;
    private static final int scrollRangeMult = 100;

    private EditWindow(Cell cell, WindowFrame wf, Dimension approxSZ) {
        this.cell = cell;
        this.pageNumber = 0;
        this.wf = wf;
        this.setDrawingAlgorithm();
        this.gridXSpacing = User.getDefGridXSpacing();
        this.gridYSpacing = User.getDefGridYSpacing();
        this.inPlaceDisplay = false;
        this.viewBrowser = new EditWindowFocusBrowser(this);
        this.sz = approxSZ;
        if (this.sz == null) {
            this.sz = new Dimension(500, 500);
        }
        this.szHalfWidth = this.sz.width / 2;
        this.szHalfHeight = this.sz.height / 2;
        this.setSize(this.sz.width, this.sz.height);
        this.setPreferredSize(this.sz);
        this.databaseBounds = new Rectangle2D.Double();
        this.scale = 1.0;
        this.overall = new JPanel();
        this.overall.setLayout(new GridBagLayout());
        int thumbSize = 10;
        this.bottomScrollBar = new JScrollBar(0, 100, thumbSize, 0, 200 + thumbSize);
        this.bottomScrollBar.setBlockIncrement(40);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.overall.add((Component)this.bottomScrollBar, gbc);
        this.bottomScrollBar.addAdjustmentListener(new ScrollAdjustmentListener(this));
        this.bottomScrollBar.setValue(this.bottomScrollBar.getMaximum() / 2);
        this.rightScrollBar = new JScrollBar(1, 100, thumbSize, 0, 200 + thumbSize);
        this.rightScrollBar.setBlockIncrement(40);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 3;
        this.overall.add((Component)this.rightScrollBar, gbc);
        this.rightScrollBar.addAdjustmentListener(new ScrollAdjustmentListener(this));
        this.rightScrollBar.setValue(this.rightScrollBar.getMaximum() / 2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.overall.add((Component)this, gbc);
        this.setOpaque(true);
        this.setLayout(null);
        new DropTarget(this, 0x40000000, editWindowDropTarget, true);
        this.installHighlighters();
        if (wf != null) {
            UserInterfaceMain.addDatabaseChangeListener(this);
            Highlighter.addHighlightListener(this);
            this.setCell(cell, VarContext.globalContext, null);
        }
    }

    private void setDrawingAlgorithm() {
        boolean isLayerDrawing;
        boolean bl = isLayerDrawing = User.getDisplayAlgorithm() == 2 && this.cell != null && this.cell.getTechnology().isLayout();
        if (isLayerDrawing && !(this.drawing instanceof LayerDrawing.Drawing)) {
            this.drawing = new LayerDrawing.Drawing(this);
        } else if (!isLayerDrawing && !(this.drawing instanceof PixelDrawing.Drawing)) {
            this.drawing = new PixelDrawing.Drawing(this);
        }
        LayerTab layerTab = this.getWindowFrame().getLayersTab();
        if (layerTab != null) {
            layerTab.setDisplayAlgorithm(isLayerDrawing);
        }
    }

    private void installHighlighters() {
        this.rulerHighlighter = null;
        this.mouseOverHighlighter = null;
        this.highlighter = null;
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            EditWindow oWnd;
            WindowFrame oWf = it.next();
            if (!(oWf.getContent() instanceof EditWindow) || (oWnd = (EditWindow)oWf.getContent()) == this || oWnd.getCell() != this.cell) continue;
            this.highlighter = oWnd.highlighter;
            this.mouseOverHighlighter = oWnd.mouseOverHighlighter;
            this.rulerHighlighter = oWnd.rulerHighlighter;
            break;
        }
        if (this.highlighter == null) {
            this.highlighter = new Highlighter(0, this.wf);
            this.mouseOverHighlighter = new Highlighter(1, this.wf);
            this.rulerHighlighter = new Highlighter(2, this.wf);
        }
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    private void uninstallHighlighters() {
        this.removeKeyListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseWheelListener(this);
        boolean used = false;
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            EditWindow oWnd;
            WindowFrame oWf = it.next();
            if (!(oWf.getContent() instanceof EditWindow) || (oWnd = (EditWindow)oWf.getContent()) == this || oWnd.getCell() != this.cell) continue;
            used = true;
            break;
        }
        if (!used) {
            this.highlighter.delete();
            this.mouseOverHighlighter.delete();
            this.rulerHighlighter.delete();
        }
    }

    public static EditWindow CreateElectricDoc(Cell cell, WindowFrame wf, Dimension approxSZ) {
        EditWindow ui = new EditWindow(cell, wf, approxSZ);
        return ui;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        Cell cell = (Cell)Cell.findNodeProto(source.getText());
        if (cell == null) {
            return;
        }
        Cell currentCell = this.getCell();
        this.setCell(cell, VarContext.globalContext, null);
        this.highlighter.clear();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.isCellInstance()) continue;
            Cell nodeCell = (Cell)ni.getProto();
            if (nodeCell == currentCell) {
                this.highlighter.addElectricObject(ni, cell);
                break;
            }
            if (!nodeCell.isIconOf(currentCell)) continue;
            this.highlighter.addElectricObject(ni, cell);
            break;
        }
        this.highlighter.finished();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.requestFocus();
        MessagesStream.userCommandIssued();
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        WindowFrame.curMouseListener.mousePressed(evt);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        WindowFrame.curMouseListener.mouseReleased(evt);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        WindowFrame.curMouseListener.mouseClicked(evt);
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        this.showCoordinates(evt);
        WindowFrame.curMouseListener.mouseEntered(evt);
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        WindowFrame.curMouseListener.mouseExited(evt);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        this.showCoordinates(evt);
        WindowFrame.curMouseMotionListener.mouseMoved(evt);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        this.showCoordinates(evt);
        WindowFrame.curMouseMotionListener.mouseDragged(evt);
    }

    private void showCoordinates(MouseEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        if (wnd.getCell() == null) {
            StatusBar.setCoordinates(null, wnd.wf);
        } else {
            Point2D pt = wnd.screenToDatabase(evt.getX(), evt.getY());
            EditWindow.gridAlign(pt);
            if (User.isShowHierarchicalCursorCoordinates()) {
                String path = null;
                if (this.cellVarContext != VarContext.globalContext) {
                    Point2D.Double ptPath = new Point2D.Double(pt.getX(), pt.getY());
                    boolean validPath = true;
                    boolean first = true;
                    Geometric ni = null;
                    path = "";
                    for (VarContext vc = this.cellVarContext; vc != VarContext.globalContext; vc = vc.pop()) {
                        Nodable no = vc.getNodable();
                        if (!(no instanceof NodeInst)) {
                            validPath = false;
                            break;
                        }
                        ni = (NodeInst)no;
                        path = ni.getParent().getName() + "[" + ((NodeInst)ni).getName() + "]" + (first ? "" : " / ") + path;
                        if (first) {
                            first = false;
                        }
                        AffineTransform trans = ((NodeInst)ni).translateOut(((NodeInst)ni).rotateOut());
                        trans.transform(ptPath, ptPath);
                    }
                    path = validPath ? (ni.getParent().getView() == View.SCHEMATIC ? "Location is " + ni.getParent() + " / " + path : "Location in " + ni.getParent() + " / " + path + " is (" + TextUtils.formatDouble(((Point2D)ptPath).getX(), 2) + ", " + TextUtils.formatDouble(((Point2D)ptPath).getY(), 2) + ")") : null;
                }
                StatusBar.setHierarchicalCoordinates(path, wnd.wf);
            }
            StatusBar.setCoordinates("(" + TextUtils.formatDouble(pt.getX(), 2) + ", " + TextUtils.formatDouble(pt.getY(), 2) + ")", wnd.wf);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        WindowFrame.curMouseWheelListener.mouseWheelMoved(evt);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        MessagesStream.userCommandIssued();
        WindowFrame.curKeyListener.keyPressed(evt);
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        WindowFrame.curKeyListener.keyReleased(evt);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        WindowFrame.curKeyListener.keyTyped(evt);
    }

    @Override
    public void highlightChanged(Highlighter which) {
        this.repaint();
    }

    @Override
    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
    }

    public Point getLastMousePosition() {
        return new Point(this.lastXPosition, this.lastYPosition);
    }

    public void showDraggedBox(Object toDraw, int oldx, int oldy) {
        Highlighter highlighter = this.getHighlighter();
        highlighter.clear();
        Point2D drawnLoc = this.screenToDatabase(oldx, oldy);
        EditWindow.gridAlign(drawnLoc);
        NodeProto np = null;
        if (toDraw instanceof NodeInst) {
            NodeInst ni = (NodeInst)toDraw;
            np = ni.getProto();
        }
        if (toDraw instanceof NodeProto) {
            np = (NodeProto)toDraw;
        }
        int defAngle = 0;
        if (toDraw instanceof NodeInst) {
            NodeInst ni = (NodeInst)toDraw;
            defAngle = ni.getAngle();
        }
        if (toDraw instanceof PrimitiveNode) {
            defAngle = ((PrimitiveNode)toDraw).getDefPlacementAngle();
        }
        if (np != null) {
            this.zoomWindowToFitCellInstance(np);
            Poly poly = null;
            Orientation orient = Orientation.fromJava(defAngle, defAngle >= 3600, false);
            if (np instanceof Cell) {
                Cell placeCell = (Cell)np;
                ERectangle cellBounds = placeCell.getBounds();
                poly = new Poly(cellBounds);
                AffineTransform rotate = orient.pureRotate();
                AffineTransform translate = new AffineTransform();
                translate.setToTranslation(drawnLoc.getX(), drawnLoc.getY());
                rotate.concatenate(translate);
                poly.transform(rotate);
            } else {
                SizeOffset so = np.getProtoSizeOffset();
                double trueSizeX = np.getDefWidth() - so.getLowXOffset() - so.getHighXOffset();
                double trueSizeY = np.getDefHeight() - so.getLowYOffset() - so.getHighYOffset();
                double dX = (so.getHighXOffset() - so.getLowXOffset()) / 2.0;
                double dY = (so.getHighYOffset() - so.getLowYOffset()) / 2.0;
                poly = new Poly(drawnLoc.getX() - dX, drawnLoc.getY() - dY, trueSizeX, trueSizeY);
                AffineTransform trans = orient.rotateAbout(drawnLoc.getX(), drawnLoc.getY());
                poly.transform(trans);
            }
            Point2D[] points = poly.getPoints();
            for (int i = 0; i < points.length; ++i) {
                int last = i - 1;
                if (i == 0) {
                    last = points.length - 1;
                }
                highlighter.addLine(points[last], points[i], this.getCell());
            }
            this.repaint();
        }
        highlighter.finished();
    }

    public void zoomWindowToFitCellInstance(NodeProto np) {
        NodeInst onlyNi;
        Cell parent = this.getCell();
        if (parent == null) {
            return;
        }
        boolean empty = true;
        if (parent.getNumArcs() > 0) {
            empty = false;
        }
        if (parent.getNumNodes() > 1) {
            empty = false;
        } else if (parent.getNumNodes() == 1 && (onlyNi = parent.getNode(0)).getProto() != Generic.tech.cellCenterNode) {
            empty = false;
        }
        if (empty && np instanceof Cell) {
            ERectangle cellBounds = ((Cell)np).getBounds();
            Rectangle2D screenBounds = this.displayableBounds();
            if (((RectangularShape)cellBounds).getWidth() > screenBounds.getWidth() || ((RectangularShape)cellBounds).getHeight() > screenBounds.getHeight()) {
                double scaleX = ((RectangularShape)cellBounds).getWidth() / (screenBounds.getWidth() * 0.9);
                double scaleY = ((RectangularShape)cellBounds).getHeight() / (screenBounds.getHeight() * 0.9);
                double scale = Math.max(scaleX, scaleY);
                this.setScale(this.getScale() / scale);
            }
        }
    }

    @Override
    public JPanel getPanel() {
        return this.overall;
    }

    @Override
    public Point getScreenLocationOfCorner() {
        return this.overall.getLocationOnScreen();
    }

    public static EditWindow getCurrent() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
        if (wf == null) {
            return null;
        }
        if (wf.getContent() instanceof EditWindow) {
            return (EditWindow)wf.getContent();
        }
        return null;
    }

    public static EditWindow needCurrent() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
        if (wf != null && wf.getContent() instanceof EditWindow) {
            return (EditWindow)wf.getContent();
        }
        System.out.println("There is no current window for this operation");
        return null;
    }

    @Override
    public Cell getCell() {
        return this.cell;
    }

    public void setMultiPageNumber(int pageNumber) {
        if (this.pageNumber == pageNumber) {
            return;
        }
        this.pageNumber = pageNumber;
        this.setWindowTitle();
        this.fillScreen();
    }

    public int getMultiPageNumber() {
        return this.pageNumber;
    }

    public boolean isInPlaceEdit() {
        return this.inPlaceDisplay;
    }

    public Cell getInPlaceEditTopCell() {
        return this.topLevelCell;
    }

    public List<NodeInst> getInPlaceEditNodePath() {
        return this.inPlaceDescent;
    }

    public void setInPlaceEditNodePath(List<NodeInst> list) {
        this.inPlaceDescent = list;
    }

    public AffineTransform getInPlaceTransformIn() {
        return this.intoCell;
    }

    public AffineTransform getInPlaceTransformOut() {
        return this.outofCell;
    }

    @Override
    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public Highlighter getMouseOverHighlighter() {
        return this.mouseOverHighlighter;
    }

    public Highlighter getRulerHighlighter() {
        return this.rulerHighlighter;
    }

    public WindowFrame getWindowFrame() {
        return this.wf;
    }

    @Override
    public void setCell(Cell cell, VarContext context, WindowFrame.DisplayAttributes displayAttributes) {
        if (context == null) {
            context = VarContext.globalContext;
        }
        boolean fillTheScreen = false;
        if (displayAttributes == null) {
            displayAttributes = new WindowFrame.DisplayAttributes();
            displayAttributes.scale = this.scale;
            displayAttributes.offX = this.offx;
            displayAttributes.offY = this.offy;
            displayAttributes.inPlace = false;
            fillTheScreen = true;
        }
        this.showCell(cell, context, fillTheScreen, displayAttributes);
    }

    private void showCell(Cell cell, VarContext context, boolean fillTheScreen, WindowFrame.DisplayAttributes displayAttributes) {
        this.wf.saveCurrentCellHistoryState();
        this.uninstallHighlighters();
        this.cell = cell;
        this.inPlaceDisplay = displayAttributes.inPlace;
        this.intoCell = displayAttributes.intoCell;
        this.outofCell = displayAttributes.outofCell;
        this.topLevelCell = displayAttributes.topLevelCell;
        this.inPlaceDescent = displayAttributes.inPlaceDescent;
        this.pageNumber = 0;
        this.cellVarContext = context;
        if (cell != null) {
            Library lib = cell.getLibrary();
            Job.getUserInterface().setCurrentCell(lib, cell);
        }
        this.setDrawingAlgorithm();
        this.installHighlighters();
        this.viewBrowser.clear();
        this.setWindowTitle();
        if (this.wf != null && cell != null && this.wf == WindowFrame.getCurrentWindowFrame(false)) {
            WindowFrame.autoTechnologySwitch(cell, this.wf);
        }
        if (fillTheScreen) {
            this.fillScreen();
        } else {
            this.setScale(displayAttributes.scale);
            this.setOffset(new Point2D.Double(displayAttributes.offX, displayAttributes.offY));
        }
        if (cell != null && User.isCheckCellDates()) {
            cell.checkCellDates();
        }
        this.clearCrossProbeLevels();
        StatusBar.updateStatusBar();
    }

    @Override
    public void setWindowTitle() {
        if (this.wf == null) {
            return;
        }
        this.wf.setTitle(this.wf.composeTitle(this.cell, "", this.pageNumber));
    }

    public static EditWindow findWindow(Cell cell) {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || content.getCell() != cell) continue;
            return (EditWindow)content;
        }
        return null;
    }

    @Override
    public List<MutableTreeNode> loadExplorerTrees() {
        return this.wf.loadDefaultExplorerTree();
    }

    @Override
    public void finished() {
        this.uninstallHighlighters();
        UserInterfaceMain.removeDatabaseChangeListener(this);
        Highlighter.removeHighlightListener(this);
    }

    public static int getScrollBarResolution() {
        return 200;
    }

    public JScrollBar getBottomScrollBar() {
        return this.bottomScrollBar;
    }

    public JScrollBar getRightScrollBar() {
        return this.rightScrollBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        if (this.wf == null) {
            return;
        }
        Graphics2D g = (Graphics2D)graphics;
        if (this.cell == null) {
            g.setColor(new Color(User.getColorBackground()));
            Dimension sz = this.getSize();
            g.fillRect(0, 0, sz.width, sz.height);
            String msg = "No cell in this window";
            Font f = new Font(User.getDefaultFont(), 1, 18);
            g.setFont(f);
            g.setColor(new Color(User.getColorText()));
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.drawString(msg, (sz.width - g.getFontMetrics(f).stringWidth(msg)) / 2, sz.height / 2);
            return;
        }
        logger.entering(CLASS_NAME, "paintComponent", this);
        if (!this.drawing.paintComponent(g, this.sz)) {
            Dimension newSize = this.getSize();
            this.setScreenSize(newSize);
            this.repaintContents(null, false);
            g.setColor(new Color(User.getColorBackground()));
            g.fillRect(0, 0, newSize.width, newSize.height);
            logger.exiting(CLASS_NAME, "paintComponent", "resize and repaint");
            return;
        }
        logger.logp(Level.FINER, CLASS_NAME, "paintComponent", "offscreen is drawn");
        this.showCrossProbeLevels(g);
        if (Job.getDebug()) {
            if (Job.acquireExamineLock(false)) {
                try {
                    this.drawCellFrame(g);
                    this.rulerHighlighter.showHighlights(this, g);
                    this.mouseOverHighlighter.showHighlights(this, g);
                    this.highlighter.showHighlights(this, g);
                    Job.releaseExamineLock();
                }
                catch (Error e) {
                    Job.releaseExamineLock();
                    throw e;
                }
            }
        } else {
            try {
                this.drawCellFrame(g);
                this.rulerHighlighter.showHighlights(this, g);
                this.mouseOverHighlighter.showHighlights(this, g);
                this.highlighter.showHighlights(this, g);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.doingAreaDrag) {
            this.showDragBox(g);
        }
        if (this.showPopupCloud) {
            this.drawPopupCloud(g);
        }
        if (this.inPlaceDisplay) {
            ERectangle bounds = this.cell.getBounds();
            Point i1 = this.databaseToScreen(bounds.getMinX(), bounds.getMinY());
            Point i2 = this.databaseToScreen(bounds.getMinX(), ((RectangularShape)bounds).getMaxY());
            Point i3 = this.databaseToScreen(((RectangularShape)bounds).getMaxX(), ((RectangularShape)bounds).getMaxY());
            Point i4 = this.databaseToScreen(((RectangularShape)bounds).getMaxX(), bounds.getMinY());
            Polygon innerPoly = new Polygon();
            innerPoly.addPoint(i1.x, i1.y);
            innerPoly.addPoint(i2.x, i2.y);
            innerPoly.addPoint(i3.x, i3.y);
            innerPoly.addPoint(i4.x, i4.y);
            Area outerArea = new Area(new Rectangle(0, 0, this.sz.width, this.sz.height));
            Area innerArea = new Area(innerPoly);
            outerArea.subtract(innerArea);
            g.setColor(new Color(128, 128, 128, 128));
            g.fill(outerArea);
            g.setStroke(inPlaceMarker);
            g.setColor(Color.RED);
            g.drawLine(i1.x, i1.y, i2.x, i2.y);
            g.drawLine(i2.x, i2.y, i3.x, i3.y);
            g.drawLine(i3.x, i3.y, i4.x, i4.y);
            g.drawLine(i4.x, i4.y, i1.x, i1.y);
        }
        logger.logp(Level.FINER, CLASS_NAME, "paintComponent", "overlays are drawn");
        List<EditWindow> list = redrawThese;
        synchronized (list) {
            logger.logp(Level.FINEST, CLASS_NAME, "paintComponent", "checkForOtherRequests");
            if (runningNow == null) {
                if (EditWindow.handleWindowChangeRequests(this) && !redrawThese.contains(this)) {
                    redrawThese.add(this);
                }
                if (redrawThese.size() > 0) {
                    runningNow = redrawThese.get(0);
                    redrawThese.remove(0);
                    logger.logp(Level.FINER, CLASS_NAME, "paintComponent", "restart RenderJob");
                    new RenderJob(runningNow, null, false);
                    logger.exiting(CLASS_NAME, "paintComponent");
                    return;
                }
            }
        }
        logger.exiting(CLASS_NAME, "paintComponent");
    }

    public void addInPlaceTextObject(GetInfoText.EditInPlaceListener tl) {
        this.inPlaceTextObjects.add(tl);
        this.add(tl.getTextComponent());
    }

    public void removeInPlaceTextObject(GetInfoText.EditInPlaceListener tl) {
        this.inPlaceTextObjects.remove(tl);
        this.remove(tl.getTextComponent());
    }

    public void removeAllInPlaceTextObjects() {
        ArrayList<GetInfoText.EditInPlaceListener> allTextObjects = new ArrayList<GetInfoText.EditInPlaceListener>();
        for (GetInfoText.EditInPlaceListener eip : this.inPlaceTextObjects) {
            allTextObjects.add(eip);
        }
        for (GetInfoText.EditInPlaceListener tl : allTextObjects) {
            tl.closeEditInPlace();
        }
    }

    @Override
    public void fullRepaint() {
        this.repaintContents(null, false);
    }

    public static void displayAlgorithmChanged() {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow)) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.setDrawingAlgorithm();
            wnd.repaintContents(null, false);
        }
    }

    public static void repaintAllContents() {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow)) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.repaintContents(null, false);
        }
    }

    public static void repaintAll() {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow)) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repaintContents(Rectangle2D bounds, boolean fullInstantiate) {
        if (this.wf == null) {
            return;
        }
        if (this.cell == null) {
            this.repaint();
            return;
        }
        logger.entering(CLASS_NAME, "repaintContents", bounds);
        List<EditWindow> list = redrawThese;
        synchronized (list) {
            if (runningNow != null) {
                if (runningNow == this) {
                    this.drawing.abortRendering();
                }
                if (!redrawThese.contains(this)) {
                    redrawThese.add(this);
                }
                logger.exiting(CLASS_NAME, "repaintContents");
                return;
            }
            EditWindow.handleWindowChangeRequests(this);
            runningNow = this;
        }
        new RenderJob(this, bounds, fullInstantiate);
        this.setScrollPosition();
        logger.exiting(CLASS_NAME, "repaintContents");
    }

    public static void setDefaultOpacity(Technology tech) {
        Iterator<Layer> it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            Layer.Function fun = layer.getFunction();
            int extra = layer.getFunctionExtras();
            double opacity = 0.4;
            if (fun.isMetal()) {
                opacity = 0.75 - (double)fun.getLevel() * 0.05;
            } else if (fun.isContact()) {
                opacity = (extra & 0x4000) != 0 ? 0.7 : 1.0;
            } else if (fun == Layer.Function.OVERGLASS) {
                opacity = 0.2;
            } else if (fun == Layer.Function.POLY1 || fun == Layer.Function.POLY2 || fun == Layer.Function.POLY3 || fun == Layer.Function.GATE || fun == Layer.Function.DIFF || fun == Layer.Function.DIFFP || fun == Layer.Function.DIFFN || fun == Layer.Function.WELL || fun == Layer.Function.WELLP || fun == Layer.Function.WELLN || fun == Layer.Function.IMPLANT || fun == Layer.Function.IMPLANTN || fun == Layer.Function.IMPLANTP) {
                opacity = 1.0;
            } else if (fun == Layer.Function.ART && layer.getName().equals("Glyph")) {
                opacity = 0.0;
            }
            layer.getGraphics().setOpacity(opacity);
        }
    }

    List<LayerColor> getBlendingOrder(Set<Layer> layersAvailable, boolean patternedDisplay, boolean alphaBlendingOvercolor) {
        boolean showOpacity;
        ArrayList<LayerColor> layerColors = new ArrayList<LayerColor>();
        ArrayList<Layer> sortedLayers = new ArrayList<Layer>(layersAvailable);
        Collections.sort(sortedLayers, Technology.LAYERS_BY_HEIGHT_LIFT_CONTACTS);
        float[] backgroundComps = new Color(User.getColorBackground()).getRGBColorComponents(null);
        float bRed = backgroundComps[0];
        float bGreen = backgroundComps[1];
        float bBlue = backgroundComps[2];
        for (Layer layer : sortedLayers) {
            if (!layer.isVisible() || layer == Generic.tech.glyphLay && !patternedDisplay) continue;
            Color color = new Color(layer.getGraphics().getRGB());
            float[] compArray = color.getRGBComponents(null);
            float red = compArray[0];
            float green = compArray[1];
            float blue = compArray[2];
            float opacity = (float)layer.getGraphics().getOpacity();
            if (opacity <= 0.0f) continue;
            float inverseAlpha = 1.0f - opacity;
            if (alphaBlendingOvercolor) {
                red -= bRed * inverseAlpha;
                green -= bGreen * inverseAlpha;
                blue -= bBlue * inverseAlpha;
            } else {
                red *= opacity;
                green *= opacity;
                blue *= opacity;
            }
            layerColors.add(new LayerColor(layer, red, green, blue, inverseAlpha));
        }
        final LayerTab layerTab = this.getWindowFrame().getLayersTab();
        boolean bl = showOpacity = !User.isLegacyComposite();
        if (layerTab != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    layerTab.setDisplayAlgorithm(showOpacity);
                }
            });
        }
        return layerColors;
    }

    public void testJogl() {
        if (this.drawing instanceof LayerDrawing.Drawing) {
            ((LayerDrawing.Drawing)this.drawing).testJogl();
        }
    }

    void opacityChanged() {
        this.drawing.opacityChanged();
    }

    public void clearCrossProbeLevels() {
        this.crossProbeObjects.clear();
    }

    public boolean hasCrossProbeData() {
        return this.crossProbeObjects.size() > 0;
    }

    public void addCrossProbeLine(Point2D start, Point2D end, Color color) {
        CrossProbe cp = new CrossProbe();
        cp.isLine = true;
        cp.start = start;
        cp.end = end;
        cp.color = color;
        this.crossProbeObjects.add(cp);
    }

    public void addCrossProbeBox(Rectangle2D box, Color color) {
        CrossProbe cp = new CrossProbe();
        cp.isLine = false;
        cp.box = box;
        cp.color = color;
        this.crossProbeObjects.add(cp);
    }

    private void showCrossProbeLevels(Graphics g) {
        for (CrossProbe cp : this.crossProbeObjects) {
            Point pE;
            Point pS;
            g.setColor(cp.color);
            if (cp.isLine) {
                pS = this.databaseToScreen(cp.start);
                pE = this.databaseToScreen(cp.end);
                g.drawLine(pS.x, pS.y, pE.x, pE.y);
                continue;
            }
            pS = this.databaseToScreen(cp.box.getMinX(), cp.box.getMinY());
            pE = this.databaseToScreen(cp.box.getMaxX(), cp.box.getMaxY());
            int lX = Math.min(pS.x, pE.x);
            int lY = Math.min(pS.y, pE.y);
            int wid = Math.abs(pS.x - pE.x);
            int hei = Math.abs(pS.y - pE.y);
            g.fillRect(lX, lY, wid, hei);
        }
    }

    public boolean isDoingAreaDrag() {
        return this.doingAreaDrag;
    }

    public void setDoingAreaDrag() {
        this.doingAreaDrag = true;
    }

    public void clearDoingAreaDrag() {
        this.doingAreaDrag = false;
    }

    public Point getStartDrag() {
        return this.startDrag;
    }

    public void setStartDrag(int x, int y) {
        this.startDrag.setLocation(x, y);
    }

    public Point getEndDrag() {
        return this.endDrag;
    }

    public void setEndDrag(int x, int y) {
        this.endDrag.setLocation(x, y);
    }

    private void showDragBox(Graphics g) {
        int lX = (int)Math.min(this.startDrag.getX(), this.endDrag.getX());
        int hX = (int)Math.max(this.startDrag.getX(), this.endDrag.getX());
        int lY = (int)Math.min(this.startDrag.getY(), this.endDrag.getY());
        int hY = (int)Math.max(this.startDrag.getY(), this.endDrag.getY());
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(selectionLine);
        g.setColor(new Color(User.getColorHighlight()));
        g.drawLine(lX, lY, lX, hY);
        g.drawLine(lX, hY, hX, hY);
        g.drawLine(hX, hY, hX, lY);
        g.drawLine(hX, lY, lX, lY);
    }

    private void drawCellFrame(Graphics g) {
        DisplayedFrame df = new DisplayedFrame(this.cell, g, this);
        df.renderFrame();
    }

    public void setGrid(boolean showGrid) {
        this.showGrid = showGrid;
        this.repaintContents(null, false);
    }

    @Override
    public boolean isGrid() {
        return this.showGrid;
    }

    @Override
    public double getGridXSpacing() {
        return this.gridXSpacing;
    }

    public void setGridXSpacing(double spacing) {
        this.gridXSpacing = spacing;
    }

    @Override
    public double getGridYSpacing() {
        return this.gridYSpacing;
    }

    public void setGridYSpacing(double spacing) {
        this.gridYSpacing = spacing;
    }

    public Rectangle2D displayableBounds() {
        Point2D low = this.screenToDatabase(0, 0);
        Point2D high = this.screenToDatabase(this.sz.width - 1, this.sz.height - 1);
        double lowX = Math.min(low.getX(), high.getX());
        double lowY = Math.min(low.getY(), high.getY());
        double sizeX = Math.abs(high.getX() - low.getX());
        double sizeY = Math.abs(high.getY() - low.getY());
        Rectangle2D.Double bounds = new Rectangle2D.Double(lowX, lowY, sizeX, sizeY);
        return bounds;
    }

    private static TextUtils.WhatToSearch get(Set whatToSearch, TextUtils.WhatToSearch what) {
        if (whatToSearch.contains((Object)what)) {
            return what;
        }
        return null;
    }

    @Override
    public void initTextSearch(String search, boolean caseSensitive, boolean regExp, Set<TextUtils.WhatToSearch> whatToSearch) {
        this.textSearch.initTextSearch(this.cell, search, caseSensitive, regExp, whatToSearch);
    }

    private static String repeatChar(char c, int num) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    private static void printFind(StringsInCell sic) {
        String foundHdr = "Found  " + sic.key + ": ";
        String foundStr = sic.theLine;
        String highlightHdr = EditWindow.repeatChar(' ', foundHdr.length() + sic.startPosition);
        String highlight = EditWindow.repeatChar('^', sic.endPosition - sic.startPosition);
        System.out.println(foundHdr + foundStr + "\n" + highlightHdr + highlight);
    }

    @Override
    public boolean findNextText(boolean reverse) {
        return this.textSearch.findNextText(this.cell, this.highlighter, reverse);
    }

    @Override
    public void replaceText(String replace) {
        if (this.textSearch.currentStringInCell == null) {
            return;
        }
        new ReplaceTextJob(this, replace);
    }

    @Override
    public void replaceAllText(String replace) {
        new ReplaceAllTextJob(this, replace);
    }

    private static void printChange(StringsInCell sic, String newString) {
        String foundHdr = "Change " + sic.key + ": ";
        String foundStr = sic.theLine;
        String replaceHdr = "  ->  ";
        String replaceStr = newString;
        String highlightHdr = EditWindow.repeatChar(' ', foundHdr.length() + sic.startPosition);
        String highlightStr = EditWindow.repeatChar('^', sic.endPosition - sic.startPosition);
        System.out.println(foundHdr + foundStr + replaceHdr + replaceStr + "\n" + highlightHdr + highlightStr);
    }

    public boolean getShowPopupCloud() {
        return this.showPopupCloud;
    }

    public void setShowPopupCloud(List<String> text, Point2D point) {
        this.showPopupCloud = true;
    }

    public void clearShowPopupCloud() {
        this.showPopupCloud = false;
    }

    private void drawPopupCloud(Graphics2D g) {
    }

    public Dimension getScreenSize() {
        return this.sz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScreenSize(Dimension sz) {
        logger.entering(CLASS_NAME, "setScreenSize", sz);
        if (this.wf != null) {
            List<EditWindow> list = redrawThese;
            synchronized (list) {
                if (runningNow != null) {
                    WindowChangeRequest zap = new WindowChangeRequest();
                    zap.wnd = this;
                    zap.sz = sz;
                    zap.requestType = 3;
                    windowChangeRequests.add(zap);
                    logger.exiting(CLASS_NAME, "setScreenSize");
                    return;
                }
            }
        }
        this.sz = sz;
        this.szHalfWidth = sz.width / 2;
        this.szHalfHeight = sz.height / 2;
        this.drawing.setScreenSize(this.getScreenSize());
        logger.exiting(CLASS_NAME, "setScreenSize");
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScale(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Negative window scale");
        }
        if (this.wf != null) {
            List<EditWindow> list = redrawThese;
            synchronized (list) {
                if (runningNow != null) {
                    WindowChangeRequest zap = new WindowChangeRequest();
                    zap.wnd = this;
                    zap.scale = scale;
                    zap.requestType = 1;
                    windowChangeRequests.add(zap);
                    return;
                }
            }
        }
        this.scale = scale;
        this.removeAllInPlaceTextObjects();
        this.computeDatabaseBounds();
    }

    private static boolean handleWindowChangeRequests(EditWindow wnd) {
        boolean changed = false;
        ArrayList<WindowChangeRequest> notThisWindow = null;
        for (WindowChangeRequest zap : windowChangeRequests) {
            if (zap.wnd != wnd) {
                if (notThisWindow == null) {
                    notThisWindow = new ArrayList<WindowChangeRequest>();
                }
                notThisWindow.add(zap);
                continue;
            }
            switch (zap.requestType) {
                case 1: {
                    if (wnd.scale != zap.scale) {
                        changed = true;
                    }
                    wnd.scale = zap.scale;
                    break;
                }
                case 2: {
                    if (wnd.offx != zap.offx || wnd.offy != zap.offy) {
                        changed = true;
                    }
                    wnd.offx = zap.offx;
                    wnd.offy = zap.offy;
                    break;
                }
                case 3: {
                    wnd.sz = zap.sz;
                    wnd.szHalfWidth = wnd.sz.width / 2;
                    wnd.szHalfHeight = wnd.sz.height / 2;
                    wnd.drawing.setScreenSize(wnd.getScreenSize());
                }
            }
        }
        if (notThisWindow != null) {
            windowChangeRequests = notThisWindow;
        } else {
            windowChangeRequests.clear();
        }
        if (changed) {
            wnd.removeAllInPlaceTextObjects();
            wnd.computeDatabaseBounds();
        }
        return changed;
    }

    @Override
    public Point2D getOffset() {
        return new Point2D.Double(this.offx, this.offy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D getScheduledOffset() {
        double oX = this.offx;
        double oY = this.offy;
        List<EditWindow> list = redrawThese;
        synchronized (list) {
            for (WindowChangeRequest zap : windowChangeRequests) {
                if (zap.requestType != 2) continue;
                oX = zap.offx;
                oY = zap.offy;
            }
        }
        return new Point2D.Double(oX, oY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOffset(Point2D off) {
        if (this.wf != null) {
            List<EditWindow> list = redrawThese;
            synchronized (list) {
                if (runningNow != null) {
                    WindowChangeRequest zap = new WindowChangeRequest();
                    zap.wnd = this;
                    zap.offx = off.getX();
                    zap.offy = off.getY();
                    zap.requestType = 2;
                    windowChangeRequests.add(zap);
                    return;
                }
            }
        }
        this.offx = off.getX();
        this.offy = off.getY();
        this.removeAllInPlaceTextObjects();
        this.computeDatabaseBounds();
    }

    private void setScreenBounds(Rectangle2D bounds) {
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        if (width == 0.0) {
            width = 2.0;
        }
        if (height == 0.0) {
            height = 2.0;
        }
        double scalex = (double)this.sz.width / width * 0.9;
        double scaley = (double)this.sz.height / height * 0.9;
        this.setScale(Math.min(scalex, scaley));
        this.setOffset(new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
    }

    private void computeDatabaseBounds() {
        double width = (double)this.sz.width / this.scale;
        double height = (double)this.sz.height / this.scale;
        this.databaseBounds.setRect(this.offx - width / 2.0, this.offy - height / 2.0, width, height);
    }

    @Override
    public Rectangle2D getDisplayedBounds() {
        return this.databaseBounds;
    }

    public void setScrollPosition() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditWindow.this.setScrollPositionUnsafe();
                }
            });
        } else {
            this.setScrollPositionUnsafe();
        }
    }

    private void setScrollPositionUnsafe() {
        int max;
        int min;
        int extent;
        int value;
        if (this.bottomScrollBar == null || this.rightScrollBar == null) {
            return;
        }
        this.bottomScrollBar.setEnabled(this.cell != null);
        this.rightScrollBar.setEnabled(this.cell != null);
        if (this.cell == null) {
            return;
        }
        ERectangle cellBounds = this.cell.getBounds();
        if (this.inPlaceDisplay) {
            cellBounds = this.topLevelCell.getBounds();
        }
        Rectangle2D viewBounds = this.displayableBounds();
        this.ignoreScrollChange = true;
        double width = viewBounds.getWidth() < ((RectangularShape)cellBounds).getWidth() ? viewBounds.getWidth() : ((RectangularShape)cellBounds).getWidth();
        double height = viewBounds.getHeight() < ((RectangularShape)cellBounds).getHeight() ? viewBounds.getHeight() : ((RectangularShape)cellBounds).getHeight();
        Point2D.Double dbPt = new Point2D.Double(this.offx, this.offy);
        double oX = ((Point2D)dbPt).getX();
        double oY = ((Point2D)dbPt).getY();
        if (!this.bottomScrollBar.getValueIsAdjusting()) {
            value = (int)((oX - 0.5 * width) * 100.0);
            extent = (int)(width * 100.0);
            min = (int)((((RectangularShape)cellBounds).getX() - 0.2 * ((RectangularShape)cellBounds).getWidth()) * 100.0);
            max = (int)((((RectangularShape)cellBounds).getX() + ((RectangularShape)cellBounds).getWidth() + 0.2 * ((RectangularShape)cellBounds).getWidth()) * 100.0);
            this.bottomScrollBar.getModel().setRangeProperties(value, extent, min, max, false);
            this.bottomScrollBar.setUnitIncrement((int)(0.05 * viewBounds.getWidth() * 100.0));
            this.bottomScrollBar.setBlockIncrement((int)(0.2 * viewBounds.getWidth() * 100.0));
        }
        if (!this.rightScrollBar.getValueIsAdjusting()) {
            value = (int)((-oY - 0.5 * height) * 100.0);
            extent = (int)(height * 100.0);
            min = (int)(-(((RectangularShape)cellBounds).getY() + ((RectangularShape)cellBounds).getHeight() + 0.2 * ((RectangularShape)cellBounds).getHeight()) * 100.0);
            max = (int)(-(((RectangularShape)cellBounds).getY() - 0.2 * ((RectangularShape)cellBounds).getHeight()) * 100.0);
            this.rightScrollBar.getModel().setRangeProperties(value, extent, min, max, false);
            this.rightScrollBar.setUnitIncrement((int)(0.05 * viewBounds.getHeight() * 100.0));
            this.rightScrollBar.setBlockIncrement((int)(0.2 * viewBounds.getHeight() * 100.0));
        }
        this.ignoreScrollChange = false;
    }

    @Override
    public void bottomScrollChanged(int value) {
        Rectangle2D viewBounds;
        if (this.cell == null) {
            return;
        }
        if (this.ignoreScrollChange) {
            return;
        }
        Point2D.Double dbPt = new Point2D.Double(this.offx, this.offy);
        double oY = ((Point2D)dbPt).getY();
        double val = (double)value / 100.0;
        ERectangle cellBounds = this.cell.getBounds();
        if (this.inPlaceDisplay) {
            cellBounds = this.topLevelCell.getBounds();
        }
        double width = (viewBounds = this.displayableBounds()).getWidth() < ((RectangularShape)cellBounds).getWidth() ? viewBounds.getWidth() : ((RectangularShape)cellBounds).getWidth();
        double newoffx = val + 0.5 * width;
        Point2D.Double offset = new Point2D.Double(newoffx, oY);
        this.setOffset(offset);
        this.getSavedFocusBrowser().updateCurrentFocus();
        this.repaintContents(null, false);
    }

    @Override
    public void rightScrollChanged(int value) {
        Rectangle2D viewBounds;
        if (this.cell == null) {
            return;
        }
        if (this.ignoreScrollChange) {
            return;
        }
        Point2D.Double dbPt = new Point2D.Double(this.offx, this.offy);
        double oX = ((Point2D)dbPt).getX();
        double val = (double)value / 100.0;
        ERectangle cellBounds = this.cell.getBounds();
        if (this.inPlaceDisplay) {
            cellBounds = this.topLevelCell.getBounds();
        }
        double height = (viewBounds = this.displayableBounds()).getHeight() < ((RectangularShape)cellBounds).getHeight() ? viewBounds.getHeight() : ((RectangularShape)cellBounds).getHeight();
        double newoffy = -(val + 0.5 * height);
        Point2D.Double offset = new Point2D.Double(oX, newoffy);
        this.setOffset(offset);
        this.getSavedFocusBrowser().updateCurrentFocus();
        this.repaintContents(null, false);
    }

    public void focusScreen(Rectangle2D bounds) {
        if (bounds == null) {
            return;
        }
        if (this.inPlaceDisplay) {
            Point2D.Double llPt = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
            Point2D.Double urPt = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY());
            this.outofCell.transform(llPt, llPt);
            this.outofCell.transform(urPt, urPt);
            double lX = Math.min(((Point2D)llPt).getX(), ((Point2D)urPt).getX());
            double hX = Math.max(((Point2D)llPt).getX(), ((Point2D)urPt).getX());
            double lY = Math.min(((Point2D)llPt).getY(), ((Point2D)urPt).getY());
            double hY = Math.max(((Point2D)llPt).getY(), ((Point2D)urPt).getY());
            bounds = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
        }
        this.setScreenBounds(bounds);
        this.setScrollPosition();
        this.getSavedFocusBrowser().saveCurrentFocus();
        this.repaintContents(null, false);
    }

    @Override
    public Rectangle2D getBoundsInWindow() {
        Rectangle2D cellBounds = this.cell.getBounds();
        Dimension d = new Dimension();
        int frameFactor = Cell.FrameDescription.getCellFrameInfo(this.cell, d);
        Rectangle2D.Double frameBounds = new Rectangle2D.Double(-d.getWidth() / 2.0, -d.getHeight() / 2.0, d.getWidth(), d.getHeight());
        if (frameFactor == 0) {
            cellBounds = frameBounds;
            if (this.cell.isMultiPage()) {
                double offY = (double)this.pageNumber * 1000.0;
                cellBounds.setRect(cellBounds.getMinX(), cellBounds.getMinY() + offY, cellBounds.getWidth(), cellBounds.getHeight());
            }
        } else {
            if (cellBounds.getWidth() == 0.0 && cellBounds.getHeight() == 0.0) {
                int defaultCellSize = 60;
                cellBounds = new Rectangle2D.Double(cellBounds.getCenterX() - (double)(defaultCellSize / 2), cellBounds.getCenterY() - (double)(defaultCellSize / 2), defaultCellSize, defaultCellSize);
            }
            if (this.wf == null || runningNow == null) {
                double oldScale = this.getScale();
                Point2D oldOffset = this.getOffset();
                this.setScreenBounds(cellBounds);
                Rectangle2D relativeTextBounds = this.cell.getRelativeTextBounds(this);
                if (relativeTextBounds != null) {
                    Rectangle2D.Double newCellBounds = new Rectangle2D.Double();
                    Rectangle2D.union(relativeTextBounds, cellBounds, newCellBounds);
                    cellBounds = newCellBounds;
                }
                this.setScale(oldScale);
                this.setOffset(oldOffset);
            }
            if (frameFactor == 1) {
                Rectangle2D.union(frameBounds, cellBounds, frameBounds);
                cellBounds = frameBounds;
            }
        }
        return cellBounds;
    }

    @Override
    public void addElectricObject(ElectricObject eObj, Cell cell) {
        this.highlighter.addElectricObject(eObj, cell);
    }

    @Override
    public Rectangle2D getHighlightedArea() {
        return this.highlighter.getHighlightedArea(this);
    }

    @Override
    public void addHighlightArea(Rectangle2D rect, Cell cell) {
        this.highlighter.addArea(rect, cell);
    }

    @Override
    public void addHighlightLine(Point2D pt1, Point2D pt2, Cell cell, boolean thick) {
        this.highlighter.addLine(pt1, pt2, cell, thick);
    }

    @Override
    public void addHighlightMessage(Cell cell, String message, Point2D loc) {
        this.highlighter.addMessage(cell, message, loc);
    }

    @Override
    public void addHighlightText(ElectricObject eObj, Cell cell, Variable.Key varKey) {
        this.highlighter.addText(eObj, cell, varKey);
    }

    @Override
    public ElectricObject getOneElectricObject(Class clz) {
        return this.highlighter.getOneElectricObject(clz);
    }

    @Override
    public List<Geometric> getHighlightedEObjs(boolean wantNodes, boolean wantArcs) {
        return this.highlighter.getHighlightedEObjs(wantNodes, wantArcs);
    }

    @Override
    public Set<Network> getHighlightedNetworks() {
        return this.highlighter.getHighlightedNetworks();
    }

    @Override
    public Point2D getHighlightOffset() {
        return this.highlighter.getHighlightOffset();
    }

    @Override
    public void setHighlightOffset(int dX, int dY) {
        this.highlighter.setHighlightOffset(dX, dY);
    }

    @Override
    public List<Highlight2> saveHighlightList() {
        ArrayList<Highlight2> saveList = new ArrayList<Highlight2>();
        for (Highlight2 h : this.highlighter.getHighlights()) {
            saveList.add(h);
        }
        return saveList;
    }

    @Override
    public void restoreHighlightList(List<Highlight2> list) {
        this.highlighter.setHighlightListGeneral(list);
    }

    @Override
    public void clearHighlighting() {
        this.highlighter.clear();
    }

    @Override
    public void finishedHighlighting() {
        this.highlighter.finished();
    }

    @Override
    public void fillScreen() {
        if (this.cell != null && !this.cell.getView().isTextView()) {
            Rectangle2D cellBounds = this.getBoundsInWindow();
            this.focusScreen(cellBounds);
            return;
        }
        this.getSavedFocusBrowser().saveCurrentFocus();
        this.repaint();
    }

    @Override
    public void zoomOutContents() {
        double scale = this.getScale();
        this.setScale(scale / 2.0);
        this.getSavedFocusBrowser().saveCurrentFocus();
        this.repaintContents(null, false);
    }

    @Override
    public void zoomInContents() {
        double scale = this.getScale();
        this.setScale(scale * 2.0);
        this.getSavedFocusBrowser().saveCurrentFocus();
        this.repaintContents(null, false);
    }

    @Override
    public void focusOnHighlighted() {
        Rectangle2D bounds = this.highlighter.getHighlightedArea(this);
        this.focusScreen(bounds);
    }

    public EditWindowFocusBrowser getSavedFocusBrowser() {
        return this.viewBrowser;
    }

    @Override
    public VarContext getVarContext() {
        return this.cellVarContext;
    }

    public void downHierarchy(boolean keepFocus, boolean newWindow, boolean inPlace) {
        Export schExport;
        boolean promptUser;
        Highlight2 h = this.highlighter.getOneHighlight();
        if (h == null) {
            return;
        }
        ElectricObject eobj = h.getElectricObject();
        NodeInst ni = null;
        PortInst pi = null;
        if (eobj instanceof NodeInst) {
            ni = (NodeInst)eobj;
        }
        if (eobj instanceof PortInst) {
            pi = (PortInst)eobj;
            ni = pi.getNodeInst();
        }
        if (ni == null) {
            System.out.println("Must select a Node to descend into");
            return;
        }
        if (!ni.isCellInstance()) {
            System.out.println("Can only descend into cell instances");
            return;
        }
        Cell cell = (Cell)ni.getProto();
        Cell schCell = cell.getEquivalent();
        if (this.cell == schCell) {
            schCell = cell;
        }
        if (schCell == null) {
            schCell = cell;
        }
        WindowFrame.DisplayAttributes da = new WindowFrame.DisplayAttributes();
        da.scale = this.scale;
        da.offX = this.offx;
        da.offY = this.offy;
        if (keepFocus) {
            da.offX -= ni.getAnchorCenterX();
            da.offY -= ni.getAnchorCenterY();
        }
        da.inPlace = inPlace;
        if (cell != schCell) {
            da.inPlace = false;
        }
        if (da.inPlace) {
            AffineTransform transIn = ni.rotateIn(ni.translateIn());
            AffineTransform transOut = ni.translateOut(ni.rotateOut());
            da.inPlaceDescent = new ArrayList<NodeInst>();
            if (this.inPlaceDisplay) {
                da.outofCell = new AffineTransform(this.outofCell);
                da.outofCell.concatenate(transOut);
                da.intoCell = new AffineTransform(this.intoCell);
                da.intoCell.preConcatenate(transIn);
                for (NodeInst n : this.inPlaceDescent) {
                    da.inPlaceDescent.add(n);
                }
                da.topLevelCell = this.topLevelCell;
            } else {
                da.outofCell = transOut;
                da.intoCell = transIn;
                da.topLevelCell = this.cell;
            }
            da.inPlaceDescent.add(ni);
        }
        Nodable desiredNO = null;
        ArrayList<Nodable> possibleNodables = new ArrayList<Nodable>();
        Netlist nl = ni.getParent().acquireUserNetlist();
        if (nl == null) {
            System.out.println("Netlist is not ready");
            return;
        }
        Iterator<Nodable> it = nl.getNodables();
        while (it.hasNext()) {
            Nodable no = it.next();
            if (no.getNodeInst() != ni) continue;
            possibleNodables.add(no);
        }
        if (possibleNodables.size() > 1 && (promptUser = EditWindow.isArrayedContextMatter(desiredNO = (Nodable)possibleNodables.get(0)))) {
            Object[] manyOptions = new String[possibleNodables.size()];
            int i = 0;
            for (Nodable no : possibleNodables) {
                manyOptions[i++] = no.getName();
            }
            String chosen = (String)JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Descend into which node?", "Choose a Node", 3, null, manyOptions, manyOptions[0]);
            if (chosen == null) {
                return;
            }
            for (Nodable no : possibleNodables) {
                if (!no.getName().equals(chosen)) continue;
                desiredNO = no;
                break;
            }
        }
        boolean redisplay = true;
        if (inPlace) {
            redisplay = false;
        }
        if (keepFocus) {
            redisplay = false;
        }
        EditWindow newWND = this;
        if (newWindow) {
            WindowFrame newWF = WindowFrame.createEditWindow(schCell);
            newWND = (EditWindow)newWF.getContent();
        } else {
            SelectObject.selectObjectDialog(schCell, true);
        }
        VarContext vc = desiredNO != null ? this.cellVarContext.push(desiredNO) : this.cellVarContext.push(ni);
        newWND.showCell(schCell, vc, redisplay, da);
        newWND.getWindowFrame().addToHistory(schCell, vc, da);
        if (!redisplay) {
            this.fullRepaint();
        }
        EditWindow.clearSubCellCache();
        if (pi != null && (schExport = schCell.findExport(pi.getPortProto().getName())) != null) {
            PortInst origPort = schExport.getOriginalPort();
            newWND.highlighter.addElectricObject(origPort, schCell);
            newWND.highlighter.finished();
        }
    }

    public static boolean isArrayedContextMatter(Nodable no) {
        if (User.isPromptForIndexWhenDescending()) {
            return true;
        }
        Iterator<Object> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            if (!(wf.getContent() instanceof WaveformWindow)) continue;
            return true;
        }
        it = no.getVariables();
        while (it.hasNext()) {
            String str;
            Variable var = (Variable)it.next();
            Object obj = var.getObject();
            if (!(obj instanceof String) || !(str = (String)obj).matches(".*LE\\.getdrive.*")) continue;
            return true;
        }
        return false;
    }

    public void upHierarchy() {
        if (this.cell == null) {
            return;
        }
        Cell oldCell = this.cell;
        Export selectedExport = null;
        Set<Network> nets = this.highlighter.getHighlightedNetworks();
        for (Network net : nets) {
            Iterator<Export> eIt = net.getExports();
            if (eIt.hasNext()) {
                Export e;
                selectedExport = e = eIt.next();
            }
            if (selectedExport == null) continue;
            break;
        }
        try {
            NodeInst ni;
            Iterator<NodeInst> it;
            Cell iconView;
            Cell schCell;
            Nodable no = this.cellVarContext.getNodable();
            if (no != null) {
                Cell parent = no.getParent();
                VarContext context = this.cellVarContext.pop();
                int historyIndex = this.wf.findCellHistoryIndex(parent, context);
                PortInst pi = null;
                if (historyIndex >= 0) {
                    WindowFrame.CellHistory foundHistory = this.wf.getCellHistoryList().get(historyIndex);
                    pi = foundHistory.getDisplayAttributes().selPort;
                    foundHistory.setContext(context);
                    if (selectedExport != null) {
                        foundHistory.getDisplayAttributes().selPort = no.getNodeInst().findPortInstFromProto(selectedExport);
                    }
                    this.wf.setCellByHistory(historyIndex);
                } else {
                    WindowFrame.DisplayAttributes da = new WindowFrame.DisplayAttributes();
                    da.scale = this.scale;
                    da.offX = this.offx;
                    da.offY = this.offy;
                    da.inPlace = this.inPlaceDisplay;
                    da.intoCell = this.intoCell;
                    da.outofCell = this.outofCell;
                    da.topLevelCell = this.topLevelCell;
                    da.inPlaceDescent = null;
                    if (this.inPlaceDisplay) {
                        int inPlaceDepth = this.inPlaceDescent.size() - 1;
                        if (inPlaceDepth == 0) {
                            da.inPlace = false;
                        } else {
                            da.inPlaceDescent = new ArrayList<NodeInst>();
                            da.intoCell = new AffineTransform();
                            da.outofCell = new AffineTransform();
                            for (int i = 0; i < inPlaceDepth; ++i) {
                                NodeInst ni2 = this.inPlaceDescent.get(i);
                                da.inPlaceDescent.add(ni2);
                                da.outofCell.concatenate(ni2.translateOut(ni2.rotateOut()));
                                da.intoCell.preConcatenate(ni2.rotateIn(ni2.translateIn()));
                            }
                        }
                    }
                    this.showCell(parent, context, true, da);
                    this.wf.addToHistory(parent, context, da);
                    if (selectedExport != null) {
                        pi = no.getNodeInst().findPortInstFromProto(selectedExport);
                    }
                    if (pi != null) {
                        this.highlighter.addElectricObject(pi, parent);
                    } else {
                        this.highlighter.addElectricObject(no.getNodeInst(), parent);
                    }
                }
                EditWindow.clearSubCellCache();
                SelectObject.selectObjectDialog(parent, true);
                return;
            }
            if (this.cell.isIcon() && (schCell = this.cell.getEquivalent()) != null) {
                this.setCell(schCell, VarContext.globalContext, null);
                SelectObject.selectObjectDialog(schCell, true);
                return;
            }
            HashSet<Cell> found = new HashSet<Cell>();
            Iterator<NodeInst> it2 = this.cell.getInstancesOf();
            while (it2.hasNext()) {
                NodeInst ni3 = it2.next();
                Cell parent = ni3.getParent();
                if (parent.getLibrary().isHidden()) continue;
                found.add(parent);
            }
            if (this.cell.isSchematic() && (iconView = this.cell.iconView()) != null) {
                it = iconView.getInstancesOf();
                while (it.hasNext()) {
                    Cell parent;
                    ni = it.next();
                    if (ni.isIconOfParent() || (parent = ni.getParent()).getLibrary().isHidden()) continue;
                    found.add(parent);
                }
            }
            if (found.size() == 0) {
                System.out.println("Not in any cells");
            } else if (found.size() == 1) {
                Cell parent = (Cell)found.iterator().next();
                this.setCell(parent, VarContext.globalContext, null);
                it = parent.getNodes();
                while (it.hasNext()) {
                    Cell nodeCell;
                    ni = it.next();
                    if (!ni.isCellInstance() || (nodeCell = (Cell)ni.getProto()) != oldCell && !nodeCell.isIconOf(oldCell)) continue;
                    if (selectedExport != null) {
                        this.highlighter.addElectricObject(ni.findPortInstFromProto(selectedExport), parent);
                        break;
                    }
                    this.highlighter.addElectricObject(ni, parent);
                    break;
                }
                this.highlighter.finished();
                SelectObject.selectObjectDialog(parent, true);
            } else {
                JPopupMenu parents = new JPopupMenu("parents");
                for (Cell parent : found) {
                    String cellName = parent.describe(false);
                    JMenuItem menuItem = new JMenuItem(cellName);
                    menuItem.addActionListener(this);
                    parents.add(menuItem);
                }
                parents.show(this.overall, 0, 0);
            }
        }
        catch (NullPointerException e) {
            ActivityLogger.logException(e);
        }
    }

    public static void clearSubCellCache() {
        PixelDrawing.clearSubCellCache();
        LayerDrawing.clearSubCellCache();
    }

    public static void forceRedraw(Cell cell) {
        PixelDrawing.forceRedraw(cell);
        LayerDrawing.forceRedraw(cell);
    }

    public Point2D screenToDatabase(int screenX, int screenY) {
        double dbX = (double)(screenX - this.szHalfWidth) / this.scale + this.offx;
        double dbY = (double)(this.szHalfHeight - screenY) / this.scale + this.offy;
        Point2D.Double dbPt = new Point2D.Double(dbX, dbY);
        if (this.inPlaceDisplay) {
            this.intoCell.transform(dbPt, dbPt);
        }
        return dbPt;
    }

    public Rectangle2D screenToDatabase(Rectangle2D screenRect) {
        Point2D anchor = this.screenToDatabase((int)screenRect.getX(), (int)screenRect.getY());
        Point2D size = this.deltaScreenToDatabase((int)screenRect.getWidth(), (int)screenRect.getHeight());
        return new Rectangle2D.Double(anchor.getX(), anchor.getY() + size.getY(), size.getX(), -size.getY());
    }

    public Point2D deltaScreenToDatabase(int screenDX, int screenDY) {
        Point2D origin = this.screenToDatabase(0, 0);
        Point2D pt = this.screenToDatabase(screenDX, screenDY);
        return new Point2D.Double(pt.getX() - origin.getX(), pt.getY() - origin.getY());
    }

    public void databaseToScreen(double dbX, double dbY, Point result) {
        if (this.inPlaceDisplay) {
            Point2D.Double dbPt = new Point2D.Double(dbX, dbY);
            this.outofCell.transform(dbPt, dbPt);
            dbX = ((Point2D)dbPt).getX();
            dbY = ((Point2D)dbPt).getY();
        }
        double scrX = (double)this.szHalfWidth + (dbX - this.offx) * this.scale;
        double scrY = (double)this.szHalfHeight - (dbY - this.offy) * this.scale;
        result.x = (int)(scrX >= 0.0 ? scrX + 0.5 : scrX - 0.5);
        result.y = (int)(scrY >= 0.0 ? scrY + 0.5 : scrY - 0.5);
    }

    @Override
    public Point databaseToScreen(double dbX, double dbY) {
        Point result = new Point();
        this.databaseToScreen(dbX, dbY, result);
        return result;
    }

    public Point databaseToScreen(Point2D db) {
        return this.databaseToScreen(db.getX(), db.getY());
    }

    public Rectangle databaseToScreen(Rectangle2D db) {
        int swap;
        Point llPt = this.databaseToScreen(db.getMinX(), db.getMinY());
        Point urPt = this.databaseToScreen(db.getMaxX(), db.getMaxY());
        int screenLX = llPt.x;
        int screenHX = urPt.x;
        int screenLY = llPt.y;
        int screenHY = urPt.y;
        if (screenHX < screenLX) {
            swap = screenHX;
            screenHX = screenLX;
            screenLX = swap;
        }
        if (screenHY < screenLY) {
            swap = screenHY;
            screenHY = screenLY;
            screenLY = swap;
        }
        return new Rectangle(screenLX, screenLY, screenHX - screenLX + 1, screenHY - screenLY + 1);
    }

    public Point deltaDatabaseToScreen(double dbDX, double dbDY) {
        Point origin = this.databaseToScreen(0.0, 0.0);
        Point pt = this.databaseToScreen(dbDX, dbDY);
        return new Point(pt.x - origin.x, pt.y - origin.y);
    }

    public static void gridAlign(Point2D pt) {
        DBMath.gridAlign(pt, User.getAlignmentToGrid());
    }

    public double getTextUnitSize(double pointSize) {
        return pointSize / this.scale;
    }

    public double getTextScreenSize(double dbSize) {
        return dbSize * this.scale;
    }

    public static int getDefaultFontSize() {
        return TextDescriptor.getDefaultFontSize();
    }

    public Font getFont(TextDescriptor descript) {
        return descript != null ? descript.getFont(this, 5) : TextDescriptor.getDefaultFont();
    }

    public double getFontHeight(TextDescriptor descript) {
        double size = EditWindow.getDefaultFontSize();
        if (descript != null) {
            size = descript.getTrueSize(this);
        }
        return size;
    }

    public GlyphVector getGlyphs(String text, Font font) {
        return TextDescriptor.getGlyphs(text, font);
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
        if (this.cell != null && !this.cell.isLinked()) {
            this.showCell(null, VarContext.globalContext, true, null);
            this.wf.cellHistoryGoBack();
        }
    }

    @Override
    public void writeImage(ElectricPrinter ep, String filePath) {
        BufferedImage img = this.getPrintImage(ep);
        PNG.writeImage(img, filePath);
    }

    @Override
    public boolean initializePrinting(ElectricPrinter ep, PageFormat pageFormat) {
        int scaleFactor = ep.getDesiredDPI() / 72;
        if (scaleFactor > 2) {
            scaleFactor = 2;
        } else if (scaleFactor <= 0) {
            scaleFactor = 1;
        }
        int pageWid = (int)pageFormat.getImageableWidth() * scaleFactor;
        int pageHei = (int)pageFormat.getImageableHeight() * scaleFactor;
        this.setSize(pageWid, pageHei);
        this.validate();
        this.repaint();
        return true;
    }

    @Override
    public BufferedImage getPrintImage(ElectricPrinter ep) {
        Graphics2D g2d;
        if (this.getCell() == null) {
            return null;
        }
        int scaleFactor = ep.getDesiredDPI() / 72;
        if (scaleFactor > 2) {
            scaleFactor = 2;
        } else if (scaleFactor <= 0) {
            scaleFactor = 1;
        }
        int wid = (int)ep.getPageFormat().getImageableWidth() * scaleFactor;
        int hei = (int)ep.getPageFormat().getImageableHeight() * scaleFactor;
        BufferedImage img = ep.getBufferedImage();
        if (img == null) {
            PixelDrawing offscreen = new PixelDrawing(new Dimension(wid, hei));
            PrinterJob pj = ep.getPrintJob();
            ColorSupported cs = pj.getPrintService().getAttribute(ColorSupported.class);
            int printMode = 1;
            if (cs.getValue() == 0) {
                printMode = 2;
            }
            offscreen.setPrintingMode(printMode);
            offscreen.setBackgroundColor(Color.WHITE);
            int oldBackgroundColor = User.getColorBackground();
            User.setColorBackground(0xFFFFFF);
            Rectangle2D cellBounds = this.getBoundsInWindow();
            double width = cellBounds.getWidth();
            double height = cellBounds.getHeight();
            if (width == 0.0) {
                width = 2.0;
            }
            if (height == 0.0) {
                height = 2.0;
            }
            double scalex = (double)wid / width;
            double scaley = (double)hei / height;
            double scale = Math.min(scalex, scaley);
            EPoint offset = new EPoint(cellBounds.getCenterX(), cellBounds.getCenterY());
            offscreen.printImage(scale, offset, this.getCell(), this.getVarContext());
            img = offscreen.getBufferedImage();
            ep.setBufferedImage(img);
            offscreen.setPrintingMode(0);
            User.setColorBackground(oldBackgroundColor);
        }
        if ((g2d = (Graphics2D)ep.getGraphics()) != null) {
            AffineTransform saveAT = g2d.getTransform();
            int ix = (int)ep.getPageFormat().getImageableX() * scaleFactor;
            int iy = (int)ep.getPageFormat().getImageableY() * scaleFactor;
            g2d.scale(1.0 / (double)scaleFactor, 1.0 / (double)scaleFactor);
            g2d.drawImage((Image)img, ix, iy, null);
            Point2D saveOffset = this.getOffset();
            double saveScale = this.scale;
            int saveHalfWid = this.szHalfWidth;
            int saveHalfHei = this.szHalfHeight;
            Rectangle2D cellBounds = this.getBoundsInWindow();
            double width = cellBounds.getWidth();
            double height = cellBounds.getHeight();
            if (width == 0.0) {
                width = 2.0;
            }
            if (height == 0.0) {
                height = 2.0;
            }
            this.scale = Math.min((double)wid / width, (double)hei / height);
            this.offy = 0.0;
            this.offx = 0.0;
            this.szHalfWidth = ix + wid / 2;
            this.szHalfHeight = iy + hei / 2;
            this.computeDatabaseBounds();
            g2d.setColor(Color.BLACK);
            this.drawCellFrame(g2d);
            this.scale = saveScale;
            this.szHalfWidth = saveHalfWid;
            this.szHalfHeight = saveHalfHei;
            this.offx = saveOffset.getX();
            this.offy = saveOffset.getY();
            this.computeDatabaseBounds();
            g2d.setTransform(saveAT);
        }
        return img;
    }

    @Override
    public void panXOrY(int direction, double[] panningAmounts, int ticks) {
        double panningAmount;
        Cell cell = this.getCell();
        if (cell == null) {
            return;
        }
        Dimension dim = this.getSize();
        double value = direction == 0 ? (double)dim.width : (double)dim.height;
        int mult = (int)(value * (panningAmount = panningAmounts[User.getPanningDistance()]) / this.getScale());
        if (mult == 0) {
            mult = 1;
        }
        Point2D wndOffset = this.getOffset();
        Point2D.Double newOffset = direction == 0 ? new Point2D.Double(wndOffset.getX() - (double)(mult * ticks), wndOffset.getY()) : new Point2D.Double(wndOffset.getX(), wndOffset.getY() - (double)(mult * ticks));
        this.setOffset(newOffset);
        this.getSavedFocusBrowser().updateCurrentFocus();
        this.repaintContents(null, false);
    }

    private static class ReplaceAllTextJob
    extends Job {
        private StringSearch search;
        private String replace;
        private Cell cell;

        public ReplaceAllTextJob(EditWindow wnd, String replace) {
            super("Replace All Text", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.search = wnd.textSearch;
            this.replace = replace;
            this.cell = wnd.cell;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.search.replaceAllText(this.replace, this.cell);
            this.fieldVariableChanged("search");
            return true;
        }
    }

    private static class ReplaceTextJob
    extends Job {
        private String replace;
        private Cell cell;
        private StringSearch search;

        private ReplaceTextJob(EditWindow wnd, String replace) {
            super("Replace Text", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.search = wnd.textSearch;
            this.cell = wnd.cell;
            this.replace = replace;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            StringSearch.changeOneText(this.search.foundInCell, this.search.currentStringInCell, this.replace, this.cell);
            this.fieldVariableChanged("search");
            return true;
        }
    }

    private static class StringsInCell
    implements Serializable {
        final Object object;
        final Variable.Key key;
        String theLine;
        final int lineInVariable;
        int startPosition;
        int endPosition;
        final String regExpSearch;
        boolean replaced;

        StringsInCell(Object object, Variable.Key key, int lineInVariable, String theLine, int startPosition, int endPosition, String regExpSearch) {
            this.object = object;
            assert (key != null);
            this.key = key;
            this.lineInVariable = lineInVariable;
            this.theLine = theLine;
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.regExpSearch = regExpSearch;
            this.replaced = false;
        }

        public String toString() {
            return "StringsInCell obj=" + this.object + " var=" + this.key + " line=" + this.lineInVariable + " start=" + this.startPosition + " end=" + this.endPosition + " msg=" + this.theLine;
        }
    }

    private static class StringSearch
    implements Serializable {
        private List<StringsInCell> foundInCell;
        private StringsInCell currentStringInCell;
        private int currentFindPosition;

        private StringSearch() {
        }

        private static Pattern getPattern(String search, boolean caseSensitive) {
            int flags = caseSensitive ? 0 : 66;
            Pattern p = null;
            try {
                p = Pattern.compile(search, flags);
            }
            catch (Exception e) {
                System.out.println("Error in regular expression '" + search + "'");
                System.out.println(e.getMessage());
            }
            return p;
        }

        private void searchTextNodes(Cell cell, String search, boolean caseSensitive, boolean regExp, Set whatToSearch, Pattern pattern) {
            boolean doTemp = whatToSearch.contains((Object)TextUtils.WhatToSearch.TEMP_NAMES);
            TextUtils.WhatToSearch what = EditWindow.get(whatToSearch, TextUtils.WhatToSearch.NODE_NAME);
            TextUtils.WhatToSearch whatVar = EditWindow.get(whatToSearch, TextUtils.WhatToSearch.NODE_VAR);
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (what != null) {
                    Name name = ni.getNameKey();
                    if (doTemp || !name.isTempname()) {
                        this.findAllMatches(ni, NodeInst.NODE_NAME, 0, name.toString(), search, caseSensitive, regExp, pattern);
                    }
                }
                if (whatVar == null) continue;
                this.addVariableTextToList(ni, search, caseSensitive, regExp, pattern);
            }
        }

        private void searchTextArcs(Cell cell, String search, boolean caseSensitive, boolean regExp, Set whatToSearch, Pattern pattern) {
            boolean doTemp = whatToSearch.contains((Object)TextUtils.WhatToSearch.TEMP_NAMES);
            TextUtils.WhatToSearch what = EditWindow.get(whatToSearch, TextUtils.WhatToSearch.ARC_NAME);
            TextUtils.WhatToSearch whatVar = EditWindow.get(whatToSearch, TextUtils.WhatToSearch.ARC_VAR);
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                if (what != null) {
                    Name name = ai.getNameKey();
                    if (doTemp || !name.isTempname()) {
                        this.findAllMatches(ai, ArcInst.ARC_NAME, 0, name.toString(), search, caseSensitive, regExp, pattern);
                    }
                }
                if (whatVar == null) continue;
                this.addVariableTextToList(ai, search, caseSensitive, regExp, pattern);
            }
        }

        private void searchTextExports(Cell cell, String search, boolean caseSensitive, boolean regExp, Set whatToSearch, Pattern pattern) {
            TextUtils.WhatToSearch what = EditWindow.get(whatToSearch, TextUtils.WhatToSearch.EXPORT_NAME);
            TextUtils.WhatToSearch whatVar = EditWindow.get(whatToSearch, TextUtils.WhatToSearch.EXPORT_VAR);
            Iterator<Export> it = cell.getExports();
            while (it.hasNext()) {
                Export pp = it.next();
                if (what != null) {
                    Name name = pp.getNameKey();
                    this.findAllMatches(pp, Export.EXPORT_NAME, 0, name.toString(), search, caseSensitive, regExp, pattern);
                }
                if (whatVar == null) continue;
                this.addVariableTextToList(pp, search, caseSensitive, regExp, pattern);
            }
        }

        private void searchTextCellVars(Cell cell, String search, boolean caseSensitive, boolean regExp, Set whatToSearch, Pattern pattern) {
            TextUtils.WhatToSearch whatVar = EditWindow.get(whatToSearch, TextUtils.WhatToSearch.CELL_VAR);
            if (whatVar != null) {
                Iterator<Variable> it = cell.getVariables();
                while (it.hasNext()) {
                    Variable var = it.next();
                    if (!var.isDisplay()) continue;
                    this.findAllMatches(null, var.getKey(), -1, var.getPureValue(-1), search, caseSensitive, regExp, pattern);
                }
            }
        }

        private static void changeOneText(List<StringsInCell> foundInCell, StringsInCell sic, String rep, Cell cell) {
            String newString;
            if (sic.replaced) {
                return;
            }
            sic.replaced = true;
            String oldString = sic.theLine;
            if (sic.regExpSearch != null) {
                Pattern p = Pattern.compile(sic.regExpSearch);
                Matcher m = p.matcher(oldString);
                boolean found = m.find(sic.startPosition);
                LayoutLib.error(!found, "regExp find before replace failed");
                try {
                    StringBuffer ns = new StringBuffer();
                    m.appendReplacement(ns, rep);
                    m.appendTail(ns);
                    newString = ns.toString();
                }
                catch (Exception e) {
                    System.out.println("Regular expression replace failed");
                    newString = oldString;
                }
            } else {
                newString = oldString.substring(0, sic.startPosition) + rep + oldString.substring(sic.endPosition);
            }
            EditWindow.printChange(sic, newString);
            if (sic.object == null) {
                cell.updateVar(sic.key, newString);
            } else if (sic.key == NodeInst.NODE_NAME) {
                NodeInst ni = (NodeInst)sic.object;
                ni.setName(newString);
            } else if (sic.key == ArcInst.ARC_NAME) {
                ArcInst ai = (ArcInst)sic.object;
                ai.setName(newString);
            } else if (sic.key == Export.EXPORT_NAME) {
                Export pp = (Export)sic.object;
                pp.rename(newString);
            } else {
                ElectricObject base = (ElectricObject)sic.object;
                Variable var = base.getVar(sic.key);
                Object obj = var.getObject();
                if (obj instanceof String) {
                    base.updateVar(sic.key, newString);
                } else if (obj instanceof String[]) {
                    String[] oldLines = (String[])obj;
                    String[] newLines = new String[oldLines.length];
                    for (int i = 0; i < oldLines.length; ++i) {
                        newLines[i] = i == sic.lineInVariable ? newString : oldLines[i];
                    }
                    base.updateVar(sic.key, newLines);
                }
            }
            int delta = newString.length() - oldString.length();
            if (delta != 0) {
                for (StringsInCell oSIC : foundInCell) {
                    if (oSIC == sic || oSIC.object != sic.object || oSIC.key != sic.key || oSIC.lineInVariable != sic.lineInVariable) continue;
                    oSIC.theLine = newString;
                    if (oSIC.startPosition <= sic.startPosition) continue;
                    oSIC.startPosition += delta;
                    oSIC.endPosition += delta;
                }
            }
        }

        private void replaceAllText(String replace, Cell cell) {
            int total = 0;
            this.currentFindPosition = 0;
            while (this.currentFindPosition < this.foundInCell.size()) {
                this.currentStringInCell = this.foundInCell.get(this.currentFindPosition);
                StringSearch.changeOneText(this.foundInCell, this.currentStringInCell, replace, cell);
                ++total;
                ++this.currentFindPosition;
            }
            if (total == 0) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                System.out.println("Replaced " + total + " times");
            }
        }

        public void initTextSearch(Cell cell, String search, boolean caseSensitive, boolean regExp, Set<TextUtils.WhatToSearch> whatToSearch) {
            this.foundInCell = new ArrayList<StringsInCell>();
            if (cell == null) {
                System.out.println("No current Cell");
                return;
            }
            Pattern pattern = null;
            if (regExp && (pattern = StringSearch.getPattern(search, caseSensitive)) == null) {
                return;
            }
            this.searchTextNodes(cell, search, caseSensitive, regExp, whatToSearch, pattern);
            this.searchTextArcs(cell, search, caseSensitive, regExp, whatToSearch, pattern);
            this.searchTextExports(cell, search, caseSensitive, regExp, whatToSearch, pattern);
            this.searchTextCellVars(cell, search, caseSensitive, regExp, whatToSearch, pattern);
            if (this.foundInCell.size() == 0) {
                System.out.println("Nothing found");
            }
            this.currentFindPosition = -1;
            this.currentStringInCell = null;
        }

        private boolean findNextText(Cell cell, Highlighter highlighter, boolean reverse) {
            if (this.foundInCell == null || this.foundInCell.size() == 0) {
                this.currentStringInCell = null;
                return false;
            }
            if (reverse) {
                --this.currentFindPosition;
                if (this.currentFindPosition < 0) {
                    this.currentFindPosition = this.foundInCell.size() - 1;
                }
            } else {
                ++this.currentFindPosition;
                if (this.currentFindPosition >= this.foundInCell.size()) {
                    this.currentFindPosition = 0;
                }
            }
            this.currentStringInCell = this.foundInCell.get(this.currentFindPosition);
            highlighter.clear();
            EditWindow.printFind(this.currentStringInCell);
            if (this.currentStringInCell.object == null) {
                highlighter.addText(cell, cell, this.currentStringInCell.key);
            } else {
                ElectricObject eObj = (ElectricObject)this.currentStringInCell.object;
                Variable.Key key = this.currentStringInCell.key;
                if (eObj instanceof Export) {
                    key = Export.EXPORT_NAME;
                } else if (eObj instanceof ArcInst) {
                    key = ArcInst.ARC_NAME;
                } else if (eObj instanceof NodeInst) {
                    key = NodeInst.NODE_NAME;
                }
                assert (key != null);
                highlighter.addText(eObj, cell, key);
            }
            highlighter.finished();
            return true;
        }

        protected void findAllMatches(Object object, Variable.Key key, int lineInVariable, String theLine, String search, boolean caseSensitive, boolean regExp, Pattern p) {
            Matcher m = p != null ? p.matcher(theLine) : null;
            int startPos = 0;
            while (true) {
                int endPos;
                if (regExp) {
                    boolean found = m.find();
                    if (!found) break;
                    startPos = m.start();
                    endPos = m.end();
                } else {
                    if ((startPos = TextUtils.findStringInString(theLine, search, startPos, caseSensitive, false)) < 0) break;
                    endPos = startPos + search.length();
                }
                String regExpSearch = regExp ? search : null;
                this.foundInCell.add(new StringsInCell(object, key, lineInVariable, theLine, startPos, endPos, regExpSearch));
                startPos = endPos;
            }
        }

        private void addVariableTextToList(ElectricObject eObj, String search, boolean caseSensitive, boolean regExp, Pattern p) {
            Iterator<Variable> it = eObj.getVariables();
            while (it.hasNext()) {
                Variable var = it.next();
                if (!var.isDisplay()) continue;
                Object obj = var.getObject();
                if (obj instanceof String) {
                    this.findAllMatches(eObj, var.getKey(), -1, (String)obj, search, caseSensitive, regExp, p);
                    continue;
                }
                if (!(obj instanceof String[])) continue;
                String[] strings = (String[])obj;
                for (int i = 0; i < strings.length; ++i) {
                    this.findAllMatches(eObj, var.getKey(), i, strings[i], search, caseSensitive, regExp, p);
                }
            }
        }
    }

    private static class DisplayedFrame
    extends Cell.FrameDescription {
        private Graphics g;
        private EditWindow wnd;
        private Color lineColor;
        private Color textColor;

        public DisplayedFrame(Cell cell, Graphics g, EditWindow wnd) {
            super(cell, wnd.pageNumber);
            this.g = g;
            this.wnd = wnd;
            this.lineColor = new Color(User.getColorInstanceOutline());
            this.textColor = new Color(User.getColorText());
        }

        @Override
        public void showFrameLine(Point2D from, Point2D to) {
            this.g.setColor(this.lineColor);
            Point f = this.wnd.databaseToScreen(from);
            Point t = this.wnd.databaseToScreen(to);
            this.g.drawLine(f.x, f.y, t.x, t.y);
        }

        @Override
        public void showFrameText(Point2D ctr, double size, double maxWid, double maxHei, String string) {
            Point sizeVector = this.wnd.deltaDatabaseToScreen(size, size);
            int initialHeight = (int)Math.abs(((Point2D)sizeVector).getY());
            Font font = new Font(User.getDefaultFont(), 0, initialHeight);
            this.g.setFont(font);
            this.g.setColor(this.textColor);
            FontRenderContext frc = new FontRenderContext(null, true, true);
            GlyphVector gv = font.createGlyphVector(frc, string);
            LineMetrics lm = font.getLineMetrics(string, frc);
            Rectangle rect = gv.getOutline(0.0f, lm.getAscent() - lm.getLeading()).getBounds();
            double width = rect.width;
            double height = lm.getHeight();
            Point2D databaseSize = this.wnd.deltaScreenToDatabase((int)width, (int)height);
            double dbWidth = Math.abs(databaseSize.getX());
            double dbHeight = Math.abs(databaseSize.getY());
            if (maxWid > 0.0 && maxHei > 0.0 && (dbWidth > maxWid || dbHeight > maxHei)) {
                double scale = Math.min(maxWid / dbWidth, maxHei / dbHeight);
                font = new Font(User.getDefaultFont(), 0, (int)((double)initialHeight * scale));
                if (font != null) {
                    gv = font.createGlyphVector(frc, string);
                    lm = font.getLineMetrics(string, frc);
                    rect = gv.getOutline(0.0f, lm.getAscent() - lm.getLeading()).getBounds();
                    width = rect.width;
                    height = lm.getHeight();
                }
            }
            Graphics2D g2 = (Graphics2D)this.g;
            Point p = this.wnd.databaseToScreen(ctr);
            g2.drawGlyphVector(gv, (float)((double)p.x - width / 2.0), (float)((double)p.y + height / 2.0 - (double)lm.getDescent()));
        }
    }

    private static class CrossProbe {
        boolean isLine;
        Point2D start;
        Point2D end;
        Rectangle2D box;
        Color color;

        private CrossProbe() {
        }
    }

    private static class RenderJob
    extends Job {
        private EditWindow wnd;
        private Rectangle2D bounds;
        private boolean fullInstantiate;

        protected RenderJob(EditWindow wnd, Rectangle2D bounds, boolean fullInstantiate) {
            super("Display", User.getUserTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.wnd = wnd;
            this.bounds = bounds;
            this.fullInstantiate = fullInstantiate;
            this.startJob();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doIt() throws JobException {
            logger.entering(RENDER_JOB_CLASS_NAME, "doIt");
            if (this.bounds == null) {
                this.bounds = User.getChangedInWindow(this.wnd);
                if (this.bounds != null) {
                    User.clearChangedInWindow(this.wnd);
                }
            }
            try {
                this.wnd.drawing.render(this.fullInstantiate, this.bounds);
            }
            catch (ConcurrentModificationException e) {
                System.out.println("GOT ConcurrentModificationException during redisplay!");
                ActivityLogger.logException(e);
                this.wnd.repaintContents(this.bounds, this.fullInstantiate);
            }
            finally {
                List list = redrawThese;
                synchronized (list) {
                    runningNow = null;
                }
            }
            this.wnd.repaint();
            logger.exiting(RENDER_JOB_CLASS_NAME, "doIt");
            return true;
        }
    }

    private static class ScrollAdjustmentListener
    implements AdjustmentListener {
        EditWindow wnd;

        ScrollAdjustmentListener(EditWindow wnd) {
            this.wnd = wnd;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (e.getSource() == this.wnd.getBottomScrollBar() && this.wnd.getCell() != null) {
                this.wnd.bottomScrollChanged(e.getValue());
            }
            if (e.getSource() == this.wnd.getRightScrollBar() && this.wnd.getCell() != null) {
                this.wnd.rightScrollChanged(e.getValue());
            }
        }
    }

    private static class EditWindowDropTarget
    implements DropTargetListener {
        private EditWindowDropTarget() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            this.dragAction(e);
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            this.dragAction(e);
        }

        private Object getDraggedObject(DataFlavor[] flavors) {
            if (flavors.length > 0 && flavors[0] instanceof NodeProtoDataFlavor) {
                NodeProtoDataFlavor npdf = (NodeProtoDataFlavor)flavors[0];
                Object obj = npdf.getFlavorObject();
                return obj;
            }
            return null;
        }

        private void dragAction(DropTargetDragEvent e) {
            Object obj = this.getDraggedObject(e.getCurrentDataFlavors());
            if (obj != null) {
                e.acceptDrag(e.getDropAction());
                DropTarget dt = (DropTarget)e.getSource();
                if (dt.getComponent() instanceof JPanel) {
                    EditWindow wnd = (EditWindow)dt.getComponent();
                    wnd.showDraggedBox(obj, e.getLocation().x, e.getLocation().y);
                }
                return;
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(0x40000000);
            Object obj = this.getDraggedObject(dtde.getCurrentDataFlavors());
            if (obj == null) {
                dtde.dropComplete(false);
                return;
            }
            DropTarget dt = (DropTarget)dtde.getSource();
            if (!(dt.getComponent() instanceof JPanel)) {
                dtde.dropComplete(false);
                return;
            }
            EditWindow wnd = (EditWindow)dt.getComponent();
            Point2D where = wnd.screenToDatabase(dtde.getLocation().x, dtde.getLocation().y);
            EditWindow.gridAlign(where);
            wnd.getHighlighter().clear();
            NodeInst ni = null;
            NodeProto np = null;
            int defAngle = 0;
            if (obj instanceof NodeProto) {
                np = (NodeProto)obj;
                if (np instanceof PrimitiveNode) {
                    defAngle = ((PrimitiveNode)np).getDefPlacementAngle();
                }
            } else if (obj instanceof NodeInst) {
                ni = (NodeInst)obj;
                np = ni.getProto();
            } else if (obj instanceof Cell.CellGroup) {
                Cell.CellGroup gp = (Cell.CellGroup)obj;
                View view = wnd.getCell().getView();
                if (view == View.SCHEMATIC) {
                    view = View.ICON;
                }
                Iterator<Cell> itG = gp.getCells();
                while (itG.hasNext()) {
                    Cell c = itG.next();
                    if (c.getView() != view) continue;
                    np = c;
                    break;
                }
                if (np == null) {
                    System.out.println("No " + view + " type found in the dragged group '" + gp.getName() + "'");
                }
            }
            if (np != null) {
                new PaletteFrame.PlaceNewNode("Create Node", np, ni, defAngle, where, wnd.getCell(), null, false);
            }
        }
    }

    public static class NodeProtoTransferable
    implements Transferable {
        private Cell cell;
        private Cell.CellGroup group;
        private NodeProtoDataFlavor df;

        public NodeProtoTransferable(Object obj, ExplorerTree tree) {
            if (obj instanceof Cell) {
                this.cell = (Cell)obj;
                this.group = this.cell.getCellGroup();
            } else if (obj instanceof Cell.CellGroup) {
                this.group = (Cell.CellGroup)obj;
            }
            this.df = new NodeProtoDataFlavor(this.cell, this.group, tree);
        }

        public boolean isValid() {
            return this.group != null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] it = new DataFlavor[]{this.df};
            return it;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == this.df;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            if (flavor != this.df) {
                return null;
            }
            if (this.cell != null) {
                return this.cell;
            }
            return this.group;
        }
    }

    public static class NodeProtoDataFlavor
    extends DataFlavor {
        private Cell cell;
        private Cell.CellGroup group;
        private ExplorerTree originalTree;

        NodeProtoDataFlavor(Cell cell, Cell.CellGroup group, ExplorerTree originalTree) {
            super(NodeProto.class, "electric/instance");
            this.cell = cell;
            this.group = group;
            this.originalTree = originalTree;
        }

        public Object getFlavorObject() {
            if (this.cell != null) {
                return this.cell;
            }
            return this.group;
        }

        public ExplorerTree getOriginalTree() {
            return this.originalTree;
        }
    }

    static class LayerColor {
        public final Layer layer;
        public final float premultipliedRed;
        public final float premultipliedGreen;
        public final float premultipliedBlue;
        public final float inverseAlpha;

        LayerColor(Layer layer, float premultipliedRed, float premultipliedGreen, float premultipliedBlue, float inverseAlpha) {
            this.layer = layer;
            this.premultipliedRed = premultipliedRed;
            this.premultipliedGreen = premultipliedGreen;
            this.premultipliedBlue = premultipliedBlue;
            this.inverseAlpha = inverseAlpha;
        }
    }

    static abstract class Drawing {
        final EditWindow wnd;

        Drawing(EditWindow wnd) {
            this.wnd = wnd;
        }

        abstract void setScreenSize(Dimension var1);

        abstract boolean paintComponent(Graphics2D var1, Dimension var2);

        abstract void render(boolean var1, Rectangle2D var2);

        void abortRendering() {
        }

        void opacityChanged() {
        }
    }

    private static class WindowChangeRequest {
        private static final int ZOOMREQUEST = 1;
        private static final int PANREQUEST = 2;
        private static final int RESIZEREQUEST = 3;
        EditWindow wnd;
        double offx;
        double offy;
        Dimension sz;
        double scale;
        int requestType;

        private WindowChangeRequest() {
        }
    }
}

