/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Inv2i {
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double pGatesY = 4.0;
    private static final double nGatesY = -4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        double totWid;
        sz = stdCell.roundSize(sz);
        String nm = "inv2i";
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        double spaceAvail = stdCell.getCellTop() - 6.0 - 9.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid = sz * 6.0, 1);
        Inv2i.error(fwP == null, "can't make " + nm + " this small: " + sz);
        spaceAvail = -9.0 - (stdCell.getCellBot() + 6.0);
        totWid = sz * 3.0;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Inv2i.error(fwN == null, "can't make " + nm + " this small: " + sz);
        Cell buf = stdCell.findPart(nm, sz);
        if (buf != null) {
            return buf;
        }
        buf = stdCell.newPart(nm, sz);
        double inNX = 3.5;
        double mosX = inNX + 2.0 + 3.0 + 2.0;
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedPmos pmos = new FoldedPmos(mosX, pmosY, fwP.nbFolds, 1, fwP.gateWid, buf, stdCell);
        double nmosY = -9.0 - fwN.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(mosX, nmosY, fwN.nbFolds, 1, fwN.gateWid, buf, stdCell);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, buf);
        stdCell.wireVddGnd(pmos, StdCellParams.EVEN, buf);
        TrackRouterH pGates = new TrackRouterH(Tech.m1, 3.0, 4.0, buf);
        for (int i = 0; i < pmos.nbGates(); ++i) {
            pGates.connect(pmos.getGate(i, 'B'));
        }
        TrackRouterH nGates = new TrackRouterH(Tech.m1, 3.0, -4.0, buf);
        for (int i = 0; i < nmos.nbGates(); ++i) {
            nGates.connect(nmos.getGate(i, 'T'));
        }
        LayoutLib.newExport(buf, "in[n]", PortCharacteristic.IN, Tech.m1, 4.0, inNX, -4.0);
        nGates.connect(buf.findExport("in[n]"));
        double lastSrcDrnX = StdCellParams.getRightDiffX(pmos, nmos);
        double inPX = lastSrcDrnX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(buf, "in[p]", PortCharacteristic.IN, Tech.m1, 4.0, inPX, 4.0);
        pGates.connect(buf.findExport("in[p]"));
        double outX = inPX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(buf, "out", PortCharacteristic.OUT, Tech.m1, 4.0, outX, 0.0);
        TrackRouterH outHi = new TrackRouterH(Tech.m2, 4.0, 11.0, buf);
        outHi.connect(buf.findExport("out"));
        for (int i = 1; i < pmos.nbSrcDrns(); i += 2) {
            outHi.connect(pmos.getSrcDrn(i));
        }
        TrackRouterH outLo = new TrackRouterH(Tech.m2, 4.0, -11.0, buf);
        outLo.connect(buf.findExport("out"));
        for (int i = 1; i < nmos.nbSrcDrns(); i += 2) {
            outLo.connect(nmos.getSrcDrn(i));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, buf);
        stdCell.addPmosWell(wellMinX, wellMaxX, buf);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, buf);
        stdCell.doNCC(buf, nm + "{sch}");
        return buf;
    }
}

