/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ncc.ExportAssertionFailures;
import com.sun.electric.tool.user.ncc.ExportAssertionTable;
import com.sun.electric.tool.user.ncc.ExportTableModel;
import com.sun.electric.tool.user.ncc.HighlightTools;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class AssertionTableModel
extends ExportTableModel {
    ExportAssertionFailures[] failures;
    int[][] cellPrefHeights;
    int[][] cellPrefWidths;
    String[] colNames;

    protected AssertionTableModel(ExportAssertionTable parent) {
        super(parent);
        this.cellPrefHeights = this.parent.cellPrefHeights;
        this.cellPrefWidths = this.parent.cellPrefWidths;
        this.colNames = new String[]{"Cell", "Exports"};
        this.failures = parent.failures;
        this.cellPrefHeights = parent.cellPrefHeights;
        this.cellPrefWidths = parent.cellPrefWidths;
        StringBuffer text = new StringBuffer(64);
        for (int col = 0; col < this.numCols; ++col) {
            for (int row = 0; row < this.height; ++row) {
                Object[][] items = null;
                if (col == 1 && ((items = this.failures[row].getExportsGlobals()) == null || items.length == 0)) continue;
                text.setLength(0);
                text.append("<html><font size=3><font face=\"Helvetica, TimesRoman\">");
                if (col == 0) {
                    CellName cellName = this.failures[row].getCell().getCellName();
                    text.append(cellName.getName() + " {" + cellName.getView().getAbbreviation() + "}");
                    int[] nArray = this.cellPrefHeights[row];
                    nArray[0] = nArray[0] + 17;
                } else {
                    this.appendLinks(text, row);
                }
                text.append("</font></html>");
                JEditorPane textPane = new JEditorPane();
                textPane.setEditable(false);
                if (col == 1) {
                    textPane.addHyperlinkListener(this);
                }
                textPane.setContentType("text/html");
                textPane.setText(text.toString());
                textPane.setMargin(this.insets);
                textPane.addMouseListener(this.mouseAdapter);
                textPane.moveCaretPosition(0);
                this.cellPrefWidths[row][col] = textPane.getPreferredSize().width + 11;
                if (this.cellPrefHeights[row][col] > 118) {
                    this.cellPrefHeights[row][col] = 118;
                }
                JPanel panel = new JPanel();
                panel.setBackground(Color.WHITE);
                panel.add(textPane);
                this.panes[row][col] = new JScrollPane(panel);
                this.panes[row][col].setBorder(BorderFactory.createEmptyBorder());
            }
        }
    }

    private void appendLinks(StringBuffer html, int row) {
        if (html == null || row < 0 || row > this.failures.length) {
            return;
        }
        String[][] names = this.failures[row].getNames();
        String href = "<a style=\"text-decoration: none\" href=\"";
        int rowNdx = row * 1000000;
        for (int i = 0; i < names.length; ++i) {
            html.append("{ ");
            int lineNdx = rowNdx + i * 1000;
            for (int j = 0; j < names[i].length; ++j) {
                int itemNdx = lineNdx + j;
                html.append(href + itemNdx + "\">" + names[i][j] + "</a>");
                if (j >= names[i].length - 1) continue;
                html.append(", ");
            }
            html.append(" }");
            if (i < names.length - 1) {
                html.append("<br>");
            }
            int[] nArray = this.cellPrefHeights[row];
            nArray[1] = nArray[1] + 17;
        }
    }

    protected void highlight(int index) {
        VarContext context;
        int item = index % 1000;
        int line = index / 1000 % 1000;
        int row = index / 1000000;
        ExportAssertionFailures eaf = this.failures[row];
        Object obj = eaf.getExportsGlobals()[line][item];
        Cell cell = eaf.getCell();
        Highlighter highlighter = HighlightTools.getHighlighter(cell, context = eaf.getContext());
        if (highlighter == null) {
            return;
        }
        if (obj instanceof Export) {
            highlighter.addText((Export)obj, cell, null, null);
        } else if (obj instanceof Network) {
            highlighter.addNetwork((Network)obj, cell);
        }
        highlighter.finished();
    }

    public String getColumnName(int col) {
        return this.colNames[col];
    }
}

