/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TechnologyTab
extends PreferencePanel {
    private JList schemPrimList;
    private DefaultListModel schemPrimModel;
    private HashMap schemPrimMap;
    private boolean changingVHDL = false;
    private JLabel defaultTechLabel;
    private JComboBox defaultTechPulldown;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel49;
    private JLabel jLabel52;
    private JLabel jLabel59;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel9;
    private JCheckBox techArtworkArrowsFilled;
    private JCheckBox techMOCMOSAlternateContactRules;
    private JRadioButton techMOCMOSDeepRules;
    private JCheckBox techMOCMOSDisallowStackedVias;
    private JComboBox techMOCMOSMetalLayers;
    private ButtonGroup techMOCMOSRules;
    private JRadioButton techMOCMOSSCMOSRules;
    private JCheckBox techMOCMOSSecondPoly;
    private JRadioButton techMOCMOSSubmicronRules;
    private JTextField techSchematicsNegatingSize;
    private JPanel technology;
    private JComboBox technologyPopup;
    private JTextField vhdlName;
    private JTextField vhdlNegatedName;
    private JScrollPane vhdlPrimPane;

    public TechnologyTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.technology;
    }

    public String getName() {
        return "Technology";
    }

    public void init() {
        int initialTechRules = MoCMOS.getRuleSet();
        if (initialTechRules == 0) {
            this.techMOCMOSSCMOSRules.setSelected(true);
        } else if (initialTechRules == 1) {
            this.techMOCMOSSubmicronRules.setSelected(true);
        } else {
            this.techMOCMOSDeepRules.setSelected(true);
        }
        this.techMOCMOSMetalLayers.addItem("2 Layers");
        this.techMOCMOSMetalLayers.addItem("3 Layers");
        this.techMOCMOSMetalLayers.addItem("4 Layers");
        this.techMOCMOSMetalLayers.addItem("5 Layers");
        this.techMOCMOSMetalLayers.addItem("6 Layers");
        this.techMOCMOSMetalLayers.setSelectedIndex(MoCMOS.getNumMetal() - 2);
        this.techMOCMOSSecondPoly.setSelected(MoCMOS.isSecondPolysilicon());
        this.techMOCMOSDisallowStackedVias.setSelected(MoCMOS.isDisallowStackedVias());
        this.techMOCMOSAlternateContactRules.setSelected(MoCMOS.isAlternateActivePolyRules());
        this.techArtworkArrowsFilled.setSelected(Artwork.isFilledArrowHeads());
        Iterator it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = (Technology)it.next();
            this.technologyPopup.addItem(tech.getTechName());
            this.defaultTechPulldown.addItem(tech.getTechName());
        }
        this.technologyPopup.setSelectedItem(User.getSchematicTechnology().getTechName());
        this.schemPrimModel = new DefaultListModel();
        this.schemPrimList = new JList(this.schemPrimModel);
        this.schemPrimList.setSelectionMode(0);
        this.vhdlPrimPane.setViewportView(this.schemPrimList);
        this.schemPrimList.clearSelection();
        this.schemPrimList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TechnologyTab.this.schemClickPrim();
            }
        });
        this.schemPrimModel.clear();
        this.schemPrimMap = new HashMap();
        it = Schematics.tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = (PrimitiveNode)it.next();
            if (np != Schematics.tech.andNode && np != Schematics.tech.orNode && np != Schematics.tech.xorNode && np != Schematics.tech.muxNode && np != Schematics.tech.bufferNode) continue;
            String str = Schematics.getVHDLNames(np);
            this.schemPrimMap.put(np, str);
            this.schemPrimModel.addElement(this.makeLine(np, str));
        }
        this.schemPrimList.setSelectedIndex(0);
        this.vhdlName.getDocument().addDocumentListener(new SchemPrimDocumentListener(this));
        this.vhdlNegatedName.getDocument().addDocumentListener(new SchemPrimDocumentListener(this));
        this.schemClickPrim();
        this.defaultTechPulldown.setSelectedItem(User.getDefaultTechnology());
        this.techSchematicsNegatingSize.setText(TextUtils.formatDouble(Schematics.getNegatingBubbleSize()));
        try {
            Class<?> extraTechClass = Class.forName("com.sun.electric.plugins.tsmc90.TSMC90Tab");
            extraTechClass.getMethod("openTechnologyTab", JPanel.class).invoke(null, this.jPanel3);
        }
        catch (Exception e) {
            System.out.println("Exceptions while importing extra technologies");
        }
    }

    private String makeLine(PrimitiveNode np, String vhdlName) {
        return np.getName() + "  (" + vhdlName + ")";
    }

    private void schemClickPrim() {
        this.changingVHDL = true;
        PrimitiveNode np = this.getSelectedPrim();
        if (np == null) {
            return;
        }
        String vhdlNames = (String)this.schemPrimMap.get(np);
        int slashPos = vhdlNames.indexOf(47);
        if (slashPos < 0) {
            this.vhdlName.setText(vhdlNames);
            this.vhdlNegatedName.setText("");
        } else {
            this.vhdlName.setText(vhdlNames.substring(0, slashPos));
            this.vhdlNegatedName.setText(vhdlNames.substring(slashPos + 1));
        }
        this.changingVHDL = false;
    }

    private PrimitiveNode getSelectedPrim() {
        String str = (String)this.schemPrimList.getSelectedValue();
        int spacePos = str.indexOf(32);
        if (spacePos >= 0) {
            str = str.substring(0, spacePos);
        }
        PrimitiveNode np = Schematics.tech.findNodeProto(str);
        return np;
    }

    private void primVHDLChanged() {
        PrimitiveNode np;
        if (this.changingVHDL) {
            return;
        }
        String str = this.vhdlName.getText();
        String strNot = this.vhdlNegatedName.getText();
        String vhdl = "";
        if (str.length() > 0 || strNot.length() > 0) {
            vhdl = str + "/" + strNot;
        }
        if ((np = this.getSelectedPrim()) == null) {
            return;
        }
        this.schemPrimMap.put(np, vhdl);
        int index = this.schemPrimList.getSelectedIndex();
        this.schemPrimModel.set(index, this.makeLine(np, vhdl));
    }

    public void term() {
        WindowFrame wf;
        double currentNegatingBubbleSize;
        String defaultTech;
        String currentTechName;
        Technology currentTech;
        boolean currentArrowsFilled;
        boolean currentAlternateContact;
        boolean currentNoStackedVias;
        boolean currentSecondPolys;
        boolean redrawPalette = false;
        boolean redrawWindows = false;
        int currentNumMetals = this.techMOCMOSMetalLayers.getSelectedIndex() + 2;
        int currentRules = 0;
        if (this.techMOCMOSSubmicronRules.isSelected()) {
            currentRules = 1;
        } else if (this.techMOCMOSDeepRules.isSelected()) {
            currentRules = 2;
        }
        switch (currentNumMetals) {
            case 2: 
            case 3: 
            case 4: {
                if (currentRules != 2) break;
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot use Deep rules if there are less than 5 layers of metal...using SubMicron rules.");
                currentRules = 1;
                break;
            }
            case 5: 
            case 6: {
                if (currentRules != 0) break;
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot use SCMOS rules if there are more than 4 layers of metal...using SubMicron rules.");
                currentRules = 1;
            }
        }
        if (currentNumMetals != MoCMOS.getNumMetal()) {
            MoCMOS.setNumMetal(currentNumMetals);
        }
        if (currentRules != MoCMOS.getRuleSet()) {
            MoCMOS.setRuleSet(currentRules);
        }
        if ((currentSecondPolys = this.techMOCMOSSecondPoly.isSelected()) != MoCMOS.isSecondPolysilicon()) {
            MoCMOS.setSecondPolysilicon(currentSecondPolys);
        }
        if ((currentNoStackedVias = this.techMOCMOSDisallowStackedVias.isSelected()) != MoCMOS.isDisallowStackedVias()) {
            MoCMOS.setDisallowStackedVias(currentNoStackedVias);
        }
        if ((currentAlternateContact = this.techMOCMOSAlternateContactRules.isSelected()) != MoCMOS.isAlternateActivePolyRules()) {
            MoCMOS.setAlternateActivePolyRules(currentAlternateContact);
        }
        if ((currentArrowsFilled = this.techArtworkArrowsFilled.isSelected()) != Artwork.isFilledArrowHeads()) {
            Artwork.setFilledArrowHeads(currentArrowsFilled);
            redrawWindows = true;
        }
        if ((currentTech = Technology.findTechnology(currentTechName = (String)this.technologyPopup.getSelectedItem())) != User.getSchematicTechnology() && currentTech != null) {
            User.setSchematicTechnology(currentTech);
        }
        if (!(defaultTech = (String)this.defaultTechPulldown.getSelectedItem()).equals(User.getDefaultTechnology())) {
            User.setDefaultTechnology(defaultTech);
        }
        if ((currentNegatingBubbleSize = TextUtils.atof(this.techSchematicsNegatingSize.getText())) != Schematics.getNegatingBubbleSize()) {
            Schematics.setNegatingBubbleSize(currentNegatingBubbleSize);
            redrawWindows = true;
        }
        for (int i = 0; i < this.schemPrimModel.size(); ++i) {
            String oldVHDLname;
            String newVHDLname;
            String primName;
            PrimitiveNode np;
            String str = (String)this.schemPrimModel.get(i);
            int spacePos = str.indexOf(32);
            if (spacePos < 0 || (np = Schematics.tech.findNodeProto(primName = str.substring(0, spacePos))) == null || (newVHDLname = str.substring(spacePos + 3, str.length() - 1)).equals(oldVHDLname = Schematics.getVHDLNames(np))) continue;
            Schematics.setVHDLNames(np, newVHDLname);
        }
        try {
            Class<?> extraTechClass = Class.forName("com.sun.electric.plugins.tsmc90.TSMC90Tab");
            extraTechClass.getMethod("closeTechnologyTab", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Exceptions while importing extra technologies: " + e.getMessage());
        }
        if (redrawPalette && (wf = WindowFrame.getCurrentWindowFrame(false)) != null) {
            wf.loadComponentMenuForTechnology();
        }
        if (redrawWindows) {
            EditWindow.repaintAllContents();
        }
    }

    private void initComponents() {
        this.techMOCMOSRules = new ButtonGroup();
        this.technology = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.defaultTechLabel = new JLabel();
        this.defaultTechPulldown = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jLabel49 = new JLabel();
        this.techMOCMOSMetalLayers = new JComboBox();
        this.techMOCMOSSCMOSRules = new JRadioButton();
        this.techMOCMOSSubmicronRules = new JRadioButton();
        this.techMOCMOSDeepRules = new JRadioButton();
        this.techMOCMOSSecondPoly = new JCheckBox();
        this.techMOCMOSDisallowStackedVias = new JCheckBox();
        this.techMOCMOSAlternateContactRules = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jPanel9 = new JPanel();
        this.techArtworkArrowsFilled = new JCheckBox();
        this.jPanel10 = new JPanel();
        this.techSchematicsNegatingSize = new JTextField();
        this.jLabel52 = new JLabel();
        this.jLabel59 = new JLabel();
        this.technologyPopup = new JComboBox();
        this.vhdlPrimPane = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.vhdlName = new JTextField();
        this.jLabel2 = new JLabel();
        this.vhdlNegatedName = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TechnologyTab.this.closeDialog(evt);
            }
        });
        this.technology.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 1));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new TitledBorder("Default Technology for Startup/IO Reading"));
        this.defaultTechLabel.setText("Technology:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.defaultTechLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.defaultTechPulldown, gridBagConstraints);
        this.jPanel3.add(this.jPanel2);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("MOSIS CMOS"));
        this.jLabel49.setText("Metal layers:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel49, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.techMOCMOSMetalLayers, gridBagConstraints);
        this.techMOCMOSRules.add(this.techMOCMOSSCMOSRules);
        this.techMOCMOSSCMOSRules.setText("SCMOS rules (4 metal or less)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel1.add((Component)this.techMOCMOSSCMOSRules, gridBagConstraints);
        this.techMOCMOSRules.add(this.techMOCMOSSubmicronRules);
        this.techMOCMOSSubmicronRules.setText("Submicron rules");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.techMOCMOSSubmicronRules, gridBagConstraints);
        this.techMOCMOSRules.add(this.techMOCMOSDeepRules);
        this.techMOCMOSDeepRules.setText("Deep rules (5 metal or more)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel1.add((Component)this.techMOCMOSDeepRules, gridBagConstraints);
        this.techMOCMOSSecondPoly.setText("Second Polysilicon Layer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.techMOCMOSSecondPoly, gridBagConstraints);
        this.techMOCMOSDisallowStackedVias.setText("Disallow stacked vias");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.techMOCMOSDisallowStackedVias, gridBagConstraints);
        this.techMOCMOSAlternateContactRules.setText("Alternate Active and Poly contact rules");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.techMOCMOSAlternateContactRules, gridBagConstraints);
        this.jPanel3.add(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.technology.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 1));
        this.jPanel9.setLayout(new GridBagLayout());
        this.jPanel9.setBorder(new TitledBorder("Artwork"));
        this.techArtworkArrowsFilled.setText("Arrows filled");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel9.add((Component)this.techArtworkArrowsFilled, gridBagConstraints);
        this.jPanel4.add(this.jPanel9);
        this.jPanel10.setLayout(new GridBagLayout());
        this.jPanel10.setBorder(new TitledBorder("Schematics"));
        this.techSchematicsNegatingSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel10.add((Component)this.techSchematicsNegatingSize, gridBagConstraints);
        this.jLabel52.setText("Negating Bubble Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel10.add((Component)this.jLabel52, gridBagConstraints);
        this.jLabel59.setText("Use scale values from this technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel10.add((Component)this.jLabel59, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel10.add((Component)this.technologyPopup, gridBagConstraints);
        this.vhdlPrimPane.setMinimumSize(new Dimension(22, 100));
        this.vhdlPrimPane.setPreferredSize(new Dimension(22, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel10.add((Component)this.vhdlPrimPane, gridBagConstraints);
        this.jLabel1.setText("VHDL for primitive:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel10.add((Component)this.jLabel1, gridBagConstraints);
        this.vhdlName.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel10.add((Component)this.vhdlName, gridBagConstraints);
        this.jLabel2.setText("VHDL for negated primitive:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel10.add((Component)this.jLabel2, gridBagConstraints);
        this.vhdlNegatedName.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel10.add((Component)this.vhdlNegatedName, gridBagConstraints);
        this.jPanel4.add(this.jPanel10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.technology.add((Component)this.jPanel4, gridBagConstraints);
        this.getContentPane().add((Component)this.technology, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class SchemPrimDocumentListener
    implements DocumentListener {
        TechnologyTab dialog;

        SchemPrimDocumentListener(TechnologyTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.primVHDLChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.primVHDLChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.primVHDLChanged();
        }
    }
}

