/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.Main;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public class MessagesWindow
extends OutputStream
implements ActionListener,
MouseListener,
KeyListener,
Runnable,
ClipboardOwner {
    private ArrayList history;
    private JTextField entry;
    private JTextArea info;
    private Container contentFrame;
    private int histidx = 0;
    private Thread ticker = null;
    private StringBuffer buffer = new StringBuffer();
    private Container jf;
    private PrintWriter printWriter = null;
    private static boolean newCommand = true;
    private static int commandNumber = 1;

    public MessagesWindow() {
        Dimension scrnSize = TopLevel.getScreenSize();
        Dimension msgSize = new Dimension(scrnSize.width / 3 * 2, scrnSize.height / 100 * 15);
        if (TopLevel.isMDIMode()) {
            JInternalFrame jInternalFrame = new JInternalFrame("Electric Messages", true, false, true, true);
            this.jf = jInternalFrame;
            this.contentFrame = jInternalFrame.getContentPane();
            jInternalFrame.setFrameIcon(TopLevel.getFrameIcon());
        } else {
            JFrame jFrame = new JFrame("Electric Messages");
            this.jf = jFrame;
            jFrame.setDefaultCloseOperation(0);
            this.contentFrame = jFrame.getContentPane();
            jFrame.setIconImage(TopLevel.getFrameIcon().getImage());
        }
        this.contentFrame.setLayout(new BorderLayout());
        this.history = new ArrayList();
        this.entry = new JTextField();
        this.entry.addActionListener(this);
        this.entry.addKeyListener(this);
        this.contentFrame.add((Component)this.entry, "South");
        this.info = new JTextArea(20, 110);
        this.info.setLineWrap(false);
        this.info.setFont(new Font("Monospaced", 0, 12));
        this.info.addMouseListener(this);
        JScrollPane scrollPane = new JScrollPane(this.info, 22, 30);
        scrollPane.setPreferredSize(msgSize);
        JScrollBar vertscroll = scrollPane.getVerticalScrollBar();
        this.contentFrame.add((Component)scrollPane, "Center");
        this.jf.setLocation(150, scrnSize.height / 100 * 80);
        if (TopLevel.isMDIMode()) {
            ((JInternalFrame)this.jf).pack();
            TopLevel.addToDesktop((JInternalFrame)this.jf);
        } else {
            ((JFrame)this.jf).pack();
            if (!Main.BATCHMODE) {
                ((JFrame)this.jf).setVisible(true);
            }
        }
        System.setOut(new PrintStream(this));
    }

    public Rectangle getMessagesLocation() {
        return this.jf.getBounds();
    }

    public void flush() {
    }

    public void close() {
    }

    public void clear() {
        this.info.setText("");
    }

    public static void userCommandIssued() {
        newCommand = true;
    }

    public void save() {
        this.save(OpenFile.chooseOutputFile(FileType.TEXT, null, "emessages.txt"));
    }

    public void save(String filePath) {
        if (filePath == null) {
            return;
        }
        try {
            this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
        }
        catch (IOException e) {
            System.out.println("Error creating " + filePath);
            return;
        }
        System.out.println("Messages will be saved to " + filePath);
    }

    public void write(byte[] b) {
        this.appendString(new String(b));
    }

    public void write(int b) {
        this.appendString(String.valueOf((char)b));
    }

    public void write(byte[] b, int off, int len) {
        this.appendString(new String(b, off, len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendString(String str) {
        if (str.equals("")) {
            return;
        }
        if (newCommand) {
            newCommand = false;
            str = "=================================" + commandNumber++ + "=================================\n" + str;
        }
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            if (this.printWriter != null) {
                this.printWriter.print(str);
                this.printWriter.flush();
            }
            this.buffer.append(str);
            if (this.ticker == null) {
                this.ticker = new Thread(this);
                this.ticker.start();
            }
        }
    }

    public void run() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.ticker = null;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                StringBuffer stringBuffer = MessagesWindow.this.buffer;
                synchronized (stringBuffer) {
                    MessagesWindow.this.dump(MessagesWindow.this.buffer.toString());
                    MessagesWindow.this.buffer.setLength(0);
                }
            }
        });
    }

    protected void dump(String str) {
        this.info.append(str);
        if (Main.BATCHMODE) {
            return;
        }
        try {
            Rectangle r = this.info.modelToView(this.info.getDocument().getLength());
            this.info.scrollRectToVisible(r);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void keyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        if (code == 38) {
            if (this.histidx > 0) {
                --this.histidx;
            }
            if (this.histidx < this.history.size()) {
                this.entry.setText((String)this.history.get(this.histidx));
            }
        } else if (code == 40 && this.histidx < this.history.size()) {
            ++this.histidx;
            if (this.histidx < this.history.size()) {
                this.entry.setText((String)this.history.get(this.histidx));
            } else {
                this.entry.setText("");
            }
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doContext(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doContext(e);
        }
    }

    public void lostOwnership(Clipboard parClipboard, Transferable parTransferable) {
    }

    private void doContext(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu("Messages Window");
        JMenuItem menuItem = new JMenuItem("Cut");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagesWindow.this.copyText(false, true);
            }
        });
        menuItem = new JMenuItem("Copy");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagesWindow.this.copyText(false, false);
            }
        });
        menuItem = new JMenuItem("Paste");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagesWindow.this.pasteText();
            }
        });
        menu.addSeparator();
        menuItem = new JMenuItem("Cut All");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagesWindow.this.copyText(true, true);
            }
        });
        menuItem = new JMenuItem("Copy All");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagesWindow.this.copyText(true, false);
            }
        });
        menuItem = new JMenuItem("Clear");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagesWindow.this.clear();
            }
        });
        menu.show((Component)e.getSource(), e.getX(), e.getY());
    }

    private void pasteText() {
        this.info.paste();
    }

    private void copyText(boolean all, boolean cut) {
        if (all) {
            if (cut) {
                this.info.selectAll();
                this.info.cut();
            } else {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(this.info.getText()), this);
            }
        } else if (cut) {
            this.info.cut();
        } else {
            this.info.copy();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        String msg = this.entry.getText();
        this.history.add(msg);
        this.histidx = this.history.size();
        this.entry.setText("");
        this.info.append("=================== " + msg + " =================\n");
        StringTokenizer st = new StringTokenizer(msg);
        String[] cmds = new String[st.countTokens()];
        if (cmds.length == 0) {
            return;
        }
        for (int i = 0; i < cmds.length; ++i) {
            cmds[i] = st.nextToken();
        }
        if (cmds[0].equals("mem")) {
            Runtime rt = Runtime.getRuntime();
            System.out.println("Total memory: " + rt.totalMemory());
            System.out.println("Free memory: " + rt.freeMemory());
        }
    }

    public void selectFont() {
        if (TopLevel.isMDIMode()) {
            TopLevel jf = TopLevel.getCurrentJFrame();
            new FontSelectDialog(jf);
        } else {
            new FontSelectDialog(null);
        }
    }

    private class FontSelectDialog
    extends EDialog {
        private Font initialFont;
        private String initialFontName;
        private int initialFontSize;
        private JLabel sampleText;
        private JList fontNameList;
        private JList fontSizeList;

        public FontSelectDialog(Frame parent) {
            super(parent, true);
            this.setTitle("Set Messages Window Font");
            this.getContentPane().setLayout(new GridBagLayout());
            this.initialFont = MessagesWindow.this.info.getFont();
            this.initialFontName = this.initialFont.getName();
            this.initialFontSize = this.initialFont.getSize();
            JLabel fontLabel = new JLabel("Font:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)fontLabel, gbc);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] fontNames = ge.getAvailableFontFamilyNames();
            JScrollPane fontNamePane = new JScrollPane();
            DefaultListModel<String> fontNameListModel = new DefaultListModel<String>();
            this.fontNameList = new JList(fontNameListModel);
            this.fontNameList.setSelectionMode(0);
            fontNamePane.setViewportView(this.fontNameList);
            int initialIndex = 0;
            for (int i = 0; i < fontNames.length; ++i) {
                if (fontNames[i].equals(this.initialFontName)) {
                    initialIndex = i;
                }
                fontNameListModel.addElement(fontNames[i]);
            }
            this.fontNameList.setSelectedIndex(initialIndex);
            this.fontNameList.ensureIndexIsVisible(initialIndex);
            this.fontNameList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    FontSelectDialog.this.updateSampleText();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)fontNamePane, gbc);
            JLabel sizeLabel = new JLabel("Size:");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)sizeLabel, gbc);
            JScrollPane fontSizePane = new JScrollPane();
            DefaultListModel<String> fontSizeListModel = new DefaultListModel<String>();
            this.fontSizeList = new JList(fontSizeListModel);
            this.fontSizeList.setSelectionMode(0);
            fontSizePane.setViewportView(this.fontSizeList);
            fontSizeListModel.addElement("8");
            fontSizeListModel.addElement("9");
            fontSizeListModel.addElement("10");
            fontSizeListModel.addElement("11");
            fontSizeListModel.addElement("12");
            fontSizeListModel.addElement("14");
            fontSizeListModel.addElement("16");
            fontSizeListModel.addElement("18");
            fontSizeListModel.addElement("20");
            fontSizeListModel.addElement("22");
            fontSizeListModel.addElement("24");
            fontSizeListModel.addElement("28");
            fontSizeListModel.addElement("32");
            fontSizeListModel.addElement("36");
            fontSizeListModel.addElement("40");
            fontSizeListModel.addElement("48");
            fontSizeListModel.addElement("72");
            this.fontSizeList.setSelectedValue(Integer.toString(this.initialFontSize), true);
            this.fontSizeList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    FontSelectDialog.this.updateSampleText();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)fontSizePane, gbc);
            this.sampleText = new JLabel("The Electric VLSI Design System");
            this.sampleText.setBorder(BorderFactory.createTitledBorder("Sample text"));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.sampleText, gbc);
            this.sampleText.setFont(this.initialFont);
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    FontSelectDialog.this.OK();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)okButton, gbc);
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    FontSelectDialog.this.cancel();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancelButton, gbc);
            this.pack();
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    FontSelectDialog.this.cancel();
                }
            });
            this.setVisible(true);
        }

        private void cancel() {
            this.dispose();
        }

        private void updateSampleText() {
            String currentFontName = this.initialFontName;
            if (this.fontNameList.getSelectedIndex() != -1) {
                currentFontName = (String)this.fontNameList.getSelectedValue();
            }
            int currentFontSize = this.initialFontSize;
            if (this.fontSizeList.getSelectedIndex() != -1) {
                currentFontSize = TextUtils.atoi((String)this.fontSizeList.getSelectedValue());
            }
            Font font = new Font(currentFontName, 0, currentFontSize);
            this.sampleText.setFont(font);
        }

        private void OK() {
            String currentFontName = this.initialFontName;
            if (this.fontNameList.getSelectedIndex() != -1) {
                currentFontName = (String)this.fontNameList.getSelectedValue();
            }
            int currentFontSize = this.initialFontSize;
            if (this.fontSizeList.getSelectedIndex() != -1) {
                currentFontSize = TextUtils.atoi((String)this.fontSizeList.getSelectedValue());
            }
            if (!currentFontName.equals(this.initialFontName) || currentFontSize != this.initialFontSize) {
                this.initialFont = new Font(currentFontName, 0, currentFontSize);
                MessagesWindow.this.info.setFont(this.initialFont);
                System.out.println("Messages window font is now " + currentFontName + ", size " + currentFontSize);
            }
            this.cancel();
        }
    }
}

