/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.variable.ImmutableTextDescriptor;

public class ImmutableNodeInst {
    public static final int NEXPAND = 4;
    public static final int WIPED = 8;
    public static final int HARDSELECTN = 32768;
    public static final int NVISIBLEINSIDE = 0x800000;
    public static final int NTECHBITS = 0x7E0000;
    public static final int NTECHBITSSH = 17;
    public static final int NILOCKED = 0x1000000;
    public static final int NODE_BITS = 33456140;
    public final int protoId;
    public final Name name;
    public final int duplicate;
    public final ImmutableTextDescriptor nameDescriptor;
    public final Orientation orient;
    public final EPoint anchor;
    public final double width;
    public final double height;
    public final int userBits;
    public final ImmutableTextDescriptor protoDescriptor;
    static final /* synthetic */ boolean $assertionsDisabled;

    ImmutableNodeInst(int protoId, Name name, int duplicate, ImmutableTextDescriptor nameDescriptor, Orientation orient, EPoint anchor, double width, double height, int userBits, ImmutableTextDescriptor protoDescriptor) {
        this.protoId = protoId;
        this.name = name;
        this.duplicate = duplicate;
        this.nameDescriptor = nameDescriptor;
        this.orient = orient;
        this.anchor = anchor;
        this.width = width;
        this.height = height;
        this.userBits = userBits;
        this.protoDescriptor = protoDescriptor;
        this.check();
    }

    public static ImmutableNodeInst newInstance(int protoId, Name name, EPoint anchor) {
        return ImmutableNodeInst.newInstance(protoId, name, 0, null, Orientation.IDENT, anchor, 0.0, 0.0, 0, null);
    }

    public static ImmutableNodeInst newInstance(int protoId, Name name, int duplicate, ImmutableTextDescriptor nameDescriptor, Orientation orient, EPoint anchor, double width, double height, int userBits, ImmutableTextDescriptor protoDescriptor) {
        if (protoId < 0) {
            throw new ArrayIndexOutOfBoundsException(protoId);
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (duplicate < 0) {
            throw new IllegalArgumentException("duplicate");
        }
        if (orient == null) {
            throw new NullPointerException("orient");
        }
        if (anchor == null) {
            throw new NullPointerException("anchor");
        }
        if (!(width >= 0.0)) {
            throw new IllegalArgumentException("width");
        }
        if (!(height >= 0.0)) {
            throw new IllegalArgumentException("height");
        }
        width = DBMath.round(width);
        height = DBMath.round(height);
        if (width == -0.0) {
            width = 0.0;
        }
        if (height == -0.0) {
            height = 0.0;
        }
        return new ImmutableNodeInst(protoId, name, duplicate, nameDescriptor, orient, anchor, width, height, userBits &= 0x1FE800C, protoDescriptor);
    }

    public ImmutableNodeInst withProto(int protoId) {
        if (this.protoId == protoId) {
            return this;
        }
        if (protoId < 0) {
            throw new ArrayIndexOutOfBoundsException(protoId);
        }
        return new ImmutableNodeInst(protoId, this.name, this.duplicate, this.nameDescriptor, this.orient, this.anchor, this.width, this.height, this.userBits, this.protoDescriptor);
    }

    public ImmutableNodeInst withName(Name name, int duplicate) {
        if (this.name == name && this.duplicate == duplicate) {
            return this;
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (duplicate < 0) {
            throw new IllegalArgumentException("duplicate");
        }
        return new ImmutableNodeInst(this.protoId, name, duplicate, this.nameDescriptor, this.orient, this.anchor, this.width, this.height, this.userBits, this.protoDescriptor);
    }

    public ImmutableNodeInst withNameDescriptor(ImmutableTextDescriptor nameDescriptor) {
        if (this.nameDescriptor == nameDescriptor) {
            return this;
        }
        return new ImmutableNodeInst(this.protoId, this.name, this.duplicate, nameDescriptor, this.orient, this.anchor, this.width, this.height, this.userBits, this.protoDescriptor);
    }

    public ImmutableNodeInst withOrient(Orientation orient) {
        if (this.orient == orient) {
            return this;
        }
        if (orient == null) {
            throw new NullPointerException("orient");
        }
        return new ImmutableNodeInst(this.protoId, this.name, this.duplicate, this.nameDescriptor, orient, this.anchor, this.width, this.height, this.userBits, this.protoDescriptor);
    }

    public ImmutableNodeInst withAnchor(EPoint anchor) {
        if (this.anchor == anchor) {
            return this;
        }
        if (anchor == null) {
            throw new NullPointerException("anchor");
        }
        return new ImmutableNodeInst(this.protoId, this.name, this.duplicate, this.nameDescriptor, this.orient, anchor, this.width, this.height, this.userBits, this.protoDescriptor);
    }

    public ImmutableNodeInst withSize(double width, double height) {
        if (this.width == width && this.height == height) {
            return this;
        }
        width = DBMath.round(width);
        height = DBMath.round(height);
        if (this.width == width && this.height == height) {
            return this;
        }
        if (width == -0.0) {
            width = 0.0;
        }
        if (height == -0.0) {
            height = 0.0;
        }
        return new ImmutableNodeInst(this.protoId, this.name, this.duplicate, this.nameDescriptor, this.orient, this.anchor, width, height, this.userBits, this.protoDescriptor);
    }

    public ImmutableNodeInst withUserBits(int userBits) {
        if (this.userBits == (userBits &= 0x1FE800C)) {
            return this;
        }
        return new ImmutableNodeInst(this.protoId, this.name, this.duplicate, this.nameDescriptor, this.orient, this.anchor, this.width, this.height, userBits, this.protoDescriptor);
    }

    public ImmutableNodeInst withProtoDescriptor(ImmutableTextDescriptor protoDescriptor) {
        if (this.protoDescriptor == protoDescriptor) {
            return this;
        }
        return new ImmutableNodeInst(this.protoId, this.name, this.duplicate, this.nameDescriptor, this.orient, this.anchor, this.width, this.height, this.userBits, protoDescriptor);
    }

    public void check() {
        if (!$assertionsDisabled && this.protoId < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.anchor == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.duplicate < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.orient == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.anchor == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.width > 0.0 || this.width == 0.0 && 1.0 / this.width > 0.0)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.height > 0.0 || this.height == 0.0 && 1.0 / this.height > 0.0)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && DBMath.round(this.width) != this.width) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && DBMath.round(this.height) != this.height) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (this.userBits & 0xFE017FF3) != 0) {
            throw new AssertionError();
        }
    }

    void checkProto(ImmutableCell[] cells) {
        if (cells[this.protoId] == null) {
            throw new ArrayIndexOutOfBoundsException(this.protoId);
        }
    }

    public static int parseJelibUserBits(String jelibUserBits) {
        int userBits = 0;
        block8: for (int i = 0; i < jelibUserBits.length(); ++i) {
            char chr = jelibUserBits.charAt(i);
            switch (chr) {
                case 'E': {
                    userBits |= 4;
                    continue block8;
                }
                case 'L': {
                    userBits |= 0x1000000;
                    continue block8;
                }
                case 'S': {
                    continue block8;
                }
                case 'V': {
                    userBits |= 0x800000;
                    continue block8;
                }
                case 'W': {
                    userBits |= 8;
                    continue block8;
                }
                case 'A': {
                    userBits |= 0x8000;
                    continue block8;
                }
                default: {
                    if (!Character.isDigit(chr)) continue block8;
                    jelibUserBits = jelibUserBits.substring(i);
                    int techBits = Integer.parseInt(jelibUserBits);
                    return userBits | techBits << 17 & 0x7E0000;
                }
            }
        }
        return userBits;
    }

    static {
        $assertionsDisabled = !ImmutableNodeInst.class.desiredAssertionStatus();
    }
}

