/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.output.Output;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;

public class JELIB
extends Output {
    private static final boolean NEWREVISION = Version.getVersion().compareTo(Version.parseVersion("8.01aw")) >= 0;
    private HashMap abbreviationMap;
    private HashSet externalObjs;
    private static Comparator nodesComparator = new TextUtils.NodesByName();
    private static Comparator arcsComparator = new TextUtils.ArcsByName();
    private static Comparator exportsComparator = new TextUtils.ExportsByName();

    JELIB() {
    }

    protected boolean writeLib(Library lib) {
        try {
            return this.writeTheLibrary(lib);
        }
        catch (IOException e) {
            System.out.println("End of file reached while writing " + this.filePath);
            return true;
        }
    }

    private boolean writeTheLibrary(Library lib) throws IOException {
        Technology tech;
        Tool tool;
        Cell cell;
        Iterator cIt;
        Library eLib;
        View view;
        this.printWriter.print("# header information:\n");
        this.abbreviationMap = new HashMap();
        this.externalObjs = new HashSet();
        this.traverseAndGatherNames(lib);
        this.printWriter.print("H" + this.convertString(lib.getName()) + "|" + Version.getVersion());
        this.writeVars(lib, null);
        this.printWriter.print("\n");
        TreeSet<View> views = new TreeSet<View>();
        Iterator it = View.getViews();
        while (it.hasNext()) {
            view = (View)it.next();
            if (!this.externalObjs.contains(view)) continue;
            views.add(view);
        }
        if (views.size() > 0) {
            this.printWriter.print("\n# Views:\n");
            it = views.iterator();
            while (it.hasNext()) {
                view = (View)it.next();
                this.printWriter.print("V" + this.convertString(view.getFullName()) + "|" + this.convertString(view.getAbbreviation()) + "\n");
            }
        }
        TreeMap<String, Library> externalLibs = new TreeMap<String, Library>();
        Iterator it2 = Library.getLibraries();
        while (it2.hasNext()) {
            eLib = (Library)it2.next();
            if (eLib == lib || !this.externalObjs.contains(eLib)) continue;
            externalLibs.put(eLib.getName(), eLib);
        }
        if (externalLibs.size() > 0) {
            this.printWriter.print("\n# External Libraries and cells:\n");
            it2 = externalLibs.values().iterator();
            while (it2.hasNext()) {
                eLib = (Library)it2.next();
                String libFile = eLib.getLibFile().toString();
                if (NEWREVISION) {
                    this.printWriter.println();
                }
                this.printWriter.print("L" + this.convertString(eLib.getName()) + "|" + this.convertString(libFile) + "\n");
                TreeMap<CellName, Cell> externalCells = new TreeMap<CellName, Cell>();
                cIt = eLib.getCells();
                while (cIt.hasNext()) {
                    cell = (Cell)cIt.next();
                    if (!this.externalObjs.contains(cell)) continue;
                    externalCells.put(cell.getCellName(), cell);
                }
                cIt = externalCells.values().iterator();
                while (cIt.hasNext()) {
                    Export export;
                    cell = (Cell)cIt.next();
                    Rectangle2D bounds = cell.getBounds();
                    if (NEWREVISION) {
                        this.printWriter.print("R" + this.convertString(cell.getCellName().toString()) + "|" + TextUtils.formatDouble(DBMath.round(bounds.getMinX()), 0) + "|" + TextUtils.formatDouble(DBMath.round(bounds.getMaxX()), 0) + "|" + TextUtils.formatDouble(DBMath.round(bounds.getMinY()), 0) + "|" + TextUtils.formatDouble(DBMath.round(bounds.getMaxY()), 0) + "|" + cell.getCreationDate().getTime() + "|" + cell.getRevisionDate().getTime() + "\n");
                    } else {
                        this.printWriter.print("R" + this.convertString(cell.getName()) + ";" + cell.getVersion() + "{" + this.convertString(cell.getView().getAbbreviation()) + "}" + "|" + TextUtils.formatDouble(bounds.getMinX(), 0) + "|" + TextUtils.formatDouble(bounds.getMaxX(), 0) + "|" + TextUtils.formatDouble(bounds.getMinY(), 0) + "|" + TextUtils.formatDouble(bounds.getMaxY(), 0) + "\n");
                    }
                    ArrayList<Export> sortedExports = new ArrayList<Export>();
                    Iterator eIt = cell.getPorts();
                    while (eIt.hasNext()) {
                        export = (Export)eIt.next();
                        if (!this.externalObjs.contains(export)) continue;
                        sortedExports.add(export);
                    }
                    Collections.sort(sortedExports, exportsComparator);
                    eIt = sortedExports.iterator();
                    while (eIt.hasNext()) {
                        export = (Export)eIt.next();
                        if (NEWREVISION) {
                            Poly poly = export.getOriginalPort().getPoly();
                            this.printWriter.println("F" + this.convertString(export.getName()) + "|" + TextUtils.formatDouble(DBMath.round(poly.getCenterX()), 0) + "|" + TextUtils.formatDouble(DBMath.round(poly.getCenterY()), 0));
                            continue;
                        }
                        this.printWriter.print("#" + this.convertString(export.getName()));
                        this.printWriter.print("|" + this.describeDescriptor(null, export.getTextDescriptor()));
                        PortOriginal po = new PortOriginal(export.getOriginalPort());
                        PrimitivePort pp = po.getBottomPortProto();
                        PrimitiveNode pn = (PrimitiveNode)pp.getParent();
                        this.printWriter.print("|" + pn.getFullName() + "|");
                        if (pn.getNumPorts() > 1) {
                            this.printWriter.print(pp.getName());
                        }
                        Poly poly = export.getOriginalPort().getPoly();
                        this.printWriter.print("|" + TextUtils.formatDouble(poly.getCenterX(), 0) + "|" + TextUtils.formatDouble(poly.getCenterY(), 0));
                        int angle = po.getAngleToTop();
                        this.printWriter.print(angle != 0 ? "|" + angle : "|");
                        this.printWriter.print("|" + export.getCharacteristic().getShortName());
                        if (export.isAlwaysDrawn()) {
                            this.printWriter.print("/A");
                        }
                        if (export.isBodyOnly()) {
                            this.printWriter.print("/B");
                        }
                        this.printWriter.print("\n");
                    }
                }
            }
        }
        TreeMap<String, Tool> tools = new TreeMap<String, Tool>();
        Iterator it3 = Tool.getTools();
        while (it3.hasNext()) {
            tool = (Tool)it3.next();
            if (Pref.getMeaningVariables(tool).size() == 0) continue;
            tools.put(tool.getName(), tool);
        }
        if (tools.size() > 0) {
            this.printWriter.print("\n# Tools:\n");
            it3 = tools.values().iterator();
            while (it3.hasNext()) {
                tool = (Tool)it3.next();
                this.printWriter.print("O" + this.convertString(tool.getName()));
                this.writeMeaningPrefs(tool);
                this.printWriter.print("\n");
            }
        }
        TreeMap<String, Technology> technologies = new TreeMap<String, Technology>();
        Iterator it4 = Technology.getTechnologies();
        while (it4.hasNext()) {
            tech = (Technology)it4.next();
            if (!this.externalObjs.contains(tech) && Pref.getMeaningVariables(tech).size() == 0) continue;
            technologies.put(tech.getTechName(), tech);
        }
        it4 = technologies.values().iterator();
        while (it4.hasNext()) {
            ArcProto ap;
            PrimitiveNode pn;
            tech = (Technology)it4.next();
            this.printWriter.print("\n# Technology " + tech.getTechName() + "\n");
            this.printWriter.print("T" + this.convertString(tech.getTechName()));
            this.writeMeaningPrefs(tech);
            this.printWriter.print("\n");
            TreeMap<String, PrimitiveNode> primNodes = new TreeMap<String, PrimitiveNode>();
            Iterator nIt = tech.getNodes();
            while (nIt.hasNext()) {
                pn = (PrimitiveNode)nIt.next();
                if (!this.externalObjs.contains(pn)) continue;
                primNodes.put(pn.getName(), pn);
            }
            nIt = primNodes.values().iterator();
            while (nIt.hasNext()) {
                PrimitivePort pp;
                pn = (PrimitiveNode)nIt.next();
                this.printWriter.print("D" + this.convertString(pn.getName()));
                this.printWriter.print("\n");
                TreeMap<String, PrimitivePort> primPorts = new TreeMap<String, PrimitivePort>();
                Iterator pIt = pn.getPorts();
                while (pIt.hasNext()) {
                    pp = (PrimitivePort)pIt.next();
                    if (!this.externalObjs.contains(pp)) continue;
                    primPorts.put(pp.getName(), pp);
                }
                pIt = primPorts.values().iterator();
                while (pIt.hasNext()) {
                    pp = (PrimitivePort)pIt.next();
                    this.printWriter.print("P" + this.convertString(pp.getName()));
                    this.printWriter.print("\n");
                }
            }
            TreeMap<String, ArcProto> arcProtos = new TreeMap<String, ArcProto>();
            Iterator aIt = tech.getArcs();
            while (aIt.hasNext()) {
                ap = (ArcProto)aIt.next();
                if (!this.externalObjs.contains(ap)) continue;
                arcProtos.put(ap.getName(), ap);
            }
            aIt = arcProtos.values().iterator();
            while (aIt.hasNext()) {
                ap = (ArcProto)aIt.next();
                this.printWriter.print("W" + this.convertString(ap.getName()));
                this.printWriter.print("\n");
            }
        }
        TreeMap<CellName, Cell> cells = new TreeMap<CellName, Cell>();
        Iterator cIt2 = lib.getCells();
        while (cIt2.hasNext()) {
            Cell cell2 = (Cell)cIt2.next();
            cells.put(cell2.getCellName(), cell2);
        }
        ArrayList<Cell.CellGroup> groups = new ArrayList<Cell.CellGroup>();
        cIt = cells.values().iterator();
        while (cIt.hasNext()) {
            NodeInst ni;
            cell = (Cell)cIt.next();
            if (!groups.contains(cell.getCellGroup())) {
                groups.add(cell.getCellGroup());
            }
            this.printWriter.print("\n# Cell " + cell.describe() + "\n");
            if (NEWREVISION) {
                this.printWriter.print("C" + this.convertString(cell.getCellName().toString()));
            } else {
                this.printWriter.print("C" + this.convertString(cell.getName()));
                this.printWriter.print("|" + this.convertString(cell.getView().getAbbreviation()));
                this.printWriter.print("|" + cell.getVersion());
            }
            this.printWriter.print("|" + this.convertString(cell.getTechnology().getTechName()));
            this.printWriter.print("|" + cell.getCreationDate().getTime());
            this.printWriter.print("|" + cell.getRevisionDate().getTime());
            StringBuffer cellBits = new StringBuffer();
            if (cell.isInCellLibrary()) {
                cellBits.append("C");
            }
            if (cell.isWantExpanded()) {
                cellBits.append("E");
            }
            if (cell.isInstancesLocked()) {
                cellBits.append("I");
            }
            if (cell.isAllLocked()) {
                cellBits.append("L");
            }
            if (cell.isInTechnologyLibrary()) {
                cellBits.append("T");
            }
            this.printWriter.print("|" + cellBits.toString());
            this.writeVars(cell, cell);
            this.printWriter.print("\n");
            ArrayList sortedNodes = new ArrayList();
            Iterator it5 = cell.getNodes();
            while (it5.hasNext()) {
                sortedNodes.add(it5.next());
            }
            Collections.sort(sortedNodes, nodesComparator);
            HashMap<NodeInst, Integer> sortedNodeIndices = null;
            for (int i = 1; i < sortedNodes.size(); ++i) {
                ni = (NodeInst)sortedNodes.get(i);
                NodeInst lastNi = (NodeInst)sortedNodes.get(i - 1);
                if (!ni.getName().equals(lastNi.getName())) continue;
                sortedNodeIndices = new HashMap<NodeInst, Integer>();
                for (int j = 0; j < sortedNodes.size(); ++j) {
                    ni = (NodeInst)sortedNodes.get(j);
                    int start = j;
                    for (int k = j + 1; k < sortedNodes.size(); ++k) {
                        NodeInst otherNi = (NodeInst)sortedNodes.get(k);
                        if (!ni.getName().equals(otherNi.getName())) continue;
                        if (k == start + 1) {
                            sortedNodeIndices.put(ni, new Integer(1));
                        }
                        sortedNodeIndices.put(otherNi, new Integer(k - start + 1));
                        ++j;
                    }
                }
                break;
            }
            Iterator it6 = sortedNodes.iterator();
            while (it6.hasNext()) {
                String tdString;
                int ts;
                ni = (NodeInst)it6.next();
                NodeProto np = ni.getProto();
                if (NEWREVISION) {
                    if (np instanceof Cell) {
                        this.printWriter.print("I" + (String)this.abbreviationMap.get(np));
                    } else {
                        PrimitiveNode prim = (PrimitiveNode)np;
                        if (cell.getTechnology() == prim.getTechnology()) {
                            this.printWriter.print("N" + this.convertString(prim.getName()));
                        } else {
                            this.printWriter.print("N" + this.convertString(prim.getFullName()));
                        }
                    }
                } else {
                    if (np instanceof Cell) {
                        this.printWriter.print("I");
                    } else {
                        this.printWriter.print("N");
                    }
                    String nodeTypeName = (String)this.abbreviationMap.get(np);
                    this.printWriter.print(nodeTypeName);
                }
                this.printWriter.print("|" + this.getNodeName(ni, sortedNodeIndices) + "|");
                if (!ni.getNameKey().isTempname()) {
                    this.printWriter.print(this.describeDescriptor(null, ni.getNameTextDescriptor()));
                }
                this.printWriter.print("|" + TextUtils.formatDouble(ni.getAnchorCenterX(), 0));
                this.printWriter.print("|" + TextUtils.formatDouble(ni.getAnchorCenterY(), 0));
                if (NEWREVISION) {
                    int angle;
                    if (np instanceof PrimitiveNode) {
                        this.printWriter.print("|" + TextUtils.formatDouble(ni.getXSize(), 0));
                        this.printWriter.print("|" + TextUtils.formatDouble(ni.getYSize(), 0));
                    }
                    this.printWriter.print('|');
                    if (ni.isXMirrored()) {
                        this.printWriter.print('X');
                    }
                    if (ni.isYMirrored()) {
                        this.printWriter.print('Y');
                    }
                    if ((angle = ni.getAngle() % 3600) == 900 || angle == -2700) {
                        this.printWriter.print("R");
                    } else if (angle == 1800 || angle == -1800) {
                        this.printWriter.print("RR");
                    } else if (angle == 2700 || angle == -900) {
                        this.printWriter.print("RRR");
                    } else if (angle != 0) {
                        this.printWriter.print(angle);
                    }
                } else {
                    this.printWriter.print("|" + TextUtils.formatDouble(ni.getXSizeWithMirror(), 0));
                    this.printWriter.print("|" + TextUtils.formatDouble(ni.getYSizeWithMirror(), 0));
                    this.printWriter.print("|" + ni.getAngle());
                }
                StringBuffer nodeBits = new StringBuffer();
                if (ni.isHardSelect()) {
                    nodeBits.append("A");
                }
                if (ni.isExpanded()) {
                    nodeBits.append("E");
                }
                if (ni.isLocked()) {
                    nodeBits.append("L");
                }
                if (ni.isShortened()) {
                    nodeBits.append("S");
                }
                if (ni.isVisInside()) {
                    nodeBits.append("V");
                }
                if (ni.isWiped()) {
                    nodeBits.append("W");
                }
                if ((ts = ni.getTechSpecific()) != 0) {
                    nodeBits.append(ts);
                }
                if (NEWREVISION) {
                    this.printWriter.print("|" + nodeBits.toString());
                    if (np instanceof Cell) {
                        tdString = this.describeDescriptor(null, ni.getProtoTextDescriptor());
                        this.printWriter.print("|" + tdString);
                    }
                } else {
                    this.printWriter.print("|" + nodeBits.toString() + "|");
                    if (np instanceof Cell) {
                        tdString = this.describeDescriptor(null, ni.getProtoTextDescriptor());
                        this.printWriter.print(tdString);
                    }
                }
                this.writeVars(ni, cell);
                this.printWriter.print("\n");
            }
            ArrayList sortedArcs = new ArrayList();
            Iterator it7 = cell.getArcs();
            while (it7.hasNext()) {
                sortedArcs.add(it7.next());
            }
            Collections.sort(sortedArcs, arcsComparator);
            it7 = sortedArcs.iterator();
            while (it7.hasNext()) {
                ArcInst ai = (ArcInst)it7.next();
                PrimitiveArc ap = (PrimitiveArc)ai.getProto();
                if (NEWREVISION) {
                    if (cell.getTechnology() == ap.getTechnology()) {
                        this.printWriter.print("A" + this.convertString(ap.getName()));
                    } else {
                        this.printWriter.print("A" + this.convertString(ap.getFullName()));
                    }
                } else {
                    this.printWriter.print("A" + this.convertString(ap.getTechnology().getTechName()) + ":" + this.convertString(ap.getName()));
                }
                this.printWriter.print("|" + this.convertString(ai.getName()) + "|");
                if (!ai.getNameKey().isTempname()) {
                    this.printWriter.print(this.describeDescriptor(null, ai.getNameTextDescriptor()));
                }
                this.printWriter.print("|" + TextUtils.formatDouble(ai.getWidth(), 0));
                StringBuffer arcBits = new StringBuffer();
                if (ai.isHardSelect()) {
                    arcBits.append("A");
                }
                if (ai.isDirectional()) {
                    arcBits.append("D");
                }
                if (!ai.isExtended()) {
                    arcBits.append("E");
                }
                if (!ai.isFixedAngle()) {
                    arcBits.append("F");
                }
                if (ai.getHead().isNegated()) {
                    arcBits.append("G");
                }
                if (ai.isSkipHead()) {
                    arcBits.append("H");
                }
                if (ai.getTail().isNegated()) {
                    arcBits.append("N");
                }
                if (ai.isRigid()) {
                    arcBits.append("R");
                }
                if (ai.isSlidable()) {
                    arcBits.append("S");
                }
                if (ai.isSkipTail()) {
                    arcBits.append("T");
                }
                if (ai.isReverseEnds()) {
                    arcBits.append("V");
                }
                this.printWriter.print("|" + arcBits.toString() + ai.getAngle());
                for (int e = 0; e < 2; ++e) {
                    Connection con = ai.getConnection(e);
                    NodeInst ni2 = con.getPortInst().getNodeInst();
                    this.printWriter.print("|" + this.getNodeName(ni2, sortedNodeIndices) + "|");
                    PortProto pp = con.getPortInst().getPortProto();
                    if (ni2.getProto().getNumPorts() > 1) {
                        this.printWriter.print(this.convertString(pp.getName()));
                    }
                    this.printWriter.print("|" + TextUtils.formatDouble(con.getLocation().getX(), 0));
                    this.printWriter.print("|" + TextUtils.formatDouble(con.getLocation().getY(), 0));
                }
                this.writeVars(ai, cell);
                this.printWriter.print("\n");
            }
            ArrayList sortedExports = new ArrayList();
            Iterator it8 = cell.getPorts();
            while (it8.hasNext()) {
                sortedExports.add(it8.next());
            }
            Collections.sort(sortedExports, exportsComparator);
            it8 = sortedExports.iterator();
            while (it8.hasNext()) {
                Export pp = (Export)it8.next();
                this.printWriter.print("E" + this.convertString(pp.getName()));
                this.printWriter.print("|" + this.describeDescriptor(null, pp.getTextDescriptor()));
                PortInst subPI = pp.getOriginalPort();
                NodeInst subNI = subPI.getNodeInst();
                PortProto subPP = subPI.getPortProto();
                this.printWriter.print("|" + this.getNodeName(subNI, sortedNodeIndices) + "|");
                if (subNI.getProto().getNumPorts() > 1) {
                    this.printWriter.print(this.convertString(subPP.getName()));
                }
                if (!NEWREVISION) {
                    Poly poly = subPI.getPoly();
                    this.printWriter.print("|" + TextUtils.formatDouble(poly.getCenterX(), 0) + "|" + TextUtils.formatDouble(poly.getCenterY(), 0));
                }
                this.printWriter.print("|" + pp.getCharacteristic().getShortName());
                if (pp.isAlwaysDrawn()) {
                    this.printWriter.print("/A");
                }
                if (pp.isBodyOnly()) {
                    this.printWriter.print("/B");
                }
                this.writeVars(pp, cell);
                this.printWriter.print("\n");
            }
            this.printWriter.print("X\n");
        }
        this.printWriter.print("\n# Groups:\n");
        Collections.sort(groups, new GroupsByName());
        Iterator it9 = groups.iterator();
        while (it9.hasNext()) {
            Cell.CellGroup group = (Cell.CellGroup)it9.next();
            this.printWriter.print("G");
            Cell main = group.getMainSchematics();
            if (main != null) {
                if (NEWREVISION) {
                    this.printWriter.print(this.convertString(main.getCellName().toString()));
                } else {
                    this.printWriter.print(this.convertString(main.describe()));
                }
            }
            TreeMap<CellName, Cell> groupCells = new TreeMap<CellName, Cell>();
            Iterator cIt3 = group.getCells();
            while (cIt3.hasNext()) {
                Cell c = (Cell)cIt3.next();
                if (c == main) continue;
                groupCells.put(c.getCellName(), c);
            }
            cIt3 = groupCells.values().iterator();
            while (cIt3.hasNext()) {
                Cell cell3 = (Cell)cIt3.next();
                this.printWriter.print("|");
                if (NEWREVISION) {
                    this.printWriter.print(this.convertString(cell3.getCellName().toString()));
                    continue;
                }
                this.printWriter.print(this.convertString(cell3.describe()));
            }
            this.printWriter.print("\n");
        }
        lib.clearChangedMinor();
        lib.clearChangedMajor();
        System.out.println(this.filePath + " written");
        return false;
    }

    private String getNodeName(NodeInst ni, HashMap indices) {
        if (indices == null) {
            return this.convertString(ni.getName());
        }
        Integer index = (Integer)indices.get(ni);
        if (index != null) {
            if (NEWREVISION) {
                return "\"" + this.convertQuotedString(ni.getName()) + "\"" + index;
            }
            return this.convertString("\"" + ni.getName() + "\"" + index);
        }
        return this.convertString(ni.getName());
    }

    private void traverseAndGatherNames(Library lib) {
        Iterator cIt = lib.getCells();
        while (cIt.hasNext()) {
            Cell cell = (Cell)cIt.next();
            this.gatherCell(cell, !NEWREVISION);
            this.gatherVariables(cell);
            Iterator it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                this.gatherVariables(ni);
                if (ni.getName() == null) {
                    System.out.println("ERROR: Cell " + cell.describe() + " has node " + ni.describe() + " with no name");
                }
                if (ni.getProto() instanceof Cell) {
                    Cell subCell = (Cell)ni.getProto();
                    if (subCell.getLibrary() == lib) continue;
                    this.gatherCell(subCell, true);
                    continue;
                }
                PrimitiveNode np = (PrimitiveNode)ni.getProto();
                this.externalObjs.add(np.getTechnology());
                this.externalObjs.add(np);
                if (NEWREVISION || this.abbreviationMap.containsKey(np)) continue;
                this.abbreviationMap.put(np, this.convertString(np.getTechnology().getTechName()) + ":" + this.convertString(np.getName()));
            }
            it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                this.gatherVariables(ai);
                for (int i = 0; i < 2; ++i) {
                    this.externalObjs.add(ai.getConnection(i).getPortInst().getPortProto());
                }
            }
            it = cell.getPorts();
            while (it.hasNext()) {
                Export e = (Export)it.next();
                this.gatherVariables(e);
                this.externalObjs.add(e.getOriginalPort().getPortProto());
            }
        }
    }

    private void gatherCell(Cell cell, boolean full) {
        if (cell == null) {
            return;
        }
        if (this.abbreviationMap.containsKey(cell)) {
            return;
        }
        this.externalObjs.add(cell);
        this.externalObjs.add(cell.getLibrary());
        this.externalObjs.add(cell.getView());
        this.abbreviationMap.put(cell, this.convertString(this.getCellName(cell, full)));
    }

    private String getCellName(Cell cell, boolean full) {
        if (full) {
            return cell.getLibrary().getName() + ":" + cell.getCellName();
        }
        return cell.getCellName().toString();
    }

    private void gatherVariables(ElectricObject eObj) {
        Iterator it = eObj.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            Object value = var.getObject();
            if (value == null) continue;
            int length = value instanceof Object[] ? ((Object[])value).length : 1;
            for (int i = 0; i < length; ++i) {
                Object v;
                Object object = v = value instanceof Object[] ? ((Object[])value)[i] : value;
                if (v == null) continue;
                if (v instanceof Technology || v instanceof Tool) {
                    this.externalObjs.add(v);
                    continue;
                }
                if (v instanceof PrimitiveNode) {
                    this.externalObjs.add(v);
                    this.externalObjs.add(((PrimitiveNode)v).getTechnology());
                    continue;
                }
                if (v instanceof ArcProto) {
                    this.externalObjs.add(v);
                    this.externalObjs.add(((ArcProto)v).getTechnology());
                    continue;
                }
                if (!(v instanceof ElectricObject)) continue;
                this.externalObjs.add(v);
                this.gatherCell(((ElectricObject)v).whichCell(), true);
            }
        }
    }

    private String describeDescriptor(Variable var, TextDescriptor td) {
        TextDescriptor.Unit unit;
        StringBuffer ret = new StringBuffer();
        boolean display = false;
        if (var == null || var.isDisplay()) {
            display = true;
        }
        if (display) {
            int color;
            TextDescriptor.Size size = td.getSize();
            if (size.isAbsolute()) {
                ret.append("A" + (int)size.getSize() + ";");
            }
            if (td.isBold()) {
                ret.append("B");
            }
            if ((color = td.getColorIndex()) != 0) {
                ret.append("C" + color + ";");
            }
            ret.append("D");
            TextDescriptor.Position pos = td.getPos();
            if (pos == TextDescriptor.Position.UP) {
                ret.append("8");
            } else if (pos == TextDescriptor.Position.DOWN) {
                ret.append("2");
            } else if (pos == TextDescriptor.Position.LEFT) {
                ret.append("4");
            } else if (pos == TextDescriptor.Position.RIGHT) {
                ret.append("6");
            } else if (pos == TextDescriptor.Position.UPLEFT) {
                ret.append("7");
            } else if (pos == TextDescriptor.Position.UPRIGHT) {
                ret.append("9");
            } else if (pos == TextDescriptor.Position.DOWNLEFT) {
                ret.append("1");
            } else if (pos == TextDescriptor.Position.DOWNRIGHT) {
                ret.append("3");
            } else if (pos == TextDescriptor.Position.BOXED) {
                ret.append("0");
            } else {
                ret.append("5");
            }
            int font = td.getFace();
            if (font != 0) {
                TextDescriptor.ActiveFont af = TextDescriptor.ActiveFont.findActiveFont(font);
                ret.append("F" + this.convertString(af.toString()) + ";");
            }
            if (!size.isAbsolute()) {
                ret.append("G" + TextUtils.formatDouble(size.getSize()) + ";");
            }
        }
        if (td.isInherit()) {
            ret.append("H");
        }
        if (display) {
            TextDescriptor.DispPos dispPos;
            if (td.isItalic()) {
                ret.append("I");
            }
            if (td.isUnderline()) {
                ret.append("L");
            }
            if ((dispPos = td.getDispPart()) == TextDescriptor.DispPos.NAMEVALUE) {
                ret.append("N");
            }
        }
        if (var != null && var.isCode() && (var.getObject() instanceof String || var.getObject() instanceof String[])) {
            Variable.Code codeType = var.getCode();
            if (codeType == Variable.Code.JAVA) {
                ret.append("OJ");
            } else if (codeType == Variable.Code.LISP) {
                ret.append("OL");
            } else if (codeType == Variable.Code.TCL) {
                ret.append("OT");
            }
        }
        if (td.isParam()) {
            ret.append("P");
        }
        if (display) {
            TextDescriptor.Rotation rot = td.getRotation();
            if (rot == TextDescriptor.Rotation.ROT90) {
                ret.append("R");
            } else if (rot == TextDescriptor.Rotation.ROT180) {
                ret.append("RR");
            } else if (rot == TextDescriptor.Rotation.ROT270) {
                ret.append("RRR");
            }
        }
        if (td.isInterior()) {
            ret.append("T");
        }
        if ((unit = td.getUnit()) == TextDescriptor.Unit.RESISTANCE) {
            ret.append("UR");
        } else if (unit == TextDescriptor.Unit.CAPACITANCE) {
            ret.append("UC");
        } else if (unit == TextDescriptor.Unit.INDUCTANCE) {
            ret.append("UI");
        } else if (unit == TextDescriptor.Unit.CURRENT) {
            ret.append("UA");
        } else if (unit == TextDescriptor.Unit.VOLTAGE) {
            ret.append("UV");
        } else if (unit == TextDescriptor.Unit.DISTANCE) {
            ret.append("UD");
        } else if (unit == TextDescriptor.Unit.TIME) {
            ret.append("UT");
        }
        if (display) {
            double offY;
            double offX = td.getXOff();
            if (offX != 0.0) {
                ret.append("X" + TextUtils.formatDouble(offX, 0) + ";");
            }
            if ((offY = td.getYOff()) != 0.0) {
                ret.append("Y" + TextUtils.formatDouble(offY, 0) + ";");
            }
        }
        return ret.toString();
    }

    private void writeVars(ElectricObject eObj, Cell curCell) {
        int numVars = 0;
        Iterator it = eObj.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (var.isDontSave()) continue;
            ++numVars;
        }
        if (numVars == 0) {
            return;
        }
        Iterator varIterator = eObj.getVariables();
        if (numVars > 1) {
            ArrayList<Variable> sortedVars = new ArrayList<Variable>();
            Iterator it2 = eObj.getVariables();
            while (it2.hasNext()) {
                Variable var = (Variable)it2.next();
                if (var.isDontSave()) continue;
                sortedVars.add(var);
            }
            Collections.sort(sortedVars, new TextUtils.VariablesByName());
            varIterator = sortedVars.iterator();
        }
        Iterator it3 = varIterator;
        while (it3.hasNext()) {
            Variable var = (Variable)it3.next();
            if (var.isDontSave()) continue;
            String tdString = this.describeDescriptor(var, var.getTextDescriptor());
            this.printWriter.print("|" + this.convertVariableName(var.getKey().getName()) + "(" + tdString + ")");
            Object varObj = var.getObject();
            String pt = this.makeString(varObj, curCell);
            if (pt == null) {
                pt = "";
            }
            this.printWriter.print(pt);
        }
    }

    private void writeMeaningPrefs(Object obj) {
        List prefs = Pref.getMeaningVariables(obj);
        Iterator it = prefs.iterator();
        while (it.hasNext()) {
            Pref pref = (Pref)it.next();
            Object value = pref.getValue();
            this.printWriter.print("|" + this.convertVariableName(pref.getPrefName()) + "()" + this.makeString(value, null));
        }
    }

    private String makeString(Object obj, Cell curCell) {
        StringBuffer infstr = new StringBuffer();
        if (obj instanceof Object[]) {
            Object[] objArray = (Object[])obj;
            int len = objArray.length;
            for (int i = 0; i < len; ++i) {
                Object oneObj = objArray[i];
                if (i != 0) {
                    infstr.append(",");
                } else {
                    infstr.append(this.getVarType(oneObj));
                    infstr.append("[");
                }
                this.makeStringVar(infstr, oneObj, curCell, true);
            }
            infstr.append("]");
        } else {
            infstr.append(this.getVarType(obj));
            this.makeStringVar(infstr, obj, curCell, false);
        }
        return infstr.toString();
    }

    private void makeStringVar(StringBuffer infstr, Object obj, Cell curCell, boolean inArray) {
        if (obj instanceof Integer) {
            infstr.append((Integer)obj);
            return;
        }
        if (obj instanceof Short) {
            infstr.append(((Short)obj).shortValue());
            return;
        }
        if (obj instanceof Byte) {
            infstr.append(((Byte)obj).byteValue());
            return;
        }
        if (obj instanceof String) {
            if (NEWREVISION) {
                infstr.append(this.convertString((String)obj, inArray));
            } else {
                infstr.append("\"");
                infstr.append(this.convertQuotedString((String)obj));
                infstr.append("\"");
            }
            return;
        }
        if (obj instanceof Float) {
            infstr.append(((Float)obj).floatValue());
            return;
        }
        if (obj instanceof Double) {
            infstr.append((Double)obj);
            return;
        }
        if (obj instanceof Boolean) {
            infstr.append((Boolean)obj != false ? "T" : "F");
            return;
        }
        if (obj instanceof Long) {
            infstr.append((Long)obj);
            return;
        }
        if (obj instanceof Point2D) {
            Point2D pt2 = (Point2D)obj;
            infstr.append(TextUtils.formatDouble(pt2.getX(), 0) + "/" + TextUtils.formatDouble(pt2.getY(), 0));
            return;
        }
        if (obj instanceof Technology) {
            Technology tech = (Technology)obj;
            infstr.append(this.convertString(tech.getTechName(), inArray));
            return;
        }
        if (obj instanceof Library) {
            Library lib = (Library)obj;
            infstr.append(this.convertString(lib.getName(), inArray));
            return;
        }
        if (obj instanceof Tool) {
            Tool tool = (Tool)obj;
            infstr.append(this.convertString(tool.getName(), inArray));
            return;
        }
        if (obj instanceof NodeInst) {
            NodeInst ni = (NodeInst)obj;
            infstr.append(this.convertString(this.getCellName(ni.getParent(), true) + ":" + ni.getName(), inArray));
            return;
        }
        if (obj instanceof ArcInst) {
            ArcInst ai = (ArcInst)obj;
            String arcName = ai.getName();
            if (arcName == null) {
                System.out.println("Cannot save pointer to unnamed ArcInst: " + ai.getParent().describe() + ":" + ai.describe());
            }
            infstr.append(this.convertString(this.getCellName(ai.getParent(), true) + ":" + arcName, inArray));
            return;
        }
        if (obj instanceof Cell) {
            Cell cell = (Cell)obj;
            infstr.append(this.convertString(this.getCellName(cell, true), inArray));
            return;
        }
        if (obj instanceof PrimitiveNode) {
            PrimitiveNode np = (PrimitiveNode)obj;
            infstr.append(this.convertString(np.getFullName(), inArray));
            return;
        }
        if (obj instanceof PrimitiveArc) {
            PrimitiveArc ap = (PrimitiveArc)obj;
            infstr.append(this.convertString(ap.getFullName(), inArray));
            return;
        }
        if (obj instanceof Export) {
            Export pp = (Export)obj;
            infstr.append(this.convertString(this.getCellName((Cell)pp.getParent(), true) + ":" + pp.getName(), inArray));
            return;
        }
    }

    private String getVarType(Object obj) {
        if (obj instanceof ArcInst) {
            return "S";
        }
        if (obj instanceof Boolean) {
            return "B";
        }
        if (obj instanceof Cell) {
            return "C";
        }
        if (obj instanceof Double) {
            return "D";
        }
        if (obj instanceof Export) {
            return "E";
        }
        if (obj instanceof Float) {
            return "F";
        }
        if (obj instanceof Long) {
            return "G";
        }
        if (obj instanceof Short) {
            return "H";
        }
        if (obj instanceof Integer) {
            return "I";
        }
        if (obj instanceof Library) {
            return "L";
        }
        if (obj instanceof NodeInst) {
            return "S";
        }
        if (obj instanceof Tool) {
            return "O";
        }
        if (obj instanceof PrimitiveNode) {
            return "P";
        }
        if (obj instanceof ArcProto) {
            return "R";
        }
        if (obj instanceof String) {
            return "S";
        }
        if (obj instanceof Technology) {
            return "T";
        }
        if (obj instanceof Point2D) {
            return "V";
        }
        if (obj instanceof Byte) {
            return "Y";
        }
        return null;
    }

    private String convertQuotedString(String str) {
        StringBuffer infstr = new StringBuffer();
        int len = str.length();
        if (NEWREVISION) {
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (ch == '\n') {
                    infstr.append("\\n");
                    continue;
                }
                if (ch == '\r') {
                    infstr.append("\\r");
                    continue;
                }
                if (ch == '\"' || ch == '\\') {
                    infstr.append('\\');
                }
                infstr.append(ch);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (ch == '\n') {
                    infstr.append("^\\n");
                    continue;
                }
                if (ch == '\"' || ch == '^') {
                    infstr.append('^');
                }
                infstr.append(ch);
            }
        }
        return infstr.toString();
    }

    private String convertString(String str) {
        if (NEWREVISION) {
            return this.convertString(str, '\u0000', '\u0000');
        }
        StringBuffer infstr = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\n') {
                ch = ' ';
            }
            if (ch == '|' || ch == '^' || ch == '\"') {
                infstr.append('^');
            }
            infstr.append(ch);
        }
        return infstr.toString();
    }

    private String convertString(String str, char delim1, char delim2) {
        if (!(str.length() == 0 || str.indexOf(10) >= 0 || str.indexOf(13) >= 0 || str.indexOf(92) >= 0 || str.indexOf(34) >= 0 || str.indexOf(124) >= 0 || delim1 != '\u0000' && str.indexOf(delim1) >= 0 || delim2 != '\u0000' && str.indexOf(delim2) >= 0)) {
            return str;
        }
        return '\"' + this.convertQuotedString(str) + '\"';
    }

    private String convertVariableName(String str) {
        if (NEWREVISION) {
            return this.convertString(str, '(', '\u0000');
        }
        StringBuffer infstr = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\n') {
                ch = ' ';
            }
            if (ch == '|' || ch == '^' || ch == '\"' || ch == '(') {
                infstr.append('^');
            }
            infstr.append(ch);
        }
        return infstr.toString();
    }

    private String convertString(String str, boolean inArray) {
        return NEWREVISION && inArray ? this.convertString(str, ',', ']') : this.convertString(str, '\u0000', '\u0000');
    }

    public static class GroupsByName
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Cell.CellGroup g1 = (Cell.CellGroup)o1;
            Cell.CellGroup g2 = (Cell.CellGroup)o2;
            String s1 = g1.getName();
            String s2 = g2.getName();
            return TextUtils.nameSameNumeric(s1, s2);
        }
    }
}

