/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.ChipNode;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.TestNode;
import com.sun.electric.tool.simulation.test.XMLIO;

public class CompareXML {
    String file1;
    String file2;
    TestNode system1;
    TestNode system2;

    CompareXML(String file1, String file2) {
        this.file1 = file1;
        this.file2 = file2;
        if (file1 == null || file2 == null) {
            Infrastructure.fatal("CompareXML: null input file name");
        }
        try {
            this.system1 = XMLIO.read(file1);
            this.system2 = XMLIO.read(file2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void diffChips() {
        int nchip2;
        int nchip1 = this.system1.getChildCount();
        if (nchip1 != (nchip2 = this.system2.getChildCount())) {
            System.out.println("File " + this.file1 + " contains " + nchip1 + " chips, but " + this.file2 + "contains " + nchip2 + ".  Comparison aborted.");
            Infrastructure.exit(1);
        }
        for (int ichip = 0; ichip < nchip1; ++ichip) {
            ChipNode chip1 = (ChipNode)this.system1.getChildAt(ichip);
            ChipNode chip2 = (ChipNode)this.system2.getChildAt(ichip);
            chip1.compare(chip2, this.file1, this.file2);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            Infrastructure.fatal("Must enter exactly two file names on command line");
        }
        CompareXML comparer = new CompareXML(args[0], args[1]);
        comparer.diffChips();
    }
}

