/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class STL
extends Output {
    private STLPreferences localPrefs;

    STL(STLPreferences dp) {
        this.localPrefs = dp;
    }

    private void writeSTL(Cell cell) {
        Technology tech;
        this.printWriter.print("solid electric_" + cell.getName() + "\n");
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.isCellInstance() || NodeInst.isSpecialNode(ni)) continue;
            tech = ni.getProto().getTechnology();
            FixpTransform bound = ni.rotateOut();
            Poly[] polyList = tech.getShapeOfNode(ni);
            String name = ni.getName();
            Poly[] polyArray = polyList;
            int n = polyArray.length;
            for (int i = 0; i < n; ++i) {
                Poly poly = polyArray[i];
                poly.transform(bound);
                this.writePoly(name, poly);
            }
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            tech = ai.getProto().getTechnology();
            Poly[] polyList = tech.getShapeOfArc(ai);
            String name = ai.getName();
            for (Poly poly : polyList) {
                this.writePoly(name, poly);
            }
        }
        this.printWriter.print("endsolid\n");
    }

    private void writePoly(String name, Poly poly) {
        Layer l = poly.getLayer();
        if (this.localPrefs.visibleLayers.get(l) == null) {
            return;
        }
        PolyBase.Point[] pts = poly.getPoints();
        if (pts.length != 4) {
            System.out.println("Warning: skipping non-rectangular face in '" + name + "'");
            return;
        }
        FixpRectangle rect = poly.getBounds2D();
        double minz = l.getDistance();
        double maxz = l.getDepth();
        this.printWriter.print("\tfacet normal 0.0 0.0 -1.0\n");
        this.printWriter.print("\t\touter loop\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMinY() + " " + minz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMaxY() + " " + minz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMinY() + " " + minz + "\n");
        this.printWriter.print("\t\tendloop\n");
        this.printWriter.print("\tendfacet\n");
        this.printWriter.print("\tfacet normal 0.0 0.0 -1.0\n");
        this.printWriter.print("\t\touter loop\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMinY() + " " + minz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMaxY() + " " + minz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMaxY() + " " + minz + "\n");
        this.printWriter.print("\t\tendloop\n");
        this.printWriter.print("\tendfacet\n");
        this.printWriter.print("\tfacet normal 0.0 0.0 1.0\n");
        this.printWriter.print("\t\touter loop\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMinY() + " " + maxz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMinY() + " " + maxz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMaxY() + " " + maxz + "\n");
        this.printWriter.print("\t\tendloop\n");
        this.printWriter.print("\tendfacet\n");
        this.printWriter.print("\tfacet normal 0.0 0.0 1.0\n");
        this.printWriter.print("\t\touter loop\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMinY() + " " + maxz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMaxY() + " " + maxz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMaxY() + " " + maxz + "\n");
        this.printWriter.print("\t\tendloop\n");
        this.printWriter.print("\tendfacet\n");
        this.printWriter.print("\tfacet normal 0.0 -1.0 0.0\n");
        this.printWriter.print("\t\touter loop\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMinY() + " " + minz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMinY() + " " + minz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMinY() + " " + maxz + "\n");
        this.printWriter.print("\t\tendloop\n");
        this.printWriter.print("\tendfacet\n");
        this.printWriter.print("\tfacet normal 0.0 -1.0 0.0\n");
        this.printWriter.print("\t\touter loop\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMinY() + " " + maxz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMinY() + " " + minz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMinY() + " " + maxz + "\n");
        this.printWriter.print("\t\tendloop\n");
        this.printWriter.print("\tendfacet\n");
        this.printWriter.print("\tfacet normal 0.0 1.0 0.0\n");
        this.printWriter.print("\t\touter loop\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMaxY() + " " + minz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMaxY() + " " + maxz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMaxY() + " " + minz + "\n");
        this.printWriter.print("\t\tendloop\n");
        this.printWriter.print("\tendfacet\n");
        this.printWriter.print("\tfacet normal 0.0 1.0 0.0\n");
        this.printWriter.print("\t\touter loop\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMaxY() + " " + maxz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMaxY() + " " + maxz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMaxY() + " " + minz + "\n");
        this.printWriter.print("\t\tendloop\n");
        this.printWriter.print("\tendfacet\n");
        this.printWriter.print("\tfacet normal -1.0 0.0 0.0\n");
        this.printWriter.print("\t\touter loop\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMinY() + " " + minz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMaxY() + " " + maxz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMaxY() + " " + minz + "\n");
        this.printWriter.print("\t\tendloop\n");
        this.printWriter.print("\tendfacet\n");
        this.printWriter.print("\tfacet normal -1.0 0.0 0.0\n");
        this.printWriter.print("\t\touter loop\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMinY() + " " + minz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMinY() + " " + maxz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMinX() + " " + rect.getLambdaMaxY() + " " + maxz + "\n");
        this.printWriter.print("\t\tendloop\n");
        this.printWriter.print("\tendfacet\n");
        this.printWriter.print("\tfacet normal 1.0 0.0 0.0\n");
        this.printWriter.print("\t\touter loop\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMinY() + " " + minz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMaxY() + " " + minz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMaxY() + " " + maxz + "\n");
        this.printWriter.print("\t\tendloop\n");
        this.printWriter.print("\tendfacet\n");
        this.printWriter.print("\tfacet normal 1.0 0.0 0.0\n");
        this.printWriter.print("\t\touter loop\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMinY() + " " + minz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMaxY() + " " + maxz + "\n");
        this.printWriter.print("\t\t\tvertex " + rect.getLambdaMaxX() + " " + rect.getLambdaMinY() + " " + maxz + "\n");
        this.printWriter.print("\t\tendloop\n");
        this.printWriter.print("\tendfacet\n");
    }

    public static class STLPreferences
    extends Output.OutputPreferences {
        public Technology tech;
        public Map<Layer, Layer> visibleLayers = new HashMap<Layer, Layer>();

        public STLPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            STL out = new STL(this);
            this.tech = cell.getTechnology();
            LayerVisibility lv = Job.isClientThread() ? LayerVisibility.getLayerVisibility() : null;
            Iterator<Layer> it = this.tech.getLayers();
            while (it.hasNext()) {
                Layer l = it.next();
                if (lv != null && !lv.isVisible(l)) continue;
                this.visibleLayers.put(l, l);
            }
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            out.writeSTL(cell);
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }
    }
}

