/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.LogicSettable;
import com.sun.electric.tool.simulation.test.VerilogModel;
import com.sun.electric.tool.simulation.test.VerilogParser;
import java.util.ArrayList;
import java.util.List;

public class VerilogLogicSettable
implements LogicSettable {
    private final VerilogModel vm;
    private final String port;
    private final VerilogModel.AliasedNames replacedNames;

    VerilogLogicSettable(VerilogModel vm, String port) {
        this.vm = vm;
        this.port = port;
        this.replacedNames = null;
    }

    VerilogLogicSettable(VerilogModel vm, List ports) {
        this.vm = vm;
        if (ports == null) {
            this.port = null;
            this.replacedNames = null;
            return;
        }
        this.port = (String)ports.get(0);
        this.replacedNames = new VerilogModel.AliasedNames(this.port, ports);
    }

    private String getPortName() {
        return this.port;
    }

    @Override
    public boolean isLogicStateHigh() {
        String p = this.getPortName();
        if (p == null) {
            return false;
        }
        int state = this.vm.getNodeState(this.port);
        return state == 1;
    }

    @Override
    public void setLogicState(boolean logicState) {
        String p = this.getPortName();
        if (p == null) {
            return;
        }
        this.vm.setNodeState(this.port, logicState ? 1 : 0);
    }

    List getPorts() {
        ArrayList<VerilogParser.Port> ports = new ArrayList<VerilogParser.Port>();
        if (this.getPortName() == null) {
            return ports;
        }
        ports.add(new VerilogParser.Port(this.getPortName(), 2));
        return ports;
    }

    VerilogModel.AliasedNames getAliasedNames() {
        return this.replacedNames;
    }

    public static void main(String[] args) {
        VerilogModel vm = new VerilogModel();
        ArrayList<String> list = new ArrayList<String>();
        list.add("TCK");
        list.add("TMS");
        list.add("TDOb");
        vm.createLogicSettable(list);
        vm.start("verilog", VerilogModel.getExampleVerilogChipFile(), 0);
        vm.finish();
    }
}

