/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.converter;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.converter.ExpressionConverter;
import org.eclipse.wb.internal.core.model.property.converter.IntegerConverter;

public final class IntegerArrayConverter
extends ExpressionConverter {
    public static final ExpressionConverter INSTANCE = new IntegerArrayConverter();

    private IntegerArrayConverter() {
    }

    @Override
    public String toJavaSource(JavaInfo javaInfo, Object value) throws Exception {
        if (value == null) {
            return "(int[]) null";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("new int[] {");
        int[] items = (int[])value;
        int i = 0;
        while (i < items.length) {
            int item = items[i];
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(IntegerConverter.INSTANCE.toJavaSource(javaInfo, item));
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }
}

