/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.os.macosx;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.os.macosx.OSSupportMacOSX;

public final class OSSupportMacOSXCarbon
extends OSSupportMacOSX {
    static {
        System.loadLibrary("wbp");
    }

    private static Image createImageFromHandle(int imageHandle, int width, int height) throws Exception {
        if (imageHandle != 0) {
            Image tempImage = (Image)ReflectionUtils.invokeMethod(Image.class, (String)"carbon_new(org.eclipse.swt.graphics.Device,int,int,int)", (Object[])new Object[]{Display.getCurrent(), 0, imageHandle, 0});
            Image image = new Image((Device)Display.getCurrent(), width, height);
            GC gc = new GC((Drawable)tempImage);
            gc.copyArea(image, 0, 0);
            gc.dispose();
            tempImage.dispose();
            return image;
        }
        return null;
    }

    public Image makeShot(Control control) {
        Rectangle rect;
        block9: {
            rect = control.getBounds();
            if (rect.width > 0 && rect.height > 0) break block9;
            return null;
        }
        try {
            int controlHandle = -1;
            int shellHandle = -1;
            if (control instanceof Shell) {
                shellHandle = this.getIntegerField(control, "shellHandle");
                if (shellHandle != -1) {
                    controlHandle = OSSupportMacOSXCarbon._HIViewGetRoot(shellHandle);
                }
            } else {
                controlHandle = this.getHandleField(control);
                shellHandle = this.getIntegerField(control.getShell(), "shellHandle");
            }
            int imageHandle = OSSupportMacOSXCarbon._makeShot(controlHandle, shellHandle);
            Image image = OSSupportMacOSXCarbon.createImageFromHandle(imageHandle, rect.width, rect.height);
            control.setData("WBP_IMAGE", (Object)image);
            if (control instanceof Composite && !(control instanceof Browser)) {
                Composite composite = (Composite)control;
                Control[] children = composite.getChildren();
                int i = 0;
                while (i < children.length) {
                    Image childImage;
                    Control child = children[children.length - 1 - i];
                    if (child.isVisible() && (childImage = this.makeShot(child)) != null) {
                        child.setData("WBP_IMAGE", (Object)childImage);
                    }
                    ++i;
                }
            }
            return image;
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate((Throwable)e);
        }
    }

    public Image getMenuPopupVisualData(Menu menu, int[] bounds) throws Exception {
        int handle = this.getHandleField(menu);
        int[] menuSize = new int[4];
        int[] itemsBounds = new int[bounds.length];
        int menuImageHandle = OSSupportMacOSXCarbon._fetchPopupMenuVisualData(handle, menuSize, itemsBounds);
        MenuItem firstItem = menu.getItem(0);
        int itemOffsetX = OSSupportMacOSXCarbon.isSeparatorItem(firstItem) ? 6 : itemsBounds[0];
        int itemOffsetY = OSSupportMacOSXCarbon.isSeparatorItem(firstItem) ? 5 : itemsBounds[1] / 2;
        int i = 0;
        while (i < menu.getItemCount()) {
            if (OSSupportMacOSXCarbon.isSeparatorItem(menu.getItem(i))) {
                if (i > 0) {
                    itemsBounds[i * 4 + 0] = itemsBounds[(i - 1) * 4 + 0];
                    itemsBounds[i * 4 + 1] = itemsBounds[(i - 1) * 4 + 1] + itemsBounds[(i - 1) * 4 + 3];
                } else {
                    itemsBounds[i * 4 + 0] = itemOffsetX;
                    itemsBounds[i * 4 + 1] = itemOffsetY * 2;
                }
                itemsBounds[i * 4 + 2] = menuSize[2];
                itemsBounds[i * 4 + 3] = 11;
            }
            bounds[i * 4 + 0] = itemsBounds[i * 4 + 0] - itemOffsetX;
            bounds[i * 4 + 1] = itemsBounds[i * 4 + 1] - itemOffsetY;
            bounds[i * 4 + 2] = itemsBounds[i * 4 + 2];
            bounds[i * 4 + 3] = itemsBounds[i * 4 + 3];
            ++i;
        }
        return OSSupportMacOSXCarbon.createImageFromHandle(menuImageHandle, menuSize[2], menuSize[3]);
    }

    public int getAlpha(Shell shell) {
        return OSSupportMacOSXCarbon._getAlpha(this.getHandleField(shell));
    }

    public void setAlpha(Shell shell, int alpha) {
        OSSupportMacOSXCarbon._setAlpha(this.getHandleField(shell), alpha);
    }

    public int getDefaultMenuBarHeight() {
        return OSSupportMacOSXCarbon._getMenuBarHeight();
    }

    @Override
    public int[] getPushButtonInsets() {
        int[] insets = new int[4];
        Object insetsRect = ReflectionUtils.getFieldObject((Object)DesignerPlugin.getStandardDisplay(), (String)"buttonInset");
        insets[0] = ReflectionUtils.getFieldShort((Object)insetsRect, (String)"left");
        insets[1] = ReflectionUtils.getFieldShort((Object)insetsRect, (String)"right");
        insets[2] = ReflectionUtils.getFieldShort((Object)insetsRect, (String)"top");
        insets[3] = ReflectionUtils.getFieldShort((Object)insetsRect, (String)"bottom");
        return insets;
    }

    private int getHandleField(Object object) {
        return this.getIntegerField(object, "handle");
    }

    private int getIntegerField(Object object, String name) {
        try {
            return ReflectionUtils.getFieldInt((Object)object, (String)name);
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate((Throwable)e);
        }
    }

    private static native int _getMenuBarHeight();

    private static native int _fetchPopupMenuVisualData(int var0, int[] var1, int[] var2);

    private static native int _HIViewGetRoot(int var0);

    private static native int _makeShot(int var0, int var1);

    private static native void _setAlpha(int var0, int var1);

    private static native int _getAlpha(int var0);
}

