/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.NoOpLog;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.palette.model.entry.LibraryInfo;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.model.description.resource.ResourceInfo;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.xml.sax.Attributes;

public final class LayoutDescription {
    private final ToolkitDescription m_toolkit;
    private final String m_id;
    private final String m_name;
    private final String m_layoutClassName;
    private final String m_creationId;
    private String m_source;
    private final List<LibraryInfo> m_libraries = Lists.newArrayList();

    public LayoutDescription(ToolkitDescription toolkit, IConfigurationElement element) {
        this.m_toolkit = toolkit;
        this.m_id = ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)element, (String)"id");
        this.m_name = ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)element, (String)"name");
        this.m_layoutClassName = ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)element, (String)"class");
        String creationId = element.getAttribute("creationId");
        this.m_creationId = StringUtils.isEmpty((String)creationId) ? null : creationId;
        String source = element.getAttribute("source");
        if (StringUtils.isEmpty((String)source)) {
            try {
                this.loadDescription();
            }
            catch (Exception e) {
                DesignerPlugin.log((Throwable)e);
            }
            this.m_source = this.m_source != null ? this.m_source : "new " + this.m_layoutClassName + "()";
        } else {
            this.m_source = source;
        }
        this.addLibraries(element);
    }

    public ToolkitDescription getToolkit() {
        return this.m_toolkit;
    }

    public String getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public String getLayoutClassName() {
        return this.m_layoutClassName;
    }

    public String getSourceFull() {
        return this.m_source;
    }

    public String getSourceSmart() {
        String shortClass = CodeUtils.getShortClass(this.m_layoutClassName);
        return StringUtils.replace((String)this.m_source, (String)this.m_layoutClassName, (String)shortClass);
    }

    public String getCreationId() {
        return this.m_creationId;
    }

    private void addLibraries(IConfigurationElement componentElement) {
        IConfigurationElement[] iConfigurationElementArray = componentElement.getChildren("library");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement libraryElement = iConfigurationElementArray[n2];
            this.m_libraries.add(new LibraryInfo(libraryElement));
            ++n2;
        }
    }

    public void ensureLibraries(IJavaProject javaProject) throws Exception {
        for (LibraryInfo library : this.m_libraries) {
            library.ensure(javaProject);
        }
    }

    private void loadDescription() throws Exception {
        String resourcePath = String.valueOf(this.m_layoutClassName.replace('.', '/')) + ".wbp-component.xml";
        ResourceInfo resourceInfo = DescriptionHelper.getResourceInfo(resourcePath, this.m_toolkit.getId());
        if (resourceInfo == null) {
            DesignerPlugin.log((String)("Not found resource " + this.m_layoutClassName.replace('.', '/') + ".wbp-component.xml" + " in bundle " + this.m_toolkit.getId()));
            return;
        }
        final Digester digester = new Digester();
        digester.setLogger((Log)new NoOpLog());
        digester.addRule("component/creation", new Rule(){

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                String id = attributes.getValue("id");
                digester.push((Object)(id != null ? id : ""));
            }

            public void end(String namespace, String name) throws Exception {
                digester.pop();
            }
        });
        digester.addRule("component/creation/source", new Rule(){

            public void body(String namespace, String name, String text) throws Exception {
                String id = (String)digester.peek();
                if (id.equals(LayoutDescription.this.m_creationId)) {
                    LayoutDescription.this.m_source = text;
                }
            }
        });
        InputStream is = resourceInfo.getURL().openStream();
        try {
            digester.parse(is);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

