/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.markdown.ui.preferences;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.markdown.ui.preferences.MarkdownPreferences;

public final class MarkdownPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor validateEnabledEditor;
    private Composite validationGroup;

    public MarkdownPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    private static <E extends Enum<E>> String[][] toLabelValueArray(Class<E> enumClass) {
        try {
            Field labelField = enumClass.getDeclaredField("label");
            Field valueField = enumClass.getDeclaredField("value");
            return (String[][])Arrays.stream((Enum[])enumClass.getEnumConstants()).map(enumValue -> {
                try {
                    return new String[]{(String)labelField.get(enumValue), (String)valueField.get(enumValue)};
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
            }).toArray(n -> new String[n][]);
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalArgumentException(enumClass.getName() + " must have 'label' and 'value' fields");
        }
    }

    protected void createFieldEditors() {
        Composite pageParent = this.getFieldEditorParent();
        this.addField((FieldEditor)new ComboFieldEditor("markdown.server.log", "Server log level", MarkdownPreferencePage.toLabelValueArray(MarkdownPreferences.ServerLog.class), pageParent));
        this.addField((FieldEditor)new BooleanFieldEditor("markdown.occurrencesHighlight.enabled", "Highlight link occurrences", pageParent));
        Composite suggestionsGroup = MarkdownPreferencePage.createPaddedGroup(pageParent, "Suggestions");
        this.addField((FieldEditor)new ComboFieldEditor("markdown.preferredMdPathExtensionStyle", "Path suggestions: add file extensions (e.g. `.md`) for links to Markdown files?", MarkdownPreferencePage.toLabelValueArray(MarkdownPreferences.PreferredMdPathExtensionStyle.class), suggestionsGroup));
        this.addField((FieldEditor)new BooleanFieldEditor("markdown.suggest.paths.enabled", "Enable path suggestions while writing links", suggestionsGroup));
        this.addField((FieldEditor)new ComboFieldEditor("markdown.suggest.paths.includeWorkspaceHeaderCompletions", "Enable suggestions for headers in other Markdown files", MarkdownPreferencePage.toLabelValueArray(MarkdownPreferences.IncludeWorkspaceHeaderCompletions.class), suggestionsGroup));
        StringFieldEditor excludeGlobs = new StringFieldEditor("markdown.suggest.paths.excludeGlobs", "Excluded path suggestion globs (comma-separated)", suggestionsGroup);
        this.addField((FieldEditor)excludeGlobs);
        String excludeTooltip = "Glob patterns to exclude Markdown files from path suggestions.\nMatched against project-relative paths, for example:\n\u2022 **/node_modules/**\n\u2022 docs/generated/**\n\u2022 **/drafts/**\n\u2022 **/*.tmp.md\n";
        excludeGlobs.getLabelControl(suggestionsGroup).setToolTipText("Glob patterns to exclude Markdown files from path suggestions.\nMatched against project-relative paths, for example:\n\u2022 **/node_modules/**\n\u2022 docs/generated/**\n\u2022 **/drafts/**\n\u2022 **/*.tmp.md\n");
        excludeGlobs.getTextControl(suggestionsGroup).setToolTipText("Glob patterns to exclude Markdown files from path suggestions.\nMatched against project-relative paths, for example:\n\u2022 **/node_modules/**\n\u2022 docs/generated/**\n\u2022 **/drafts/**\n\u2022 **/*.tmp.md\n");
        this.validateEnabledEditor = new BooleanFieldEditor("markdown.validate.enabled", "Enable validation", pageParent);
        this.addField((FieldEditor)this.validateEnabledEditor);
        this.validationGroup = MarkdownPreferencePage.createPaddedGroup(pageParent, "Validation settings");
        this.addField((FieldEditor)new ComboFieldEditor("markdown.validate.referenceLinks.enabled", "Reference links validation severity [text][ref]", MarkdownPreferencePage.toLabelValueArray(MarkdownPreferences.ValidateEnabled.class), this.validationGroup));
        this.addField((FieldEditor)new ComboFieldEditor("markdown.validate.fragmentLinks.enabled", "Fragment links validation severity [text](#head)", MarkdownPreferencePage.toLabelValueArray(MarkdownPreferences.ValidateEnabled.class), this.validationGroup));
        this.addField((FieldEditor)new ComboFieldEditor("markdown.validate.fileLinks.enabled", "File links validation severity", MarkdownPreferencePage.toLabelValueArray(MarkdownPreferences.ValidateEnabled.class), this.validationGroup));
        this.addField((FieldEditor)new ComboFieldEditor("markdown.validate.fileLinks.markdownFragmentLinks", "Fragment part of links to headers in other files in Markdown files", MarkdownPreferencePage.toLabelValueArray(MarkdownPreferences.ValidateEnabledForFragmentLinks.class), this.validationGroup));
        StringFieldEditor ignoredLinks = new StringFieldEditor("markdown.validate.ignoredLinks", "Ignored link globs (comma-separated)", this.validationGroup);
        this.addField((FieldEditor)ignoredLinks);
        String ignoredTooltip = "Glob patterns are matched against the link destination (href).\n\nSuppresses:\n\u2022 Missing file -> match the path only\n    e.g. docs/generated/**, **/images/**\n\u2022 Missing header (same file) -> match '#fragment'\n    e.g. #*, #intro\n\u2022 Missing header (other file) -> match 'path#fragment' or just the path\n    e.g. /guide.md#*, docs/guide.md#intro, /guide.md\n";
        ignoredLinks.getLabelControl(this.validationGroup).setToolTipText("Glob patterns are matched against the link destination (href).\n\nSuppresses:\n\u2022 Missing file -> match the path only\n    e.g. docs/generated/**, **/images/**\n\u2022 Missing header (same file) -> match '#fragment'\n    e.g. #*, #intro\n\u2022 Missing header (other file) -> match 'path#fragment' or just the path\n    e.g. /guide.md#*, docs/guide.md#intro, /guide.md\n");
        ignoredLinks.getTextControl(this.validationGroup).setToolTipText("Glob patterns are matched against the link destination (href).\n\nSuppresses:\n\u2022 Missing file -> match the path only\n    e.g. docs/generated/**, **/images/**\n\u2022 Missing header (same file) -> match '#fragment'\n    e.g. #*, #intro\n\u2022 Missing header (other file) -> match 'path#fragment' or just the path\n    e.g. /guide.md#*, docs/guide.md#intro, /guide.md\n");
        this.addField((FieldEditor)new ComboFieldEditor("markdown.validate.unusedLinkDefinitions.enabled", "Unused link definitions severity", MarkdownPreferencePage.toLabelValueArray(MarkdownPreferences.ValidateEnabled.class), this.validationGroup));
        this.addField((FieldEditor)new ComboFieldEditor("markdown.validate.duplicateLinkDefinitions.enabled", "Duplicated definitions severity", MarkdownPreferencePage.toLabelValueArray(MarkdownPreferences.ValidateEnabled.class), this.validationGroup));
    }

    protected void initialize() {
        super.initialize();
        this.updateValidationGroupEnablement();
        this.normalizeComboWidths(this.getFieldEditorParent());
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.validateEnabledEditor) {
            this.updateValidationGroupEnablement();
        }
    }

    private void updateValidationGroupEnablement() {
        boolean enabled = this.validateEnabledEditor != null && this.validateEnabledEditor.getBooleanValue();
        MarkdownPreferencePage.setEnabledRecursive((Control)this.validationGroup, enabled);
    }

    private static void setEnabledRecursive(Control control, boolean enabled) {
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setEnabled(enabled);
        if (control instanceof Composite) {
            Composite comp = (Composite)control;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                MarkdownPreferencePage.setEnabledRecursive(child, enabled);
                ++n2;
            }
        }
    }

    public static Composite createPaddedGroup(Composite parent, String title) {
        int marginWidth = 12;
        int marginHeight = 8;
        int spacingX = 8;
        int spacingY = 6;
        Group group = new Group(parent, 0);
        if (title != null) {
            group.setText(title);
        }
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 0).create());
        group.setLayout((Layout)new GridLayout(1, false));
        Composite body = new Composite((Composite)group, 0);
        body.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        body.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(12, 8).spacing(8, 6).create());
        return body;
    }

    private void normalizeComboWidths(Composite container) {
        if (container == null || container.isDisposed()) {
            return;
        }
        GC gc = new GC((Drawable)container);
        try {
            Control[] controlArray = container.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Composite) {
                    Composite comp = (Composite)child;
                    this.normalizeComboWidths(comp);
                }
                if (child instanceof Combo) {
                    Combo combo = (Combo)child;
                    GridData gd = new GridData(1, 0x1000000, false, false);
                    int max = 0;
                    String[] stringArray = combo.getItems();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String item = stringArray[n4];
                        Point p = gc.textExtent(item);
                        if (p.x > max) {
                            max = p.x;
                        }
                        ++n4;
                    }
                    gd.widthHint = max;
                    child.setLayoutData((Object)gd);
                }
                ++n2;
            }
        }
        finally {
            gc.dispose();
        }
        container.layout(true, true);
    }
}

