/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.resources;

import java.util.Map;
import org.eclipse.rse.files.ui.resources.ISystemRemoteMarker;
import org.eclipse.rse.files.ui.resources.ISystemRemoteResource;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteMarkerInfo;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteMarkerManager;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteResource;

public class SystemRemoteMarker
implements ISystemRemoteMarker {
    protected ISystemRemoteResource resource;
    protected long id;

    public SystemRemoteMarker(ISystemRemoteResource resource, long id) {
        this.resource = resource;
        this.id = id;
    }

    public void delete() {
        SystemRemoteMarkerManager.getInstance().removeMarker(this.getResource(), this.getId());
    }

    public boolean equals(Object object) {
        if (!(object instanceof ISystemRemoteMarker)) {
            return false;
        }
        ISystemRemoteMarker other = (ISystemRemoteMarker)object;
        return this.id == other.getId() && this.resource.equals(other.getResource());
    }

    public boolean exists() {
        return this.getInfo() != null;
    }

    private SystemRemoteMarkerInfo getInfo() {
        return SystemRemoteMarkerManager.getInstance().findMarkerInfo(this.getResource(), this.getId());
    }

    public Object getAttribute(String attributeName) {
        SystemRemoteMarkerInfo info = this.getInfo();
        if (info == null) {
            return null;
        }
        return info.getAttribute(attributeName);
    }

    public int getAttribute(String attributeName, int defaultValue) {
        SystemRemoteMarkerInfo info = this.getInfo();
        if (info == null) {
            return defaultValue;
        }
        Object value = info.getAttribute(attributeName);
        if (value != null && value instanceof Integer) {
            return (Integer)value;
        }
        return defaultValue;
    }

    public String getAttribute(String attributeName, String defaultValue) {
        SystemRemoteMarkerInfo info = this.getInfo();
        if (info == null) {
            return defaultValue;
        }
        Object value = info.getAttribute(attributeName);
        if (value != null && value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        SystemRemoteMarkerInfo info = this.getInfo();
        if (info == null) {
            return defaultValue;
        }
        Object value = info.getAttribute(attributeName);
        if (value != null && value instanceof Integer) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public Map getAttributes() {
        SystemRemoteMarkerInfo info = this.getInfo();
        if (info == null) {
            return null;
        }
        return info.getAttributes();
    }

    public Object[] getAttributes(String[] attributeNames) {
        SystemRemoteMarkerInfo info = this.getInfo();
        if (info == null) {
            return new Object[0];
        }
        return info.getAttributes(attributeNames);
    }

    public long getCreationTime() {
        SystemRemoteMarkerInfo info = this.getInfo();
        if (info == null) {
            return -1L;
        }
        return info.getCreationTime();
    }

    public long getId() {
        return this.id;
    }

    public ISystemRemoteResource getResource() {
        return this.resource;
    }

    public String getType() {
        SystemRemoteMarkerInfo info = this.getInfo();
        if (info == null) {
            return null;
        }
        return info.getType();
    }

    public boolean isSubtypeOf(String superType) {
        String type = this.getType();
        if (type == null) {
            return false;
        }
        return SystemRemoteMarkerManager.getInstance().getCache().isSubtype(type, superType);
    }

    public void setAttribute(String attributeName, int value) {
        this.setAttribute(attributeName, new Integer(value));
    }

    public void setAttribute(String attributeName, Object value) {
        SystemRemoteMarkerManager manager = SystemRemoteMarkerManager.getInstance();
        SystemRemoteMarkerInfo info = this.getInfo();
        info.setAttribute(attributeName, value);
        if (manager.isPersistent(info)) {
            ((SystemRemoteResource)this.resource).getResourceInfo().set(4096);
        }
    }

    public void setAttribute(String attributeName, boolean value) {
        this.setAttribute(attributeName, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setAttributes(String[] attributeNames, Object[] values) {
        SystemRemoteMarkerManager manager = SystemRemoteMarkerManager.getInstance();
        SystemRemoteMarkerInfo info = this.getInfo();
        info.setAttributes(attributeNames, values);
        if (manager.isPersistent(info)) {
            ((SystemRemoteResource)this.resource).getResourceInfo().set(4096);
        }
    }

    public void setAttributes(Map attributes) {
        SystemRemoteMarkerManager manager = SystemRemoteMarkerManager.getInstance();
        SystemRemoteMarkerInfo info = this.getInfo();
        info.setAttributes(attributes);
        if (manager.isPersistent(info)) {
            ((SystemRemoteResource)this.resource).getResourceInfo().set(4096);
        }
    }
}

