/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;

class AutoBuildJob
extends Job
implements Preferences.IPropertyChangeListener {
    private volatile boolean avoidBuild;
    private volatile boolean buildNeeded;
    private volatile boolean forceBuild;
    private volatile boolean interrupted;
    private volatile boolean isAutoBuilding;
    private volatile long lastBuild = 0L;
    private Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
    private final Bundle systemBundle = Platform.getBundle((String)"org.eclipse.osgi");
    private Workspace workspace;
    final Job noBuildJob;

    AutoBuildJob(Workspace workspace) {
        super(Messages.events_building_0);
        this.setRule(workspace.getRoot());
        this.setPriority(40);
        this.isAutoBuilding = workspace.isAutoBuilding();
        this.workspace = workspace;
        this.preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.noBuildJob = new AutoBuildOffJob();
    }

    synchronized void avoidBuild() {
        this.avoidBuild = true;
    }

    synchronized void avoidBuildIfNotInterrupted() {
        if (!this.interrupted) {
            this.avoidBuild();
        }
    }

    public boolean belongsTo(Object family) {
        return family == ResourcesPlugin.FAMILY_AUTO_BUILD;
    }

    synchronized void build(boolean needsBuild) {
        this.buildNeeded |= needsBuild;
        long delay = this.computeScheduleDelay();
        int state = this.getState();
        if (Policy.DEBUG_BUILD_NEEDED) {
            Policy.debug("build requested, needsBuild: " + needsBuild + " state: " + state + ", delay: " + delay);
        }
        if (state != 4) {
            this.setInterrupted(false);
        }
        switch (state) {
            case 1: {
                if (Policy.DEBUG_BUILD_INVOKING) {
                    AutoBuildJob.traceMessageOrFullStack("wakeup, needsBuild: " + needsBuild + ", delay: " + delay);
                }
                this.wakeUp(delay);
                break;
            }
            case 0: {
                if (this.isAutoBuilding) {
                    if (Policy.DEBUG_BUILD_INVOKING) {
                        AutoBuildJob.traceMessageOrFullStack("scheduled, needsBuild: " + needsBuild + ", delay: " + delay);
                    }
                    this.schedule(delay);
                    break;
                }
                if (this.noBuildJob.getState() == 4) break;
                this.noBuildJob.schedule(delay);
                break;
            }
            case 4: {
                if (!this.isAutoBuilding || !this.buildNeeded || this.avoidBuild || Job.getJobManager().currentJob() == this) break;
                if (Policy.DEBUG_BUILD_INVOKING) {
                    AutoBuildJob.traceMessageOrFullStack("scheduled from other thread with delay: " + delay);
                }
                this.schedule(delay);
            }
        }
    }

    private static void traceMessageOrFullStack(String message) {
        message = "AutoBuildJob: " + message;
        if (Policy.DEBUG_BUILD_NEEDED_STACK) {
            Policy.debug(new RuntimeException(message));
        } else {
            Policy.debug(message);
        }
    }

    private long computeScheduleDelay() {
        long maxDelay = Math.min(1000L, 1000L + this.lastBuild - System.currentTimeMillis());
        return Math.max(100L, maxDelay);
    }

    private synchronized IStatus canceled() {
        this.buildNeeded = true;
        if (this.interrupted) {
            if (Policy.DEBUG_BUILD_INTERRUPT) {
                AutoBuildJob.traceMessageOrFullStack("scheduling due to interruption");
            }
            this.setInterrupted(false);
            this.schedule(this.computeScheduleDelay());
        }
        return Status.CANCEL_STATUS;
    }

    private void doBuild(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(Policy.opWork + 1));
        ISchedulingRule rule = this.workspace.getRuleFactory().buildRule();
        SubMonitor split = subMonitor.split(1);
        try {
            this.workspace.prepareOperation(rule, (IProgressMonitor)split);
            this.workspace.beginOperation(true);
            this.workspace.broadcastBuildEvent(this.workspace, 8, 9);
            IStatus result = Status.OK_STATUS;
            try {
                if (this.shouldBuild()) {
                    result = this.workspace.getBuildManager().build(this.workspace.getBuildOrder(), ICoreConstants.EMPTY_BUILD_CONFIG_ARRAY, 9, (IProgressMonitor)subMonitor.split(Policy.opWork));
                }
            }
            finally {
                this.workspace.broadcastBuildEvent(this.workspace, 16, 9);
            }
            if (!result.isOK()) {
                throw new ResourceException(result);
            }
        }
        finally {
            if (this.workspace.getElementTree().isImmutable()) {
                this.workspace.newWorkingTree();
            }
            this.workspace.endOperation(rule, false);
        }
    }

    public void forceBuild() {
        this.forceBuild = true;
    }

    synchronized void interrupt() {
        if (this.interrupted) {
            return;
        }
        switch (this.getState()) {
            case 0: {
                return;
            }
            case 2: {
                this.setInterrupted(!this.sleep());
                break;
            }
            case 4: {
                if (Job.getJobManager().currentJob() == this) {
                    return;
                }
                this.setInterrupted(true);
            }
        }
        if (this.interrupted) {
            this.avoidBuild = false;
        }
    }

    synchronized boolean isInterrupted() {
        if (this.interrupted) {
            return true;
        }
        if (this.isBlocking()) {
            this.setInterrupted(true);
        }
        return this.interrupted;
    }

    @Deprecated
    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (!event.getProperty().equals("description.autobuilding")) {
            return;
        }
        boolean wasAutoBuilding = this.isAutoBuilding;
        this.isAutoBuilding = this.preferences.getBoolean("description.autobuilding");
        if (wasAutoBuilding && !this.isAutoBuilding) {
            this.interrupt();
        } else if (!wasAutoBuilding && this.isAutoBuilding) {
            this.noBuildJob.cancel();
            this.forceBuild = true;
            this.build(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        AutoBuildJob autoBuildJob = this;
        synchronized (autoBuildJob) {
            if (subMonitor.isCanceled() || this.isInterrupted()) {
                return this.canceled();
            }
        }
        if (this.systemBundle.getState() == 16) {
            return Status.OK_STATUS;
        }
        try {
            this.doBuild((IProgressMonitor)subMonitor.split(1));
            this.lastBuild = System.currentTimeMillis();
            this.setInterrupted(false);
            return Status.OK_STATUS;
        }
        catch (OperationCanceledException operationCanceledException) {
            return this.canceled();
        }
        catch (CoreException sig) {
            return sig.getStatus();
        }
    }

    private synchronized void setInterrupted(boolean value) {
        this.interrupted = value;
        if (this.interrupted && Policy.DEBUG_BUILD_INTERRUPT) {
            AutoBuildJob.traceMessageOrFullStack("was interrupted");
        }
    }

    private synchronized boolean shouldBuild() {
        try {
            if (!this.workspace.isAutoBuilding()) {
                return false;
            }
            if (this.forceBuild) {
                return true;
            }
            if (this.avoidBuild) {
                return false;
            }
            boolean bl = this.buildNeeded;
            return bl;
        }
        finally {
            this.buildNeeded = false;
            this.avoidBuild = false;
            this.forceBuild = false;
        }
    }

    private final class AutoBuildOffJob
    extends Job {
        private AutoBuildOffJob() {
            super("Sending build events with disabled autobuild");
            this.setRule(AutoBuildJob.this.workspace.getRoot());
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return family == ResourcesPlugin.FAMILY_AUTO_BUILD;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (AutoBuildJob.this.systemBundle.getState() == 16) {
                return Status.OK_STATUS;
            }
            ISchedulingRule rule = AutoBuildJob.this.workspace.getRuleFactory().buildRule();
            try {
                try {
                    AutoBuildJob.this.workspace.prepareOperation(rule, monitor);
                    AutoBuildJob.this.workspace.beginOperation(true);
                    AutoBuildJob.this.workspace.broadcastBuildEvent(AutoBuildJob.this.workspace, 8, 9);
                    AutoBuildJob.this.workspace.broadcastBuildEvent(AutoBuildJob.this.workspace, 16, 9);
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    try {
                        AutoBuildJob.this.workspace.endOperation(rule, false);
                    }
                    catch (CoreException e2) {
                        return e2.getStatus();
                    }
                    return iStatus;
                }
            }
            finally {
                try {
                    AutoBuildJob.this.workspace.endOperation(rule, false);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
            return Status.OK_STATUS;
        }
    }
}

