/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.oniguruma;

import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.oniguruma.OnigRegExp;
import org.eclipse.tm4e.core.internal.oniguruma.OnigResult;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;

final class OnigSearcher {
    private final List<OnigRegExp> regExps;

    OnigSearcher(Collection<String> regExps) {
        this.regExps = regExps.stream().map(OnigRegExp::new).toList();
    }

    @Nullable OnigResult search(OnigString source, int charOffset) {
        int byteOffset = source.getByteIndexOfChar(charOffset);
        int bestLocation = 0;
        OnigResult bestResult = null;
        int index = 0;
        for (OnigRegExp regExp : this.regExps) {
            OnigResult result = regExp.search(source, byteOffset);
            if (result != null && result.count() > 0) {
                int location = result.locationAt(0);
                if (bestResult == null || location < bestLocation) {
                    bestLocation = location;
                    bestResult = result;
                    bestResult.setIndex(index);
                }
                if (location == byteOffset) break;
            }
            ++index;
        }
        return bestResult;
    }
}

