import { DebugProtocol } from 'vscode-debugprotocol';
import { IInternalStackTraceResponseBody } from '../src/debugAdapterInterfaces';
import * as utils from '../src/utils';
import { IMock } from 'typemoq';
export declare function setupUnhandledRejectionListener(): void;
export declare function removeUnhandledRejectionListener(): void;
export declare class MockEvent implements DebugProtocol.Event {
    event: string;
    body: any;
    seq: number;
    type: string;
    constructor(event: string, body?: any);
}
export declare function getStackTraceResponseBody(aPath: string, locations: DebugProtocol.SourceBreakpoint[], sourceReferences?: number[], isSourceMapped?: boolean): IInternalStackTraceResponseBody;
/**
 * Some tests use this to override 'os' and 'path' with the windows versions for consistency when running on different
 * platforms. For other tests, it either doesn't matter, or they have platform-specific test code.
 */
export declare function registerWin32Mocks(): void;
export declare function registerOSXMocks(): void;
export declare function registerLocMocks(): void;
/**
 * path.resolve + fixing the drive letter to match what VS Code does. Basically tests can use this when they
 * want to force a path to native slashes and the correct letter case, but maybe can't use un-mocked utils.
 */
export declare function pathResolve(...segments: string[]): string;
export declare function registerMockReadFile(...entries: {
    absPath: string;
    data: string;
}[]): void;
/**
 * Mock utils.getURL to return the specified contents.
 * Note that if you call this twice, the second call will overwrite the first.
 */
export declare function registerMockGetURL(utilsRelativePath: string, url: string, contents: string, utilsMock?: IMock<typeof utils>, isError?: boolean): void;
export declare function registerMockGetURLFail(utilsRelativePath: string, url: string, failContents?: string, utilsMock?: IMock<typeof utils>): void;
/**
 * Returns a promise that is resolved if the given promise is rejected, and is rejected if the given
 * promise is resolved
 */
export declare function assertPromiseRejected(promise: Promise<any>): Promise<any>;
export declare function assertFail(msg: string): void;
